/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.DialogMatchLithology;
import jsbugs.DialogSampleLithologyImport;
import jsbugs.FrameJsbugs;
import model2.Lastval;
import model2.SBdb;
import model2.Sample;
import model2.SampleLithology;
import model2.WsLithology;
import model2.WsWell;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchSampleLithology
extends JDialog {
    TableModelMatchSampleLithology model = new TableModelMatchSampleLithology();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Image backgroundImage;
    WsWell well;
    SBdb db;
    SBdb ws;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchLith;

    public DialogMatchSampleLithology(Frame parent, boolean modal, WsWell well, SBdb db, SBdb ws, char units) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.ws = ws;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Sample Lithology");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.initData();
        this.model.setupTable(this.jTableMatchLith);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchLith);
        this.sorter.reallocateIndexes();
    }

    private void initData() throws SBException, SQLException {
        LinkedList<Sample> lithSamples = new LinkedList<Sample>();
        for (Sample sample : this.well.getSamples()) {
            if (sample.getLithology() == null || sample.getLithology().getLithology().size() <= 0) continue;
            lithSamples.add(sample);
        }
        LinkedList<Sample> dbSamples = null;
        if (this.well.getLink() != null) {
            dbSamples = new LinkedList<Sample>();
            for (Sample samp : this.well.getLink().getSamples()) {
                dbSamples.add(samp);
            }
            LinkedList<Sample> toRemove = new LinkedList<Sample>();
            for (Sample dbSample : dbSamples) {
                if (dbSample.getLithology() != null && !dbSample.getLithology().getLithology().isEmpty()) continue;
                boolean found = false;
                for (Sample s : lithSamples) {
                    if (dbSample.compareTo(s) != 0) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRemove.add(dbSample);
            }
            for (Sample remove : toRemove) {
                dbSamples.remove(remove);
            }
        }
        this.model.data.init(lithSamples, dbSamples);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchSampleLithology.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchLith = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonClose = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonRead = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.jTableMatchLith.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchLith);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSampleLithology.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSampleLithology.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSampleLithology.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSampleLithology.this.jButtonReadActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 259, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 417, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonRead)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 222, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 326, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteLithology(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteLithology(true);
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        this.read();
    }

    private void deleteLithology(boolean fromDatabase) {
        block8: {
            if (fromDatabase && this.well.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchLith.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "Select rows to " + (fromDatabase ? "delete" : "exclude"), this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchLith.getSelectedRows();
            LinkedList<Sample> toRemove = new LinkedList<Sample>();
            for (int i : selected) {
                Sample sample = fromDatabase ? (Sample)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (Sample)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (sample == null) continue;
                toRemove.add(sample);
            }
            if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog(this, "Really delete " + (toRemove.size() == 1 ? "this" : "these " + toRemove.size()) + (toRemove.size() == 1 ? " sample lithology?" : " sample lithologies?"), this.getTitle(), 0, 3) == 1) {
                return;
            }
            try {
                int nSamples = 0;
                WsWell deleteWell = fromDatabase ? this.well.getLink() : this.well;
                for (Sample sample : toRemove) {
                    sample.deleteLithology(deleteWell.getWellID());
                    ++nSamples;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Sample lithologies " + text + ": " + nSamples, this.getTitle(), 1);
                this.well.updateSampleLithologyStatus(true);
                this.initData();
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (fromDatabase) {
                    deleteWell.getDataModel().commit();
                    deleteWell.setDataChanged();
                    deleteWell.notifyObservers(toRemove.get(0));
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error excluding samples: " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block8;
                this.well.getLink().getDataModel().doRollback();
            }
        }
    }

    private void read() {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"SAMPLITHFL"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                Lastval.putString((SBdb)this.db, (String)"SAMPLITHFL", (String)fileName);
                this.db.commit();
                LinkedList<WsLithology> wsLiths = new LinkedList<WsLithology>();
                LinkedList samples = new LinkedList();
                DialogSampleLithologyImport importDialog = new DialogSampleLithologyImport((Dialog)this, true, this.well);
                importDialog.setLocationRelativeTo(this);
                importDialog.setVisible(true);
                if (!importDialog.isOK) {
                    return;
                }
                SampleLithology.readFile((String)fileName, (SBdb)this.ws, (WsWell)this.well, wsLiths, samples, (boolean)importDialog.singleDepth, (float)importDialog.interval, (char)importDialog.units);
                DialogMatchLithology dialog = new DialogMatchLithology((Dialog)this, true, wsLiths, this.db);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    for (Sample sample : samples) {
                        sample.getLithology().discardUnmatched();
                        if (sample.getLithology().getLithology().isEmpty()) continue;
                        Sample existing = null;
                        existing = sample.hasBaseDepth() && sample.hasTopDepth() ? this.well.getSample(sample.getTopDepth(), sample.getBaseDepth(), sample.getType()) : this.well.getSample(sample.getDepth(), sample.getType(), false);
                        if (existing == null) {
                            Sample.insert((List)this.well.getSamples(), (Sample)sample, (char)this.well.getWellUnits());
                            continue;
                        }
                        existing.copyLithology(sample.getLithology());
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                }
                this.well.updateSampleStatus(true);
                this.well.updateSampleLithologyStatus(true);
                this.initData();
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (IOException eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error: ", (Exception)((Object)sbe));
                sbe.printStackTrace();
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQL Error: ", (SQLException)sql);
                sql.printStackTrace();
            }
        }
    }

    class TableModelMatchSampleLithology
    extends AbstractTableModel {
        final String[] colTitles = new String[]{"Sample", "Lithology", "", "Sample", "Lithology"};
        final int[] colWidths = new int[]{15, 80, 16, 15, 80};
        static final int COL_WS_SAMP = 0;
        static final int COL_WS_LITH = 1;
        static final int COL_ARROW = 2;
        static final int COL_DB_SAMP = 3;
        static final int COL_DB_LITH = 4;
        char units = (char)77;
        MatchData data = new MatchData();

        TableModelMatchSampleLithology() {
        }

        @Override
        public int getColumnCount() {
            return this.colTitles.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            MatchData.MatchPair pair = this.data.get(row);
            if (pair == null) {
                return "";
            }
            Sample ws = (Sample)pair.getWs();
            Sample db = (Sample)pair.getDb();
            switch (col) {
                case 0: {
                    return ws == null ? null : new StringStatus(ws.toString(this.units), ws.getStatus());
                }
                case 1: {
                    return ws == null ? null : new StringStatus(ws.getLithology().toString(), db != null && db.getLithology() != null && !db.getLithology().getLithology().isEmpty() ? ws.getLithology().getStatus(db.getLithology()) : Sample.NOTSTORED);
                }
                case 2: {
                    return new Boolean(ws != null && db != null && ws.getStatus() == Sample.STORED);
                }
                case 3: {
                    return db == null ? null : new StringStatus(db.toString(this.units), db.getStatus());
                }
                case 4: {
                    return db == null || db.getLithology() == null || db.getLithology().getLithology().isEmpty() ? null : new StringStatus(db.getLithology().toString(), Sample.STORED);
                }
            }
            return "";
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    return StringStatus.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        void setupTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < DialogMatchSampleLithology.this.model.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(this.colTitles[i]);
                columnModel.getColumn(i).setWidth(this.colWidths[i]);
            }
            columnModel.getColumn(2).setMaxWidth(this.colWidths[2]);
            table.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
            table.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
            table.getTableHeader().setReorderingAllowed(false);
        }
    }
}

