/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.SampleTypePair;
import jsbugs.TableModelMatchSampleTypes;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogMatchSampleTypes
extends SBDialog {
    private final TableModelMatchSampleTypes model = new TableModelMatchSampleTypes();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private Image backgroundImage;
    private final SBdb db;
    private final SBdb ws;
    private JButton jButtonCancel;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableSampleTypes;

    public DialogMatchSampleTypes(Frame parent, boolean modal, SBdb ws, SBdb db, HashSet<String> donorTypes) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.ws = ws;
        this.setTitle("Match Sample Types");
        this.initComponents();
        this.init(donorTypes);
    }

    private void init(HashSet<String> donorTypes) throws SQLException {
        this.model.setupTable(this.jTableSampleTypes, donorTypes);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSampleTypes);
        this.sorter.reallocateIndexes();
        this.sorter.sortByColumn(0);
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
        this.jTableSampleTypes.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchSampleTypes.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSampleTypes = new JTable();
        this.jButtonMatchAll = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 250));
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jScrollPane1.setToolTipText("Select the database abbreviation to match");
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableSampleTypes.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableSampleTypes);
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSampleTypes.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSampleTypes.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSampleTypes.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 406, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 248, Short.MAX_VALUE).addComponent(this.jLabel2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 21, -2).addComponent(this.jLabel2, -2, 27, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonMatchAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 249, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            for (SampleTypePair pair : this.model.types) {
                if (pair.dbType != null) continue;
                for (int i = 0; i < Sample.getSampleTypes().length; ++i) {
                    if (!pair.wsType.equalsIgnoreCase(Sample.getSampleTypes()[i])) continue;
                    pair.dbType = Sample.getSampleTypes()[i];
                }
            }
            this.sorter.fireTableDataChanged();
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            for (SampleTypePair pair : this.model.types) {
                if (pair.dbType != null) continue;
                JOptionPane.showMessageDialog(this, "Not all sample types matched: " + pair.wsType, this.getTitle(), 2);
                return;
            }
            Iterator it = this.ws.getProject(0).getWellIterator();
            while (it.hasNext()) {
                Well well = (Well)it.next();
                for (Sample sample : well.getSamples()) {
                    if (sample.getDonorSampleType() == null) continue;
                    for (SampleTypePair pair : this.model.types) {
                        if (!pair.wsType.equals(sample.getDonorSampleType())) continue;
                        sample.setType(pair.dbType);
                    }
                }
            }
            this.setOK();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }
}

