/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchSamples;
import model2.Sample;
import model2.Smpdtl;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchSamples
extends JDialog {
    TableModelMatchSamples model = new TableModelMatchSamples();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    WsWell well;
    Image backgroundImage;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonDeleteLabels;
    private JButton jButtonExclude;
    private JButton jButtonExcludeBases;
    private JButton jButtonExcludeLabels;
    private JButton jButtonExcludeTops;
    private JButton jButtonHelp;
    private JButton jButtonSave;
    private JButton jButtonSaveBases;
    private JButton jButtonSaveTops;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchSamples;

    public DialogMatchSamples(Frame parent, boolean modal, WsWell well, char units) throws SBException, SQLException {
        super(parent, modal);
        this.well = well;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        this.setTitle("Match Samples: " + this.well);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
        SB.setTableHeaderBold((JTable)this.jTableMatchSamples);
        TableColumnModel columnModel = this.jTableMatchSamples.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchSamples.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchSamples.colWidths[i]);
        }
        columnModel.getColumn(4).setMaxWidth(TableModelMatchSamples.colWidths[4]);
        this.jTableMatchSamples.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchSamples.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchSamples);
        this.sorter.reallocateIndexes();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.jTableMatchSamples.getTableHeader().setReorderingAllowed(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchSamples.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchSamples = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonClose = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonExcludeLabels = new JButton();
        this.jButtonDeleteLabels = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonExcludeTops = new JButton();
        this.jButtonSaveTops = new JButton();
        this.jPanel4 = new JPanel();
        this.jButtonExcludeBases = new JButton();
        this.jButtonSaveBases = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 485));
        this.setModal(true);
        this.jTableMatchSamples.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchSamples);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected samples from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected samples from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved samples in database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Labels", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jButtonExcludeLabels.setText("Exclude");
        this.jButtonExcludeLabels.setToolTipText("Exclude selected sample labels from workspace");
        this.jButtonExcludeLabels.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonExcludeLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonExcludeLabelsActionPerformed(evt);
            }
        });
        this.jButtonDeleteLabels.setText("Delete");
        this.jButtonDeleteLabels.setToolTipText("Delete selected sample labels from database");
        this.jButtonDeleteLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonDeleteLabelsActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jButtonExcludeLabels, -1, 69, Short.MAX_VALUE).add(2, (Component)this.jButtonDeleteLabels, -1, 69, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jButtonExcludeLabels).addPreferredGap(0).add((Component)this.jButtonDeleteLabels)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Top depths", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jButtonExcludeTops.setText("Exclude");
        this.jButtonExcludeTops.setToolTipText("Exclude selected workspace depths (only where base depths exist)");
        this.jButtonExcludeTops.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonExcludeTopsActionPerformed(evt);
            }
        });
        this.jButtonSaveTops.setText("Save");
        this.jButtonSaveTops.setToolTipText("");
        this.jButtonSaveTops.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonSaveTopsActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jButtonExcludeTops).add((Component)this.jButtonSaveTops, -2, 69, -2));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jButtonExcludeTops).addPreferredGap(0).add((Component)this.jButtonSaveTops).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Base depths", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jButtonExcludeBases.setText("Exclude");
        this.jButtonExcludeBases.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonExcludeBasesActionPerformed(evt);
            }
        });
        this.jButtonSaveBases.setText("Save");
        this.jButtonSaveBases.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonSaveBasesActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jButtonExcludeBases, -2, 69, -2).add((Component)this.jButtonSaveBases, -2, 69, -2));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jButtonExcludeBases).addPreferredGap(0).add((Component)this.jButtonSaveBases).addContainerGap()));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSamples.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 315, Short.MAX_VALUE).add((Component)this.jLabel2)).add((Component)this.jScrollPane1, -1, 473, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jPanel4, 0, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, 81, Short.MAX_VALUE).add(2, (Component)this.jButtonSave, -1, 81, Short.MAX_VALUE).add(2, (Component)this.jButtonExclude, -1, 81, Short.MAX_VALUE).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, 81, Short.MAX_VALUE).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -2, 81, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonSave).add(13, 13, 13).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(1).add((Component)this.jPanel3, -2, 78, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, 80, -2).addPreferredGap(0, 36, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 436, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.delete(false, true);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.delete(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        try {
            Statement stmt = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int row = 0; row < this.model.data.size(); ++row) {
                MatchData.MatchPair pair = this.model.data.get(row);
                Sample ws = (Sample)pair.getWs();
                Sample db = (Sample)pair.getDb();
                if (db == null) {
                    db = new Sample(this.well.getLink().getDataModel(), ws, true);
                    if (stmt == null) {
                        stmt = this.well.getLink().getDataModel().getDatabase().createStatement();
                    }
                    this.well.getLink().addSample(stmt, db);
                    continue;
                }
                if (ws == null || ws.getStatus() != Sample.PARTSTORED) continue;
                db.update(this.well.getLink(), ws);
                this.well.getLink().setDataChanged();
            }
            if (stmt != null) {
                stmt.close();
            }
            this.model.data.init(this.well.getSamples(), this.well.getLink().getSamples());
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.well.getLink().getDataModel().commit();
            this.well.getLink().notifyObservers(Sample.class);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving samples: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.well.getLink().getDataModel().doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonExcludeLabelsActionPerformed(ActionEvent evt) {
        this.delete(false, false);
    }

    private void jButtonDeleteLabelsActionPerformed(ActionEvent evt) {
        this.delete(true, false);
    }

    private void jButtonExcludeTopsActionPerformed(ActionEvent evt) {
        this.excludeDepth(true);
    }

    private void jButtonExcludeBasesActionPerformed(ActionEvent evt) {
        this.excludeDepth(false);
    }

    private void jButtonSaveTopsActionPerformed(ActionEvent evt) {
        this.saveDepth(true);
    }

    private void jButtonSaveBasesActionPerformed(ActionEvent evt) {
        this.saveDepth(false);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchsamples.html");
    }

    private void excludeDepth(boolean top) {
        if (this.jTableMatchSamples.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchSamples.getSelectedRows();
        try {
            for (int i : selected) {
                Sample sample = (Sample)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (sample == null) continue;
                if (top && sample.getBaseDepth() != null) {
                    sample.setDepth(null, sample.getBaseDepth(), this.well.getWellUnits());
                    continue;
                }
                if (top || sample.getTopDepth() == null) continue;
                sample.setDepth(sample.getTopDepth(), null, this.well.getWellUnits());
            }
            this.well.updateSampleStatus(false);
            this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error excluding depths: ", (Exception)((Object)sbe));
        }
        catch (SQLException e) {
            SB.showStackError((String)"Error excluding depths: ", (SQLException)e);
        }
    }

    private void saveDepth(boolean saveTop) {
        if (this.jTableMatchSamples.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 2);
            return;
        }
        if (this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "Wells not linked", this.getTitle(), 2);
            return;
        }
        try {
            if (this.well.getLink().getSamples().isEmpty()) {
                JOptionPane.showMessageDialog(this, "No samples in linked well", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchSamples.getSelectedRows();
            LinkedHashMap<Sample, Double> toUpdate = new LinkedHashMap<Sample, Double>();
            for (int i : selected) {
                Sample sample = (Sample)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (sample == null || (!saveTop || sample.getTopDepth() == null) && (saveTop || sample.getBaseDepth() == null)) continue;
                for (Sample s : this.well.getLink().getSamples()) {
                    if (saveTop && s.getTopDepth() == null && sample.getType().equals(s.getType()) && Math.abs(sample.getBaseDepth() - s.getBaseDepth()) < (double)0.0029f) {
                        toUpdate.put(s, sample.getTopDepth());
                        continue;
                    }
                    if (saveTop || s.getBaseDepth() != null || !sample.getType().equals(s.getType()) || !(Math.abs(sample.getTopDepth() - s.getTopDepth()) < (double)0.0029f)) continue;
                    toUpdate.put(s, sample.getBaseDepth());
                }
            }
            for (Map.Entry e : ((HashMap)toUpdate).entrySet()) {
                Sample samp = (Sample)e.getKey();
                Double d = (Double)e.getValue();
                if (saveTop) {
                    this.well.getLink().updateSample(samp, d, samp.getBaseDepth(), samp.getType(), samp.getLabel());
                    continue;
                }
                this.well.getLink().updateSample(samp, samp.getTopDepth(), d, samp.getType(), samp.getLabel());
            }
            if (!toUpdate.isEmpty()) {
                this.well.getLink().getDataModel().commit();
                this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
                this.well.updateSampleStatus(false);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error excluding depths: ", (Exception)((Object)sbe));
        }
        catch (SQLException e) {
            SB.showStackError((String)"Error excluding depths: ", (SQLException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(boolean fromDatabase, boolean samples) {
        String strg;
        if (fromDatabase && this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchSamples.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No samples selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchSamples.getSelectedRows();
        LinkedList<Sample> toRemove = new LinkedList<Sample>();
        for (int i : selected) {
            Sample sample = fromDatabase ? (Sample)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (Sample)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
            if (sample == null) continue;
            toRemove.add(sample);
        }
        if (toRemove.size() == 0) {
            return;
        }
        if (fromDatabase && JOptionPane.showConfirmDialog(this, strg = "Really delete " + (toRemove.size() == 1 ? "this " : "these " + toRemove.size() + " ") + (samples ? "sample" : "sample label") + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (samples) {
                this.deleteSamples(fromDatabase, toRemove);
            } else {
                this.deleteLabels(fromDatabase, toRemove);
            }
            this.model.data.init(this.well.getSamples(), this.well.getLink() != null ? this.well.getLink().getSamples() : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            if (fromDatabase) {
                this.well.getLink().getDataModel().commit();
                this.well.getLink().notifyObservers(Sample.class);
            } else {
                this.well.updateSampleStatus(true);
            }
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, "Error excluding samples: " + sbe.getMessage(), this.getTitle(), 0);
            sbe.printStackTrace();
            if (fromDatabase) {
                this.well.getLink().getDataModel().doRollback();
            }
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(this, "SQL Error excluding samples: " + sqle.getMessage(), this.getTitle(), 0);
            sqle.printStackTrace();
            if (fromDatabase) {
                this.well.getLink().getDataModel().doRollback();
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void deleteLabels(boolean fromDatabase, LinkedList<Sample> toRemove) throws SBException, SQLException {
        for (Sample sample : toRemove) {
            WsWell w = fromDatabase ? this.well.getLink() : this.well;
            w.updateSample(sample, sample.getTopDepth(), sample.getBaseDepth(), sample.getType(), "");
        }
    }

    private void deleteSamples(boolean fromDatabase, LinkedList<Sample> toRemove) throws SBException, SQLException {
        String text;
        int nSamples = 0;
        WsWell deleteWell = fromDatabase ? this.well.getLink() : this.well;
        Boolean deleteAnalyses = null;
        for (Sample sample : toRemove) {
            boolean hasIGD = false;
            boolean hasAnalyses = false;
            Iterator i$ = sample.getAnalyses().iterator();
            if (i$.hasNext()) {
                Smpdtl dtl = (Smpdtl)i$.next();
                if (deleteAnalyses == null) {
                    int opt;
                    deleteAnalyses = !fromDatabase ? Boolean.valueOf((opt = JOptionPane.showConfirmDialog(this, "Do you want to exclude linked analysis data?", this.getTitle(), 0)) == 0) : Boolean.valueOf(false);
                }
                if (deleteAnalyses.booleanValue()) {
                    sample.deleteDtl(deleteWell.getWellID(), dtl.getAnalyID(), dtl);
                    deleteWell.setDataChanged();
                    hasAnalyses = false;
                } else {
                    hasAnalyses = true;
                }
            }
            if (!hasAnalyses && deleteWell.hasSampleIGD(sample) > 0) {
                hasIGD = true;
            }
            if (hasAnalyses || hasIGD) continue;
            deleteWell.deleteSample(sample);
            ++nSamples;
        }
        String string = text = fromDatabase ? "deleted" : "excluded";
        if (toRemove.size() - nSamples > 0) {
            JOptionPane.showMessageDialog(this, "Not all samples " + text + " (" + nSamples + "/" + toRemove.size() + "): linked interpreted or analysis data", this.getTitle(), 2);
        } else {
            JOptionPane.showMessageDialog(this, "Samples " + text + ": " + nSamples, this.getTitle(), 1);
        }
    }
}

