/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogMatchGroup;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchSet;
import model2.ImageSet;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import model2.TxGroupSet;
import util.MatchData;
import util.SB;
import util.SBException;

public class DialogMatchSet
extends JDialog {
    Image backgroundImage;
    SBdb ws;
    SBdb db;
    TxGroupSet wsSet = null;
    TableModelMatchSet model = new TableModelMatchSet();
    DefaultComboBoxModel dbModel = new DefaultComboBoxModel();
    static final String SAVE_IMAGE_QUESTION = "Do you want to save the images in the import file as new linked images?\nNote: if taxa are already linked to the same images then they will be duplicated";
    boolean inStartup = true;
    private JButton jButtonAddSet;
    private JButton jButtonCancel;
    private JButton jButtonExclude;
    private JButton jButtonHelp;
    private JButton jButtonMatchGroup;
    private JButton jButtonOK;
    private JComboBox jComboBoxDBSet;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchSet;
    private JTextField jTextFieldDonorSet;

    public DialogMatchSet(Frame parent, boolean modal, SBdb ws, SBdb db) throws SQLException {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Match Group Set");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.setUpTable(this.jTableMatchSet);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        for (TxGroupSet set : this.db.getTxGroupSetsSorted()) {
            this.dbModel.addElement(set);
        }
        this.wsSet = (TxGroupSet)this.ws.getTxGroupSets().iterator().next();
        this.jTextFieldDonorSet.setText(this.wsSet.getName());
        this.dbModel.setSelectedItem(this.db.getTxGroupSet(this.wsSet.getName()));
        this.initData();
        this.inStartup = false;
    }

    private void initData() {
        if (this.wsSet == null) {
            return;
        }
        try {
            TxGroupSet set = (TxGroupSet)this.jComboBoxDBSet.getSelectedItem();
            if (set != null && set != this.wsSet) {
                this.model.data = new MatchData();
                this.model.data.init(this.wsSet.getGroups(), set.getGroups());
                for (int i = 0; i < this.model.data.size(); ++i) {
                    MatchData.MatchPair pair = this.model.data.get(i);
                    TxGroup wsGroup = (TxGroup)pair.getWs();
                    if (wsGroup == null) continue;
                    wsGroup.updateStatus(this.db.getTxGroup(wsGroup.getName()));
                }
                this.model.fireTableDataChanged();
            } else if (set == this.wsSet) {
                this.model.data = new MatchData();
                LinkedList<TxGroup> dbList = new LinkedList<TxGroup>();
                this.model.data.init(this.wsSet.getGroups(), null);
                for (int i = 0; i < this.model.data.size(); ++i) {
                    MatchData.MatchPair pair = this.model.data.get(i);
                    TxGroup wsGroup = (TxGroup)pair.getWs();
                    if (wsGroup != null) {
                        for (Taxon taxon : this.ws.getTxGroupTaxa(wsGroup)) {
                            this.db.lookupTaxonLink(taxon);
                        }
                    }
                    TxGroup dbGroup = this.db.getTxGroup(wsGroup.getName());
                    wsGroup.updateStatus(dbGroup);
                    if (dbGroup == null) continue;
                    dbList.add(dbGroup);
                }
                if (dbList.size() > 0) {
                    this.model.data.init(this.wsSet.getGroups(), dbList);
                }
                this.model.fireTableDataChanged();
            } else if (set == null) {
                this.model.data = new MatchData();
                this.model.data.init(this.wsSet.getGroups(), null);
                for (int i = 0; i < this.model.data.size(); ++i) {
                    MatchData.MatchPair pair = this.model.data.get(i);
                    TxGroup wsGroup = (TxGroup)pair.getWs();
                    if (wsGroup == null) continue;
                    for (Taxon taxon : this.ws.getTxGroupTaxa(wsGroup)) {
                        this.db.lookupTaxonLink(taxon);
                    }
                    wsGroup.updateStatus(this.db.getTxGroup(wsGroup.getName()));
                }
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchSet.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonMatchGroup = new JButton();
        this.jTextFieldDonorSet = new JTextField();
        this.jComboBoxDBSet = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchSet = new JTable();
        this.jButtonAddSet = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 250));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSet.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace:");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude slected groups from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSet.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("Database:");
        this.jButtonMatchGroup.setText("Match group..");
        this.jButtonMatchGroup.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMatchGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSet.this.jButtonMatchGroupActionPerformed(evt);
            }
        });
        this.jTextFieldDonorSet.setEditable(false);
        this.jComboBoxDBSet.setModel(this.dbModel);
        this.jComboBoxDBSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSet.this.jComboBoxDBSetActionPerformed(evt);
            }
        });
        this.jTableMatchSet.setModel(this.model);
        this.jTableMatchSet.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchSet.this.jTableMatchSetMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchSet);
        this.jButtonAddSet.setText("Add...");
        this.jButtonAddSet.setToolTipText("Add workspace set to database");
        this.jButtonAddSet.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAddSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSet.this.jButtonAddSetActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSet.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSet.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDonorSet, -1, 146, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddSet, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxDBSet, 0, 189, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 554, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING, -2, 93, -2).addComponent(this.jButtonHelp, GroupLayout.Alignment.TRAILING, -2, 93, -2).addComponent(this.jButtonCancel, GroupLayout.Alignment.TRAILING, -1, 93, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -1, 93, Short.MAX_VALUE).addComponent(this.jButtonMatchGroup, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.jButtonCancel, this.jButtonExclude, this.jButtonHelp, this.jButtonMatchGroup, this.jButtonOK);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDonorSet, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jButtonAddSet).addComponent(this.jLabel2)).addComponent(this.jComboBoxDBSet, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMatchGroup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 72, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, -1, 205, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxDBSetActionPerformed(ActionEvent evt) {
        if (!this.inStartup) {
            this.initData();
        }
    }

    private void jButtonMatchGroupActionPerformed(ActionEvent evt) {
        if (this.jTableMatchSet.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row of the table to match", this.getTitle(), 2);
            return;
        }
        MatchData.MatchPair pair = this.model.data.get(this.jTableMatchSet.getSelectedRow());
        try {
            TxGroup wsGroup = (TxGroup)pair.getWs();
            TxGroup dbGroup = (TxGroup)pair.getDb();
            if (dbGroup == null) {
                dbGroup = this.db.getTxGroup(wsGroup.getName());
            }
            DialogMatchGroup dialog = new DialogMatchGroup(this, true, wsGroup, dbGroup, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (wsGroup != null) {
                if (dbGroup == null) {
                    dbGroup = this.db.getTxGroup(wsGroup.getName());
                    wsGroup.updateStatus(dbGroup);
                    this.initData();
                } else {
                    wsGroup.updateStatus(dbGroup);
                }
            }
            this.model.fireTableDataChanged();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jTableMatchSetMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonMatchGroupActionPerformed(null);
        }
    }

    private void jButtonAddSetActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.dbModel.getSize(); ++i) {
            TxGroupSet set = (TxGroupSet)this.dbModel.getElementAt(i);
            if (!set.getName().equals(this.wsSet.getName())) continue;
            JOptionPane.showMessageDialog(this, "A set of this name already exists", this.getTitle(), 1);
            return;
        }
        this.dbModel.addElement(this.wsSet);
        this.jComboBoxDBSet.repaint();
        this.jComboBoxDBSet.setSelectedItem(this.wsSet);
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        int[] selected = this.jTableMatchSet.getSelectedRows();
        LinkedList<TxGroup> toRemove = new LinkedList<TxGroup>();
        for (int i : selected) {
            TxGroup wsGroup = (TxGroup)this.model.data.get(i).getWs();
            if (wsGroup == null) continue;
            toRemove.add(wsGroup);
        }
        try {
            for (TxGroup wsGroup : toRemove) {
                this.wsSet.removeGroup(wsGroup.getID());
            }
            this.initData();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            TxGroupSet dbSet = (TxGroupSet)this.jComboBoxDBSet.getSelectedItem();
            if (dbSet == null) {
                JOptionPane.showMessageDialog(this, "No database group set selected/added", this.getTitle(), 2);
                return;
            }
            for (TxGroup group : this.wsSet.getGroups()) {
                if (group.getStatus() != TxGroup.CONFLICT) continue;
                JOptionPane.showMessageDialog(this, "Cannot save due to conflicting group contents", this.getTitle(), 2);
                return;
            }
            LinkedList<TxGroup> dbGroups = new LinkedList<TxGroup>();
            for (TxGroup group : this.wsSet.getGroups()) {
                if (group.getStatus() == TxGroup.NOTSTORED) {
                    TxGroup dbGroup = this.db.copyToDatabase(this.ws, group);
                    this.db.commit();
                    group.updateStatus(dbGroup);
                    dbGroups.add(dbGroup);
                    continue;
                }
                dbGroups.add(this.db.getTxGroup(group.getName()));
            }
            if (dbSet == this.wsSet) {
                dbSet = this.db.addTxGroupSet(this.wsSet.getName(), dbGroups);
                this.db.notifyObservers((Object)dbSet);
                JOptionPane.showMessageDialog(this, "Set added to database", this.getTitle(), 1);
            } else {
                dbSet.update(dbSet.getName(), dbGroups);
                dbSet.notifyObservers();
                JOptionPane.showMessageDialog(this, "Set updated in database", this.getTitle(), 1);
            }
            this.db.commit();
            this.saveImages();
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.db.doRollback();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchset.html");
    }

    void saveImages() throws SQLException, SBException, FileNotFoundException, IOException {
        boolean askImageSave = false;
        for (Taxon taxon : this.ws.getTaxa()) {
            if (taxon.getNwsImages() == null) continue;
            if (!askImageSave) {
                int opt = JOptionPane.showConfirmDialog(this, SAVE_IMAGE_QUESTION, this.getTitle(), 0, 3);
                if (opt != 0) {
                    return;
                }
                askImageSave = true;
            }
            Taxon dbTaxon = taxon.getLink();
            for (ImageSet wsTaxonSet : taxon.getWsImageSets()) {
                ImageSet set = new ImageSet(this.db, wsTaxonSet);
                set.store();
                this.db.addTaxonImageSet(dbTaxon, set);
            }
        }
    }
}

