/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.DialogFilePreviewSelect;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchSqpick;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.InterpHdr;
import model2.Lastval;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Surface;
import model2.Well;
import model2.WellInterp;
import model2.WsWell;
import util.ArrowCellRenderer;
import util.InvalidFieldException;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchSqpick
extends JDialog {
    WsWell wsWell = null;
    TableModelMatchSqpick model = new TableModelMatchSqpick();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Image backgroundImage;
    WellInterp wsInterp = null;
    WellInterp dbInterp = null;
    SBdb dbDB;
    SBdb wsDB;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonRead;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableMatchSqpick;

    public DialogMatchSqpick(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char units, InterpHdr hdr) throws SBException, SQLException {
        super(parent, modal);
        this.wsWell = well;
        this.dbDB = db;
        this.wsDB = ws;
        this.model.units = units;
        this.initComponents();
        this.init(hdr);
    }

    private void init(InterpHdr hdr) throws SBException, SQLException {
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        this.setTitle("Match Sequence Picks");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        int interpID = hdr.getInterpID();
        if (this.wsWell.hasInterpLoaded(interpID)) {
            this.wsInterp = this.wsWell.getInterp(interpID);
        }
        this.checkLinks();
        if (this.wsWell.getLink() != null && hdr.getLink() != null) {
            this.wsWell.getLink().loadInterps();
            int linkInterpID = hdr.getLink().getInterpID();
            if (this.wsWell.getLink().hasInterpLoaded(linkInterpID)) {
                this.dbInterp = this.wsWell.getLink().getInterp(linkInterpID);
                this.wsWell.getLink().loadInterp(this.dbInterp);
            }
        }
        this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
        SB.setTableHeaderBold((JTable)this.jTableMatchSqpick);
        TableColumnModel columnModel = this.jTableMatchSqpick.getTableHeader().getColumnModel();
        columnModel.getColumn(8).setMaxWidth(TableModelMatchSqpick.colWidths[8]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchSqpick.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchSqpick.colWidths[i]);
        }
        this.jTableMatchSqpick.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchSqpick.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchSqpick);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableMatchSqpick.getTableHeader().setReorderingAllowed(false);
    }

    private void checkLinks() throws SQLException, SBException {
        if (this.wsWell.getLink() != null) {
            for (InterpHdr interpHdr : this.wsDB.getInterps()) {
                if (interpHdr.getLink() != null) continue;
                throw new SBException("Cannot open dialog, Versions not Matched");
            }
            for (SQPick pick : this.wsInterp.getSQPicks()) {
                if (pick.getSurface() == null || pick.getSurface().getScheme().getLink() != null) continue;
                throw new SBException("Cannot open dialog, Stratigraphic Schemes not Matched");
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchSqpick.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchSqpick = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.setModal(true);
        this.jTableMatchSqpick.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableMatchSqpick);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSqpick.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSqpick.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSqpick.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSqpick.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved intervals from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchSqpick.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 401, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jScrollPane1, -1, 559, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonRead, -1, 78, Short.MAX_VALUE).addComponent(this.jSeparator1, -1, 78, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, 78, Short.MAX_VALUE)).addGap(13, 13, 13)));
        jPanel1Layout.linkSize(0, this.jButtonClose, this.jButtonDelete, this.jButtonExclude, this.jButtonRead, this.jButtonSave, this.jSeparator1);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addGap(13, 13, 13).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 227, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 383, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteSqpick(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteSqpick(true);
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.dbDB, (String)"JIGDFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.addExtension("csv");
        filter.addExtension("lst");
        filter.addExtension("prn");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            String[] types = new String[]{"CSV well | depth | pick (no header)", "CSV depth | pick (1 header lines)", "CSV well | pick | depth | age (1 header line)", "Tabbed well | well | * | * | pick | age | depth"};
            try {
                Lastval.putString((SBdb)this.dbDB, (String)"JIGDFILE", (String)fileName);
                this.dbDB.getDatabase().commit();
                DialogFilePreviewSelect selector = new DialogFilePreviewSelect((Dialog)this, true, fileName, types);
                selector.setLocationRelativeTo(this);
                selector.setVisible(true);
                if (!selector.isOK()) {
                    return;
                }
                int selectedFileType = selector.selectedItem;
                BufferedReader in = new BufferedReader(new FileReader(fileName));
                String schemeName = jFileChooser.getSelectedFile().getName();
                schemeName = schemeName.substring(0, schemeName.indexOf(46) - 1);
                IGDScheme scheme = this.wsDB.addIGDScheme(10, schemeName);
                LinkedList<Integer> dummy = new LinkedList<Integer>();
                dummy.add(1);
                this.wsWell.fillData(dummy);
                switch (selectedFileType) {
                    case 0: {
                        this.importTextFile(in, scheme, ',', 0, 3, 0, 1, -1, 2, -1);
                        break;
                    }
                    case 1: {
                        this.importTextFile(in, scheme, ',', 1, 2, -1, 0, -1, 1, -1);
                        break;
                    }
                    case 2: {
                        this.importTextFile(in, scheme, ',', 1, 4, 0, 2, -1, 1, 3);
                        break;
                    }
                    case 3: {
                        this.importTextFile(in, scheme, '\t', 1, 7, 0, 6, -1, 4, 5);
                        break;
                    }
                    default: {
                        JOptionPane.showMessageDialog(this, "Cannot recognise file type. Please select a file type from the list of types at the base of the dialog", "Import", 2);
                    }
                }
                in.close();
                if (this.wsInterp != null) {
                    this.wsInterp.updateSQPickStatus(this.wsWell.getMonitor(this.wsInterp.getHeader().getInterpID(), 14), this.wsWell.getLink(), this.wsWell.getWellUnits());
                }
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (IOException eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.dbDB);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        block27: {
            if (this.wsWell.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
                return;
            }
            if (this.dbInterp == null) {
                JOptionPane.showMessageDialog(this, "Version not linked - use Match | Versions from main menu.", this.getTitle(), 2);
                return;
            }
            boolean samplesCreated = false;
            SQPick added = null;
            Well dbWell = this.wsWell.getLink();
            Statement stmt = null;
            for (int row = 0; row < this.model.data.size(); ++row) {
                MatchData.MatchPair pair = this.model.data.get(row);
                SQPick ws = (SQPick)pair.getWs();
                SQPick db = (SQPick)pair.getDb();
                if (ws == null) continue;
                if (db == null) {
                    if (ws.getSurface().getSchID() == 0) {
                        JOptionPane.showMessageDialog(this, "Interval: " + ws.toString() + " not linked to a scheme. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    IGDScheme wsScheme = this.wsDB.getIGDScheme(ws.getSurface().getSchID());
                    if (wsScheme == null) {
                        JOptionPane.showMessageDialog(this, "Scheme for pick: " + ws.toString() + " not found in workspace. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    IGDScheme dbScheme = wsScheme.getLink();
                    if (dbScheme == null) {
                        JOptionPane.showMessageDialog(this, "Pick: " + ws.toString() + " scheme not found in workspace. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    if (ws.getSurface().getLink() == null) {
                        JOptionPane.showMessageDialog(this, "Pick: " + ws.toString() + " surface not linked to database. Use Match | Stratigraphic intervals from menu.");
                        break;
                    }
                    Sample sample = dbWell.getSample(ws.getSample().getTopDepth(), ws.getSample().getBaseDepth(), ws.getSample().getType());
                    if (sample == null) {
                        int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getSample() + " does not exist: create it?", this.getTitle(), 1, 3);
                        if (opt == 1) continue;
                        if (opt == 2 || opt == -1) break;
                        if (stmt == null) {
                            stmt = dbWell.getDataModel().getDatabase().createStatement();
                        }
                        sample = dbWell.addWsSample(stmt, ws.getSample());
                        samplesCreated = true;
                    }
                    added = this.dbInterp.addSQPick(dbWell, sample, ws.getSurface().getLink(), ws.getInfName(), ws.isQuestionable(), ws.getBnd());
                    dbWell.getDataModel().commit();
                    continue;
                }
                if (ws.getStatus() != Sample.PARTSTORED) continue;
                JOptionPane.showMessageDialog(null, "Not implemented - can't update picks from workspace.");
            }
            if (stmt != null) {
                stmt.close();
            }
            this.wsWell.getLink().getDataModel().commit();
            try {
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (added != null) {
                    this.dbInterp.notifyObservers(added);
                }
                if (samplesCreated) {
                    this.wsWell.getLink().notifyObservers(Sample.class);
                }
                break block27;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block27;
            catch (Exception e) {
                try {
                    JOptionPane.showMessageDialog(this, "Error saving interval: " + e.getMessage(), this.getTitle(), 0);
                    e.printStackTrace();
                    this.wsWell.getLink().getDataModel().doRollback();
                }
                catch (Throwable throwable) {
                    try {
                        this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                        this.sorter.reallocateIndexes();
                        this.sorter.fireTableDataChanged();
                        if (added != null) {
                            this.dbInterp.notifyObservers(added);
                        }
                        if (samplesCreated) {
                            this.wsWell.getLink().notifyObservers(Sample.class);
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                    this.sorter.reallocateIndexes();
                    this.sorter.fireTableDataChanged();
                    if (added != null) {
                        this.dbInterp.notifyObservers(added);
                    }
                    if (samplesCreated) {
                        this.wsWell.getLink().notifyObservers(Sample.class);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    void importTextFile(BufferedReader in, IGDScheme scheme, char delim, int nHeaders, int nColumns, int wellColumn, int topColumn, int baseColumn, int pickColumn, int ageColumn) throws IOException, SBException, SQLException {
        String buff;
        for (int i = 0; i < nHeaders; ++i) {
            buff = in.readLine();
        }
        buff = in.readLine();
        String wellUWI = null;
        while (buff != null) {
            block26: {
                if (buff.indexOf(delim) <= 0) continue;
                Sample sample = null;
                Surface surface = null;
                double age = 0.0;
                double depth = 0.0;
                int column = 0;
                while (column < nColumns && buff != null && !buff.isEmpty()) {
                    String strg = buff.indexOf(delim) > 0 ? buff.substring(0, buff.indexOf(delim)).trim() : buff.trim();
                    if (column == wellColumn) {
                        if (wellUWI == null) {
                            wellUWI = strg;
                        }
                        if (!wellUWI.equals(strg)) {
                            throw new SBException("Well identifier changes in file - edit file to separate");
                        }
                    } else if (column == topColumn) {
                        depth = SB.parseDepthString((String)strg);
                        if (depth < (double)0.0029f) {
                            buff = null;
                            continue;
                        }
                        sample = this.wsWell.getSample(depth, null, true);
                        if (sample == null) {
                            sample = this.wsWell.addSample(this.dbDB.useSampleTops() ? Double.valueOf(depth) : null, this.dbDB.useSampleTops() ? null : Double.valueOf(depth), "LOG", null);
                        }
                    } else {
                        if (column == baseColumn) {
                            throw new SBException("Base column reading not supported");
                        }
                        if (column == pickColumn) {
                            String pickName = buff.substring(0).trim();
                            if (pickName.indexOf(delim) >= 0) {
                                pickName = pickName.substring(0, pickName.indexOf(delim)).trim();
                            }
                            if ((surface = scheme.getSurface(pickName)) == null) {
                                try {
                                    surface = scheme.addSurface(new Surface.Builder(scheme.getDatabase()).name(pickName).age(age).type(Surface.SurfaceType.parseType((String)pickName, (Surface.SurfaceType)Surface.SurfaceType.MFS)));
                                }
                                catch (InvalidFieldException ife) {
                                    ife.printStackTrace();
                                }
                            }
                        } else if (column == ageColumn) {
                            age = Double.parseDouble(strg);
                            if (surface != null) {
                                surface.setAge(age);
                            }
                        }
                    }
                    buff = buff.substring(buff.indexOf(delim) + 1);
                    ++column;
                }
                if (sample != null && surface != null) {
                    try {
                        this.wsInterp.addSQPick((Well)this.wsWell, sample, surface, (String)null, false, IGDIntervalZone.bnds[surface.getBndDefault() - 1]);
                        break block26;
                    }
                    catch (IllegalStateException ex) {
                        if (!this.handleException(ex)) {
                            break;
                        }
                        break block26;
                    }
                    catch (InvalidFieldException ex) {
                        if (!this.handleException((Exception)((Object)ex))) {
                            break;
                        }
                        break block26;
                    }
                }
                System.out.println("Can't add pick for depth: " + depth + ", surface: " + surface);
            }
            buff = in.readLine();
        }
    }

    private boolean handleException(Exception ex) {
        int opt = JOptionPane.showConfirmDialog(this, "Error reading file: " + ex.getMessage() + "\nContinue reading?", this.getTitle(), 0, 3);
        return opt != 1;
    }

    private void deleteSqpick(boolean fromDatabase) {
        block10: {
            if (fromDatabase && this.wsWell.getLink() == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchSqpick.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchSqpick.getSelectedRows();
            LinkedList<SQPick> toRemove = new LinkedList<SQPick>();
            for (int i : selected) {
                SQPick sqpick = fromDatabase ? (SQPick)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (SQPick)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (sqpick == null) continue;
                toRemove.add(sqpick);
            }
            if (fromDatabase && toRemove.size() > 0) {
                String msg = "Really delete ";
                msg = msg + (toRemove.size() == 1 ? "this pick" : "these " + toRemove.size() + " pick");
                if (JOptionPane.showConfirmDialog(this, msg = msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                    return;
                }
            }
            try {
                int nItems = 0;
                WsWell deleteFromWell = fromDatabase ? this.wsWell.getLink() : this.wsWell;
                WellInterp deleteFromInterp = fromDatabase ? this.dbInterp : this.wsInterp;
                for (SQPick sqpick : toRemove) {
                    deleteFromInterp.deleteSQPick(sqpick, deleteFromWell.getWellID());
                    ++nItems;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Picks " + text + ": " + nItems, this.getTitle(), 1);
                if (fromDatabase) {
                    deleteFromWell.getDataModel().commit();
                    deleteFromInterp.notifyObservers((Object)21);
                } else {
                    this.wsWell.updateSQPickStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
                }
                this.model.data.init(this.wsInterp != null ? this.wsInterp.getSQPicks() : null, this.dbInterp != null ? this.dbInterp.getSQPicks() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error " + (fromDatabase ? "deleting" : "excluding") + " : " + e.getMessage(), this.getTitle(), 0);
                e.printStackTrace();
                if (!fromDatabase) break block10;
                this.wsWell.getLink().getDataModel().doRollback();
            }
        }
    }
}

