/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import jsbugs.DialogMatchCategories;
import jsbugs.DialogMatchTaxaEdit;
import jsbugs.DialogSelectTaxa;
import jsbugs.DialogSource;
import jsbugs.DialogTaxonImages;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.TableModelMatchTaxa;
import jsbugs.WebSearch;
import model2.AbnScheme;
import model2.Category;
import model2.Discipline;
import model2.Genus;
import model2.Project;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Source;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import model2.Well;
import util.BareBonesBrowserLaunch;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.TableSorter;

public class DialogMatchTaxa
extends SBDialog {
    private final TableModelMatchTaxa model = new TableModelMatchTaxa();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final SBdb ws;
    private final SBdb db;
    private Source source;
    private final int[] nMatched = new int[]{0, 0, 0, 0, 0};
    private final boolean[] discOK = new boolean[]{false, false, false, false, false};
    private final JComboBox jComboBoxOccType = new JComboBox();
    private Image backgroundImage;
    private boolean askDataSource = true;
    private final boolean wellData;
    private ButtonGroup buttonGroupDiscipline;
    private JButton jButtonAddAll;
    private JButton jButtonCancel;
    private JButton jButtonCategories;
    private JButton jButtonClean;
    private JButton jButtonCodes;
    private JButton jButtonEdit;
    private JButton jButtonExclude;
    private JButton jButtonHelp;
    private JButton jButtonLoad;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JButton jButtonSelectSource;
    private JButton jButtonWebLookup;
    private JButton jButtonWrite;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JProgressBar jProgressBarEvents;
    private JProgressBar jProgressBarMacro;
    private JProgressBar jProgressBarMicro;
    private JProgressBar jProgressBarNanno;
    private JProgressBar jProgressBarPaly;
    private JRadioButton jRadioButtonEvents;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTable jTableMatchTaxa;
    private JTextField jTextFieldSource;

    public DialogMatchTaxa(Frame parent, boolean modal, SBdb ws, SBdb db, boolean wellData) throws SQLException, SBException {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.wellData = wellData;
        this.setTitle("Match Taxa");
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.setupTable(this.jTableMatchTaxa);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchTaxa);
        this.model.init(this.ws, this.wellData);
        this.jProgressBarMicro.setStringPainted(true);
        if (this.wellData) {
            this.jProgressBarNanno.setStringPainted(true);
            this.jProgressBarMacro.setStringPainted(true);
            this.jProgressBarPaly.setStringPainted(true);
            this.jProgressBarEvents.setStringPainted(true);
            for (int i = 0; i < 5; ++i) {
                char discID;
                char c = discID = i == 4 ? (char)'E' : SBdb.discArr[i];
                if (this.model.taxa[i].isEmpty()) {
                    this.getProgressBar(discID).setEnabled(false);
                    this.getProgressBar(discID).setForeground(new Color(240, 240, 240));
                    this.getProgressBar(discID).setStringPainted(false);
                    this.getRadioButton(discID).setEnabled(false);
                }
                this.model.discID = discID;
                this.setProgressBar(discID, this.model.getNMatched(), this.model.taxa[i].size());
            }
        } else {
            this.jRadioButtonMicro.setText("Progress:");
            this.jProgressBarNanno.setVisible(false);
            this.jProgressBarNanno.setEnabled(false);
            this.jProgressBarMacro.setVisible(false);
            this.jProgressBarMacro.setEnabled(false);
            this.jProgressBarPaly.setVisible(false);
            this.jProgressBarPaly.setEnabled(false);
            this.jProgressBarEvents.setVisible(false);
            this.jProgressBarEvents.setEnabled(false);
            this.jRadioButtonMacro.setVisible(false);
            this.jRadioButtonNanno.setVisible(false);
            this.jRadioButtonPaly.setVisible(false);
            this.jRadioButtonEvents.setVisible(false);
            this.model.discID = (char)77;
            this.setProgressBar('M', this.model.getNMatched(), this.model.taxa[0].size());
        }
        this.setDiscButton();
        this.jTextFieldSource.setText("<not selected>");
        this.jComboBoxOccType.insertItemAt("In-situ", 0);
        this.jComboBoxOccType.insertItemAt("Reworked", 1);
        this.jComboBoxOccType.insertItemAt("Caved", 2);
        this.jComboBoxOccType.insertItemAt("Questionable", 3);
        Iterator it = this.db.getSpecTypeIterator();
        String defaultType = this.db.getSpecType(0);
        while (it.hasNext()) {
            String type = (String)it.next();
            if (type.equals(defaultType)) continue;
            this.jComboBoxOccType.addItem(type);
        }
        this.jTableMatchTaxa.getTableHeader().getColumnModel().getColumn(8).setCellEditor(new DefaultCellEditor(this.jComboBoxOccType));
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void setModel(char discID) {
        this.model.discID = discID;
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.nMatched[this.model.getListIndex((char)this.model.discID)] = this.model.getNMatched();
    }

    private void editTaxon() {
        int selectedRow = this.jTableMatchTaxa.getSelectedRow();
        Taxon wsTx = this.model.getList().get(this.sorter.getIndexOf(selectedRow));
        boolean wasAlreadyMatched = false;
        if (this.source == null && this.askDataSource) {
            int opt = JOptionPane.showConfirmDialog(this, "Do you want to select a data source to record matches?", this.getTitle(), 0);
            if (opt == 0) {
                this.jButtonSelectSourceActionPerformed(null);
            }
            this.askDataSource = false;
        }
        try {
            Taxon searchTaxon;
            if (this.sorter.getValueAt(selectedRow, 6) == null) {
                String cat = wsTx.getCatMnem().isEmpty() ? null : wsTx.getCatMnem();
                Taxon[] txArr = this.db.lookupSpecies(cat, wsTx.getGenus().getGenus(), wsTx.getGenus().getSubGenus(), wsTx.getSpecies(), wsTx.getSubSpecies(), wsTx.getGenus().getQ1(), wsTx.getGenus().getQ2(), wsTx.getGenus().getQ3(), wsTx.getGenus().getQ4(), wsTx.getQ1(), wsTx.getQ2(), wsTx.getQ3(), wsTx.getQ4());
                searchTaxon = txArr != null ? txArr[0] : wsTx;
            } else {
                searchTaxon = this.model.getList().get(this.sorter.getIndexOf(selectedRow));
                boolean bl = wasAlreadyMatched = searchTaxon.getLink() != null;
            }
            if (wasAlreadyMatched && this.jTableMatchTaxa.getSelectedColumn() == 9) {
                this.showImages();
                return;
            }
            DialogSelectTaxa selectTaxon = new DialogSelectTaxa((JDialog)this, true, this.db, true, searchTaxon);
            selectTaxon.setLocationRelativeTo(this);
            selectTaxon.setVisible(true);
            if (selectTaxon.selection != null) {
                wsTx.setLink(selectTaxon.selection.get(0));
                if (this.source != null) {
                    this.source.storeMatch(this.db, wsTx);
                }
                if (!wasAlreadyMatched) {
                    int n = this.model.getListIndex(this.model.discID);
                    this.nMatched[n] = this.nMatched[n] + 1;
                    this.setProgress();
                }
                this.discOK[this.model.getListIndex((char)this.model.discID)] = true;
                this.db.commit();
            }
            this.sorter.checkModel();
            this.sorter.fireTableDataChanged();
            this.jTableMatchTaxa.setRowSelectionInterval(selectedRow, selectedRow);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void showImages() {
        Taxon taxon = this.model.getList().get(this.sorter.getIndexOf(this.jTableMatchTaxa.getSelectedRow())).getLink();
        try {
            DialogTaxonImages dialog = new DialogTaxonImages(this, true, this.db, taxon);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.buttonGroupDiscipline = new ButtonGroup();
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchTaxa.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchTaxa = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jProgressBarMicro = new JProgressBar();
        this.jProgressBarNanno = new JProgressBar();
        this.jProgressBarPaly = new JProgressBar();
        this.jProgressBarMacro = new JProgressBar();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonEvents = new JRadioButton();
        this.jProgressBarEvents = new JProgressBar();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jTextFieldSource = new JTextField();
        this.jButtonLoad = new JButton();
        this.jButtonSelectSource = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonCategories = new JButton();
        this.jButtonMatchAll = new JButton();
        this.jButtonCodes = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonWebLookup = new JButton();
        this.jButtonClean = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonWrite = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 530));
        this.setModal(true);
        this.jTableMatchTaxa.setModel((TableModel)this.sorter);
        this.jTableMatchTaxa.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchTaxa.this.jTableMatchTaxaMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchTaxa);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel7.setFont(new Font("Tahoma", 1, 13));
        this.jLabel7.setText("...Database");
        this.jPanel5.setOpaque(false);
        this.jPanel4.setOpaque(false);
        this.jProgressBarMicro.setForeground(new Color(255, 51, 51));
        this.jProgressBarNanno.setForeground(new Color(255, 51, 51));
        this.jProgressBarPaly.setForeground(new Color(255, 51, 51));
        this.jProgressBarPaly.setRequestFocusEnabled(false);
        this.jProgressBarMacro.setForeground(new Color(255, 51, 51));
        this.buttonGroupDiscipline.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nanno:");
        this.jRadioButtonNanno.setOpaque(false);
        this.jRadioButtonNanno.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jRadioButtonNannoActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macro:");
        this.jRadioButtonMacro.setOpaque(false);
        this.jRadioButtonMacro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jRadioButtonMacroActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micro:");
        this.jRadioButtonMicro.setOpaque(false);
        this.jRadioButtonMicro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jRadioButtonMicroActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Paly:");
        this.jRadioButtonPaly.setOpaque(false);
        this.jRadioButtonPaly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jRadioButtonPalyActionPerformed(evt);
            }
        });
        this.buttonGroupDiscipline.add(this.jRadioButtonEvents);
        this.jRadioButtonEvents.setText("Events:");
        this.jRadioButtonEvents.setOpaque(false);
        this.jRadioButtonEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jRadioButtonEventsActionPerformed(evt);
            }
        });
        this.jProgressBarEvents.setForeground(new Color(255, 51, 51));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Data Source", 0, 0, null, new Color(51, 102, 204)));
        this.jPanel2.setOpaque(false);
        this.jTextFieldSource.setBackground(new Color(255, 255, 204));
        this.jTextFieldSource.setEditable(false);
        this.jTextFieldSource.setText("jTextField1");
        this.jButtonLoad.setText("Load...");
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonLoadActionPerformed(evt);
            }
        });
        this.jButtonSelectSource.setText("...");
        this.jButtonSelectSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonSelectSourceActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jButtonLoad, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectSource, -2, 31, -2).addGap(12, 12, 12)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldSource, -1, 154, Short.MAX_VALUE).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldSource, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonLoad).addComponent(this.jButtonSelectSource)).addContainerGap()));
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jRadioButtonEvents).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBarEvents, -2, 117, -2)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonNanno).addComponent(this.jRadioButtonMicro).addComponent(this.jRadioButtonPaly).addComponent(this.jRadioButtonMacro)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jProgressBarPaly, GroupLayout.Alignment.LEADING, -2, 117, -2).addComponent(this.jProgressBarNanno, GroupLayout.Alignment.LEADING, -2, 117, -2).addComponent(this.jProgressBarMicro, -2, 117, -2).addComponent(this.jProgressBarMacro, -2, 117, -2)))).addGap(12, 12, 12)));
        jPanel4Layout.linkSize(0, this.jRadioButtonEvents, this.jRadioButtonMacro, this.jRadioButtonMicro, this.jRadioButtonNanno, this.jRadioButtonPaly);
        jPanel4Layout.linkSize(0, this.jProgressBarEvents, this.jProgressBarMacro, this.jProgressBarMicro, this.jProgressBarNanno, this.jProgressBarPaly);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jRadioButtonMicro, -2, 11, -2).addComponent(this.jProgressBarMicro, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonNanno, -2, 17, -2).addComponent(this.jProgressBarNanno, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jRadioButtonPaly, -2, 15, -2).addComponent(this.jProgressBarPaly, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMacro, -2, 17, -2).addComponent(this.jProgressBarMacro, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonEvents, -2, 17, -2).addComponent(this.jProgressBarEvents, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        jPanel4Layout.linkSize(1, this.jProgressBarEvents, this.jProgressBarMacro, this.jProgressBarMicro, this.jProgressBarNanno, this.jProgressBarPaly);
        jPanel4Layout.linkSize(1, this.jRadioButtonEvents, this.jRadioButtonMacro, this.jRadioButtonMicro, this.jRadioButtonNanno, this.jRadioButtonPaly);
        this.jPanel3.setOpaque(false);
        this.jButtonCategories.setText("Categories...");
        this.jButtonCategories.setToolTipText("Match taxon categories in workspace against categories in database");
        this.jButtonCategories.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCategories.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonCategoriesActionPerformed(evt);
            }
        });
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.setToolTipText("Attempt to match all taxa in workspace with taxa of the same nams in database");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonCodes.setText("Match codes");
        this.jButtonCodes.setToolTipText("Use taxon codes for matching instead of taxon names");
        this.jButtonCodes.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonCodesActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit/Search...");
        this.jButtonEdit.setToolTipText("Search for a taxon to match to");
        this.jButtonEdit.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonWebLookup.setText("Web lookup...");
        this.jButtonWebLookup.setToolTipText("Look up selected taxon on the WWW");
        this.jButtonWebLookup.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonWebLookup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonWebLookupActionPerformed(evt);
            }
        });
        this.jButtonClean.setText("Edit list...");
        this.jButtonClean.setToolTipText("Make changes to all taxa in workspace to make more consistent");
        this.jButtonClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonCleanActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude taxa from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonWrite.setText("Write...");
        this.jButtonWrite.setToolTipText("Output a list of unmatched taxa to a text file");
        this.jButtonWrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonWriteActionPerformed(evt);
            }
        });
        this.jButtonAddAll.setText("Add all");
        this.jButtonAddAll.setToolTipText("Add all unmatched taxa from workspace into database");
        this.jButtonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonAddAllActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCodes, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMatchAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonWebLookup, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCategories, -2, 93, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonWrite, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAddAll, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClean, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, -1, 92, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCategories).addComponent(this.jButtonClean)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonMatchAll).addComponent(this.jButtonExclude)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCodes).addComponent(this.jButtonAddAll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonEdit).addComponent(this.jButtonWrite)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonWebLookup).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxa.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addComponent(this.jSeparator2).addGap(20, 20, 20)).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonOK, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(68, 68, 68)).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -2, 192, -2).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 79, Short.MAX_VALUE).addComponent(this.jSeparator2, -2, -1, -2).addGap(8, 8, 8).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHelp).addComponent(this.jButtonOK).addComponent(this.jButtonCancel))));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 451, Short.MAX_VALUE).addComponent(this.jLabel7)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 609, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jPanel5, -2, 193, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 514, Short.MAX_VALUE))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean ignoreCategory = false;
        boolean askIgnoreCategory = false;
        this.discOK[this.model.getListIndex((char)this.model.discID)] = true;
        try {
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                String[] s;
                Taxon wsTx = this.model.taxa[this.model.getListIndex(this.model.discID)].get(i);
                if (wsTx.getLink() != null) continue;
                String cat_mnem = wsTx.getCatMnem();
                if (cat_mnem.isEmpty()) {
                    cat_mnem = null;
                } else if (this.db.getCategory(wsTx.getCatMnem()) == null) {
                    if (!askIgnoreCategory) {
                        askIgnoreCategory = true;
                        if (JOptionPane.showConfirmDialog(this, "Unknown category found\nDo you want to ignore unknown categories in search?", "Match Taxa", 0, 3) == 0) {
                            ignoreCategory = true;
                        }
                    }
                    if (!ignoreCategory) continue;
                    cat_mnem = null;
                }
                assert (cat_mnem == null || !cat_mnem.isEmpty());
                Taxon[] txArr = this.db.lookupSpecies(cat_mnem, wsTx.getGenus().getGenus(), wsTx.getGenus().getSubGenus(), wsTx.getSpecies(), wsTx.getSubSpecies(), wsTx.getGenus().getQ1(), wsTx.getGenus().getQ2(), wsTx.getGenus().getQ3(), wsTx.getGenus().getQ4(), wsTx.getQ1(), wsTx.getQ2(), wsTx.getQ3(), wsTx.getQ4());
                if (!(txArr != null || wsTx.getSpecies() == null || wsTx.getSpecies().isEmpty() || wsTx.getSpecies().startsWith("sp.") || wsTx.getSubSpecies() != null && !wsTx.getSubSpecies().isEmpty() || (s = wsTx.getSpecies().split("\\s+")).length <= 1)) {
                    String species = s[0];
                    int l = 1;
                    String subSpec = s[l++];
                    while (l < s.length) {
                        subSpec = subSpec + " " + s[l++];
                    }
                    txArr = this.db.lookupSpecies(cat_mnem, wsTx.getGenus().getGenus(), wsTx.getGenus().getSubGenus(), species, subSpec, wsTx.getGenus().getQ1(), wsTx.getGenus().getQ2(), wsTx.getGenus().getQ3(), wsTx.getGenus().getQ4(), wsTx.getQ1(), wsTx.getQ2(), wsTx.getQ3(), wsTx.getQ4());
                }
                if (txArr == null) continue;
                Taxon dbTaxon = txArr[0];
                wsTx.setLink(dbTaxon);
                dbTaxon.hasTypeImage();
                int n = this.model.getListIndex(this.model.discID);
                this.nMatched[n] = this.nMatched[n] + 1;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.sorter.fireTableDataChanged();
        this.setProgress();
    }

    private void jButtonSelectSourceActionPerformed(ActionEvent evt) {
        this.selectSource(false);
    }

    private void jButtonLoadActionPerformed(ActionEvent evt) {
        this.load();
    }

    private void load() {
        if (this.source == null) {
            this.selectSource(true);
            if (this.source == null) {
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.discOK[this.model.getListIndex((char)this.model.discID)] = true;
        try {
            Statement stmt = this.db.getDatabase().createStatement();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                Taxon taxon = this.model.taxa[this.model.getListIndex(this.model.discID)].get(i);
                if (taxon.getLink() != null) continue;
                this.source.getTaxon(this.db, stmt, taxon);
                if (taxon.getLink() == null) continue;
                int n = this.model.getListIndex(this.model.discID);
                this.nMatched[n] = this.nMatched[n] + 1;
            }
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            ex.printStackTrace();
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + SB.sql, "SQL Error", 0);
            ex.printStackTrace();
        }
        this.sorter.fireTableDataChanged();
        this.setProgress();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setProgress() {
        this.setProgressBar(this.model.discID, this.nMatched[this.model.getListIndex(this.model.discID)], this.model.getRowCount());
    }

    private JProgressBar getProgressBar(char discID) {
        JProgressBar bar = null;
        switch (discID) {
            case 'E': {
                bar = this.jProgressBarEvents;
                break;
            }
            case 'M': {
                bar = this.jProgressBarMicro;
                break;
            }
            case 'A': {
                bar = this.jProgressBarMacro;
                break;
            }
            case 'N': {
                bar = this.jProgressBarNanno;
                break;
            }
            case 'P': {
                bar = this.jProgressBarPaly;
            }
        }
        return bar;
    }

    private JRadioButton getRadioButton(char discID) {
        JRadioButton button = null;
        switch (discID) {
            case 'M': {
                button = this.jRadioButtonMicro;
                break;
            }
            case 'A': {
                button = this.jRadioButtonMacro;
                break;
            }
            case 'N': {
                button = this.jRadioButtonNanno;
                break;
            }
            case 'P': {
                button = this.jRadioButtonPaly;
                break;
            }
            case 'E': {
                button = this.jRadioButtonEvents;
            }
        }
        return button;
    }

    private void setProgressBar(char discID, int nMatched, int total) {
        JProgressBar bar = this.getProgressBar(discID);
        bar.setString(nMatched + "/" + total);
        if (total > 0) {
            bar.setValue(nMatched * 100 / total);
        } else {
            bar.setValue(0);
        }
        if (bar.getValue() == 100) {
            bar.setForeground(new Color(50, 150, 50));
            bar.setStringPainted(true);
        }
        bar.repaint();
    }

    private void setDiscButton() {
        if (this.jRadioButtonMicro.isEnabled()) {
            this.jRadioButtonMicro.setSelected(true);
            this.setModel('M');
        } else if (this.jRadioButtonNanno.isEnabled()) {
            this.jRadioButtonNanno.setSelected(true);
            this.setModel('N');
        } else if (this.jRadioButtonPaly.isEnabled()) {
            this.jRadioButtonPaly.setSelected(true);
            this.setModel('P');
        } else if (this.jRadioButtonMacro.isEnabled()) {
            this.jRadioButtonMacro.setSelected(true);
            this.setModel('A');
        } else if (this.jRadioButtonEvents.isEnabled()) {
            this.jRadioButtonEvents.setSelected(true);
            this.setModel('E');
        }
    }

    private void jButtonWebLookupActionPerformed(ActionEvent evt) {
        int nRows = this.jTableMatchTaxa.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        WebSearch webSearch = new WebSearch();
        try {
            int[] selectedRows = this.jTableMatchTaxa.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                int index = this.sorter.getIndexOf(selectedRows[i]);
                String name = this.model.getList().get(index).getDonorString();
                if (name == null || name.length() == 0) {
                    name = this.model.getList().get(index).toString(true);
                }
                BareBonesBrowserLaunch.openURL((String)webSearch.getURL(this.db, name));
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), this.getTitle(), 2);
            ex.printStackTrace();
        }
    }

    private void jButtonCategoriesActionPerformed(ActionEvent evt) {
        try {
            DialogMatchCategories dialog = new DialogMatchCategories(this, true, this.ws, this.db, this.model.taxa[this.model.getListIndex(this.model.discID)], this.wellData ? Discipline.getDisc((char)this.model.discID) : null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.sorter.fireTableDataChanged();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableMatchTaxa.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one taxon", this.getTitle(), 1);
            return;
        }
        this.editTaxon();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        int nRows = this.jTableMatchTaxa.getSelectedRowCount();
        if (nRows == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to exclude " + (nRows > 1 ? "these " + nRows + " taxa" : "this taxon") + (nRows > 1 ? "?\nThey" : "?\nIt") + " will be removed from all wells in the workspace when you close this dialog.", this.getTitle(), 0, 3) != 0) {
            return;
        }
        LinkedList<Taxon> excluders = new LinkedList<Taxon>();
        int[] selectedRows = this.jTableMatchTaxa.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            int index = this.sorter.getIndexOf(selectedRows[i]);
            excluders.add(this.model.getList().get(index));
        }
        this.exclude(excluders);
    }

    private void exclude(List<Taxon> excluders) {
        List<Taxon> list = this.model.getList();
        for (int i = 0; i < excluders.size(); ++i) {
            Taxon donorTaxon = excluders.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Taxon taxon = list.get(j);
                if (donorTaxon != taxon) continue;
                if (taxon.getLink() != null) {
                    int n = this.model.getListIndex(this.model.discID);
                    this.nMatched[n] = this.nMatched[n] - 1;
                }
                list.remove(j);
                if (!this.model.wellData) continue;
                this.model.nOcc[this.model.getListIndex(this.model.discID)].remove(j);
            }
        }
        this.sorter.reallocateIndexes();
        this.jTableMatchTaxa.clearSelection();
        this.sorter.sort((Object)this.jTableMatchTaxa);
        this.sorter.fireTableDataChanged();
        this.setProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        List<Taxon> list = this.model.getList();
        if (list.isEmpty()) {
            return;
        }
        int toAdd = list.size() - this.nMatched[this.model.getListIndex(this.model.discID)];
        if (toAdd == 0) {
            JOptionPane.showMessageDialog(this, "There are no unmatched taxa to add.", this.getTitle(), 2);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "WARNING: This option may add duplicate, unnecessary, or inconsistent species to your database.\nDo you want to continue?", "Add all", 0, 2) != 0) {
            return;
        }
        try {
            int nTaxa = Taxon.getNSpecies((SBdb)this.db);
            this.discOK[this.model.getListIndex((char)this.model.discID)] = true;
            if ((nTaxa > 9000 || toAdd > 20) && JOptionPane.showConfirmDialog(this, "WARNING: There are already " + nTaxa + " entries in your species dictionary.\nAre you sure you want to continue to add these " + toAdd + "?", "Add all", 0, 3) != 0) {
                return;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int unknownCategory = 0;
        try {
            for (int i = 0; i < list.size(); ++i) {
                Genus.Builder genBuilder;
                Genus[] genArr;
                Taxon donor = list.get(i);
                if (donor.getLink() != null) continue;
                Taxon match = this.lookupTaxon(donor);
                if (match != null) {
                    donor.setLink(match);
                    int n = this.model.getListIndex(this.model.discID);
                    this.nMatched[n] = this.nMatched[n] + 1;
                    continue;
                }
                Category cat = this.db.getCategory(donor.getCatMnem());
                if (cat == null && (genArr = this.db.lookupGenus(genBuilder = Genus.Builder.copyOf((Genus)donor.getGenus()))) != null && genArr.length == 1) {
                    cat = genArr[0].getCategory();
                }
                if (cat == null) {
                    ++unknownCategory;
                    continue;
                }
                this.db.fillTaxonFromWorkspace(this.ws, donor, cat);
                int n = this.model.getListIndex(this.model.discID);
                this.nMatched[n] = this.nMatched[n] + 1;
                this.db.commit();
            }
            if (unknownCategory > 0) {
                JOptionPane.showMessageDialog(this, "" + unknownCategory + (unknownCategory > 1 ? " taxa were " : " taxon was ") + "not added because the category was blank or not recognised", "Match Taxa", 1);
            }
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.sorter.fireTableDataChanged();
        this.setProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonCodesActionPerformed(ActionEvent evt) {
        List<Taxon> list = this.model.getList();
        if (list.isEmpty()) {
            return;
        }
        this.discOK[this.model.getListIndex((char)this.model.discID)] = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (int i = 0; i < list.size(); ++i) {
                Taxon link;
                Taxon taxon = list.get(i);
                if (taxon.getLink() != null || (link = this.db.lookupTaxon(taxon.getDonorString())) == null) continue;
                taxon.setLink(link);
                int n = this.model.getListIndex(this.model.discID);
                this.nMatched[n] = this.nMatched[n] + 1;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.sorter.fireTableDataChanged();
        this.setProgress();
    }

    private void jButtonCleanActionPerformed(ActionEvent evt) {
        DialogMatchTaxaEdit dialog = new DialogMatchTaxaEdit(this, true, this.ws, this.model.getList());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.sorter.fireTableDataChanged();
        }
    }

    private void jButtonWriteActionPerformed(ActionEvent evt) {
        File setDir = System.getProperty("os.name").equals("SunOS") ? new File("~/") : new File("\\My Documents");
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        String TEXT = "Text files";
        filter.setDescription("Text files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                String fileName = jFileChooser1.getSelectedFile().getPath();
                if (fileName.toLowerCase().indexOf(".txt") < 0) {
                    fileName = fileName + ".txt";
                }
                FileWriter out = new FileWriter(fileName);
                out.write("List of unmatched taxa. Produced: " + df.format(new Date()) + "\r\n\r\n");
                LinkedList<Taxon> unmatched = new LinkedList<Taxon>();
                List<Taxon> list = this.model.getList();
                for (Taxon taxon : list) {
                    if (taxon.getLink() != null) continue;
                    unmatched.add(taxon);
                }
                Collections.sort(unmatched);
                Iterator<Object> it = unmatched.iterator();
                while (it.hasNext()) {
                    out.write(it.next() + "\r\n");
                }
                out.close();
                JOptionPane.showMessageDialog(this, "File written", this.getTitle(), 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.model.wellData) {
            Taxon donor;
            int iTaxon;
            if (!this.discOK[4] && this.model.taxa[4].size() > 0) {
                JOptionPane.showMessageDialog(this, "You must match ALL event taxa", this.getTitle(), 2);
                return;
            }
            if (this.model.taxa[4].size() > 0) {
                for (Taxon taxon : this.model.taxa[4]) {
                    if (taxon.getLink() == null) {
                        JOptionPane.showMessageDialog(this, "You must match ALL event taxa", this.getTitle(), 2);
                        return;
                    }
                    for (iTaxon = 0; iTaxon < this.model.taxa[4].size(); ++iTaxon) {
                        donor = this.model.taxa[4].get(iTaxon);
                        if (donor.getLink() == null) continue;
                        this.ws.copyLinkedTaxon(donor.getSpecID());
                    }
                }
            }
            for (int i = 0; i < 4; ++i) {
                if (!this.discOK[i] && this.model.taxa[i].size() > 0) {
                    if (JOptionPane.showConfirmDialog(this, "You have not matched the " + SBdb.getDiscAdj((char)SBdb.discArr[i]) + " taxa. Continue to close?", "Match Taxa", 0, 3) == 0) continue;
                    return;
                }
                if (this.nMatched[i] < this.model.taxa[i].size() && JOptionPane.showConfirmDialog(this, "Occurrence records of unmatched " + SBdb.getDiscAdj((char)SBdb.discArr[i]) + " taxa will be discarded. Continue to close?", "Match Taxa", 0, 3) != 0) {
                    return;
                }
                int nRows = this.model.taxa[i].size();
                if (this.source != null) {
                    try {
                        for (iTaxon = 0; iTaxon < nRows; ++iTaxon) {
                            donor = this.model.taxa[i].get(iTaxon);
                            if (donor.getLink() == null || donor.getDonorOccType().equals("In-situ")) continue;
                            this.source.storeMatch(this.db, donor);
                        }
                        this.db.commit();
                    }
                    catch (SQLException sqle) {
                        FrameJsbugs.showStackError("Error storing matches", sqle, this.db);
                        this.db.doRollback();
                    }
                }
                for (iTaxon = 0; iTaxon < nRows; ++iTaxon) {
                    donor = this.model.taxa[i].get(iTaxon);
                    if (donor.getLink() == null) continue;
                    this.ws.copyLinkedTaxon(donor.getSpecID());
                }
            }
            try {
                Project project = this.ws.getProject(0);
                Iterator it = project.getWellIterator();
                while (it.hasNext()) {
                    Well well = (Well)it.next();
                    Iterator sit = well.getSamples().iterator();
                    while (sit.hasNext()) {
                        for (Smpdtl dtl : ((Sample)sit.next()).getAnalyses()) {
                            int disint = SBdb.did2i((char)dtl.getDiscID());
                            List<Taxon> list = this.model.taxa[disint];
                            Iterator oit = dtl.getOccurUnsorted().iterator();
                            while (oit.hasNext()) {
                                TaxonOcc occ = (TaxonOcc)oit.next();
                                if (!list.contains(occ.getTaxon())) {
                                    oit.remove();
                                    continue;
                                }
                                if (occ.getTaxon().getLink() == null) {
                                    oit.remove();
                                    continue;
                                }
                                if (occ.getTaxon().getDonorOccType().equals("In-situ")) continue;
                                occ.getTaxon().setFssOccType(occ);
                            }
                            AbnScheme abnScheme = this.ws.getAbnScheme(dtl.getHeader().getAbnSchID(), false);
                            dtl.mergeDuplicateOccurrences(abnScheme);
                        }
                    }
                }
            }
            catch (SQLException sqle) {
                this.db.doRollback();
                FrameJsbugs.showStackError("Error updating occurrences", sqle, this.db);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error updating occurrences", (Exception)((Object)sbe));
            }
        } else {
            if (this.nMatched[0] < this.model.taxa[0].size()) {
                if (JOptionPane.showConfirmDialog(this, "Unmatched taxa will be excluded. Do you want to continue?", "Match Taxa", 0, 3) != 0) {
                    return;
                }
                LinkedList<Taxon> excluders = new LinkedList<Taxon>();
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    Taxon taxon = this.model.taxa[0].get(i);
                    if (taxon.getLink() != null) continue;
                    excluders.add(taxon);
                }
                this.exclude(excluders);
                try {
                    for (TxGroup grp : this.ws.getTxGroups()) {
                        for (Taxon t : this.ws.getTxGroupTaxa(grp)) {
                            LinkedList<Taxon> toRemove = new LinkedList<Taxon>();
                            if (!this.model.taxa[0].contains(t)) {
                                toRemove.add(t);
                            }
                            grp.deleteTaxa(toRemove);
                        }
                    }
                }
                catch (SQLException sql) {
                    SB.showStackError((String)"Error getting groups", (SQLException)sql);
                }
            }
            int nRows = this.model.taxa[0].size();
            for (int iTaxon = 0; iTaxon < nRows; ++iTaxon) {
                Taxon donor = this.model.taxa[0].get(iTaxon);
                if (donor.getLink() == null) continue;
                this.ws.copyLinkedTaxon(donor.getSpecID());
            }
        }
        this.setOK();
    }

    private void jTableMatchTaxaMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            try {
                if (this.jTableMatchTaxa.getSelectedColumn() == 9) {
                    int selectedRow = this.jTableMatchTaxa.getSelectedRow();
                    Taxon wsTx = this.model.getList().get(this.sorter.getIndexOf(selectedRow));
                    if (wsTx == null) {
                        JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 1);
                        return;
                    }
                    Taxon dbTx = wsTx.getLink();
                    if (dbTx == null) {
                        JOptionPane.showMessageDialog(this, "No matched taxon", this.getTitle(), 1);
                        return;
                    }
                    if (dbTx.getImageSetCount(false) == 0) {
                        JOptionPane.showMessageDialog(this, "There are no images in the database for selected taxon.", this.getTitle(), 1);
                        return;
                    }
                    DialogTaxonImages dialog = new DialogTaxonImages(this, true, this.db, dbTx);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                } else if (this.jTableMatchTaxa.getSelectedColumn() == 3) {
                    int selectedRow = this.jTableMatchTaxa.getSelectedRow();
                    Taxon wsTx = this.model.getList().get(this.sorter.getIndexOf(selectedRow));
                    if (wsTx == null) {
                        JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 1);
                        return;
                    }
                    if (this.model.getValueAt(this.sorter.getIndexOf(selectedRow), 3) == null) {
                        JOptionPane.showMessageDialog(this, "There are no images in the database for selected taxon.", this.getTitle(), 1);
                        return;
                    }
                    DialogTaxonImages dialog = new DialogTaxonImages(this, true, this.ws, wsTx);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                } else {
                    this.editTaxon();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                ex.printStackTrace();
            }
        }
    }

    private void jRadioButtonMacroActionPerformed(ActionEvent evt) {
        this.setModel('A');
    }

    private void jRadioButtonMicroActionPerformed(ActionEvent evt) {
        this.setModel('M');
    }

    private void jRadioButtonNannoActionPerformed(ActionEvent evt) {
        this.setModel('N');
    }

    private void jRadioButtonPalyActionPerformed(ActionEvent evt) {
        this.setModel('P');
    }

    private void jRadioButtonEventsActionPerformed(ActionEvent evt) {
        this.setModel('E');
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchtaxa.html");
    }

    private Taxon lookupTaxon(Taxon wsTx) throws SQLException {
        Taxon match = null;
        String cat = wsTx.getCatMnem().isEmpty() ? null : wsTx.getCatMnem();
        Taxon[] txArr = this.db.lookupSpecies(cat, wsTx.getGenus().getGenus(), wsTx.getGenus().getSubGenus(), wsTx.getSpecies(), wsTx.getSubSpecies(), wsTx.getGenus().getQ1(), wsTx.getGenus().getQ2(), wsTx.getGenus().getQ3(), wsTx.getGenus().getQ4(), wsTx.getQ1(), wsTx.getQ2(), wsTx.getQ3(), wsTx.getQ4());
        if (txArr != null) {
            match = txArr[0];
        }
        return match;
    }

    private void selectSource(boolean fromLoad) {
        try {
            DialogSource dialog = new DialogSource(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.source = dialog.selection;
                this.jTextFieldSource.setText(this.source.getID() + "," + this.source.getName());
            }
            if (dialog.isOK) {
                int option;
                if (!fromLoad && (option = JOptionPane.showConfirmDialog(this, "Do you want to load previous matches for this data source?", "Load Matches", 0)) == 0) {
                    fromLoad = true;
                }
                if (fromLoad) {
                    this.load();
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }
}

