/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.DialogImageSetOverview;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchTaxonOcc;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.WsWell;
import util.ArrowCellRenderer;
import util.MatchData;
import util.SB;
import util.SBException;
import util.SbugsStatusRenderer;
import util.StringStatus;
import util.TableSorter;

public class DialogMatchTaxonOcc
extends JDialog {
    TableModelMatchTaxonOcc model = new TableModelMatchTaxonOcc();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    Smpdtl ws;
    Smpdtl db;
    WsWell wsWell;
    Image backgroundImage;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonReplace;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableMatchTaxonOcc;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldNumber;
    private JTextField jTextFieldSample;

    public DialogMatchTaxonOcc(Dialog parent, boolean modal, WsWell wsWell, Smpdtl ws, Smpdtl db) throws SQLException, SBException {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.wsWell = wsWell;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Taxon Occurrences");
        this.checkLinks();
        this.getRootPane().setDefaultButton(this.jButtonClose);
        SB.setTableHeaderBold((JTable)this.jTableMatchTaxonOcc);
        TableColumnModel columnModel = this.jTableMatchTaxonOcc.getTableHeader().getColumnModel();
        columnModel.getColumn(3).setMaxWidth(TableModelMatchTaxonOcc.colWidths[3]);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchTaxonOcc.colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(TableModelMatchTaxonOcc.colWidths[i]);
        }
        this.jTableMatchTaxonOcc.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        this.jTableMatchTaxonOcc.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ArrowCellRenderer());
        Smpdtl dtl = this.ws != null ? this.ws : this.db;
        this.jTextFieldSample.setText("" + dtl.getSample());
        this.jTextFieldAnalyst.setText(dtl.getAnalyst());
        this.jTextFieldNumber.setText("" + dtl.getAnalyNo());
        if (this.ws != null && this.db == null || this.ws == null && this.db != null) {
            this.jButtonReplace.setEnabled(false);
        }
        this.model.data.init(this.ws != null ? this.ws.getOccur() : null, this.db != null ? this.db.getOccur() : null);
        if (this.model.hasImages()) {
            this.jTableMatchTaxonOcc.setRowHeight((int)((double)this.jTableMatchTaxonOcc.getRowHeight() * 1.15));
            this.model.rowHeight = this.jTableMatchTaxonOcc.getRowHeight();
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchTaxonOcc);
        this.jTableMatchTaxonOcc.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void checkLinks() throws SBException {
        if (this.ws != null && this.db != null && !this.ws.getOccur().isEmpty()) {
            for (TaxonOcc occ : this.ws.getOccur()) {
                if (occ.getTaxon().getLink() != null) continue;
                throw new SBException("Cannot open dialog - taxa not Matched.");
            }
        }
    }

    private void initComponents() {
        this.jPanel2 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchTaxonOcc.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchTaxonOcc = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonReplace = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldSample = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldAnalyst = new JTextField();
        this.jLabel5 = new JLabel();
        this.jTextFieldNumber = new JTextField();
        this.jButtonSave = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(633, 250));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogMatchTaxonOcc.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMatchTaxonOcc.setModel((TableModel)this.sorter);
        this.jTableMatchTaxonOcc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchTaxonOcc.this.jTableMatchTaxonOccMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchTaxonOcc);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxonOcc.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected data from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxonOcc.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxonOcc.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonReplace.setText("Replace");
        this.jButtonReplace.setToolTipText("Replace database with workspace");
        this.jButtonReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxonOcc.this.jButtonReplaceActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jPanel1.setOpaque(false);
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("Sample:");
        this.jTextFieldSample.setBackground(new Color(255, 255, 204));
        this.jTextFieldSample.setEditable(false);
        this.jLabel4.setText("Analyst:");
        this.jTextFieldAnalyst.setBackground(new Color(255, 255, 204));
        this.jTextFieldAnalyst.setEditable(false);
        this.jLabel5.setText("Number:");
        this.jTextFieldNumber.setBackground(new Color(255, 255, 204));
        this.jTextFieldNumber.setEditable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSample, -2, 202, -2).addGap(13, 13, 13).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAnalyst, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNumber, -2, 50, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldSample, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextFieldAnalyst, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jTextFieldNumber, -2, -1, -2))));
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save new occurrences");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchTaxonOcc.this.jButtonSaveActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 600, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, 79, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, 79, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -1, 79, Short.MAX_VALUE).addComponent(this.jButtonReplace, GroupLayout.Alignment.TRAILING, -1, 79, Short.MAX_VALUE).addComponent(this.jButtonSave, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 442, Short.MAX_VALUE).addComponent(this.jLabel2)).addComponent(this.jSeparator1, -1, 600, Short.MAX_VALUE)).addGap(99, 99, 99)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 9, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReplace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 282, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 415, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteOccs(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteOccs(true);
    }

    private void jButtonReplaceActionPerformed(ActionEvent evt) {
        this.save(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.save(false);
    }

    private void jTableMatchTaxonOccMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.jTableMatchTaxonOcc.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(this, "No taxon selected", this.getTitle(), 2);
                return;
            }
            MatchData.MatchPair pair = this.model.data.get(this.jTableMatchTaxonOcc.getSelectedRow());
            TaxonOcc wsTaxonOcc = (TaxonOcc)pair.getWs();
            try {
                if (this.jTableMatchTaxonOcc.getSelectedColumn() == 2) {
                    if (wsTaxonOcc == null) {
                        JOptionPane.showMessageDialog(this, "No workspace taxon selected", this.getTitle(), 1);
                        return;
                    }
                    if (wsTaxonOcc.getImageSet() == null) {
                        JOptionPane.showMessageDialog(this, "There are no images in the workspace for selected taxon.", this.getTitle(), 1);
                        return;
                    }
                    DialogImageSetOverview dialog = new DialogImageSetOverview((Dialog)this, true, wsTaxonOcc.getImageSet(), this.ws.getDatabase());
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
                ex.printStackTrace();
            }
        }
    }

    private void save(boolean replace) {
        if (this.wsWell.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        if (this.db == null) {
            JOptionPane.showMessageDialog(this, "Can't save here: analysis must be matched to a database one.\nClose dialog, resolve other conflicts (if there are any), and Save from the main menu", this.getTitle(), 2);
            return;
        }
        if (this.ws == null) {
            return;
        }
        try {
            if (replace) {
                if (this.db.getOccur().size() > this.ws.getOccur().size() && JOptionPane.showConfirmDialog(this, "Warning: you are about to replace database data with fewer items from the workspace. Continue?", this.getTitle(), 0, 2) != 0) {
                    return;
                }
            } else {
                String msg;
                boolean b = false;
                for (int row = 0; row < this.model.data.size(); ++row) {
                    MatchData.MatchPair pair = this.model.data.get(row);
                    TaxonOcc wsp = (TaxonOcc)pair.getWs();
                    TaxonOcc dbp = (TaxonOcc)pair.getDb();
                    if (dbp == null || wsp != null) continue;
                    b = true;
                    break;
                }
                if (b && JOptionPane.showConfirmDialog(this, (msg = "Warning: database contains items not in the workspace, which may not be part of the analysis by " + this.ws.getAnalyst()) + "\nAre you sure you want to continue?", this.getTitle(), 0, 2) != 0) {
                    return;
                }
            }
            for (TaxonOcc occ : this.ws.getOccur()) {
                if (occ.getTaxon() != null && occ.getTaxon().getLink() != null) continue;
                JOptionPane.showMessageDialog(this, "Workspace data can't be saved - taxa not matched", this.getTitle(), 2);
                return;
            }
            if (replace) {
                this.db.replaceOccs(this.wsWell.getLink().getWellID(), this.ws.getOccur());
            } else {
                this.db.addOccs(this.wsWell.getLink().getWellID(), this.ws.getOccur());
            }
            this.wsWell.updateSampleStatus(true);
            this.model.data.init(this.ws != null ? this.ws.getOccur() : null, this.db != null ? this.db.getOccur() : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.wsWell.getLink().getDataModel().commit();
            this.wsWell.getLink().notifyObservers((Object)this.db);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving Occurrences: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.wsWell.getLink().getDataModel().doRollback();
        }
    }

    private void deleteOccs(boolean fromDatabase) {
        block8: {
            String msg;
            if (fromDatabase && this.db == null) {
                JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
                return;
            }
            if (this.jTableMatchTaxonOcc.getSelectedRowCount() == 0) {
                JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
                return;
            }
            int[] selected = this.jTableMatchTaxonOcc.getSelectedRows();
            LinkedList<TaxonOcc> toRemove = new LinkedList<TaxonOcc>();
            for (int i : selected) {
                TaxonOcc occ = fromDatabase ? (TaxonOcc)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (TaxonOcc)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
                if (occ == null) continue;
                toRemove.add(occ);
            }
            if (fromDatabase && toRemove.size() > 0 && JOptionPane.showConfirmDialog(this, msg = "Really delete " + (toRemove.size() == 1 ? "this occurrence?" : "these " + toRemove.size() + " occurrences?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
            try {
                int nOccs = 0;
                int wellID = fromDatabase ? this.wsWell.getLink().getWellID() : 0;
                Smpdtl deleteDtl = fromDatabase ? this.db : this.ws;
                for (TaxonOcc occ : toRemove) {
                    deleteDtl.deleteOcc(wellID, occ);
                    ++nOccs;
                }
                String text = fromDatabase ? "deleted" : "excluded";
                JOptionPane.showMessageDialog(this, "Occurrences " + text + ": " + nOccs, this.getTitle(), 1);
                this.wsWell.updateSampleStatus(true);
                this.model.data.init(this.ws != null ? this.ws.getOccur() : null, this.db != null ? this.db.getOccur() : null);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (fromDatabase) {
                    this.wsWell.getLink().getDataModel().commit();
                    this.wsWell.getLink().notifyObservers();
                }
            }
            catch (Exception e) {
                SB.showStackError((String)("Error " + (fromDatabase ? "deleting" : "excluding") + " occurrences: " + e.getMessage()), (Exception)e);
                e.printStackTrace();
                if (!fromDatabase) break block8;
                this.wsWell.getLink().getDataModel().doRollback();
            }
        }
    }
}

