/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelMatchWellEvents;
import model2.InterpHdr;
import model2.SBdb;
import model2.Sample;
import model2.Userdef;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.MatchData;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogMatchWellEvents
extends JDialog {
    TableModelMatchWellEvents model = new TableModelMatchWellEvents();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    WsWell well;
    Image backgroundImage;
    InterpHdr hdr;
    WellInterp wsInterp;
    WellInterp dbInterp;
    private JButton jButton1;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonExclude;
    private JButton jButtonSave;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JTable jTableMatchWellEvents;

    public DialogMatchWellEvents(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well, char units, InterpHdr hdr) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.hdr = hdr;
        this.model.units = units;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Well Events for : " + this.well);
        if (this.well.hasInterpLoaded(this.hdr.getInterpID())) {
            this.wsInterp = this.well.getInterp(this.hdr.getInterpID());
        }
        this.checkLinks();
        if (this.well.getLink() != null && this.hdr.getLink() != null && this.well.getLink().hasInterpLoaded(this.hdr.getLink().getInterpID())) {
            this.dbInterp = this.well.getLink().getInterp(this.hdr.getLink().getInterpID());
            this.well.getLink().loadInterp(this.dbInterp);
        }
        this.model.data.init(this.wsInterp != null ? this.wsInterp.getEvents() : null, this.dbInterp != null ? this.dbInterp.getEvents() : null);
        this.model.setUpTable(this.jTableMatchWellEvents);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableMatchWellEvents);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
    }

    private void checkLinks() throws SBException {
        if (this.well.getLink() != null && this.wsInterp != null) {
            for (WellEvent event : this.wsInterp.getEvents()) {
                if (event.getEvent().getLink() != null) continue;
                throw new SBException("Cannot open dialog - Event dictionary not Matched");
            }
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchWellEvents.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane2 = new JScrollPane();
        this.jTableMatchWellEvents = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonExclude = new JButton();
        this.jButton1.setText("jButton1");
        this.setDefaultCloseOperation(2);
        this.setBackground(Color.lightGray);
        this.setMinimumSize(new Dimension(600, 500));
        this.setModal(true);
        this.jScrollPane2.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableMatchWellEvents.setModel((TableModel)this.sorter);
        this.jTableMatchWellEvents.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchWellEvents.this.jTableMatchWellEventsMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableMatchWellEvents);
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("Workspace...");
        this.jLabel2.setFont(new Font("Tahoma", 1, 13));
        this.jLabel2.setText("...Database");
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellEvents.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.setToolTipText("Save ALL unsaved intervals from workspace into database");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellEvents.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected intervals from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellEvents.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude selected intervals from workspace");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellEvents.this.jButtonExcludeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 454, Short.MAX_VALUE).add((Component)this.jLabel2)).add(2, (Component)this.jScrollPane2, -1, 612, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jButtonCancel, -1, 82, Short.MAX_VALUE).add(2, (Component)this.jButtonExclude, -1, 82, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 82, Short.MAX_VALUE).add((Component)this.jButtonSave, -1, 82, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonExclude).add(4, 4, 4).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonSave).addPreferredGap(0, 354, Short.MAX_VALUE).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane2, -1, 456, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        this.deleteEvents(false);
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        this.deleteEvents(true);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No linked well - use Match | Wells from main menu.", this.getTitle(), 2);
            return;
        }
        if (this.dbInterp == null) {
            JOptionPane.showMessageDialog(this, "Version not linked - use Match | Versions from main menu.", this.getTitle(), 2);
            return;
        }
        Well dbWell = this.well.getLink();
        SBdb wsDB = this.well.getDataModel();
        Sample sampleAdded = null;
        LinkedList<WellEvent> toAdd = new LinkedList<WellEvent>();
        try {
            Statement stmt = null;
            for (int row = 0; row < this.model.data.size(); ++row) {
                MatchData.MatchPair pair = this.model.data.get(row);
                WellEvent ws = (WellEvent)pair.getWs();
                WellEvent db = (WellEvent)pair.getDb();
                if (ws == null) continue;
                if (ws.getSample().getLink() == null) {
                    int opt = JOptionPane.showConfirmDialog(this, "Sample: " + ws.getSample() + " does not exist: create it?", this.getTitle(), 1, 3);
                    if (opt == 1) continue;
                    if (opt == 2 || opt == -1) {
                        toAdd.clear();
                        break;
                    }
                    if (stmt == null) {
                        stmt = dbWell.getDataModel().getDatabase().createStatement();
                    }
                    sampleAdded = dbWell.addWsSample(stmt, ws.getSample());
                }
                if (ws.getAnalyst() > 0) {
                    Userdef wsUser = wsDB.getUser(ws.getAnalyst());
                    if (wsUser == null) {
                        JOptionPane.showMessageDialog(this, "Cannot save: analyst used does not exist in workspace.");
                        break;
                    }
                    if (wsUser.getLink() == null) {
                        JOptionPane.showMessageDialog(this, "Cannot save: analyst is not matched: " + wsUser.getAbr());
                        break;
                    }
                }
                if (ws.getEvent().getLink() == null) {
                    JOptionPane.showMessageDialog(this, "Cannot save: events unmatched.");
                    break;
                }
                toAdd.add(ws);
            }
            if (!toAdd.isEmpty()) {
                this.dbInterp.storeEvents(this.wsInterp, this.well.getLink().getWellID(), wsDB);
                this.model.data.init(this.wsInterp.getEvents(), this.dbInterp.getEvents());
                this.well.updateEventsStatus(this.wsInterp, this.hdr, this.model.units, true);
                this.dbInterp.notifyObservers((Object)20);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                this.well.getLink().getDataModel().commit();
            }
            if (sampleAdded != null) {
                this.well.getLink().notifyObservers(sampleAdded);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving samples: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.well.getLink().getDataModel().doRollback();
        }
    }

    private void jTableMatchWellEventsMouseClicked(MouseEvent evt) {
    }

    private void deleteEvents(boolean fromDatabase) {
        if (fromDatabase && this.well.getLink() == null) {
            JOptionPane.showMessageDialog(this, "No well data - use Exclude to remove from workspace", this.getTitle(), 2);
            return;
        }
        if (this.jTableMatchWellEvents.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No events selected", this.getTitle(), 2);
            return;
        }
        int[] selected = this.jTableMatchWellEvents.getSelectedRows();
        LinkedList<WellEvent> toRemove = new LinkedList<WellEvent>();
        for (int i : selected) {
            WellEvent event = fromDatabase ? (WellEvent)this.model.data.get(this.sorter.getIndexOf(i)).getDb() : (WellEvent)this.model.data.get(this.sorter.getIndexOf(i)).getWs();
            if (event == null) continue;
            toRemove.add(event);
        }
        if (fromDatabase && toRemove.size() > 0) {
            String msg = "Really delete ";
            msg = msg + (toRemove.size() == 1 ? "this event" : "these " + toRemove.size() + " event");
            if (JOptionPane.showConfirmDialog(this, msg = msg + (toRemove.size() == 1 ? "?" : "s?"), this.getTitle(), 0, 3) != 0) {
                return;
            }
        }
        try {
            int nItems = 0;
            WsWell deleteWell = fromDatabase ? this.well.getLink() : this.well;
            WellInterp deleteInterp = fromDatabase ? this.dbInterp : this.wsInterp;
            for (WellEvent event : toRemove) {
                deleteInterp.deleteEvent(event, deleteWell.getWellID());
                ++nItems;
            }
            String text = fromDatabase ? "deleted" : "excluded";
            JOptionPane.showMessageDialog(this, "Events " + text + ": " + nItems, this.getTitle(), 1);
            if (fromDatabase) {
                deleteWell.getDataModel().commit();
                deleteInterp.notifyObservers((Object)20);
            } else {
                this.well.updateEventsStatus(this.wsInterp, this.dbInterp != null ? this.dbInterp.getHeader() : null, this.model.units, true);
            }
            this.model.data.init(this.wsInterp != null ? this.wsInterp.getEvents() : null, this.dbInterp != null ? this.dbInterp.getEvents() : null);
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException sql) {
            if (fromDatabase) {
                this.well.getLink().getDataModel().doRollback();
            }
            FrameJsbugs.showStackError("SQL Error " + (fromDatabase ? "deleting" : "excluding"), sql, this.well.getLink().getDataModel());
        }
        catch (SBException sbe) {
            if (fromDatabase) {
                this.well.getLink().getDataModel().doRollback();
            }
            SB.showStackError((String)("Error " + (fromDatabase ? "deleting" : "excluding")), (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }
}

