/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogWell;
import jsbugs.TableModelMatchWellHeader;
import model2.SBdb;
import model2.Well;
import model2.WsWell;
import util.GreyRenderer;
import util.SB;
import util.SbugsStatusRenderer;
import util.StringStatus;

public class DialogMatchWellHeader
extends JDialog {
    TableModelMatchWellHeader model = new TableModelMatchWellHeader();
    SBdb ws;
    SBdb db;
    WsWell well = null;
    private JButton jButtonClose;
    private JButton jButtonEditDB;
    private JButton jButtonEditWS;
    private JButton jButtonExclude;
    private JButton jButtonReplace;
    private JScrollPane jScrollPane1;
    private JTable jTableMatchWellHeader;

    public DialogMatchWellHeader(Frame parent, boolean modal, SBdb ws, SBdb db, WsWell well) {
        super(parent, modal);
        this.ws = ws;
        this.db = db;
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Match Well Headers");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        SB.setTableHeaderBold((JTable)this.jTableMatchWellHeader);
        TableColumnModel columnModel = this.jTableMatchWellHeader.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelMatchWellHeader.colTitles[i]);
            columnModel.getColumn(i).setWidth(TableModelMatchWellHeader.colWidths[i]);
        }
        this.jTableMatchWellHeader.setDefaultRenderer(StringStatus.class, (TableCellRenderer)new SbugsStatusRenderer());
        TableColumn firstColumn = this.jTableMatchWellHeader.getColumnModel().getColumn(0);
        firstColumn.setHeaderValue(" ");
        firstColumn.setPreferredWidth(45);
        this.jTableMatchWellHeader.setRowHeight(19);
        this.jTableMatchWellHeader.getColumnModel().setColumnMargin(5);
        GreyRenderer renderer = new GreyRenderer(false);
        renderer.setCursor(new Cursor(12));
        firstColumn.setCellRenderer((TableCellRenderer)renderer);
        renderer.setHorizontalAlignment(11);
        this.model.sbdb = this.db;
        this.model.ws = this.well.getHeader();
        this.model.db = this.well.getLink() != null ? this.well.getLink().getHeader() : null;
        this.jTableMatchWellHeader.getTableHeader().setReorderingAllowed(false);
        if (this.well.getLink() == null) {
            this.jButtonEditDB.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableMatchWellHeader = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonEditWS = new JButton();
        this.jButtonExclude = new JButton();
        this.jButtonReplace = new JButton();
        this.jButtonEditDB = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 400));
        this.setModal(true);
        this.jTableMatchWellHeader.setModel(this.model);
        this.jTableMatchWellHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogMatchWellHeader.this.jTableMatchWellHeaderMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableMatchWellHeader);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellHeader.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonEditWS.setText("Edit workspace...");
        this.jButtonEditWS.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEditWS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellHeader.this.jButtonEditWSActionPerformed(evt);
            }
        });
        this.jButtonExclude.setText("Exclude");
        this.jButtonExclude.setToolTipText("Exclude values from selected rows from import");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellHeader.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonReplace.setText("Replace");
        this.jButtonReplace.setToolTipText("Replace database values with selected workspace values");
        this.jButtonReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellHeader.this.jButtonReplaceActionPerformed(evt);
            }
        });
        this.jButtonEditDB.setText("Edit database...");
        this.jButtonEditDB.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonEditDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWellHeader.this.jButtonEditDBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 410, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, 69, Short.MAX_VALUE).addComponent(this.jButtonEditDB, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEditWS, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonExclude, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonReplace, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 624, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonEditWS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEditDB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonReplace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 491, Short.MAX_VALUE).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        try {
            this.well.updateHeaderStatus();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
        this.dispose();
    }

    private void jButtonEditWSActionPerformed(ActionEvent evt) {
        try {
            DialogWell dialog = new DialogWell(this, true, this.ws, (Well)this.well);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
            e.printStackTrace();
        }
    }

    private void jTableMatchWellHeaderMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.jTableMatchWellHeader.getSelectedColumn() == 1) {
                this.jButtonEditWSActionPerformed(null);
            } else if (this.jTableMatchWellHeader.getSelectedColumn() == 2) {
                if (this.well.getLink() != null) {
                    this.jButtonEditDBActionPerformed(null);
                } else {
                    this.jButtonEditWSActionPerformed(null);
                }
            }
        }
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        if (this.jTableMatchWellHeader.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
        }
        try {
            this.model.exclude(this.jTableMatchWellHeader.getSelectedRows());
            this.model.fireTableDataChanged();
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
            e.printStackTrace();
        }
    }

    private void jButtonReplaceActionPerformed(ActionEvent evt) {
        if (this.jTableMatchWellHeader.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
        }
        try {
            this.model.replace(this.jTableMatchWellHeader.getSelectedRows());
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
            e.printStackTrace();
        }
    }

    private void jButtonEditDBActionPerformed(ActionEvent evt) {
        try {
            DialogWell dialog = new DialogWell(this, true, this.db, this.well.getLink());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
            e.printStackTrace();
        }
    }
}

