/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.DialogSelectWell;
import jsbugs.DialogWell;
import jsbugs.FrameJsbugs;
import jsbugs.WellsTableModel;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WsWell;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogMatchWells
extends JDialog {
    WellsTableModel model = new WellsTableModel();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    boolean isOK = false;
    Image backgroundImage;
    List<Well> links = new LinkedList<Well>();
    private JButton jButton3;
    private JButton jButtonAddAll;
    private JButton jButtonAddEdit;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMatchAll;
    private JButton jButtonOK;
    private JButton jButtonSelect;
    private JButton jButtonSelectMaster;
    private JButton jButtonUnmatch;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableWells;

    public DialogMatchWells(Frame parent, boolean modal, SBdb ws, SBdb db) throws SQLException, SBException {
        super(parent, modal);
        this.model.ws = ws;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Match Wells");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.setupTable(this.jTableWells);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        if (this.model.ws.getProject(0).getSize() == 1) {
            this.jTableWells.setRowSelectionInterval(0, 0);
        }
        this.jTableWells.getTableHeader().setReorderingAllowed(false);
        this.backgroundImage = Toolkit.getDefaultToolkit().createImage(FrameJsbugs.class.getResource("/jsbugs/icon_new/MatchBG.png"));
        Iterator it = this.model.ws.getProject(0).getWellIterator();
        while (it.hasNext()) {
            WsWell well = (WsWell)it.next();
            this.links.add(well.getLink());
        }
        this.jButtonSelectMaster.setVisible(false);
    }

    private void initComponents() {
        this.jButton3 = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawImage(DialogMatchWells.this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
            }
        };
        this.jScrollPane1 = new JScrollPane();
        this.jTableWells = new JTable();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButtonMatchAll = new JButton();
        this.jButtonSelect = new JButton();
        this.jButtonSelectMaster = new JButton();
        this.jButtonAddEdit = new JButton();
        this.jButtonAddAll = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonUnmatch = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButton3.setText("jButton3");
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 350));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogMatchWells.this.formWindowClosing(evt);
            }
        });
        this.jScrollPane1.setViewportBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.jTableWells.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableWells);
        this.jLabel3.setFont(new Font("Tahoma", 1, 13));
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("Workspace...");
        this.jLabel1.setFont(new Font("Tahoma", 1, 13));
        this.jLabel1.setText("...Database");
        this.jButtonMatchAll.setText("Match all");
        this.jButtonMatchAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonMatchAllActionPerformed(evt);
            }
        });
        this.jButtonSelect.setText("Select...");
        this.jButtonSelect.setToolTipText("Select a well from database to match to selected well");
        this.jButtonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonSelectActionPerformed(evt);
            }
        });
        this.jButtonSelectMaster.setText(" Select master...");
        this.jButtonSelectMaster.setEnabled(false);
        this.jButtonSelectMaster.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSelectMaster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonSelectMasterActionPerformed(evt);
            }
        });
        this.jButtonAddEdit.setText("Add/Edit...");
        this.jButtonAddEdit.setToolTipText("Add selected workspace well to database");
        this.jButtonAddEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonAddEditActionPerformed(evt);
            }
        });
        this.jButtonAddAll.setText("Add all");
        this.jButtonAddAll.setToolTipText("Add all workspace wells to database");
        this.jButtonAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonAddAllActionPerformed(evt);
            }
        });
        this.jButtonUnmatch.setText("Unmatch");
        this.jButtonUnmatch.setToolTipText("Reverse all matches made in current session");
        this.jButtonUnmatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonUnmatchActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMatchWells.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0, 309, Short.MAX_VALUE).add((Component)this.jLabel1)).add((Component)this.jScrollPane1, -1, 467, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add(2, (Component)this.jButtonUnmatch, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jSeparator1).add(2, (Component)this.jButtonMatchAll, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonSelect, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAddAll, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAddEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonSelectMaster, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonCancel, -1, 101, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, 101, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel1)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jButtonMatchAll).addPreferredGap(0).add((Component)this.jButtonSelect).addPreferredGap(0).add((Component)this.jButtonSelectMaster).addPreferredGap(0).add((Component)this.jButtonAddEdit).addPreferredGap(0).add((Component)this.jButtonAddAll).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonUnmatch).addPreferredGap(0, 28, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 293, Short.MAX_VALUE)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void jButtonSelectMasterActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemented", this.getTitle(), 1);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        try {
            Iterator it = this.model.ws.getProject(0).getWellIterator();
            int i = 0;
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                well.setLink(this.links.get(i));
                ++i;
            }
        }
        catch (Exception e) {
            SB.showStackError((String)("Error resetting well matches: " + e.getMessage()), (Exception)e);
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonMatchAllActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Project project = this.model.ws.getProject(0);
            Iterator it = project.getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                if (well.getLink() != null) continue;
                well.match(this.db);
                well.updateHeaderStatus();
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.toString(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one well to match", this.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            WsWell well = (WsWell)this.model.ws.getProject(0).getWellAt(this.sorter.getIndexOf(this.jTableWells.getSelectedRow()));
            DialogSelectWell dialog = new DialogSelectWell(this, true, this.db, false, well.getWellName());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                Well dbWell = dialog.selection.get(0);
                if (well.getType() != dbWell.getType()) {
                    well.setSectionType(dbWell.getType());
                }
                well.setLink(dbWell);
                this.sorter.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonUnmatchActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() < 1) {
            JOptionPane.showMessageDialog(this, "Select well(s) to unmatch", this.getTitle(), 1);
            return;
        }
        try {
            int[] selection = this.jTableWells.getSelectedRows();
            for (int i = 0; i < selection.length; ++i) {
                WsWell well = (WsWell)this.model.ws.getProject(0).getWellAt(this.sorter.getIndexOf(selection[i]));
                if (well.getLink() == null) continue;
                well.unMatch();
            }
            this.sorter.reallocateIndexes();
            this.jTableWells.updateUI();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonAddEditActionPerformed(ActionEvent evt) {
        if (this.jTableWells.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select well to add/edit", this.getTitle(), 1);
            return;
        }
        try {
            WsWell well = (WsWell)this.model.ws.getProject(0).getWellAt(this.sorter.getIndexOf(this.jTableWells.getSelectedRow()));
            DialogWell dialog = new DialogWell(this, true, this.db, (Well)well);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                if (well.getType() != dialog.well.getType()) {
                    well.setSectionType(dialog.well.getType());
                }
                well.getHeader().copy(dialog.well.getHeader());
                well.setLink(dialog.well);
            }
            this.sorter.reallocateIndexes();
            this.jTableWells.updateUI();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        try {
            Project project = this.model.ws.getProject(0);
            Iterator it = project.getWellIterator();
            boolean countryMissing = false;
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                if (well.getLink() != null) continue;
                String wellCode = well.getWellCode();
                if (well.getHeader().getCountry() == null || well.getHeader().getCountry().length() == 0 || !well.hasTDorTop()) {
                    countryMissing = true;
                    continue;
                }
                if (wellCode.length() == 0) {
                    wellCode = Well.makeCode((String)well.getWellName());
                }
                Well temp = new Well(this.db, wellCode, well.getHeader());
                this.db.insertWell(temp);
                well.setLink(temp);
                this.db.commit();
            }
            if (countryMissing) {
                JOptionPane.showMessageDialog(this, "Some well(s) were not added because the country name or TD/top is missing. Add these well(s) using the Add/edit button.", this.getTitle(), 1);
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception ex) {
            this.db.doRollback();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean askExclusion = false;
        try {
            Project project = this.model.ws.getProject(0);
            Iterator it = project.getWellIterator();
            while (it.hasNext()) {
                WsWell well = (WsWell)it.next();
                if (well.getLink() != null) continue;
                if (!askExclusion) {
                    int opt = JOptionPane.showConfirmDialog(this, "Not all wells matched. Do you want to exclude unmatched wells?", this.getTitle(), 0, 2);
                    if (opt == 1) {
                        return;
                    }
                    askExclusion = true;
                }
                System.out.println("Excluding well: " + well);
                it.remove();
                if (well.getLink() == null) continue;
                well.getLink().deleteObservers();
            }
            this.isOK = true;
            this.dispose();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmatchwells.html");
    }
}

