/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import model2.AbnScheme;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogMergeAbn
extends JDialog {
    SBdb db;
    AbnScheme target;
    List<AbnScheme> schemes;
    boolean isOK = false;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListAbnSchemes;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public DialogMergeAbn(JDialog parent, boolean modal, SBdb db, AbnScheme target, List<AbnScheme> schemes) {
        super((Dialog)parent, modal);
        this.db = db;
        this.target = target;
        this.schemes = schemes;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jTextFieldName.setText(this.target.getName());
        this.jListAbnSchemes.setListData(new Vector<AbnScheme>(this.schemes));
        this.jListAbnSchemes.repaint();
        this.setTitle("Abundance Schemes : Merge");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListAbnSchemes = new JList();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Abundance Scheme: ");
        this.jTextFieldName.setEditable(false);
        this.jButtonOK.setText("Merge");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeAbn.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeAbn.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jListAbnSchemes.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jListAbnSchemes);
        this.jLabel2.setText("Select scheme(s) to be merged:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jLabel2).add(1, (Component)this.jScrollPane1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldName, -2, 285, -2))).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(264, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel1)).add(18, 18, 18).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 139, Short.MAX_VALUE).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListAbnSchemes.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select at least one scheme to merge.", this.getTitle(), 1);
            return;
        }
        try {
            Object[] donors = this.jListAbnSchemes.getSelectedValues();
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (int i = 0; i < donors.length; ++i) {
                AbnScheme donor = (AbnScheme)donors[i];
                this.db.mergeAbnScheme(this.target, donor);
            }
            this.db.commit();
            this.isOK = true;
            this.dispose();
        }
        catch (SBException se) {
            JOptionPane.showMessageDialog(this, "Error: " + se.getMessage(), "Error", 0);
            se.printStackTrace();
            this.db.doRollback();
        }
        catch (SQLException se) {
            JOptionPane.showMessageDialog(this, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            se.printStackTrace();
            this.db.doRollback();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

