/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.EventCount;
import jsbugs.FrameJsbugs;
import jsbugs.MergeEventsTableModel;
import model2.SBEvent;
import model2.SBdb;
import util.SB;
import util.SBException;

public class DialogMergeEvents
extends JDialog {
    MergeEventsTableModel model = new MergeEventsTableModel();
    SBEvent target;
    boolean isOK = false;
    SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonMerge;
    private JButton jButtonSetTarget;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableMerge;
    private JTextField jTextFieldReplace;

    public DialogMergeEvents(Frame parent, boolean modal, List<SBEvent> events, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(events);
    }

    private void init(List<SBEvent> events) {
        this.setTitle("Merge Events");
        this.getRootPane().setDefaultButton(this.jButtonMerge);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableMerge.getColumnModel().getColumn(i).setHeaderValue(MergeEventsTableModel.columnTitles[i]);
            this.jTableMerge.getColumnModel().getColumn(i).setPreferredWidth(MergeEventsTableModel.columnWidths[i]);
        }
        SB.setTableHeaderBold((JTable)this.jTableMerge);
        this.model.events = new LinkedList<EventCount>();
        try {
            for (SBEvent event : events) {
                this.model.events.add(new EventCount(event, event.getNoccs(true), event.getNcmpStdOccs()));
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldReplace = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTableMerge = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonMerge = new JButton();
        this.jButtonSetTarget = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(360, 175));
        this.jLabel1.setText("Replace with:");
        this.jTextFieldReplace.setBackground(new Color(255, 255, 204));
        this.jTableMerge.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableMerge);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeEvents.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonMerge.setText("Merge");
        this.jButtonMerge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeEvents.this.jButtonMergeActionPerformed(evt);
            }
        });
        this.jButtonSetTarget.setText("Set Target");
        this.jButtonSetTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeEvents.this.jButtonSetTargetActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 444, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldReplace, -1, 375, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSetTarget).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 154, Short.MAX_VALUE).addComponent(this.jButtonMerge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonMerge);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldReplace, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 94, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonMerge).addComponent(this.jButtonSetTarget)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSetTargetActionPerformed(ActionEvent evt) {
        if (this.jTableMerge.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row only", this.getTitle(), 1);
            return;
        }
        this.target = this.model.events.get((int)this.jTableMerge.getSelectedRow()).sbEvent;
        this.jTextFieldReplace.setText(this.target.toString());
    }

    private void jButtonMergeActionPerformed(ActionEvent evt) {
        if (this.target == null) {
            JOptionPane.showMessageDialog(this, "Select a target event to which the displayed event(s) will be merged.", this.getTitle(), 1);
            return;
        }
        try {
            for (EventCount ec : this.model.events) {
                if (ec.sbEvent == this.target) continue;
                this.db.mergeEvents(ec.sbEvent, this.target);
            }
            this.db.commit();
            JOptionPane.showMessageDialog(this, "Merge complete", this.getTitle(), 1);
            this.db.notifyObservers((Object)this.target);
            this.dispose();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }
}

