/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import util.SB;

public class DialogMergeSamples
extends JDialog {
    SBdb db;
    Sample sample1;
    Sample sample2;
    Well well;
    boolean isOK = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonSample1;
    private JRadioButton jRadioButtonSample2;

    public DialogMergeSamples(Frame parent, boolean modal, SBdb db, char units, Well well, Sample sample1, Sample sample2) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.sample1 = sample1;
        this.sample2 = sample2;
        this.well = well;
        this.initComponents();
        this.init(units);
    }

    private void init(char units) throws SQLException {
        this.setTitle("Merge Samples");
        String textSample1 = this.sample1.toString(units, true, true);
        String textSample2 = this.sample2.toString(units, true, true);
        this.jRadioButtonSample1.setText(textSample1 + " (" + this.sample1.getAnalyses().size() + " analyses, " + this.sample1.getIGDOccurrences(this.well.getWellID()) + ")");
        this.jRadioButtonSample2.setText(textSample2 + " (" + this.sample2.getAnalyses().size() + " analyses, " + this.sample2.getIGDOccurrences(this.well.getWellID()) + ")");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSample2 = new JRadioButton();
        this.jRadioButtonSample1 = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 175));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeSamples.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeSamples.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogMergeSamples.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Select sample you want to keep", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroup1.add(this.jRadioButtonSample2);
        this.jRadioButtonSample2.setText("jRadioButton2");
        this.buttonGroup1.add(this.jRadioButtonSample1);
        this.jRadioButtonSample1.setText("jRadioButton1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSample1, -1, 459, Short.MAX_VALUE).addComponent(this.jRadioButtonSample2, -1, 459, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSample1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSample2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addGap(6, 6, 6).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHelp).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmergesamples.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            Sample target;
            Sample donor;
            if (this.buttonGroup1.getSelection() == null) {
                JOptionPane.showMessageDialog(this, "Make a selection", this.getTitle(), 2);
                return;
            }
            if (this.jRadioButtonSample1.isSelected()) {
                donor = this.sample2;
                target = this.sample1;
            } else {
                donor = this.sample1;
                target = this.sample2;
            }
            this.well.mergeSamples(donor, target);
            this.well.notifyObservers((Object)target);
            this.db.commit();
            this.isOK = true;
            this.dispose();
        }
        catch (Exception ex) {
            this.db.doRollback();
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }
}

