/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.TableModelNumericCodes;
import model2.SBdb;
import util.SBException;
import util.TableSorter;

public class DialogNumericCodes
extends JDialog {
    SBdb sbdb;
    TableModelNumericCodes model = new TableModelNumericCodes();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    private JButton jButtonClose;
    private JScrollPane jScrollPane1;
    private JTable jTableCodes;

    public DialogNumericCodes(Dialog parent, boolean modal, SBdb sbdb, int ccode) throws SQLException, SBException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init(ccode);
    }

    private void init(int ccode) throws SQLException, SBException {
        this.setTitle("Numeric codes : " + this.sbdb.getSipmDict(ccode));
        LinkedList<TableModelNumericCodes.TaxonCode> list = new LinkedList<TableModelNumericCodes.TaxonCode>();
        HashMap sipmDictEntries = this.sbdb.getSipmDictEntries(ccode, true);
        for (Map.Entry entry : sipmDictEntries.entrySet()) {
            list.add(new TableModelNumericCodes.TaxonCode(this.sbdb.getTaxon(((Integer)entry.getKey()).intValue()), (Integer)entry.getValue()));
        }
        Collections.sort(list);
        this.model.init(list, this.jTableCodes);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.sorter.addMouseListenerToHeaderInTable(this.jTableCodes);
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCodes = new JTable();
        this.setDefaultCloseOperation(2);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogNumericCodes.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableCodes.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableCodes);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 308, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 339, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

