/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.DialogNumericCodes;
import model2.SBdb;
import util.SB;
import util.SBException;

public class DialogNumericDicts
extends JDialog {
    DefaultListModel model = new DefaultListModel();
    SBdb sbdb;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonCodes;
    private JButton jButtonDelete;
    private JList jListDicts;
    private JScrollPane jScrollPane1;

    public DialogNumericDicts(Frame parent, boolean modal, SBdb sbdb) throws SQLException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Numeric Code Dictionaries");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.initModel();
    }

    private void initModel() throws SQLException {
        HashMap dicts = this.sbdb.getSIPMDicts();
        Set set = dicts.entrySet();
        for (Map.Entry entry : set) {
            ListItem row = new ListItem((Integer)entry.getKey(), (String)entry.getValue());
            this.model.addElement(row);
        }
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListDicts = new JList();
        this.jButtonDelete = new JButton();
        this.jButtonCodes = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 200));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogNumericDicts.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jListDicts.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jListDicts.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListDicts);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogNumericDicts.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonCodes.setText("Codes...");
        this.jButtonCodes.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCodes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogNumericDicts.this.jButtonCodesActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogNumericDicts.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 183, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonCodes, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonAdd, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jButtonCodes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 150, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, (Object)"Name of new Dictionary: ");
        if (name == null || name.length() == 0) {
            return;
        }
        for (int i = 0; i < this.model.size(); ++i) {
            ListItem item = (ListItem)this.model.getElementAt(i);
            if (!item.dictionary.equalsIgnoreCase(name)) continue;
            JOptionPane.showMessageDialog(this, "Dictionary already exists", this.getTitle(), 2);
            return;
        }
        try {
            ListItem row = new ListItem(this.sbdb.addSipmDict(name), name);
            this.sbdb.commit();
            this.model.addElement(row);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.sbdb.doRollback();
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListDicts.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select one row from the table", this.getTitle(), 2);
            return;
        }
        ListItem row = (ListItem)this.model.get(this.jListDicts.getSelectedIndex());
        try {
            int opt;
            int nEntries = this.sbdb.getSipmDictEntryCount(row.ccode);
            if (nEntries > 0 && (opt = JOptionPane.showConfirmDialog(this, "Warning: this dictionary contains codes for " + nEntries + " taxa. Are you sure you want to delete it?", this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.sbdb.deleteSipmDict(row.ccode);
            this.sbdb.commit();
            this.model.removeElement(row);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            this.sbdb.doRollback();
        }
    }

    private void jButtonCodesActionPerformed(ActionEvent evt) {
        if (this.jListDicts.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, "Select one row from the table", this.getTitle(), 2);
            return;
        }
        try {
            DialogNumericCodes dialog = new DialogNumericCodes((Dialog)this, true, this.sbdb, ((ListItem)this.model.getElementAt((int)this.jListDicts.getSelectedIndex())).ccode);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private static class ListItem {
        final int ccode;
        final String dictionary;

        ListItem(int ccode, String name) {
            this.ccode = ccode;
            this.dictionary = name;
        }

        public String toString() {
            return this.dictionary;
        }
    }
}

