/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableModel;
import jsbugs.DialogList;
import jsbugs.DialogSelectWellODM;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelODMMap;
import model2.Discipline;
import model2.Lastval;
import model2.ODMReader;
import model2.SBdb;
import model2.WsWell;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogODM
extends JDialog {
    private final SBdb ws;
    private final List<Integer> dataTypes;
    private final DefaultListModel wellModel = new DefaultListModel();
    private JCheckBox[] checkBoxes;
    TableModelODMMap model = new TableModelODMMap();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    private JButton jButtonCancel;
    private JButton jButtonClearAll;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectDatabase;
    private JButton jButtonSelectProject;
    private JButton jButtonSelectWells;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jListWells;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTableTypeMap;
    private JTextField jTextFieldDatabase;

    public DialogODM(Frame parent, boolean modal, SBdb ws, SBdb db, List<Integer> dataTypes) throws SQLException, SBException {
        super(parent, modal);
        this.ws = ws;
        this.model.db = db;
        this.dataTypes = dataTypes;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        File file;
        this.setTitle("StrataBugs - ODM Import");
        this.model.setupTable(this.jTableTypeMap);
        String dbName = Lastval.getString((SBdb)this.model.db, (String)"ODMdb");
        if (dbName != null && !dbName.isEmpty() && (file = new File(dbName)).exists()) {
            this.jTextFieldDatabase.setText(dbName);
            try {
                this.model.setOdmReader(new ODMReader(dbName));
                System.out.println("Connected to ODM database");
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (Exception ex) {
                SB.showStackError((String)ex.toString(), (Exception)ex);
            }
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTableTypeMap);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldDatabase = new JTextField();
        this.jButtonSelectDatabase = new JButton();
        this.jLabel2 = new JLabel();
        this.jButtonSelectWells = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonSelectProject = new JButton();
        this.jButtonClearAll = new JButton();
        this.jButtonHelp = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jListWells = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTableTypeMap = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(450, 400));
        this.jLabel1.setText("Database:");
        this.jTextFieldDatabase.setEditable(false);
        this.jButtonSelectDatabase.setText("...");
        this.jButtonSelectDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogODM.this.jButtonSelectDatabaseActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Well(s):");
        this.jButtonSelectWells.setText("Select...");
        this.jButtonSelectWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogODM.this.jButtonSelectWellsActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogODM.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogODM.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSelectProject.setText("Project...");
        this.jButtonSelectProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogODM.this.jButtonSelectProjectActionPerformed(evt);
            }
        });
        this.jButtonClearAll.setText("Clear all");
        this.jButtonClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogODM.this.jButtonClearAllActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogODM.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerSize(10);
        this.jSplitPane1.setOrientation(0);
        this.jScrollPane1.setPreferredSize(new Dimension(258, 230));
        this.jListWells.setModel(this.wellModel);
        this.jScrollPane1.setViewportView(this.jListWells);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jTableTypeMap.setModel((TableModel)this.sorter);
        this.jScrollPane2.setViewportView(this.jTableTypeMap);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonClearAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSplitPane1, -1, 604, Short.MAX_VALUE).addComponent(this.jTextFieldDatabase)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSelectDatabase, -2, 30, -2).addComponent(this.jButtonSelectWells, -2, 45, -2).addComponent(this.jButtonSelectProject)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.linkSize(0, this.jButtonSelectProject, this.jButtonSelectWells);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldDatabase, -2, -1, -2)).addComponent(this.jButtonSelectDatabase)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 550, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSelectWells).addGap(9, 9, 9).addComponent(this.jButtonSelectProject)).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonClearAll)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.model.odmReader == null) {
            JOptionPane.showMessageDialog(this, "You are not connected to an ODM database", this.getTitle(), 2);
            return;
        }
        if (this.wellModel.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No well(s) selected", this.getTitle(), 2);
            return;
        }
        for (ODMReader.ODMMetadataEntry entry1 : this.model.odmReader.metadata) {
            for (ODMReader.ODMMetadataEntry entry2 : this.model.odmReader.metadata) {
                if (entry1 == entry2 || entry1.getSbugsName().isEmpty() || !entry1.getSbugsName().equals(entry2.getSbugsName()) || entry1.getDtype() == 11 || entry1.getDtype() == 16) continue;
                JOptionPane.showMessageDialog(this, "Duplicate map entry for: " + entry1.getODMColumnDescrip() + "/" + entry1.getSbugsName(), this.getTitle(), 2);
                return;
            }
        }
        try {
            Enumeration en = this.wellModel.elements();
            LinkedList wells = new LinkedList();
            while (en.hasMoreElements()) {
                wells.add(en.nextElement());
            }
            this.addDataType(1);
            int n = 0;
            HashSet<String> nonImportDataTypes = new HashSet<String>();
            for (ODMReader.ODMMetadataEntry entry : this.model.odmReader.metadata) {
                if (entry.getIgdType() > 0 || entry.getDtype() > 0) {
                    boolean addType = true;
                    switch (entry.getDtype()) {
                        case 3: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.MICRO);
                            break;
                        }
                        case 5: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.NANNO);
                            break;
                        }
                        case 7: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.PALY);
                            break;
                        }
                        case 9: {
                            this.model.odmReader.loadBiocom(this.ws, wells, entry.getODMTableName(), entry.getODMDataType(), Discipline.MACRO);
                            break;
                        }
                        case 10: 
                        case 11: 
                        case 12: {
                            this.model.odmReader.loadIntervals(this.ws, wells, entry.getODMTableDescrip(), entry.getODMTableName(), entry.getODMDataType(), entry.getIgdType(), entry.getHier());
                            break;
                        }
                        case 21: {
                            this.model.odmReader.loadLithology(this.ws, wells, entry.getODMTableName());
                            break;
                        }
                        case 16: {
                            this.model.odmReader.loadEvents(this.ws, wells, entry.getODMTableName(), entry.getODMDataType());
                            break;
                        }
                        default: {
                            if (entry.getSbugsName().trim().length() > 0) {
                                nonImportDataTypes.add(entry.getSbugsName());
                            }
                            addType = false;
                        }
                    }
                    if (!addType) continue;
                    String entryString = "" + entry.getODMDataType() + "|" + entry.getODMTableID() + "|" + entry.getDtype() + "|" + entry.getIgdType() + "|" + entry.getHier();
                    Lastval.putString((SBdb)this.model.db, (String)("ODM2SB" + ++n), (String)entryString);
                    this.addDataType(entry.getDtype());
                    continue;
                }
                if (entry.getSbugsName().trim().length() <= 0) continue;
                nonImportDataTypes.add(entry.getSbugsName());
            }
            Lastval.putInt((SBdb)this.model.db, (String)"ODM2SBNN", (int)n);
            Lastval.putString((SBdb)this.model.db, (String)"ODMdb", (String)this.jTextFieldDatabase.getText());
            this.model.db.commit();
            this.model.odmReader.close();
            Iterator wit = this.ws.getProject(0).getWellIterator();
            while (wit.hasNext()) {
                WsWell well = (WsWell)wit.next();
                well.updateStatus();
            }
            if (!nonImportDataTypes.isEmpty()) {
                String msg = "The following items were not imported, a method had not been implemented. Contact StrataData if required:\n";
                Iterator it = nonImportDataTypes.iterator();
                while (it.hasNext()) {
                    msg = msg + (String)it.next() + "\n";
                }
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            }
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jButtonSelectDatabaseActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(new File("D:\\sbugs\\TestData\\ODM\\Example Database"));
        fileChooser.setDialogType(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Access database files (mdb, accdb)", "mdb", "accdb");
        fileChooser.setFileFilter(filter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(this) == 0) {
            File accDB = fileChooser.getSelectedFile();
            if (!accDB.exists()) {
                System.out.println("Looking for: " + accDB);
                JOptionPane.showMessageDialog(this, "Cannot find an ODM database in selected folder", this.getTitle(), 2);
                return;
            }
            try {
                this.model.setOdmReader(new ODMReader(accDB.getAbsolutePath()));
                this.jTextFieldDatabase.setText(accDB.getAbsolutePath());
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
            }
            catch (Exception ex) {
                SB.showStackError((String)ex.toString(), (Exception)ex);
            }
        }
    }

    private void jButtonSelectWellsActionPerformed(ActionEvent evt) {
        if (this.model.odmReader == null) {
            JOptionPane.showMessageDialog(this, "You are not connected to an ODM database", this.getTitle(), 2);
            return;
        }
        try {
            DialogSelectWellODM dialog = new DialogSelectWellODM(this, true, this.model.db, this.model.odmReader);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection.size() > 0) {
                this.wellModel.clear();
                for (ODMReader.ODMWell well : dialog.selection) {
                    this.wellModel.addElement(well);
                }
                this.jListWells.repaint();
            }
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonSelectProjectActionPerformed(ActionEvent evt) {
        if (this.model.odmReader == null) {
            JOptionPane.showMessageDialog(this, "No database selected");
            return;
        }
        try {
            DialogList dialog = new DialogList(this, true, "Select Project", this.model.db, this.model.odmReader.getProjects(), true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.wellModel.clear();
                List wells = ((ODMReader.Project)dialog.selection).getWells();
                for (ODMReader.ODMWell well : wells) {
                    this.wellModel.addElement(well);
                }
                this.jListWells.repaint();
            }
        }
        catch (SQLException e) {
            SB.showStackError((String)"Error", (SQLException)e);
        }
    }

    private void jButtonClearAllActionPerformed(ActionEvent evt) {
        if (this.model.odmReader != null) {
            for (ODMReader.ODMMetadataEntry entry : this.model.odmReader.metadata) {
                entry.clearSBugs();
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogodm.html");
    }

    private void addDataType(int dataType) {
        if (!this.dataTypes.contains(dataType)) {
            this.dataTypes.add(dataType);
        }
    }
}

