/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogList;
import model2.IGDInterval;
import model2.IGDScheme;
import model2.OWXLSReader;
import model2.SBdb;
import util.SB;

public class DialogOWXLSReader
extends JDialog {
    DefaultComboBoxModel igdTypeModel = new DefaultComboBoxModel();
    DefaultComboBoxModel schemeModel = new DefaultComboBoxModel();
    SBdb db;
    SBdb ws;
    File file;
    List dataTypes;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxDataType;
    private JComboBox jComboBoxScheme;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JTextField jTextFieldFileName;

    public DialogOWXLSReader(Frame parent, boolean modal, SBdb db, SBdb ws, File file, List dataTypes) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.ws = ws;
        this.file = file;
        this.dataTypes = dataTypes;
        this.init();
    }

    private void init() {
        this.igdTypeModel.addElement(IGDInterval.getIGDName((int)2));
        this.igdTypeModel.addElement(IGDInterval.getIGDName((int)3));
        this.igdTypeModel.addElement(IGDInterval.getIGDName((int)4));
        this.jComboBoxDataType.repaint();
        this.jTextFieldFileName.setText(this.file.getAbsolutePath());
        this.setTitle("XLS Reader");
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.jTextFieldFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.jComboBoxDataType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxScheme = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTextFieldFileName.setEditable(false);
        this.jLabel1.setText("File:");
        this.jComboBoxDataType.setModel(this.igdTypeModel);
        this.jComboBoxDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOWXLSReader.this.jComboBoxDataTypeActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Data Type:");
        this.jComboBoxScheme.setModel(this.schemeModel);
        this.jLabel3.setText("Scheme:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Units"));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setSelected(true);
        this.jRadioButtonMetres.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMetres).addGap(18, 18, 18).addComponent(this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMetres).addComponent(this.jRadioButtonFeet)).addGap(0, 0, Short.MAX_VALUE)));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOWXLSReader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOWXLSReader.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBoxScheme, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxDataType, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldFileName)).addGap(61, 61, 61)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(137, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(66, 66, 66)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFileName, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxDataType, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jComboBoxScheme, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            OWXLSReader reader;
            int igdType;
            int dataType;
            this.setCursor(Cursor.getPredefinedCursor(3));
            IGDScheme scheme = IGDScheme.copyToWorkspace((SBdb)this.ws, (IGDScheme)((IGDScheme)this.jComboBoxScheme.getSelectedItem()));
            this.ws.addIGDScheme(scheme);
            char units = 'M';
            if (this.jRadioButtonFeet.isSelected()) {
                units = 'F';
            }
            if (!this.dataTypes.contains(dataType = IGDInterval.igdType2dType((int)(igdType = IGDInterval.getIGDType((String)((String)this.jComboBoxDataType.getSelectedItem())))))) {
                this.dataTypes.add(dataType);
            }
            if (!(reader = new OWXLSReader(this.ws, this.file, units, scheme, igdType)).getNonInserts().isEmpty()) {
                JOptionPane.showMessageDialog(this, "The following list of intervals were not added to due overlaps or other problems", this.getTitle(), 2);
                DialogList dialogList = new DialogList(this, false, this.getTitle(), this.db, reader.getNonInserts(), false, false);
                dialogList.setLocationRelativeTo(this);
                dialogList.setVisible(true);
            }
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jComboBoxDataTypeActionPerformed(ActionEvent evt) {
        System.out.println("Action performed on igdType");
        this.schemeModel.removeAllElements();
        int igdType = IGDInterval.getIGDType((String)((String)this.jComboBoxDataType.getSelectedItem()));
        try {
            for (IGDScheme scheme : this.db.getIGDSchemes(igdType)) {
                this.schemeModel.addElement(scheme);
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
        this.jComboBoxScheme.repaint();
    }
}

