/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.DialogImageSet;
import jsbugs.DialogTaxonReassign;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.TableModelImageSet;
import model2.AbnScheme;
import model2.ImageSet;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogOccurrence
extends SBDialog {
    private static final int LENPRESERVATION = 20;
    private static final int LENCOLOUR = 20;
    private static final int LENCOMMENT = 255;
    private static final int spinnerLimit = 999999;
    private final SBdb db;
    private final TaxonOcc fss;
    private final Smpdtl smpdtl;
    private final Well well;
    private Taxon taxon;
    private AbnScheme abn;
    private final TableModelImageSet model = new TableModelImageSet();
    private final DefaultComboBoxModel specTypeModel = new DefaultComboBoxModel();
    final UndoableEditSupport undoSupport = new UndoableEditSupport();
    private boolean imageSetChanged = false;
    private int imageSets = 0;
    private ButtonGroup buttonGroupIdentification;
    private ButtonGroup buttonGroupSituation;
    private JButton jButtonCancel;
    private JButton jButtonEditImageSet;
    private JButton jButtonEditTaxon;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxCaved;
    private JCheckBox jCheckBoxMarker;
    private JCheckBox jCheckBoxPresentOutsideCount;
    private JComboBox jComboBoxAbundance;
    private JComboBox jComboBoxSpecType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabelCoarse;
    private JLabel jLabelFine;
    private JLabel jLabelMedium;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonInSitu;
    private JRadioButton jRadioButtonPositive;
    private JRadioButton jRadioButtonQuestionable;
    private JRadioButton jRadioButtonReworked;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerCoarse;
    private JSpinner jSpinnerFine;
    private JSpinner jSpinnerMedium;
    private JTable jTableImageSet;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldComments;
    private JTextField jTextFieldPreservation;
    private JTextField jTextFieldTaxonName;

    public DialogOccurrence(Frame parent, boolean modal, SBdb db, Well well, Smpdtl smpdtl, TaxonOcc fss, Taxon taxon, boolean isReworked, boolean isCaved, boolean questionable, boolean isMarker, boolean showSplits) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.taxon = taxon;
        this.fss = fss;
        this.well = well;
        this.smpdtl = smpdtl;
        this.initComponents();
        this.init(isReworked, isCaved, questionable, isMarker, showSplits);
    }

    private void init(boolean isReworked, boolean isCaved, boolean questionable, boolean isMarker, boolean showSplits) throws SQLException, SBException {
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.abn = this.db.getAbnScheme(this.well, this.smpdtl.getAnalyID(), true);
        this.jComboBoxAbundance.addItem("");
        if (this.abn != null) {
            this.abn.fillCombo(this.jComboBoxAbundance, false);
        }
        this.jComboBoxAbundance.setSelectedIndex(0);
        SpinnerNumberModel modelCoarse = new SpinnerNumberModel(0, 0, 999999, 1);
        SpinnerNumberModel modelMedium = new SpinnerNumberModel(1, 0, 999999, 1);
        SpinnerNumberModel modelFine = new SpinnerNumberModel(0, 0, 999999, 1);
        this.jSpinnerCoarse.setModel(modelCoarse);
        this.jSpinnerMedium.setModel(modelMedium);
        this.jSpinnerFine.setModel(modelFine);
        this.initSpecTypeModel();
        if (this.fss != null) {
            this.taxon = this.fss.getTaxon();
            this.jTextFieldPreservation.setText(this.fss.getPreservation());
            this.jTextFieldColour.setText(this.fss.getColour());
            this.jTextFieldComments.setText(this.fss.getComment());
            if (this.fss.getCoarse() > 0 || this.fss.getFine() > 0) {
                showSplits = true;
            }
            this.jSpinnerCoarse.getModel().setValue(this.fss.getCoarse());
            this.jSpinnerMedium.getModel().setValue(this.fss.getMedium());
            this.jSpinnerFine.getModel().setValue(this.fss.getFine());
            this.jRadioButtonReworked.setSelected(this.fss.getReworked());
            this.jRadioButtonInSitu.setSelected(!this.fss.getReworked());
            if (this.fss.getIdentType() == '?') {
                this.jRadioButtonQuestionable.setSelected(true);
            }
            this.jCheckBoxCaved.setSelected(this.fss.getCaved());
            this.jCheckBoxMarker.setSelected(this.fss.isMarker());
            if (this.fss.getSubAbund() != null && this.fss.getSubAbund().length() > 0) {
                if (this.abn != null) {
                    this.jComboBoxAbundance.setSelectedItem(this.abn.getClassName(this.fss.getSubAbund()));
                }
            } else if (this.fss.getTotalCount() == 0) {
                this.jCheckBoxPresentOutsideCount.setSelected(true);
            }
            this.setTitle("Occurrence: Edit - " + this.taxon.toString());
            this.model.set = this.fss.getImageSet();
            this.imageSets = this.fss.getImageSet().getID() > 0 ? 1 : 0;
            this.jComboBoxSpecType.setSelectedItem(this.db.getSpecType(this.fss.getSpecType()));
        } else {
            this.jRadioButtonQuestionable.setSelected(questionable);
            this.jRadioButtonReworked.setSelected(isReworked);
            this.jCheckBoxMarker.setSelected(isMarker);
            this.jCheckBoxCaved.setSelected(isCaved);
            this.setTitle("Occurrence: Add - " + this.taxon.toString());
        }
        this.jTextFieldTaxonName.setText(this.taxon.toString());
        if (!showSplits) {
            this.jSpinnerCoarse.setVisible(false);
            this.jSpinnerFine.setVisible(false);
            this.jLabelMedium.setText("Count:");
            this.jLabelCoarse.setVisible(false);
            this.jLabelFine.setVisible(false);
        }
        this.model.setupTable(this.jTableImageSet);
        this.pack();
    }

    private void initSpecTypeModel() throws SQLException {
        this.specTypeModel.removeAllElements();
        Iterator it = this.db.getSpecTypeIterator();
        while (it.hasNext()) {
            this.specTypeModel.addElement(it.next());
        }
        this.jComboBoxSpecType.repaint();
    }

    private void initComponents() {
        this.buttonGroupIdentification = new ButtonGroup();
        this.buttonGroupSituation = new ButtonGroup();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel10 = new JPanel();
        this.jRadioButtonReworked = new JRadioButton();
        this.jRadioButtonInSitu = new JRadioButton();
        this.jCheckBoxCaved = new JCheckBox();
        this.jCheckBoxMarker = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldTaxonName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldPreservation = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldComments = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabelCoarse = new JLabel();
        this.jLabelMedium = new JLabel();
        this.jLabelFine = new JLabel();
        this.jSpinnerCoarse = new JSpinner();
        this.jSpinnerMedium = new JSpinner();
        this.jSpinnerFine = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jComboBoxAbundance = new JComboBox();
        this.jCheckBoxPresentOutsideCount = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jRadioButtonPositive = new JRadioButton();
        this.jRadioButtonQuestionable = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableImageSet = new JTable();
        this.jButtonEditImageSet = new JButton();
        this.jLabel5 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jComboBoxSpecType = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jButtonEditTaxon = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(525, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogOccurrence.this.formWindowClosing(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOccurrence.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOccurrence.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel10.setBorder(BorderFactory.createTitledBorder(null, "Situation", 0, 0, null, new Color(51, 102, 204)));
        this.jPanel10.setMinimumSize(new Dimension(480, 600));
        this.buttonGroupSituation.add(this.jRadioButtonReworked);
        this.jRadioButtonReworked.setText("Reworked");
        this.jRadioButtonReworked.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonReworked.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupSituation.add(this.jRadioButtonInSitu);
        this.jRadioButtonInSitu.setSelected(true);
        this.jRadioButtonInSitu.setText("In situ");
        this.jRadioButtonInSitu.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonInSitu.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxCaved.setText("Caved");
        this.jCheckBoxCaved.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxCaved.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxMarker.setText("Marker");
        this.jCheckBoxMarker.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxMarker.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel10Layout = new GroupLayout((Container)this.jPanel10);
        this.jPanel10.setLayout((LayoutManager)jPanel10Layout);
        jPanel10Layout.setHorizontalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel10Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((Component)this.jRadioButtonReworked).add((Component)this.jRadioButtonInSitu).add((Component)this.jCheckBoxCaved).add((Component)this.jCheckBoxMarker)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel10Layout.setVerticalGroup((GroupLayout.Group)jPanel10Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel10Layout.createSequentialGroup().add((Component)this.jRadioButtonReworked).addPreferredGap(0).add((Component)this.jRadioButtonInSitu).addPreferredGap(0).add((Component)this.jCheckBoxCaved).addPreferredGap(0).add((Component)this.jCheckBoxMarker).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setText("Taxon:");
        this.jTextFieldTaxonName.setEditable(false);
        this.jTextFieldTaxonName.setText("jTextField2");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Comments", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel2.setText("Preservation:");
        this.jTextFieldPreservation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogOccurrence.this.jTextFieldPreservationKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Colour:");
        this.jTextFieldColour.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogOccurrence.this.jTextFieldColourKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Comments:");
        this.jTextFieldComments.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogOccurrence.this.jTextFieldCommentsKeyTyped(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jTextFieldPreservation).add((Component)this.jTextFieldComments).add((Component)this.jTextFieldColour)).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldComments, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldPreservation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldColour, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Abundance", 0, 0, null, new Color(51, 102, 204)));
        this.jLabelCoarse.setText("Coarse:");
        this.jLabelMedium.setText("Medium:");
        this.jLabelFine.setText("Fine:");
        this.jLabel8.setText("Semi-quantitative:");
        this.jCheckBoxPresentOutsideCount.setText("Present but outside the sample count");
        this.jCheckBoxPresentOutsideCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOccurrence.this.jCheckBoxPresentOutsideCountActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabelMedium).add((Component)this.jLabelCoarse).add((Component)this.jLabelFine)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jCheckBoxPresentOutsideCount, -2, 205, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jSpinnerFine).add((Component)this.jSpinnerMedium).add((Component)this.jSpinnerCoarse, -2, 79, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jComboBoxAbundance, 0, -1, Short.MAX_VALUE).add((Component)this.jLabel8)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelCoarse).add((Component)this.jSpinnerCoarse, -2, -1, -2).add((Component)this.jLabel8)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelMedium).add((Component)this.jSpinnerMedium, -2, -1, -2).add((Component)this.jComboBoxAbundance, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabelFine).add((Component)this.jSpinnerFine, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jCheckBoxPresentOutsideCount).addContainerGap()));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Identification", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupIdentification.add(this.jRadioButtonPositive);
        this.jRadioButtonPositive.setSelected(true);
        this.jRadioButtonPositive.setText("Positive");
        this.jRadioButtonPositive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonPositive.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupIdentification.add(this.jRadioButtonQuestionable);
        this.jRadioButtonQuestionable.setText("Questionable");
        this.jRadioButtonQuestionable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonQuestionable.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jRadioButtonPositive).add((Component)this.jRadioButtonQuestionable)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonPositive).addPreferredGap(0).add((Component)this.jRadioButtonQuestionable).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTableImageSet.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableImageSet);
        this.jButtonEditImageSet.setText("...");
        this.jButtonEditImageSet.setToolTipText("Edit images");
        this.jButtonEditImageSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOccurrence.this.jButtonEditImageSetActionPerformed(evt);
            }
        });
        this.jLabel5.setForeground(new Color(51, 102, 204));
        this.jLabel5.setText("Images:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOccurrence.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jComboBoxSpecType.setModel(this.specTypeModel);
        this.jLabel6.setText("Sub-type:");
        this.jButtonEditTaxon.setText("Reassign...");
        this.jButtonEditTaxon.setToolTipText("Change the name of the taxon throughut the entire database");
        this.jButtonEditTaxon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOccurrence.this.jButtonEditTaxonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldTaxonName).addPreferredGap(0).add((Component)this.jButtonEditTaxon)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel10, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0, 10, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabel6).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jComboBoxSpecType, 0, -1, Short.MAX_VALUE))).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 47, -2).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel, -2, 65, -2)).add((Component)this.jButtonEditImageSet, -2, 33, -2)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTaxonName, -2, -1, -2).add((Component)this.jButtonEditTaxon)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel6).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jComboBoxSpecType, -2, -1, -2)).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel10, -2, 131, Short.MAX_VALUE)).add(10, 10, 10).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 199, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonEditImageSet).add(8, 8, 8).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldCommentsKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldComments, (int)255, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldPreservationKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldPreservation, (int)20, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldColourKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldColour, (int)20, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        try {
            if (this.model.set != null && this.model.set.getSize() > 0 && !this.fss.hasImageSet()) {
                System.out.println("Deleting unlinked image set: ID " + this.model.set.getID());
                this.model.set.delete();
                this.db.commit();
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        this.dispose();
    }

    boolean checkSituConfChange(int newSpecType) {
        if (this.fss == null || this.fss.getQuestionable() == this.jRadioButtonQuestionable.isSelected() && this.fss.getReworked() == this.jRadioButtonReworked.isSelected() && this.fss.getSpecType() == newSpecType) {
            return true;
        }
        for (TaxonOcc occ : this.smpdtl.getOccurUnsorted()) {
            if (occ == this.fss || occ.getTaxon().getSpecID() != this.fss.getTaxon().getSpecID() || occ.getSpecType() != newSpecType || occ.getReworked() != this.jRadioButtonReworked.isSelected() || occ.getQuestionable() != this.jRadioButtonQuestionable.isSelected()) continue;
            return false;
        }
        return true;
    }

    boolean checkRwUpdate() throws SQLException, SBException {
        if (this.fss == null) {
            return false;
        }
        if (this.fss.getReworked() != this.jRadioButtonReworked.isSelected()) {
            Sample sample;
            boolean hasMultiSuites = false;
            boolean isDifferent = false;
            Iterator i$ = this.well.getSamples().iterator();
            while (i$.hasNext() && !((sample = (Sample)i$.next()).getDepth() >= this.smpdtl.getSample().getDepth())) {
                for (Smpdtl dtl : sample.getAnalyses()) {
                    for (TaxonOcc occ : dtl.getOccur()) {
                        if (occ.getSpecID() != this.fss.getSpecID() || occ.getReworked() == this.jRadioButtonReworked.isSelected()) continue;
                        isDifferent = true;
                        if (dtl.getAnalyID() == this.smpdtl.getAnalyID()) continue;
                        hasMultiSuites = true;
                    }
                }
            }
            if (isDifferent) {
                int opt = JOptionPane.showConfirmDialog(this, "Do you want to set ALL higher occurrences to " + (this.jRadioButtonReworked.isSelected() ? "" : " NOT ") + " reworked?\n" + (hasMultiSuites ? "(Warning: this will affect analyses outside the current suite)" : "(Will affect current suite only)"), "Reworking", 0, 3);
                return opt == 0;
            }
        }
        return false;
    }

    int doRwUpdate() throws SQLException, SBException, FileNotFoundException, IOException {
        Sample sample;
        if (this.fss == null) {
            return 0;
        }
        if (this.fss.getReworked() != this.jRadioButtonReworked.isSelected()) {
            throw new SBException("Unexpected value of Rw flag in doRwUpdate.");
        }
        int nUpdated = 0;
        Iterator i$ = this.well.getSamples().iterator();
        while (i$.hasNext() && !((sample = (Sample)i$.next()).getDepth() >= this.smpdtl.getSample().getDepth())) {
            for (Smpdtl dtl : sample.getAnalyses()) {
                boolean hasSame = false;
                TaxonOcc diffOcc = null;
                for (TaxonOcc occ : dtl.getOccur()) {
                    if (occ.getSpecID() != this.fss.getSpecID()) continue;
                    if (occ.getReworked() != this.jRadioButtonReworked.isSelected()) {
                        diffOcc = occ;
                        continue;
                    }
                    hasSame = true;
                }
                if (diffOcc == null || hasSame) continue;
                dtl.updateOcc(this.well.getWellID(), diffOcc, this.jRadioButtonReworked.isSelected(), diffOcc.getQuestionable(), diffOcc.getSpecType(), diffOcc.getCaved(), diffOcc.isMarker(), diffOcc.getCoarse(), diffOcc.getMedium(), diffOcc.getFine(), diffOcc.getSubAbund(), diffOcc.getPreservation(), diffOcc.getColour(), diffOcc.getComment(), diffOcc.getImageSet());
                ++nUpdated;
            }
        }
        return nUpdated;
    }

    boolean checkCvUpdate() throws SQLException, SBException {
        if (this.fss == null) {
            return false;
        }
        if (this.fss.getCaved() != this.jCheckBoxCaved.isSelected()) {
            boolean hasMultiSuites = false;
            boolean isDifferent = false;
            for (Sample sample : this.well.getSamples()) {
                if (!sample.getTypeString().equalsIgnoreCase("CU") || sample.getDepth() <= this.smpdtl.getSample().getDepth()) continue;
                for (Smpdtl dtl : sample.getAnalyses()) {
                    for (TaxonOcc occ : dtl.getOccur()) {
                        if (occ.getSpecID() != this.fss.getSpecID() || occ.getCaved() == this.jCheckBoxCaved.isSelected()) continue;
                        isDifferent = true;
                        if (dtl.getAnalyID() == this.smpdtl.getAnalyID()) continue;
                        hasMultiSuites = true;
                    }
                }
            }
            if (isDifferent) {
                int opt = JOptionPane.showConfirmDialog(this, "Do you want to set ALL lower occurrences in Cuttings to " + (this.jCheckBoxCaved.isSelected() ? "" : " NOT ") + " caved?\n" + (hasMultiSuites ? "(Warning: this will affect analyses outside the current suite)" : "(Affects current suite only)"), "Caving", 0, 3);
                return opt == 0;
            }
        }
        return false;
    }

    int doCvUpdate() throws SQLException, SBException, FileNotFoundException, IOException {
        if (this.fss == null) {
            return 0;
        }
        if (this.fss.getCaved() != this.jCheckBoxCaved.isSelected()) {
            throw new SBException("Unexpected value of Cv flag in doCvUpdate.");
        }
        int nUpdated = 0;
        for (Sample sample : this.well.getSamples()) {
            if (!sample.getTypeString().equalsIgnoreCase("CU") || sample.getDepth() <= this.smpdtl.getSample().getDepth()) continue;
            for (Smpdtl dtl : sample.getAnalyses()) {
                boolean changed = true;
                block2: while (changed) {
                    changed = false;
                    for (TaxonOcc occ : dtl.getOccur()) {
                        if (occ.getSpecID() != this.fss.getSpecID() || occ.getCaved() == this.jCheckBoxCaved.isSelected()) continue;
                        dtl.updateOcc(this.well.getWellID(), occ, occ.getReworked(), occ.getQuestionable(), occ.getSpecType(), this.jCheckBoxCaved.isSelected(), occ.isMarker(), occ.getCoarse(), occ.getMedium(), occ.getFine(), occ.getSubAbund(), occ.getPreservation(), occ.getColour(), occ.getComment(), occ.getImageSet());
                        ++nUpdated;
                        changed = true;
                        continue block2;
                    }
                }
            }
        }
        return nUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String subj = "";
            if (this.jComboBoxAbundance.getSelectedIndex() > 0) {
                subj = this.abn.getAbr((String)this.jComboBoxAbundance.getSelectedItem());
            }
            int speciesType = this.db.getSpecType((String)this.jComboBoxSpecType.getSelectedItem());
            int coarse = Integer.parseInt("" + this.jSpinnerCoarse.getValue());
            int medium = Integer.parseInt("" + this.jSpinnerMedium.getValue());
            int fine = Integer.parseInt("" + this.jSpinnerFine.getValue());
            String preserv = this.jTextFieldPreservation.getText();
            String colour = this.jTextFieldColour.getText();
            String comment = this.jTextFieldComments.getText();
            if (coarse + medium + fine > 0 && subj.length() > 0 && JOptionPane.showConfirmDialog(this, "You can't mix semi-quantitative and quantitative abundance.\nIgnore semi-quantitative data?", this.getTitle(), 0, 3) != 0) {
                return;
            }
            if (this.fss == null) {
                TaxonOcc.Builder occ = new TaxonOcc.Builder(this.db, this.taxon, this.jRadioButtonReworked.isSelected(), this.jRadioButtonQuestionable.isSelected(), speciesType);
                occ.count(coarse, medium, fine).subjAbund(subj).caved(this.jCheckBoxCaved.isSelected()).marker(this.jCheckBoxMarker.isSelected()).preservation(preserv).colour(colour).comment(comment).imageSet(this.model.set);
                Smpdtl.OccAddDelete edit = this.smpdtl.insertOccurrence(occ, this.well.getWellID());
                this.undoSupport.postEdit((UndoableEdit)edit);
            } else {
                if (!this.checkSituConfChange(speciesType)) {
                    JOptionPane.showMessageDialog(this, "Cannot save - this combination of taxon, situation, confidence and sub-type already exists in the analysis.", this.getTitle(), 2);
                    return;
                }
                boolean rwUpdate = this.checkRwUpdate();
                boolean cvUpdate = this.checkCvUpdate();
                this.smpdtl.updateOcc(this.well.getWellID(), this.fss, this.jRadioButtonReworked.isSelected(), this.jRadioButtonQuestionable.isSelected(), speciesType, this.jCheckBoxCaved.isSelected(), this.jCheckBoxMarker.isSelected(), coarse, medium, fine, subj, preserv, colour, comment, this.model.set);
                if (this.imageSetChanged) {
                    this.fss.setDataChanged();
                    this.fss.notifyObservers((Object)this.model.set);
                    if (this.fss.getImageSet() != null && !this.fss.getTaxon().hasTypeImage() && JOptionPane.showConfirmDialog(this, "There is no type reference image for this taxon.\nUse this image?", this.getTitle(), 0, 3) == 0) {
                        this.db.setTaxonImageSetType(this.taxon, this.fss.getImageSet(), true);
                    }
                }
                if (rwUpdate) {
                    JOptionPane.showMessageDialog(this, "" + this.doRwUpdate() + " higher record(s) updated.", "Reworking", 1);
                }
                if (cvUpdate) {
                    JOptionPane.showMessageDialog(this, "" + this.doCvUpdate() + " lower record(s) updated.", "Caving", 1);
                }
            }
            this.db.commit();
            if (this.fss.getImageSet() != null && (this.fss.getImageSet().getID() > 0 ? 1 : 0) != this.imageSets) {
                this.taxon.getImageSetCount(true);
            }
            if (this.model.set != null) {
                this.model.set.clearImages();
            }
            this.smpdtl.notifyObservers();
            this.setOK();
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
            this.db.doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jCheckBoxPresentOutsideCountActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxPresentOutsideCount.isSelected()) {
            this.jSpinnerCoarse.setValue(new Integer(0));
            this.jSpinnerMedium.setValue(new Integer(0));
            this.jSpinnerFine.setValue(new Integer(0));
            this.jComboBoxAbundance.setSelectedIndex(0);
        }
    }

    private void jButtonEditImageSetActionPerformed(ActionEvent evt) {
        try {
            DialogImageSet dialog = new DialogImageSet(this, true, this.db, new ImageSet(this.db, this.model.set != null ? this.model.set.getID() : 0));
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                if (this.fss != null && !this.imageSetChanged && (this.model.set == null ^ dialog.imageSet == null || this.model.set.getSize() != dialog.imageSet.getSize() || dialog.imagesDeleted)) {
                    this.imageSetChanged = true;
                }
                this.model.set = dialog.imageSet;
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogoccurrence.html");
    }

    private void jButtonEditTaxonActionPerformed(ActionEvent evt) {
        try {
            DialogTaxonReassign dialog = new DialogTaxonReassign(this, true, this.db, this.well, this.taxon);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (this.isOK()) {
                this.taxon = dialog.target;
                this.jTextFieldTaxonName.setText(this.taxon.toString());
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)"Error", (Exception)ex);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCancelActionPerformed(null);
    }
}

