/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.FrameJsbugs;
import model2.Overlay;
import model2.SBdb;
import util.SB;

public class DialogOverlay
extends JDialog {
    SBdb db;
    Overlay overlay = null;
    boolean isOK = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAlphacode;
    private JCheckBox jCheckBoxCatCols;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelCells;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonMax;
    private JRadioButton jRadioButtonShrink;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerColumns;
    private JSpinner jSpinnerRows;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;

    public DialogOverlay(Frame parent, boolean modal, SBdb db, Overlay overlay) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(overlay);
    }

    public DialogOverlay(JDialog parent, boolean modal, SBdb db, Overlay overlay) {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(overlay);
    }

    private void init(Overlay overlay) {
        if (overlay == null) {
            this.setTitle("Overlay : Add");
        } else {
            this.setTitle("Overlay : Edit " + overlay.getName());
            this.jSpinnerRows.setValue(overlay.getRows());
            this.jSpinnerColumns.setValue(overlay.getCols());
            this.jTextFieldName.setText(overlay.getName());
            this.jTextAreaDescription.setText(overlay.getDescrip());
            this.jCheckBoxAlphacode.setSelected(overlay.useCodes());
            this.jRadioButtonMax.setSelected(overlay.getMaximiseText());
            this.jRadioButtonShrink.setSelected(!overlay.getMaximiseText());
            this.jCheckBoxCatCols.setVisible(false);
        }
        this.calculateCells(true);
        this.overlay = overlay;
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void calculateCells(boolean row) {
        int rows = (Integer)this.jSpinnerRows.getValue();
        int columns = (Integer)this.jSpinnerColumns.getValue();
        int cells = rows * columns;
        this.jLabelCells.setText("" + cells);
        if (this.overlay != null && !this.overlay.checkCapacity(rows, columns)) {
            JOptionPane.showMessageDialog(this, "Warning: this overlay requires more " + (row ? "rows" : "columns"), this.getTitle(), 2);
            if (row) {
                this.jSpinnerRows.setValue((Integer)this.jSpinnerRows.getValue() + 1);
            } else {
                this.jSpinnerColumns.setValue((Integer)this.jSpinnerColumns.getValue() + 1);
            }
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinnerRows = new JSpinner();
        this.jSpinnerColumns = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jLabelCells = new JLabel();
        this.jButtonHelp = new JButton();
        this.jRadioButtonMax = new JRadioButton();
        this.jRadioButtonShrink = new JRadioButton();
        this.jCheckBoxAlphacode = new JCheckBox();
        this.jCheckBoxCatCols = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlay.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlay.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Name:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogOverlay.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Description:");
        this.jTextAreaDescription.setColumns(20);
        this.jTextAreaDescription.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaDescription.setRows(5);
        this.jTextAreaDescription.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogOverlay.this.jTextAreaDescriptionKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Overlay size", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel1.setText("Rows:");
        this.jLabel2.setText("Columns:");
        this.jSpinnerRows.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        this.jSpinnerRows.setRequestFocusEnabled(false);
        this.jSpinnerRows.setValue(16);
        this.jSpinnerRows.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogOverlay.this.jSpinnerRowsStateChanged(evt);
            }
        });
        this.jSpinnerColumns.setModel(new SpinnerNumberModel(5, 0, 100, 1));
        this.jSpinnerColumns.setValue(14);
        this.jSpinnerColumns.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogOverlay.this.jSpinnerColumnsStateChanged(evt);
            }
        });
        this.jLabel3.setText("Cells:");
        this.jLabelCells.setText("jLabel8");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerColumns, -1, 65, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSpinnerRows, -1, 65, Short.MAX_VALUE))).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCells).addGap(162, 162, 162)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerRows, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jLabelCells)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerColumns, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlay.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonMax);
        this.jRadioButtonMax.setSelected(true);
        this.jRadioButtonMax.setText("Maximise text size (may truncate)");
        this.buttonGroup1.add(this.jRadioButtonShrink);
        this.jRadioButtonShrink.setText("Shrink to fit");
        this.jCheckBoxAlphacode.setSelected(true);
        this.jCheckBoxAlphacode.setText("Use alphanumeric codes (where available)");
        this.jCheckBoxCatCols.setText("Show category colours");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName, -1, 320, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonMax).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonShrink)).addComponent(this.jScrollPane1, -1, 320, Short.MAX_VALUE).addComponent(this.jCheckBoxAlphacode).addComponent(this.jCheckBoxCatCols))))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldName, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 91, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonMax).addComponent(this.jRadioButtonShrink)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAlphacode).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxCatCols).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name = this.jTextFieldName.getText();
        if (name.length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter an overlay name", this.getTitle(), 2);
            return;
        }
        int nrows = (Integer)this.jSpinnerRows.getValue();
        int ncols = (Integer)this.jSpinnerColumns.getValue();
        if (nrows == 0 || ncols == 0) {
            JOptionPane.showMessageDialog(this, "Must have rows and columns", this.getTitle(), 2);
            return;
        }
        try {
            String descrip = this.jTextAreaDescription.getText();
            if (this.overlay != null) {
                if (!this.overlay.checkCapacity(nrows, ncols)) {
                    JOptionPane.showMessageDialog(this, "You can't make this overlay smaller without clearing some cells", this.getTitle(), 2);
                    return;
                }
                this.overlay.update(name, descrip, nrows, ncols, this.jRadioButtonMax.isSelected(), this.jCheckBoxAlphacode.isSelected());
                this.overlay.notifyObservers();
            } else {
                Overlay temp = this.db.getOverlay(name);
                if (temp != null) {
                    JOptionPane.showMessageDialog(this, "An overlay of that name already exists", this.getTitle(), 2);
                    return;
                }
                this.overlay = new Overlay(this.db, name, descrip, nrows, ncols, this.jRadioButtonMax.isSelected(), this.jCheckBoxAlphacode.isSelected());
                this.db.addOverlay(this.overlay);
            }
            this.db.commit();
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, "Error saving overlay: " + e.getMessage() + "\nSQL: " + SB.sql, this.getTitle(), 0);
            e.printStackTrace();
            this.db.doRollback();
        }
        catch (Exception e) {
            SB.showStackError((String)("Error saving overlay: " + e.getMessage()), (Exception)e);
            e.printStackTrace();
            this.db.doRollback();
        }
    }

    private void jSpinnerRowsStateChanged(ChangeEvent evt) {
        this.calculateCells(true);
    }

    private void jSpinnerColumnsStateChanged(ChangeEvent evt) {
        this.calculateCells(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)25, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextAreaDescriptionKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaDescription, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogoverlay.html");
    }
}

