/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jsbugs.DialogOverlay;
import jsbugs.FrameJsbugs;
import jsbugs.FrameOverlay;
import model2.Overlay;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogOverlays
extends JDialog {
    SBdb db = null;
    Overlay selection = null;
    DefaultListModel model = new DefaultListModel();
    FrameJsbugs frameJsbugs;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonDesign;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JList jListOverlays;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public DialogOverlays(Frame parent, FrameJsbugs f, boolean modal, SBdb db, boolean hasOKCancel) throws SQLException {
        super(parent, modal);
        this.frameJsbugs = f;
        this.db = db;
        this.initComponents();
        this.init(hasOKCancel);
    }

    private void init(boolean hasOKCancel) throws SQLException {
        this.setTitle("Overlays");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        LinkedList overlays = new LinkedList();
        Iterator it = this.db.getOverlays().iterator();
        while (it.hasNext()) {
            overlays.add(it.next());
        }
        Collections.sort(overlays);
        for (Overlay overlay : overlays) {
            this.model.addElement(overlay);
        }
        this.jListOverlays.repaint();
        if (hasOKCancel) {
            this.jButtonCancel.setText("Cancel");
            this.jButtonDesign.setEnabled(false);
        } else {
            this.jButtonOK.setVisible(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListOverlays = new JList();
        this.jButtonCancel = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonAdd = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonDesign = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 400));
        this.jListOverlays.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListOverlays.setModel(this.model);
        this.jListOverlays.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogOverlays.this.jListOverlaysMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListOverlays);
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlays.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlays.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlays.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlays.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDesign.setText("Design...");
        this.jButtonDesign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlays.this.jButtonDesignActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlays.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogOverlays.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 289, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonAdd).add((Component)this.jButtonDelete).add((Component)this.jSeparator1, -2, 50, -2).add((Component)this.jButtonDesign).add((Component)this.jButtonEdit, -1, 77, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonDesign, this.jButtonEdit, this.jButtonOK, this.jSeparator1}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).add(5, 5, 5).add((Component)this.jButtonEdit).addPreferredGap(1).add((Component)this.jButtonDelete).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonDesign).addPreferredGap(0, 175, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (Component)this.jScrollPane1, -1, 391, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.selection = null;
        this.dispose();
    }

    private void jListOverlaysMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.jButtonOK.isVisible()) {
                this.jButtonOKActionPerformed(null);
            } else {
                this.jButtonDesignActionPerformed(null);
            }
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        this.selection = (Overlay)this.jListOverlays.getSelectedValue();
        try {
            this.selection.load();
            DialogOverlay dialog = new DialogOverlay(this, true, this.db, this.selection);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.refreshList();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)("Error loading overlay:" + ex.getMessage()), (Exception)ex);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        this.selection = (Overlay)this.jListOverlays.getSelectedValue();
        if (this.selection.countObservers() > 0) {
            JOptionPane.showMessageDialog(this, "Overlay in use, close before deleting.", this.getTitle(), 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, "Delete overlay '" + this.selection.getName() + "'?", this.getTitle(), 0, 3) == 0) {
            try {
                this.db.deleteOverlay(this.selection);
                this.selection = null;
                this.db.commit();
                this.refreshList();
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        }
    }

    private void jButtonDesignActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        try {
            this.selection = (Overlay)this.jListOverlays.getSelectedValue();
            this.selection.load();
            if (this.frameJsbugs.getFrameOverlay() != null) {
                if (this.frameJsbugs.getFrameOverlay().getOverlay().getOvrID() == this.selection.getOvrID()) {
                    this.frameJsbugs.getFrameOverlay().requestFocus();
                    this.frameJsbugs.getFrameOverlay().setExtendedState(6);
                    this.dispose();
                    return;
                }
                this.frameJsbugs.getFrameOverlay().dispose();
            }
            this.frameJsbugs.setFrameOverlay(new FrameOverlay(this.frameJsbugs.getAltGC(), this.frameJsbugs, this.db, null, null, this.selection, false, this.frameJsbugs.samplesFrame));
            this.frameJsbugs.getFrameOverlay().setExtendedState(6);
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)("Error loading overlay:" + ex.getMessage()), (Exception)ex);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.frameJsbugs.getFrameOverlay() != null) {
            JOptionPane.showMessageDialog(this, "An overlay is curently being displayed.", this.getTitle(), 2);
            return;
        }
        try {
            DialogOverlay dialog = new DialogOverlay(this, true, this.db, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.overlay != null) {
                this.refreshList();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error creating overlay frame: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            return;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jListOverlays.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No overlay selected", this.getTitle(), 1);
            return;
        }
        this.selection = (Overlay)this.jListOverlays.getSelectedValue();
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogoverlays.html");
    }

    private void refreshList() {
        try {
            Iterator it = this.db.getOverlays().iterator();
            this.model.clear();
            while (it.hasNext()) {
                this.model.addElement(it.next());
            }
            this.jListOverlays.repaint();
        }
        catch (Exception e) {
            SB.showStackError((String)e.getMessage(), (Exception)e);
        }
    }
}

