/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.ChartProperties;
import jsbugs.DialogList;
import jsbugs.PanelBiocoms;
import jsbugs.PanelBiocomsProperties;
import jsbugs.SBDialog;
import model2.Biocom;
import model2.Discipline;
import model2.SBdb;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class DialogPanelBiocoms
extends SBDialog {
    private final PanelBiocoms panel;
    private final SBdb db;
    private PanelBiocomsProperties p;
    private ButtonGroup buttonGroupAnalysts;
    private ButtonGroup buttonGroupFont;
    private JButton jButtonAnalysts;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAltColour;
    private JCheckBox jCheckBoxAnalysts;
    private JCheckBox jCheckBoxColours;
    private JCheckBox jCheckBoxDiscA;
    private JCheckBox jCheckBoxDiscM;
    private JCheckBox jCheckBoxDiscN;
    private JCheckBox jCheckBoxDiscP;
    private JCheckBox jCheckBoxSamples;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonAnalyAll;
    private JRadioButton jRadioButtonAnalySelected;
    private JRadioButton jRadioButtonFontPanel;
    private JRadioButton jRadioButtonFontSmall;
    private JRadioButton jRadioButtonFontTiny;
    private JTextField jTextFieldPanelWidth;

    public DialogPanelBiocoms(Frame parent, boolean modal, PanelBiocoms panel, SBdb db) {
        super(parent, modal);
        this.panel = panel;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogPanelBiocoms(Dialog parent, boolean modal, PanelBiocoms panel, SBdb db) {
        super(parent, modal);
        this.panel = panel;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.p = new PanelBiocomsProperties(this.panel.getProperties());
        this.jTextFieldPanelWidth.setText("" + Float.valueOf(this.p.panelWidth).intValue());
        this.jCheckBoxSamples.setSelected(this.p.drawSamples);
        this.jCheckBoxAnalysts.setSelected(this.p.drawAnalyst);
        this.jCheckBoxColours.setSelected(this.p.useAnalystColours);
        this.jCheckBoxAltColour.setSelected(this.p.useAltColour);
        this.jCheckBoxDiscM.setText(Discipline.MICRO.getAbr(true));
        this.jCheckBoxDiscN.setText(Discipline.NANNO.getAbr(true));
        this.jCheckBoxDiscA.setText(Discipline.MACRO.getAbr(true));
        this.jCheckBoxDiscP.setText(Discipline.PALY.getAbr(true));
        this.jCheckBoxDiscA.setSelected(this.p.discs == null || this.p.discs.contains(Discipline.MACRO));
        this.jCheckBoxDiscM.setSelected(this.p.discs == null || this.p.discs.contains(Discipline.MICRO));
        this.jCheckBoxDiscN.setSelected(this.p.discs == null || this.p.discs.contains(Discipline.NANNO));
        this.jCheckBoxDiscP.setSelected(this.p.discs == null || this.p.discs.contains(Discipline.PALY));
        if (this.p.analysts == null) {
            this.jRadioButtonAnalyAll.setSelected(true);
        } else {
            this.jRadioButtonAnalySelected.setSelected(true);
        }
        switch (this.p.fontSize) {
            case PANEL: {
                this.jRadioButtonFontPanel.setSelected(true);
                break;
            }
            case SMALL: {
                this.jRadioButtonFontSmall.setSelected(true);
                break;
            }
            case TINY: {
                this.jRadioButtonFontTiny.setSelected(true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setTitle("Comments Panel Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.buttonGroupAnalysts = new ButtonGroup();
        this.buttonGroupFont = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldPanelWidth = new JTextField();
        this.jCheckBoxSamples = new JCheckBox();
        this.jCheckBoxAnalysts = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jCheckBoxDiscA = new JCheckBox();
        this.jCheckBoxDiscP = new JCheckBox();
        this.jCheckBoxDiscM = new JCheckBox();
        this.jCheckBoxDiscN = new JCheckBox();
        this.jCheckBoxColours = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonAnalyAll = new JRadioButton();
        this.jRadioButtonAnalySelected = new JRadioButton();
        this.jButtonAnalysts = new JButton();
        this.jCheckBoxAltColour = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jRadioButtonFontPanel = new JRadioButton();
        this.jRadioButtonFontSmall = new JRadioButton();
        this.jRadioButtonFontTiny = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelBiocoms.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelBiocoms.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Panel width:");
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelBiocoms.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jCheckBoxSamples.setText("Show samples");
        this.jCheckBoxAnalysts.setText("Show analysts");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Disciplines", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxDiscA.setText("Macro.");
        this.jCheckBoxDiscP.setText("Paly.");
        this.jCheckBoxDiscM.setText("Micro.");
        this.jCheckBoxDiscN.setText("Nanno.");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxDiscM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDiscN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDiscP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDiscA).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxDiscM).addComponent(this.jCheckBoxDiscN).addComponent(this.jCheckBoxDiscP).addComponent(this.jCheckBoxDiscA)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxColours.setText("Use analyst colours");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Analysts", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupAnalysts.add(this.jRadioButtonAnalyAll);
        this.jRadioButtonAnalyAll.setText("All");
        this.buttonGroupAnalysts.add(this.jRadioButtonAnalySelected);
        this.jRadioButtonAnalySelected.setText("Selected:");
        this.jButtonAnalysts.setText("...");
        this.jButtonAnalysts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelBiocoms.this.jButtonAnalystsActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAnalyAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAnalySelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnalysts, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAnalyAll).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAnalySelected).addComponent(this.jButtonAnalysts))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxAltColour.setText("Alternating text colour");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Font size", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupFont.add(this.jRadioButtonFontPanel);
        this.jRadioButtonFontPanel.setText("Panel font");
        this.buttonGroupFont.add(this.jRadioButtonFontSmall);
        this.jRadioButtonFontSmall.setText("Small font");
        this.buttonGroupFont.add(this.jRadioButtonFontTiny);
        this.jRadioButtonFontTiny.setText("Tiny font");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFontPanel).addComponent(this.jRadioButtonFontSmall).addComponent(this.jRadioButtonFontTiny)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jRadioButtonFontPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFontSmall).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFontTiny)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -2, 73, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPanelWidth, -2, 40, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAnalysts).addComponent(this.jCheckBoxSamples).addComponent(this.jCheckBoxColours).addComponent(this.jCheckBoxAltColour))).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPanelWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxSamples).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAnalysts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxColours).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxAltColour))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!(this.jCheckBoxDiscM.isSelected() || this.jCheckBoxDiscA.isSelected() || this.jCheckBoxDiscN.isSelected() || this.jCheckBoxDiscP.isSelected())) {
            JOptionPane.showMessageDialog(this, "Select at least one discipline to display.", this.getTitle(), 2);
            return;
        }
        float width = Float.parseFloat(this.jTextFieldPanelWidth.getText().trim());
        if (width < 40.0f) {
            width = 40.0f;
        }
        this.p.panelWidth = width;
        this.p.drawSamples = this.jCheckBoxSamples.isSelected();
        this.p.drawAnalyst = this.jCheckBoxAnalysts.isSelected();
        this.p.useAnalystColours = this.jCheckBoxColours.isSelected();
        this.p.useAltColour = this.jCheckBoxAltColour.isSelected();
        this.setDiscs();
        this.p.fontSize = this.jRadioButtonFontPanel.isSelected() ? ChartProperties.FontSize.PANEL : (this.jRadioButtonFontTiny.isSelected() ? ChartProperties.FontSize.TINY : ChartProperties.FontSize.SMALL);
        this.p.encode(this.db);
        this.panel.setProperties(this.p);
        this.setOK();
    }

    private void jButtonAnalystsActionPerformed(ActionEvent evt) {
        WellInterp interp = null;
        try {
            interp = this.panel.block.well.getInterp(this.panel.interpID);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error setting interp: ", (Exception)((Object)sbe));
        }
        LinkedList<String> commentAnalysts = new LinkedList<String>();
        this.setDiscs();
        try {
            for (Discipline d : this.p.discs) {
                for (Biocom biocom : interp.getComments(d.getChar())) {
                    String analyst = biocom.getAnalystString();
                    if (commentAnalysts.contains(analyst)) continue;
                    commentAnalysts.add(analyst);
                }
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error getting analysts: ", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error getting analysts: ", (Exception)((Object)sbe));
        }
        DialogList dialog = new DialogList(this, true, "Restrict comment analysts", this.db, commentAnalysts, true, true);
        if (this.p.analysts != null) {
            dialog.setSelectedItems(this.p.analysts);
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selected != null && !dialog.selected.isEmpty()) {
            this.p.analysts = new LinkedList<String>();
            for (Object o : dialog.selected) {
                String analyst = (String)o;
                this.p.analysts.add(analyst);
            }
        }
    }

    private void setDiscs() {
        this.p.discs = new HashSet<Discipline>();
        if (this.jCheckBoxDiscM.isSelected()) {
            this.p.discs.add(Discipline.MICRO);
        }
        if (this.jCheckBoxDiscA.isSelected()) {
            this.p.discs.add(Discipline.MACRO);
        }
        if (this.jCheckBoxDiscN.isSelected()) {
            this.p.discs.add(Discipline.NANNO);
        }
        if (this.jCheckBoxDiscP.isSelected()) {
            this.p.discs.add(Discipline.PALY);
        }
    }
}

