/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import jsbugs.PanelChromalog;
import jsbugs.SBDialog;
import model2.Lastval;
import model2.SBdb;
import util.SB;

public class DialogPanelChromalog
extends SBDialog {
    PanelChromalog panel;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSelectFile;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JTextField jTextFieldFile;
    private JTextField jTextFieldPanelWidth;

    public DialogPanelChromalog(JDialog parent, boolean modal, PanelChromalog panel) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.panel = panel;
        this.init();
    }

    public DialogPanelChromalog(JFrame parent, boolean modal, PanelChromalog panel) {
        super((Frame)parent, modal);
        this.initComponents();
        this.panel = panel;
        this.init();
    }

    private void init() {
        this.setTitle("Chromalog Panel");
        if (this.panel.file != null) {
            this.jTextFieldFile.setText(this.panel.file.getPath());
        }
        this.jTextFieldPanelWidth.setText("" + (int)this.panel.getColumnWidth());
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jTextFieldPanelWidth = new JTextField();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel2.setText("Panel width:");
        this.jTextFieldPanelWidth.setText("40");
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelChromalog.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelChromalog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelChromalog.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelChromalog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Data file:");
        this.jTextFieldFile.setEditable(false);
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelChromalog.this.jButtonSelectFileActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldPanelWidth).addGap(306, 306, 306)).addGroup(layout.createSequentialGroup().addComponent(this.jTextFieldFile, -2, 286, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectFile))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPanelWidth, -2, -1, -2).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFile, -2, -1, -2).addComponent(this.jLabel1)).addComponent(this.jButtonSelectFile)).addGap(26, 26, 26).addComponent(this.jSeparator1, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '-') {
            this.getToolkit().beep();
            evt.consume();
            return;
        }
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String fileName = this.jTextFieldFile.getText();
        if (fileName.isEmpty()) {
            JOptionPane.showMessageDialog(this, "File name blank", this.getTitle(), 2);
            return;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "File does not exist.", this.getTitle(), 2);
            return;
        }
        try {
            this.panel.setFileData(Float.parseFloat(this.jTextFieldPanelWidth.getText()), file);
            this.setOK();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogpanelchromalog.html");
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        try {
            String fileName = Lastval.getString((SBdb)this.panel.db, (String)"CHROMALOG");
            JFileChooser chooser = new JFileChooser(fileName);
            if (chooser.showOpenDialog(this) == 0) {
                fileName = chooser.getSelectedFile().getPath();
                this.jTextFieldFile.setText(fileName);
                Lastval.putString((SBdb)this.panel.db, (String)"CHROMALOG", (String)fileName);
                this.panel.db.commit();
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
    }
}

