/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.PanelCoreImages;
import jsbugs.PanelCoreImagesProperties;
import jsbugs.SBDialog;
import model2.SBdb;
import util.SB;

public class DialogPanelCoreImages
extends SBDialog {
    PanelCoreImagesProperties p;
    PanelCoreImages panel;
    SBdb sbdb;
    private ButtonGroup buttonGroupScale;
    private JButton jButtonCancel;
    private JButton jButtonColour;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxCrop;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFIT_HEIGHT;
    private JRadioButton jRadioButtonFIT_SPACE;
    private JRadioButton jRadioButtonFIT_WIDTH;
    private JSeparator jSeparator1;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldPanelWidth;

    public DialogPanelCoreImages(Frame parent, boolean modal, PanelCoreImages panel, SBdb sbdb) {
        super(parent, modal);
        this.initComponents();
        this.panel = panel;
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        this.p = new PanelCoreImagesProperties(this.panel.getProps());
        this.jTextFieldPanelWidth.setText("" + Float.valueOf(this.p.panelWidth).intValue());
        this.jTextFieldColour.setBackground(this.p.backColour);
        switch (this.p.fit) {
            case 0: {
                this.jRadioButtonFIT_SPACE.setSelected(true);
                break;
            }
            case 1: {
                this.jRadioButtonFIT_WIDTH.setSelected(true);
                break;
            }
            case 2: {
                this.jRadioButtonFIT_HEIGHT.setSelected(true);
            }
        }
        this.enableCrop();
        this.jCheckBoxCrop.setSelected(this.p.crop);
        this.setTitle("Panel Core Images Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void enableCrop() {
        this.jCheckBoxCrop.setEnabled(this.jRadioButtonFIT_WIDTH.isSelected());
    }

    private void initComponents() {
        this.buttonGroupScale = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldPanelWidth = new JTextField();
        this.jPanel1 = new JPanel();
        this.jRadioButtonFIT_SPACE = new JRadioButton();
        this.jRadioButtonFIT_WIDTH = new JRadioButton();
        this.jRadioButtonFIT_HEIGHT = new JRadioButton();
        this.jCheckBoxCrop = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonColour = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Panel width:");
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelCoreImages.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Image Scaling", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupScale.add(this.jRadioButtonFIT_SPACE);
        this.jRadioButtonFIT_SPACE.setText("Fit to interval");
        this.jRadioButtonFIT_SPACE.setToolTipText("No part of image is lost but it may be very small");
        this.jRadioButtonFIT_SPACE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelCoreImages.this.jRadioButtonFIT_SPACEActionPerformed(evt);
            }
        });
        this.buttonGroupScale.add(this.jRadioButtonFIT_WIDTH);
        this.jRadioButtonFIT_WIDTH.setText("Fit width");
        this.jRadioButtonFIT_WIDTH.setToolTipText("Image is width of panel. Extra height is either cropped or overplotted.");
        this.jRadioButtonFIT_WIDTH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelCoreImages.this.jRadioButtonFIT_WIDTHActionPerformed(evt);
            }
        });
        this.buttonGroupScale.add(this.jRadioButtonFIT_HEIGHT);
        this.jRadioButtonFIT_HEIGHT.setText("Fit height");
        this.jRadioButtonFIT_HEIGHT.setToolTipText("Image is the height of the interval. Extra width (outside panel) is always cropped off.");
        this.jRadioButtonFIT_HEIGHT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelCoreImages.this.jRadioButtonFIT_HEIGHTActionPerformed(evt);
            }
        });
        this.jCheckBoxCrop.setText("Crop extra height");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFIT_SPACE).addComponent(this.jRadioButtonFIT_WIDTH).addComponent(this.jRadioButtonFIT_HEIGHT))).addGroup(jPanel1Layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jCheckBoxCrop))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonFIT_SPACE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFIT_HEIGHT).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFIT_WIDTH).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxCrop).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setText("Background colour:");
        this.jTextFieldColour.setEditable(false);
        this.jButtonColour.setText("...");
        this.jButtonColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelCoreImages.this.jButtonColourActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelCoreImages.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelCoreImages.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPanelWidth, -2, 40, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldColour, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonColour, -2, 30, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSeparator1)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPanelWidth, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldColour, -2, -1, -2).addComponent(this.jButtonColour)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jRadioButtonFIT_WIDTHActionPerformed(ActionEvent evt) {
        this.enableCrop();
    }

    private void jRadioButtonFIT_HEIGHTActionPerformed(ActionEvent evt) {
        this.enableCrop();
    }

    private void jRadioButtonFIT_SPACEActionPerformed(ActionEvent evt) {
        this.enableCrop();
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color colour = this.p.backColour;
        if ((colour = JColorChooser.showDialog(this, "Select Background Colour", colour)) != null) {
            this.jTextFieldColour.setBackground(colour);
            this.p.backColour = colour;
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonFIT_HEIGHT.isSelected()) {
            this.p.fit = 2;
        } else if (this.jRadioButtonFIT_SPACE.isSelected()) {
            this.p.fit = 0;
        } else if (this.jRadioButtonFIT_WIDTH.isSelected()) {
            this.p.fit = 1;
        }
        this.p.crop = this.jCheckBoxCrop.isSelected();
        float width = Float.parseFloat(this.jTextFieldPanelWidth.getText().trim());
        if (width < 25.0f) {
            width = 25.0f;
        }
        this.p.panelWidth = width;
        this.p.encode(this.sbdb);
        this.panel.setProperties(this.p);
        this.setOK();
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }
}

