/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogList;
import jsbugs.DialogPanelTaxonBase;
import jsbugs.DialogPanelTaxonGroup;
import jsbugs.FrameJsbugs;
import jsbugs.PanelDendrogram;
import jsbugs.PanelDendrogramProperties;
import jsbugs.PanelTaxonBase;
import jsbugs.PanelTaxonGroup;
import model2.SBdb;
import util.SB;

public class DialogPanelDendrogram
extends DialogPanelTaxonBase {
    private PanelDendrogramProperties prop;
    private final PanelDendrogram panel;
    private final PanelTaxonGroup panelGroup;
    private ButtonGroup buttonGroupDataFilter;
    private ButtonGroup buttonGroupEdit;
    private JButton jButtonCancel;
    private JButton jButtonFilterCat;
    private JButton jButtonFilterGroup;
    private JButton jButtonFilterSet;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonOuterPanel;
    private JButton jButtonSubTypes;
    private JCheckBox jCheckBoxIncludeCv;
    private JCheckBox jCheckBoxIncludeQ;
    private JCheckBox jCheckBoxIncludeRw;
    private JCheckBox jCheckBoxIncludeSubCats;
    private JCheckBox jCheckBoxIncludeUnqualified;
    private JCheckBox jCheckBoxShading;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabelOuterPanel;
    private JLabel jLabelScope;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelDataQualifiers;
    private JPanel jPanelDataSubTypes;
    private JRadioButton jRadioButtonEditInner;
    private JRadioButton jRadioButtonEditOuter;
    private JRadioButton jRadioButtonFilterAll;
    private JRadioButton jRadioButtonFilterCategory;
    private JRadioButton jRadioButtonFilterGroup;
    private JRadioButton jRadioButtonFilterSet;
    private JRadioButton jRadioButtonSubTypesAll;
    private JRadioButton jRadioButtonSubTypesRestricted;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSlider jSliderShadingCutoff;
    private JTextField jTextFieldFilterCat;
    private JTextField jTextFieldFilterGroup;
    private JTextField jTextFieldFilterSet;
    private JTextField jTextFieldPanelWidth;

    public DialogPanelDendrogram(Dialog parent, boolean modal, SBdb sbdb, PanelTaxonGroup panelGroup, PanelDendrogram panel) {
        super(parent, modal, sbdb, (PanelTaxonBase)panel);
        this.panel = panel;
        this.panelGroup = panelGroup;
        this.initComponents();
        this.init();
    }

    public DialogPanelDendrogram(Frame parent, boolean modal, SBdb sbdb, PanelTaxonGroup panelGroup, PanelDendrogram panel) {
        super(parent, modal, sbdb, (PanelTaxonBase)panel);
        this.panel = panel;
        this.panelGroup = panelGroup;
        this.initComponents();
        this.init();
    }

    private void init() {
        super.init(this.panel);
        this.prop = new PanelDendrogramProperties(this.panel.getProperties());
        this.setTitle("Custering Panel Properties : " + this.panelGroup.getDiscID().getNoun());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jLabelOuterPanel.setText(this.panelGroup.getSubCaption(false, true));
        if (this.panelGroup.size() > 1) {
            if (this.panel.getProperties() == this.panelGroup.defaultProperties) {
                this.jRadioButtonEditOuter.setSelected(true);
            } else {
                this.jRadioButtonEditInner.setSelected(true);
                this.jRadioButtonEditOuter.setText("Reset to outer");
            }
        } else {
            this.jLabelScope.setVisible(false);
            this.jRadioButtonEditInner.setVisible(false);
            this.jRadioButtonEditOuter.setVisible(false);
        }
        this.setFilterAllLabel();
        if (this.buttonGroupDataFilter.getSelection() == null) {
            this.jRadioButtonFilterAll.setSelected(true);
        }
        this.jCheckBoxIncludeSubCats.setSelected(this.panel.getIncludeSubCats());
        this.setFilterFields();
        this.jCheckBoxIncludeUnqualified.setSelected(this.prop.includeUnqualified);
        this.jCheckBoxIncludeRw.setSelected(this.prop.includeRw);
        this.jCheckBoxIncludeCv.setSelected(this.prop.includeCv);
        this.jCheckBoxIncludeQ.setSelected(this.prop.includeQ);
        this.jRadioButtonSubTypesRestricted.setSelected(this.prop.subTypes != null);
        this.jTextFieldPanelWidth.setText("" + Float.valueOf(this.prop.panelWidth).intValue());
        this.jCheckBoxShading.setSelected(this.prop.drawShading);
        this.jSliderShadingCutoff.setValue((int)(this.prop.shadingCutoff * 100.0f));
        this.enableShading();
    }

    private void initComponents() {
        this.buttonGroupDataFilter = new ButtonGroup();
        this.buttonGroupEdit = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldPanelWidth = new JTextField();
        this.jCheckBoxShading = new JCheckBox();
        this.jSliderShadingCutoff = new JSlider();
        this.jPanelDataQualifiers = new JPanel();
        this.jCheckBoxIncludeCv = new JCheckBox();
        this.jCheckBoxIncludeQ = new JCheckBox();
        this.jCheckBoxIncludeRw = new JCheckBox();
        this.jCheckBoxIncludeUnqualified = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanelDataSubTypes = new JPanel();
        this.jRadioButtonSubTypesAll = new JRadioButton();
        this.jRadioButtonSubTypesRestricted = new JRadioButton();
        this.jButtonSubTypes = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jRadioButtonEditInner = new JRadioButton();
        this.jRadioButtonEditOuter = new JRadioButton();
        this.jLabelScope = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabelOuterPanel = new JLabel();
        this.jButtonOuterPanel = new JButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonFilterAll = new JRadioButton();
        this.jRadioButtonFilterSet = new JRadioButton();
        this.jTextFieldFilterSet = new JTextField();
        this.jButtonFilterSet = new JButton();
        this.jTextFieldFilterGroup = new JTextField();
        this.jButtonFilterGroup = new JButton();
        this.jRadioButtonFilterGroup = new JRadioButton();
        this.jRadioButtonFilterCategory = new JRadioButton();
        this.jTextFieldFilterCat = new JTextField();
        this.jCheckBoxIncludeSubCats = new JCheckBox();
        this.jButtonFilterCat = new JButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Panel width:");
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelDendrogram.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jCheckBoxShading.setText("Shading");
        this.jCheckBoxShading.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jCheckBoxShadingActionPerformed(evt);
            }
        });
        this.jPanelDataQualifiers.setBorder(BorderFactory.createTitledBorder(null, "Qualified occurrences", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxIncludeCv.setText("Caved");
        this.jCheckBoxIncludeCv.setToolTipText("Include caved occurrences");
        this.jCheckBoxIncludeQ.setText("Questionable");
        this.jCheckBoxIncludeQ.setToolTipText("Include questionable occurrences");
        this.jCheckBoxIncludeRw.setText("Reworked");
        this.jCheckBoxIncludeRw.setToolTipText("Include reworked occurrences");
        this.jCheckBoxIncludeUnqualified.setText("Unqualified");
        this.jCheckBoxIncludeUnqualified.setToolTipText("Exclude all occurrences which do not have any of the qualifiers checked above");
        GroupLayout jPanelDataQualifiersLayout = new GroupLayout(this.jPanelDataQualifiers);
        this.jPanelDataQualifiers.setLayout(jPanelDataQualifiersLayout);
        jPanelDataQualifiersLayout.setHorizontalGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataQualifiersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanelDataQualifiersLayout.createSequentialGroup().addGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxIncludeCv).addComponent(this.jCheckBoxIncludeRw).addComponent(this.jCheckBoxIncludeQ).addComponent(this.jCheckBoxIncludeUnqualified)).addGap(0, 34, Short.MAX_VALUE))).addContainerGap()));
        jPanelDataQualifiersLayout.setVerticalGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataQualifiersLayout.createSequentialGroup().addComponent(this.jCheckBoxIncludeRw).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeCv).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeQ).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeUnqualified).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelDataSubTypes.setBorder(BorderFactory.createTitledBorder(null, "Sub-types", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jRadioButtonSubTypesAll.setSelected(true);
        this.jRadioButtonSubTypesAll.setText("All");
        this.jRadioButtonSubTypesRestricted.setText("Restrict to..");
        this.jButtonSubTypes.setText("...");
        this.jButtonSubTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jButtonSubTypesActionPerformed(evt);
            }
        });
        GroupLayout jPanelDataSubTypesLayout = new GroupLayout(this.jPanelDataSubTypes);
        this.jPanelDataSubTypes.setLayout(jPanelDataSubTypesLayout);
        jPanelDataSubTypesLayout.setHorizontalGroup(jPanelDataSubTypesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSubTypesLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSubTypesAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSubTypesRestricted).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSubTypes, -2, 30, -2).addContainerGap(16, Short.MAX_VALUE)));
        jPanelDataSubTypesLayout.setVerticalGroup(jPanelDataSubTypesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSubTypesLayout.createSequentialGroup().addGroup(jPanelDataSubTypesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonSubTypesAll).addComponent(this.jRadioButtonSubTypesRestricted).addComponent(this.jButtonSubTypes)).addGap(0, 0, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jButtonOKActionPerformed(evt);
            }
        });
        this.buttonGroupEdit.add(this.jRadioButtonEditInner);
        this.jRadioButtonEditInner.setText("Inner");
        this.buttonGroupEdit.add(this.jRadioButtonEditOuter);
        this.jRadioButtonEditOuter.setText("Outer");
        this.jLabelScope.setText("Scope:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Outer panel", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabelOuterPanel.setFont(new Font("Tahoma", 1, 11));
        this.jLabelOuterPanel.setText("jLabel16");
        this.jButtonOuterPanel.setText("...");
        this.jButtonOuterPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jButtonOuterPanelActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelOuterPanel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOuterPanel, -2, 30, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelOuterPanel).addComponent(this.jButtonOuterPanel)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Restrict inner panel data to", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterAll);
        this.jRadioButtonFilterAll.setText("All <discipline>");
        this.jRadioButtonFilterAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jRadioButtonFilterAllActionPerformed(evt);
            }
        });
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterSet);
        this.jRadioButtonFilterSet.setText("Group set:");
        this.jRadioButtonFilterSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jRadioButtonFilterSetActionPerformed(evt);
            }
        });
        this.jTextFieldFilterSet.setEditable(false);
        this.jTextFieldFilterSet.setBackground(new Color(255, 255, 204));
        this.jButtonFilterSet.setText("...");
        this.jButtonFilterSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jButtonFilterSetActionPerformed(evt);
            }
        });
        this.jTextFieldFilterGroup.setEditable(false);
        this.jTextFieldFilterGroup.setBackground(new Color(255, 255, 204));
        this.jButtonFilterGroup.setText("...");
        this.jButtonFilterGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jButtonFilterGroupActionPerformed(evt);
            }
        });
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterGroup);
        this.jRadioButtonFilterGroup.setText("Group:");
        this.jRadioButtonFilterGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jRadioButtonFilterGroupActionPerformed(evt);
            }
        });
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterCategory);
        this.jRadioButtonFilterCategory.setText("Category:");
        this.jRadioButtonFilterCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jRadioButtonFilterCategoryActionPerformed(evt);
            }
        });
        this.jTextFieldFilterCat.setEditable(false);
        this.jTextFieldFilterCat.setBackground(new Color(255, 255, 204));
        this.jCheckBoxIncludeSubCats.setText("Include sub-categories");
        this.jButtonFilterCat.setText("...");
        this.jButtonFilterCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelDendrogram.this.jButtonFilterCatActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonFilterCategory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilterCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterCat, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeSubCats)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonFilterAll).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonFilterGroup).addGap(18, 18, 18).addComponent(this.jTextFieldFilterGroup, -2, 209, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonFilterSet, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldFilterSet, -2, 207, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFilterSet, -2, 35, -2).addComponent(this.jButtonFilterGroup, -2, 35, -2)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonFilterAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonFilterSet).addComponent(this.jTextFieldFilterSet, -2, -1, -2).addComponent(this.jButtonFilterSet)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFilterGroup, -2, -1, -2).addComponent(this.jButtonFilterGroup).addComponent(this.jRadioButtonFilterGroup)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxIncludeSubCats).addComponent(this.jButtonFilterCat)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonFilterCategory).addComponent(this.jTextFieldFilterCat, -2, -1, -2)))));
        this.jLabel3.setText("cutoff:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelScope).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonEditInner).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonEditOuter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPanelWidth, -2, 40, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanelDataQualifiers, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelDataSubTypes, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxShading).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderShadingCutoff, -1, -1, Short.MAX_VALUE))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDataQualifiers, -2, -1, -2).addComponent(this.jPanelDataSubTypes, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPanelWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxShading).addComponent(this.jLabel3)).addComponent(this.jSliderShadingCutoff, -2, -1, -2)).addGap(28, 28, 28).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK).addComponent(this.jRadioButtonEditOuter).addComponent(this.jRadioButtonEditInner).addComponent(this.jLabelScope)).addGap(16, 16, 16)));
        this.pack();
    }

    private void jButtonSubTypesActionPerformed(ActionEvent evt) {
        try {
            LinkedList<String> specTypes = new LinkedList<String>();
            Iterator it = this.sbdb.getSpecTypeIterator();
            while (it.hasNext()) {
                specTypes.add((String)it.next());
            }
            DialogList dialog = new DialogList(this, true, "Select Sub-Types", this.sbdb, specTypes, true, true);
            dialog.setLocationRelativeTo(this);
            if (this.prop.subTypes != null) {
                LinkedList<String> selected = new LinkedList<String>();
                Iterator i$ = this.prop.subTypes.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    selected.add(this.sbdb.getSpecType(i));
                }
                dialog.setSelectedItems(selected);
            }
            dialog.setVisible(true);
            if (dialog.selected != null && !dialog.selected.isEmpty()) {
                if (this.prop.subTypes == null) {
                    this.prop.subTypes = new LinkedList();
                }
                this.prop.subTypes.clear();
                for (Object o : dialog.selected) {
                    this.prop.subTypes.add(this.sbdb.getSpecType((String)o));
                }
            }
            this.jRadioButtonSubTypesRestricted.setSelected(this.prop.subTypes != null && !this.prop.subTypes.isEmpty());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jRadioButtonFilterAllActionPerformed(ActionEvent evt) {
        this.setFilterFields();
    }

    private void jRadioButtonFilterSetActionPerformed(ActionEvent evt) {
        if (this.filter_set == null) {
            this.selectFilterSet();
        }
        this.setFilterFields();
    }

    private void jRadioButtonFilterGroupActionPerformed(ActionEvent evt) {
        if (this.filter_group == null) {
            this.selectFilterGroup();
        }
        this.setFilterFields();
    }

    private void jButtonFilterSetActionPerformed(ActionEvent evt) {
        this.selectFilterSet();
        this.setFilterFields();
    }

    private void jButtonFilterGroupActionPerformed(ActionEvent evt) {
        this.selectFilterGroup();
        this.setFilterFields();
    }

    private void jRadioButtonFilterCategoryActionPerformed(ActionEvent evt) {
        if (this.filter_cat == null) {
            this.selectFilterCat();
        }
        this.setFilterFields();
    }

    private void jButtonFilterCatActionPerformed(ActionEvent evt) {
        this.selectFilterCat();
        this.setFilterFields();
    }

    private void jButtonOuterPanelActionPerformed(ActionEvent evt) {
        DialogPanelTaxonGroup dialog = new DialogPanelTaxonGroup((Dialog)this, true, this.panelGroup);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.jLabelOuterPanel.setText(this.panelGroup.getSubCaption(false, true));
            this.setFilterAllLabel();
        }
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jCheckBoxShadingActionPerformed(ActionEvent evt) {
        this.enableShading();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float panelWidth;
        if (this.buttonGroupEdit.getSelection() == this.jRadioButtonEditOuter.getModel() && this.panel.getProperties() != this.panelGroup.defaultProperties) {
            int opt = JOptionPane.showConfirmDialog(this, "Discard changes and revert to default outer panel properties?", this.getTitle(), 0);
            if (opt != 0) {
                return;
            }
            this.panel.setProperties(this.panelGroup.defaultProperties);
            this.setOK();
            return;
        }
        if (this.jRadioButtonFilterCategory.isSelected() && this.filter_cat == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter category", this.getTitle(), 2);
            return;
        }
        if (this.jRadioButtonFilterGroup.isSelected() && this.filter_group == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter group", this.getTitle(), 2);
            return;
        }
        if (this.jRadioButtonFilterSet.isSelected() && this.filter_set == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter group set", this.getTitle(), 2);
            return;
        }
        boolean dataChange = false;
        if (this.panel.getFilterSet() != null && this.filter_set != this.panel.getFilterSet()) {
            this.panel.getFilterSet().deleteObserver((Observer)this.panel);
        }
        if (this.panel.setFilterSet(this.jRadioButtonFilterSet.isSelected() ? this.filter_set : null)) {
            dataChange = true;
        }
        if (this.panel.getFilterSet() != null) {
            this.filter_set.addObserver((Observer)this.panel);
        }
        if (this.panel.getFilterGroup() != null && this.filter_group != this.panel.getFilterGroup()) {
            this.panel.getFilterGroup().deleteObserver((Observer)this.panel);
        }
        if (this.panel.setFilterGroup(this.jRadioButtonFilterGroup.isSelected() ? this.filter_group : null)) {
            dataChange = true;
        }
        if (this.panel.getFilterGroup() != null) {
            this.filter_group.addObserver((Observer)this.panel);
        }
        if (this.panel.setFilterCat(this.jRadioButtonFilterCategory.isSelected() ? this.filter_cat : null, this.jCheckBoxIncludeSubCats.isSelected())) {
            dataChange = true;
        }
        this.prop.includeRw = this.jCheckBoxIncludeRw.isSelected();
        this.prop.includeCv = this.jCheckBoxIncludeCv.isSelected();
        this.prop.includeQ = this.jCheckBoxIncludeQ.isSelected();
        this.prop.includeUnqualified = this.jCheckBoxIncludeUnqualified.isSelected();
        if (this.jRadioButtonSubTypesAll.isSelected()) {
            this.prop.subTypes = null;
        }
        if ((panelWidth = Float.parseFloat(this.jTextFieldPanelWidth.getText())) < 20.0f) {
            panelWidth = 20.0f;
        }
        this.prop.panelWidth = panelWidth;
        this.prop.drawShading = this.jCheckBoxShading.isSelected();
        this.prop.shadingCutoff = (float)this.jSliderShadingCutoff.getValue() / 100.0f;
        if (!this.prop.equals(this.panel.getProperties())) {
            if (this.buttonGroupEdit.getSelection() == null) {
                this.panelGroup.setDefaultProperties(this.prop);
            } else if (this.buttonGroupEdit.getSelection() == this.jRadioButtonEditOuter.getModel()) {
                if (this.panel.getProperties() != this.panelGroup.defaultProperties) {
                    this.panel.setProperties(this.panelGroup.defaultProperties);
                } else {
                    this.panelGroup.setDefaultProperties(this.prop);
                }
            } else if (this.buttonGroupEdit.getSelection() == this.jRadioButtonEditInner.getModel()) {
                this.panel.setProperties(this.prop);
            } else assert (false);
            this.setOK();
        } else if (dataChange) {
            System.out.println("Changes to panel data only");
            this.setOK();
        } else {
            System.out.println("No changes to Properties object");
            this.dispose();
        }
    }

    private void enableShading() {
        this.jSliderShadingCutoff.setEnabled(this.jCheckBoxShading.isSelected());
    }

    private void setFilterAllLabel() {
        this.jRadioButtonFilterAll.setText(this.panelGroup.getSubCaption(false, true));
    }

    @Override
    JRadioButton getFilterCatButton() {
        return this.jRadioButtonFilterCategory;
    }

    @Override
    JRadioButton getFilterSetButton() {
        return this.jRadioButtonFilterSet;
    }

    @Override
    JRadioButton getFilterGroupButton() {
        return this.jRadioButtonFilterGroup;
    }

    @Override
    JTextField getFilterCatField() {
        return this.jTextFieldFilterCat;
    }

    @Override
    JTextField getFilterSetField() {
        return this.jTextFieldFilterSet;
    }

    @Override
    JTextField getFilterGroupField() {
        return this.jTextFieldFilterGroup;
    }

    @Override
    JCheckBox getSubCatBox() {
        return this.jCheckBoxIncludeSubCats;
    }
}

