/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.PanelEnv;
import jsbugs.PanelEnvProperties;
import jsbugs.SBDialog;
import jsbugs.WellBlock;
import model2.AnalystHeader;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogPanelEnv
extends SBDialog {
    private final PanelEnv panel;
    private final SBdb db;
    private final WellBlock block;
    private final PanelEnvProperties p;
    private static final String NO_RESTRICT_STRG = "<not restricted>";
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonColour;
    private JButton jButtonOK;
    private JButton jButtonRestrictAnalyses;
    private JCheckBox jCheckBoxPlotAnalyses;
    private JCheckBox jCheckBoxPlotIntervals;
    private JCheckBox jCheckBoxPlotUsed;
    private JLabel jLabel1;
    private JLabel jLabelColour;
    private JLabel jLabelLineWidth;
    private JLabel jLabelRestrict;
    private JPanel jPanel1;
    private JSpinner jSpinnerLineWidth;
    private JTextField jTextFieldColWidth;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldRestrict;

    public DialogPanelEnv(Frame parent, boolean modal, PanelEnv panel, SBdb db, WellBlock block) {
        super(parent, modal);
        this.panel = panel;
        this.p = new PanelEnvProperties(panel.getProperties());
        this.db = db;
        this.block = block;
        this.initComponents();
        this.init();
    }

    public DialogPanelEnv(Dialog parent, boolean modal, PanelEnv panel, SBdb db, WellBlock block) {
        super(parent, modal);
        this.panel = panel;
        this.p = new PanelEnvProperties(panel.getProperties());
        this.db = db;
        this.block = block;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Environments Panel Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jCheckBoxPlotIntervals.setSelected(this.p.drawIntervals);
        this.jCheckBoxPlotUsed.setSelected(!this.p.drawAllClasses);
        this.jTextFieldColWidth.setText("" + Float.valueOf(this.p.columnWidth).intValue());
        this.jCheckBoxPlotAnalyses.setSelected(this.p.drawAnalyses);
        this.jCheckBoxPlotAnalysesActionPerformed(null);
        this.jTextFieldColour.setBackground(this.p.analyColour);
        this.jSpinnerLineWidth.setValue(Float.valueOf(this.p.analyWidth));
        this.setRestrictStrg();
    }

    private void setRestrictStrg() {
        if (this.p.suites == null) {
            this.jTextFieldRestrict.setText(NO_RESTRICT_STRG);
        } else {
            this.jTextFieldRestrict.setText(this.p.suites.size() + (this.p.suites.size() == 1 ? " suite " : " suites ") + "selected");
        }
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldColWidth = new JTextField();
        this.jCheckBoxPlotUsed = new JCheckBox();
        this.jCheckBoxPlotIntervals = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabelRestrict = new JLabel();
        this.jCheckBoxPlotAnalyses = new JCheckBox();
        this.jLabelLineWidth = new JLabel();
        this.jTextFieldRestrict = new JTextField();
        this.jButtonRestrictAnalyses = new JButton();
        this.jSpinnerLineWidth = new JSpinner();
        this.jLabelColour = new JLabel();
        this.jButtonColour = new JButton();
        this.jTextFieldColour = new JTextField();
        this.jButtonClear = new JButton();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEnv.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEnv.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Environment column width:");
        this.jTextFieldColWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelEnv.this.jTextFieldColWidthKeyTyped(evt);
            }
        });
        this.jCheckBoxPlotUsed.setText("Plot only columns used in intervals");
        this.jCheckBoxPlotIntervals.setText("Plot intervals");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Analyses", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabelRestrict.setText("Restrict to:");
        this.jCheckBoxPlotAnalyses.setText("Plot analyses");
        this.jCheckBoxPlotAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEnv.this.jCheckBoxPlotAnalysesActionPerformed(evt);
            }
        });
        this.jLabelLineWidth.setText("Line width:");
        this.jTextFieldRestrict.setBackground(new Color(240, 240, 240));
        this.jTextFieldRestrict.setText(NO_RESTRICT_STRG);
        this.jButtonRestrictAnalyses.setText("...");
        this.jButtonRestrictAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEnv.this.jButtonRestrictAnalysesActionPerformed(evt);
            }
        });
        this.jSpinnerLineWidth.setModel(new SpinnerNumberModel(Float.valueOf(3.0f), Float.valueOf(0.5f), Float.valueOf(5.0f), Float.valueOf(0.5f)));
        this.jLabelColour.setText("Colour:");
        this.jButtonColour.setText("...");
        this.jButtonColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEnv.this.jButtonColourActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear");
        this.jButtonClear.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEnv.this.jButtonClearActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxPlotAnalyses).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabelLineWidth).add((Component)this.jLabelRestrict)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jSpinnerLineWidth, -2, 54, -2).add(18, 18, 18).add((Component)this.jLabelColour).addPreferredGap(0).add((Component)this.jTextFieldColour, -2, 41, -2)).add((Component)this.jTextFieldRestrict, -2, 152, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1, false).add((Component)this.jButtonRestrictAnalyses, 0, 0, Short.MAX_VALUE).add((Component)this.jButtonColour, -2, 31, Short.MAX_VALUE)).add(6, 6, 6).add((Component)this.jButtonClear))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jCheckBoxPlotAnalyses).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelLineWidth).add((Component)this.jSpinnerLineWidth, -2, -1, -2).add((Component)this.jLabelColour).add((Component)this.jButtonColour).add((Component)this.jTextFieldColour, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabelRestrict).add((Component)this.jTextFieldRestrict, -2, -1, -2).add((Component)this.jButtonRestrictAnalyses).add((Component)this.jButtonClear)).addContainerGap(15, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jCheckBoxPlotIntervals).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldColWidth, -2, 42, -2)).add((Component)this.jCheckBoxPlotUsed).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jPanel1, -2, -1, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldColWidth, -2, -1, -2)).add(18, 18, 18).add((Component)this.jCheckBoxPlotUsed).addPreferredGap(0).add((Component)this.jCheckBoxPlotIntervals).add(18, 18, 18).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jTextFieldColWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldColWidth, (int)2, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float columnWidth = Float.parseFloat(this.jTextFieldColWidth.getText());
        if (columnWidth < 3.0f) {
            columnWidth = 3.0f;
        }
        this.p.columnWidth = columnWidth;
        this.p.analyWidth = ((Float)this.jSpinnerLineWidth.getModel().getValue()).floatValue();
        this.p.drawIntervals = this.jCheckBoxPlotIntervals.isSelected();
        this.p.drawAllClasses = !this.jCheckBoxPlotUsed.isSelected();
        this.p.drawAnalyses = this.jCheckBoxPlotAnalyses.isSelected();
        this.panel.setProperties(this.p);
        this.p.encodeProperties(this.db);
        this.setOK();
    }

    private void jCheckBoxPlotAnalysesActionPerformed(ActionEvent evt) {
        boolean selected = this.jCheckBoxPlotAnalyses.isSelected();
        this.jLabelLineWidth.setEnabled(selected);
        this.jSpinnerLineWidth.setEnabled(selected);
        this.jLabelRestrict.setEnabled(selected);
        this.jTextFieldRestrict.setEnabled(selected);
        this.jButtonRestrictAnalyses.setEnabled(selected);
        this.jTextFieldColour.setEnabled(selected);
        this.jLabelColour.setEnabled(selected);
        this.jButtonColour.setEnabled(selected);
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color colour = this.jTextFieldColour.getBackground();
        if ((colour = JColorChooser.showDialog(this, "Analysis colour", colour)) != null) {
            this.jTextFieldColour.setBackground(colour);
            this.p.analyColour = colour;
        }
    }

    private void jButtonRestrictAnalysesActionPerformed(ActionEvent evt) {
        try {
            DialogList dialog = new DialogList(this, true, "Select Analyses", this.db, this.block.well.getAnalystHeaders(), true, true);
            dialog.setLocationRelativeTo(this);
            if (this.p.suites != null) {
                dialog.setSelectedItems(this.p.suites);
            }
            dialog.setVisible(true);
            if (dialog.selected != null && !dialog.selected.isEmpty()) {
                if (this.p.suites == null) {
                    this.p.suites = new LinkedList<AnalystHeader>();
                }
                this.p.suites.clear();
                for (Object o : dialog.selected) {
                    this.p.suites.add((AnalystHeader)o);
                }
            }
            this.setRestrictStrg();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.p.suites = null;
        this.setRestrictStrg();
    }
}

