/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogSelectProject;
import jsbugs.DialogSelectVersion;
import jsbugs.DialogSelectWell;
import jsbugs.FrameJsbugs;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelEvents;
import jsbugs.PanelEventsBase;
import jsbugs.PanelEventsProperties;
import jsbugs.SBDialog;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SBException;

public class DialogPanelEvents
extends SBDialog {
    PanelEventsBase panel;
    PanelEventsProperties prop;
    SBdb sbdb;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroupColumns;
    private JButton jButtonA;
    private JButton jButtonCancel;
    private JButton jButtonM;
    private JButton jButtonN;
    private JButton jButtonNone;
    private JButton jButtonOK;
    private JButton jButtonP;
    private JButton jButtonSelectInterp;
    private JButton jButtonSelectProject;
    private JButton jButtonSelectWell;
    private JCheckBox jCheckBoxA;
    private JCheckBox jCheckBoxColours;
    private JCheckBox jCheckBoxDepths;
    private JCheckBox jCheckBoxFilter;
    private JCheckBox jCheckBoxM;
    private JCheckBox jCheckBoxN;
    private JCheckBox jCheckBoxNone;
    private JCheckBox jCheckBoxP;
    private JCheckBox jCheckBoxType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelFilter;
    private JRadioButton jRadioButtonFilterProject;
    private JRadioButton jRadioButtonFilterWell;
    private JRadioButton jRadioButtonMultiColumn;
    private JRadioButton jRadioButtonSingleColumn;
    private JTextField jTextFieldA;
    private JTextField jTextFieldInterp;
    private JTextField jTextFieldM;
    private JTextField jTextFieldN;
    private JTextField jTextFieldNone;
    private JTextField jTextFieldP;
    private JTextField jTextFieldPanelWidth;
    private JTextField jTextFieldProject;
    private JTextField jTextFieldWell;

    public DialogPanelEvents(Frame parent, boolean modal, PanelEventsBase panel, SBdb sbdb) {
        super(parent, modal);
        this.initComponents();
        this.panel = panel;
        this.sbdb = sbdb;
        this.init();
    }

    public DialogPanelEvents(Dialog parent, boolean modal, PanelEventsBase panel, SBdb sbdb) {
        super(parent, modal);
        this.initComponents();
        this.panel = panel;
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        this.prop = new PanelEventsProperties(this.panel.getProperties());
        if (this.panel instanceof PanelCompositeStandard) {
            this.setTitle("Composite Standard Panel Properties");
            this.jCheckBoxDepths.setText("Show ages");
            this.jRadioButtonMultiColumn.setText("Plot LAD on left and FAD on right");
            if (this.prop.filterInterp != null) {
                this.jCheckBoxFilter.setSelected(true);
            }
            this.setFilterFields();
        } else {
            this.setTitle("Events Panel Properties");
            this.jPanelFilter.setVisible(false);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldPanelWidth.setText("" + Float.valueOf(this.prop.panelWidth).intValue());
        if (this.prop.singleColumn) {
            this.jRadioButtonSingleColumn.setSelected(true);
        } else {
            this.jRadioButtonMultiColumn.setSelected(true);
        }
        this.jCheckBoxDepths.setSelected(this.prop.showDepths);
        this.jCheckBoxType.setSelected(this.prop.showType);
        this.jCheckBoxColours.setSelected(this.prop.useColours);
        this.jTextFieldM.setBackground(this.prop.col_M);
        this.jTextFieldN.setBackground(this.prop.col_N);
        this.jTextFieldA.setBackground(this.prop.col_A);
        this.jTextFieldP.setBackground(this.prop.col_P);
        this.jTextFieldNone.setBackground(this.prop.col_default);
        this.jCheckBoxM.setSelected(this.prop.plotM);
        this.jCheckBoxN.setSelected(this.prop.plotN);
        this.jCheckBoxA.setSelected(this.prop.plotA);
        this.jCheckBoxP.setSelected(this.prop.plotP);
        this.jCheckBoxNone.setSelected(this.prop.plotNonDes);
        this.pack();
    }

    private void initComponents() {
        this.buttonGroupColumns = new ButtonGroup();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldPanelWidth = new JTextField();
        this.jCheckBoxDepths = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSingleColumn = new JRadioButton();
        this.jRadioButtonMultiColumn = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel2 = new JPanel();
        this.jCheckBoxColours = new JCheckBox();
        this.jTextFieldM = new JTextField();
        this.jButtonM = new JButton();
        this.jButtonN = new JButton();
        this.jTextFieldN = new JTextField();
        this.jButtonP = new JButton();
        this.jTextFieldP = new JTextField();
        this.jButtonA = new JButton();
        this.jTextFieldA = new JTextField();
        this.jButtonNone = new JButton();
        this.jTextFieldNone = new JTextField();
        this.jCheckBoxM = new JCheckBox();
        this.jCheckBoxN = new JCheckBox();
        this.jCheckBoxP = new JCheckBox();
        this.jCheckBoxA = new JCheckBox();
        this.jCheckBoxNone = new JCheckBox();
        this.jPanelFilter = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldWell = new JTextField();
        this.jButtonSelectWell = new JButton();
        this.jButtonSelectInterp = new JButton();
        this.jTextFieldInterp = new JTextField();
        this.jCheckBoxFilter = new JCheckBox();
        this.jRadioButtonFilterProject = new JRadioButton();
        this.jRadioButtonFilterWell = new JRadioButton();
        this.jTextFieldProject = new JTextField();
        this.jButtonSelectProject = new JButton();
        this.jCheckBoxType = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Panel width:");
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelEvents.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jCheckBoxDepths.setText("Show depths");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Columns", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupColumns.add(this.jRadioButtonSingleColumn);
        this.jRadioButtonSingleColumn.setText("Plot events as one column");
        this.buttonGroupColumns.add(this.jRadioButtonMultiColumn);
        this.jRadioButtonMultiColumn.setText("Plot FDO on left and LDO on right");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMultiColumn).addComponent(this.jRadioButtonSingleColumn)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSingleColumn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonMultiColumn).addContainerGap(10, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Disciplines", 0, 0, null, new Color(51, 102, 204)));
        this.jCheckBoxColours.setText("Use colours:");
        this.jTextFieldM.setEditable(false);
        this.jButtonM.setText("...");
        this.jButtonM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonMActionPerformed(evt);
            }
        });
        this.jButtonN.setText("...");
        this.jButtonN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonNActionPerformed(evt);
            }
        });
        this.jTextFieldN.setEditable(false);
        this.jButtonP.setText("...");
        this.jButtonP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonPActionPerformed(evt);
            }
        });
        this.jTextFieldP.setEditable(false);
        this.jButtonA.setText("...");
        this.jButtonA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonAActionPerformed(evt);
            }
        });
        this.jTextFieldA.setEditable(false);
        this.jButtonNone.setText("...");
        this.jButtonNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonNoneActionPerformed(evt);
            }
        });
        this.jTextFieldNone.setEditable(false);
        this.jCheckBoxM.setText("Micro.");
        this.jCheckBoxN.setText("Nanno.");
        this.jCheckBoxP.setText("Paly.");
        this.jCheckBoxA.setText("Macro.");
        this.jCheckBoxNone.setText("No discipline:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCheckBoxColours)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxM).addComponent(this.jCheckBoxN).addComponent(this.jCheckBoxP).addComponent(this.jCheckBoxA).addComponent(this.jCheckBoxNone)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonNone, -2, 30, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldA).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonA, -2, 30, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonP, -2, 30, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonN, -2, 30, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jTextFieldM, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonM, -2, 30, -2))))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxColours).addGap(7, 7, 7).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldM, -2, -1, -2).addComponent(this.jButtonM).addComponent(this.jCheckBoxM)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldN, -2, -1, -2).addComponent(this.jButtonN).addComponent(this.jCheckBoxN)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldP, -2, -1, -2).addComponent(this.jButtonP).addComponent(this.jCheckBoxP)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldA, -2, -1, -2).addComponent(this.jButtonA).addComponent(this.jCheckBoxA)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldNone, -2, -1, -2).addComponent(this.jButtonNone).addComponent(this.jCheckBoxNone)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelFilter.setBorder(BorderFactory.createTitledBorder(null, "Filter events", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel3.setText("Version:");
        this.jTextFieldWell.setEditable(false);
        this.jButtonSelectWell.setText("...");
        this.jButtonSelectWell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonSelectWellActionPerformed(evt);
            }
        });
        this.jButtonSelectInterp.setText("...");
        this.jButtonSelectInterp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonSelectInterpActionPerformed(evt);
            }
        });
        this.jTextFieldInterp.setEditable(false);
        this.jCheckBoxFilter.setText("Remove events not picked in:");
        this.buttonGroup1.add(this.jRadioButtonFilterProject);
        this.jRadioButtonFilterProject.setText("Project:");
        this.buttonGroup1.add(this.jRadioButtonFilterWell);
        this.jRadioButtonFilterWell.setText("Well:");
        this.jTextFieldProject.setEditable(false);
        this.jButtonSelectProject.setText("...");
        this.jButtonSelectProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelEvents.this.jButtonSelectProjectActionPerformed(evt);
            }
        });
        GroupLayout jPanelFilterLayout = new GroupLayout(this.jPanelFilter);
        this.jPanelFilter.setLayout(jPanelFilterLayout);
        jPanelFilterLayout.setHorizontalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterLayout.createSequentialGroup().addComponent(this.jCheckBoxFilter).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanelFilterLayout.createSequentialGroup().addGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelFilterLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterWell).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldWell, -2, 106, -2)).addGroup(jPanelFilterLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterProject).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProject))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonSelectProject, -2, 1, Short.MAX_VALUE).addComponent(this.jButtonSelectWell, -2, 30, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanelFilterLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldInterp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectInterp, -2, 30, -2))).addContainerGap()));
        jPanelFilterLayout.setVerticalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelFilterLayout.createSequentialGroup().addComponent(this.jCheckBoxFilter).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldWell, -2, -1, -2).addComponent(this.jButtonSelectWell).addComponent(this.jRadioButtonFilterWell)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonFilterProject).addComponent(this.jTextFieldProject, -2, -1, -2).addComponent(this.jButtonSelectProject)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldInterp, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jButtonSelectInterp)).addGap(16, 16, 16)));
        this.jCheckBoxType.setText("Show event type");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxType).addComponent(this.jCheckBoxDepths).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPanelWidth, -2, 40, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelFilter, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPanelWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxDepths).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFilter, -2, 141, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float width = Float.parseFloat(this.jTextFieldPanelWidth.getText().trim());
        if (width < 40.0f) {
            width = 40.0f;
        }
        this.prop.panelWidth = width;
        this.prop.singleColumn = this.jRadioButtonSingleColumn.isSelected();
        this.prop.showDepths = this.jCheckBoxDepths.isSelected();
        this.prop.showType = this.jCheckBoxType.isSelected();
        this.prop.col_A = this.jTextFieldA.getBackground();
        this.prop.col_M = this.jTextFieldM.getBackground();
        this.prop.col_N = this.jTextFieldN.getBackground();
        this.prop.col_P = this.jTextFieldP.getBackground();
        this.prop.col_default = this.jTextFieldNone.getBackground();
        this.prop.useColours = this.jCheckBoxColours.isSelected();
        this.prop.plotM = this.jCheckBoxM.isSelected();
        this.prop.plotN = this.jCheckBoxN.isSelected();
        this.prop.plotA = this.jCheckBoxA.isSelected();
        this.prop.plotP = this.jCheckBoxP.isSelected();
        this.prop.plotNonDes = this.jCheckBoxNone.isSelected();
        if (this.prop.filterInterp == null || !this.jCheckBoxFilter.isSelected()) {
            this.prop.filterWell = null;
            this.prop.filterProj = null;
            this.prop.filterInterp = null;
        }
        this.prop.encode(this.sbdb, this.panel instanceof PanelEvents);
        this.panel.setProperties(this.prop);
        this.setOK();
    }

    private void jButtonMActionPerformed(ActionEvent evt) {
        this.setColour(this.jTextFieldM);
    }

    private void jButtonNActionPerformed(ActionEvent evt) {
        this.setColour(this.jTextFieldN);
    }

    private void jButtonPActionPerformed(ActionEvent evt) {
        this.setColour(this.jTextFieldP);
    }

    private void jButtonAActionPerformed(ActionEvent evt) {
        this.setColour(this.jTextFieldA);
    }

    private void jButtonNoneActionPerformed(ActionEvent evt) {
        this.setColour(this.jTextFieldNone);
    }

    private void jButtonSelectWellActionPerformed(ActionEvent evt) {
        DialogSelectWell dialog = new DialogSelectWell(this, true, this.sbdb, false, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null) {
            this.prop.filterWell = dialog.selection.get(0);
            this.prop.filterProj = null;
        }
        if (this.prop.filterInterp != null) {
            this.prop.filterInterp = null;
        }
        this.setFilterFields();
    }

    private void jButtonSelectInterpActionPerformed(ActionEvent evt) {
        try {
            LinkedList<Well> project = new LinkedList<Well>();
            if (this.prop.filterWell != null) {
                project.add(this.prop.filterWell);
            } else if (this.prop.filterProj != null) {
                Iterator wellIterator = this.prop.filterProj.getWellIterator();
                while (wellIterator.hasNext()) {
                    project.add((Well)wellIterator.next());
                }
            }
            DialogSelectVersion dialog = new DialogSelectVersion((Dialog)this, true, this.sbdb, project);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.prop.filterInterp = dialog.selection.get(0);
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        this.setFilterFields();
    }

    private void jButtonSelectProjectActionPerformed(ActionEvent evt) {
        try {
            DialogSelectProject dialog = new DialogSelectProject(this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.prop.filterProj = dialog.selection;
                this.prop.filterWell = null;
            }
            if (this.prop.filterInterp != null && this.prop.filterInterp.getInterpID() > 0) {
                this.prop.filterInterp = null;
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        this.setFilterFields();
    }

    private void setFilterFields() {
        this.jTextFieldInterp.setText(this.prop.filterInterp != null ? this.prop.filterInterp.getDescription() : "");
        this.jTextFieldWell.setText(this.prop.filterWell != null ? this.prop.filterWell.getWellName() : "");
        this.jTextFieldProject.setText(this.prop.filterProj != null ? this.prop.filterProj.getName() : "");
        this.jRadioButtonFilterProject.setSelected(this.prop.filterProj != null);
        this.jRadioButtonFilterWell.setSelected(this.prop.filterWell != null);
        if (this.prop.filterInterp != null && (this.prop.filterWell != null || this.prop.filterProj != null)) {
            this.jCheckBoxFilter.setSelected(true);
        }
        this.jButtonSelectInterp.setEnabled(this.prop.filterWell != null || this.prop.filterProj != null);
    }

    private void setColour(JTextField field) {
        Color colour = field.getBackground();
        if ((colour = JColorChooser.showDialog(this, "Colour", colour)) != null) {
            field.setBackground(colour);
        }
    }
}

