/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.PanelIntLith;
import jsbugs.SBDialog;
import util.SB;

public class DialogPanelIntLith
extends SBDialog {
    PanelIntLith panel;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxGrainSize;
    private JCheckBox jCheckBoxQuals;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonClastic;
    private JRadioButton jRadioButtonDunham;
    private JSeparator jSeparator1;
    private JTextField jTextFieldPanelWidth;

    public DialogPanelIntLith(Frame parent, boolean modal, PanelIntLith panel) {
        super(parent, modal);
        this.initComponents();
        this.panel = panel;
        this.init();
    }

    public DialogPanelIntLith(Dialog parent, boolean modal, PanelIntLith panel) {
        super(parent, modal);
        this.initComponents();
        this.panel = panel;
        this.init();
    }

    private void init() {
        this.setTitle("Lithology Panel Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldPanelWidth.setText("" + this.panel.getPanelWidth());
        this.jCheckBoxQuals.setSelected(this.panel.getQualifiers());
        this.jCheckBoxGrainSize.setSelected(this.panel.getGrainSize());
        if (this.panel.isDunham()) {
            this.jRadioButtonDunham.setSelected(true);
        } else {
            this.jRadioButtonClastic.setSelected(true);
        }
        this.enableGrainSize();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldPanelWidth = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jCheckBoxGrainSize = new JCheckBox();
        this.jRadioButtonClastic = new JRadioButton();
        this.jRadioButtonDunham = new JRadioButton();
        this.jCheckBoxQuals = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Panel width:");
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelIntLith.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelIntLith.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelIntLith.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Grain Size", 0, 0, null, new Color(51, 102, 204)));
        this.jCheckBoxGrainSize.setText("Display grain size:");
        this.jCheckBoxGrainSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelIntLith.this.jCheckBoxGrainSizeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonClastic);
        this.jRadioButtonClastic.setText("Clastic");
        this.buttonGroup1.add(this.jRadioButtonDunham);
        this.jRadioButtonDunham.setText("Carbonate (Dunham)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxGrainSize).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonDunham).addComponent(this.jRadioButtonClastic)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxGrainSize).addGap(3, 3, 3).addComponent(this.jRadioButtonClastic).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonDunham).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxQuals.setText("Display accessories / qualifiers / stringers");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPanelWidth, -2, 42, -2)).addComponent(this.jCheckBoxQuals).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jSeparator1, -1, 223, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPanelWidth, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxQuals).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void enableGrainSize() {
        this.jRadioButtonDunham.setEnabled(this.jCheckBoxGrainSize.isSelected());
        this.jRadioButtonClastic.setEnabled(this.jCheckBoxGrainSize.isSelected());
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jCheckBoxGrainSizeActionPerformed(ActionEvent evt) {
        this.enableGrainSize();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float width = Float.parseFloat(this.jTextFieldPanelWidth.getText().trim());
        if (width < 30.0f) {
            width = 30.0f;
        }
        this.panel.setProperties(width, this.jCheckBoxQuals.isSelected(), this.jCheckBoxGrainSize.isSelected(), !this.jRadioButtonClastic.isSelected());
        this.dispose();
    }
}

