/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.PanelSQPicks;
import jsbugs.PanelSequencesProperties;
import jsbugs.SBDialog;
import model2.IGDScheme;
import model2.SBdb;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class DialogPanelSQPicks
extends SBDialog {
    SBdb db;
    PanelSQPicks panel;
    DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
    PanelSequencesProperties prop;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxDisconformities;
    private JCheckBox jCheckBoxDrawDepths;
    private JCheckBox jCheckBoxTracts;
    private JCheckBox jCheckBoxUnits;
    private JComboBox jComboBoxScheme;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelDisconfColWidth;
    private JLabel jLabelScheme;
    private JLabel jLabelUnitsColWidth;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField jTextFieldDisconfColWidth;
    private JTextField jTextFieldPanelWidth;
    private JTextField jTextFieldUnitsColWidth;

    public DialogPanelSQPicks(Frame parent, boolean modal, SBdb db, PanelSQPicks panel) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.panel = panel;
        this.init();
    }

    public DialogPanelSQPicks(Dialog parent, boolean modal, SBdb db, PanelSQPicks panel) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.panel = panel;
        this.init();
    }

    private void init() {
        this.prop = new PanelSequencesProperties(this.panel.getProperties());
        this.fillSchemeCombo();
        this.jTextFieldPanelWidth.setText("" + Float.valueOf(this.prop.columnWidth).intValue());
        this.jCheckBoxUnits.setSelected(this.prop.drawUnits);
        this.enableUnitsPanel();
        this.jCheckBoxDrawDepths.setSelected(this.prop.drawDepths);
        this.jCheckBoxTracts.setSelected(this.prop.drawTracts);
        this.jCheckBoxDisconformities.setSelected(this.prop.drawDisconformities);
        this.jTextFieldDisconfColWidth.setText("" + Float.valueOf(this.prop.disconfColWidth).intValue());
        this.setTitle("Picks Panel Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void fillSchemeCombo() {
        this.comboModel.removeAllElements();
        this.comboModel.addElement("All schemes");
        try {
            WellInterp interp = this.panel.block.well.getInterp(this.panel.interpID);
            for (IGDScheme scheme : interp.getSequenceSchemes()) {
                this.comboModel.addElement(scheme);
            }
            int index = this.comboModel.getIndexOf(this.db.getIGDScheme(this.panel.schID));
            if (index == -1) {
                index = 0;
            }
            this.jComboBoxScheme.setSelectedIndex(index);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jComboBoxScheme = new JComboBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabelScheme = new JLabel();
        this.jPanel1 = new JPanel();
        this.jTextFieldPanelWidth = new JTextField();
        this.jLabel1 = new JLabel();
        this.jCheckBoxDrawDepths = new JCheckBox();
        this.jCheckBoxTracts = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jLabelUnitsColWidth = new JLabel();
        this.jTextFieldUnitsColWidth = new JTextField();
        this.jCheckBoxUnits = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabelDisconfColWidth = new JLabel();
        this.jTextFieldDisconfColWidth = new JTextField();
        this.jCheckBoxDisconformities = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel2.setText("Scheme:");
        this.jComboBoxScheme.setModel(this.comboModel);
        this.jComboBoxScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelSQPicks.this.jComboBoxSchemeActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelSQPicks.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelSQPicks.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabelScheme.setText("<html>Note: You should only plot multiple <br>schemes where they do not overlap.</html>");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Picks column", 0, 0, null, new Color(51, 102, 204)));
        this.jTextFieldPanelWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelSQPicks.this.jTextFieldPanelWidthKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Column width:");
        this.jCheckBoxDrawDepths.setText("Show depths");
        this.jCheckBoxTracts.setText("Show inferred sequence tracts");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxTracts).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPanelWidth, -2, 42, -2)).addComponent(this.jCheckBoxDrawDepths)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPanelWidth, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxTracts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDrawDepths)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Units column", 0, 0, null, new Color(51, 102, 204)));
        this.jLabelUnitsColWidth.setText("Column width:");
        this.jTextFieldUnitsColWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelSQPicks.this.jTextFieldUnitsColWidthKeyTyped(evt);
            }
        });
        this.jCheckBoxUnits.setText("Plot inferred units column");
        this.jCheckBoxUnits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelSQPicks.this.jCheckBoxUnitsActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxUnits).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabelUnitsColWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldUnitsColWidth, -2, 42, -2))).addContainerGap(61, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxUnits).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelUnitsColWidth).addComponent(this.jTextFieldUnitsColWidth, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Disconformities column", 0, 0, null, new Color(51, 102, 204)));
        this.jLabelDisconfColWidth.setText("Column width:");
        this.jTextFieldDisconfColWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelSQPicks.this.jTextFieldDisconfColWidthKeyTyped(evt);
            }
        });
        this.jCheckBoxDisconformities.setText("Plot disconformities");
        this.jCheckBoxDisconformities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelSQPicks.this.jCheckBoxDisconformitiesActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxDisconformities).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabelDisconfColWidth).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDisconfColWidth, -2, 42, -2))).addContainerGap(91, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxDisconformities).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDisconfColWidth).addComponent(this.jTextFieldDisconfColWidth, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelScheme, -2, -1, -2).addComponent(this.jComboBoxScheme, 0, 183, Short.MAX_VALUE))).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBoxScheme, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelScheme, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jComboBoxSchemeActionPerformed(ActionEvent evt) {
        this.setSchemeLabel();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float disconfColWidth;
        float unitsColWidth;
        float columnWidth;
        if (this.jTextFieldPanelWidth.getText().isEmpty()) {
            columnWidth = this.prop.columnWidth;
        } else {
            columnWidth = Float.parseFloat(this.jTextFieldPanelWidth.getText());
            if (columnWidth < 20.0f) {
                columnWidth = 20.0f;
            }
        }
        this.prop.columnWidth = columnWidth;
        if (this.jTextFieldUnitsColWidth.getText().isEmpty()) {
            unitsColWidth = this.prop.unitsColWidth;
        } else {
            unitsColWidth = Float.parseFloat(this.jTextFieldUnitsColWidth.getText());
            if (unitsColWidth < 20.0f) {
                unitsColWidth = 20.0f;
            }
        }
        this.prop.unitsColWidth = unitsColWidth;
        if (this.jTextFieldDisconfColWidth.getText().isEmpty()) {
            disconfColWidth = this.prop.disconfColWidth;
        } else {
            disconfColWidth = Float.parseFloat(this.jTextFieldDisconfColWidth.getText());
            if (disconfColWidth < 20.0f) {
                disconfColWidth = 20.0f;
            }
        }
        this.prop.disconfColWidth = disconfColWidth;
        int schID = this.jComboBoxScheme.getSelectedItem() instanceof IGDScheme ? ((IGDScheme)this.jComboBoxScheme.getSelectedItem()).getID() : 0;
        this.prop.drawDepths = this.jCheckBoxDrawDepths.isSelected();
        this.prop.drawTracts = this.jCheckBoxTracts.isSelected();
        this.prop.drawUnits = this.jCheckBoxUnits.isSelected();
        this.prop.drawDisconformities = this.jCheckBoxDisconformities.isSelected();
        this.panel.setProperties(this.prop, schID);
        this.prop.encode(this.db);
        this.setOK();
    }

    private void jCheckBoxUnitsActionPerformed(ActionEvent evt) {
        this.enableUnitsPanel();
    }

    private void jTextFieldPanelWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitsColWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldUnitsColWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDisconfColWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldDisconfColWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxDisconformitiesActionPerformed(ActionEvent evt) {
    }

    private void setSchemeLabel() {
        if (this.jComboBoxScheme.getSelectedIndex() == 0) {
            this.jLabelScheme.setVisible(true);
        } else {
            this.jLabelScheme.setVisible(false);
        }
    }

    private void enableUnitsPanel() {
        boolean enable = this.jCheckBoxUnits.isSelected();
        this.jTextFieldUnitsColWidth.setEnabled(enable);
        if (enable) {
            this.jTextFieldUnitsColWidth.setText("" + Float.valueOf(this.prop.unitsColWidth).intValue());
        } else {
            this.jTextFieldUnitsColWidth.setText("");
        }
        this.jLabelUnitsColWidth.setEnabled(enable);
    }
}

