/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jsbugs.ChartProperties;
import jsbugs.DialogList;
import jsbugs.DialogPanelTaxonBase;
import jsbugs.DialogPanelTaxonGroup;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.DialogSelectTaxa;
import jsbugs.FrameJsbugs;
import jsbugs.InvalidTaxonFieldException;
import jsbugs.PanelTaxon;
import jsbugs.PanelTaxonBase;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelTaxonProperties;
import model2.CompositeStandard;
import model2.IGDScheme;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class DialogPanelTaxon
extends DialogPanelTaxonBase {
    static final int TAB_DATA = 0;
    static final int TAB_ABN = 1;
    static final int TAB_GROUP = 2;
    static final int TAB_STYLE = 3;
    static final int TAB_OPTIONS = 4;
    static final int TAB_HDR = 5;
    private PanelTaxonProperties prop;
    private final PanelTaxon panel;
    private final PanelTaxonGroup panelGroup;
    private final WellInterp wellInterp;
    Taxon filter_spec = null;
    private static int tab = 0;
    private ButtonGroup buttonGroupAbn;
    private ButtonGroup buttonGroupCalc;
    private ButtonGroup buttonGroupCurve;
    private ButtonGroup buttonGroupDataFilter;
    private ButtonGroup buttonGroupEdit;
    private ButtonGroup buttonGroupGroup;
    private ButtonGroup buttonGroupPlotType;
    private ButtonGroup buttonGroupSort;
    private ButtonGroup buttonGroupStyleJustify;
    private ButtonGroup buttonGroupSubGroup;
    private ButtonGroup buttonGroupSubTypes;
    private JButton jButtonCancel;
    private JButton jButtonClearCmpStd;
    private JButton jButtonClearScheme;
    private JButton jButtonCmpStd;
    private JButton jButtonColour;
    private JButton jButtonFilterCat;
    private JButton jButtonFilterGroup;
    private JButton jButtonFilterSet;
    private JButton jButtonFilterSpecies;
    private JButton jButtonHelp;
    private JButton jButtonHighlightColour;
    private JButton jButtonHighlightGroup;
    private JButton jButtonHighlightGroupClear;
    private JButton jButtonInterpSchClear;
    private JButton jButtonInterpSchSelect;
    private JButton jButtonOK;
    private JButton jButtonOuterPanel;
    private JButton jButtonScheme;
    private JButton jButtonSubTypes;
    private JCheckBox jCheckBoxClearEmptyTracks;
    private JCheckBox jCheckBoxColoursInherit;
    private JCheckBox jCheckBoxColoursLabels;
    private JCheckBox jCheckBoxColoursSuites;
    private JCheckBox jCheckBoxGrid;
    private JCheckBox jCheckBoxHdrAuth;
    private JCheckBox jCheckBoxHdrCat;
    private JCheckBox jCheckBoxIncludeCv;
    private JCheckBox jCheckBoxIncludeQ;
    private JCheckBox jCheckBoxIncludeRw;
    private JCheckBox jCheckBoxIncludeSubCats;
    private JCheckBox jCheckBoxIncludeUnqualified;
    private JCheckBox jCheckBoxInterpEvents;
    private JCheckBox jCheckBoxNormaliseWeight;
    private JCheckBox jCheckBoxPlotSawtoothEnhanced;
    private JCheckBox jCheckBoxSchAbrs;
    private JCheckBox jCheckBoxShowAbundance;
    private JCheckBox jCheckBoxShowFlags;
    private JCheckBox jCheckBoxShowImages;
    private JCheckBox jCheckBoxShowImagesMarkers;
    private JCheckBox jCheckBoxSplits;
    private JCheckBox jCheckBoxStratigraphicRange;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelOuterPanel;
    private JLabel jLabelScope;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelAbn;
    private JPanel jPanelAbnDisplay;
    private JPanel jPanelData;
    private JPanel jPanelDataFilters;
    private JPanel jPanelDataQualifiers;
    private JPanel jPanelDataSubTypes;
    private JPanel jPanelGrouping;
    private JPanel jPanelGroupingGroup;
    private JPanel jPanelGroupingSubGroup;
    private JPanel jPanelHeader;
    private JPanel jPanelHeaderAges;
    private JPanel jPanelHeaderHighlight;
    private JPanel jPanelHeaderNames;
    private JPanel jPanelInterp;
    private JPanel jPanelOptions;
    private JPanel jPanelOptionsColours;
    private JPanel jPanelOptionsImages;
    private JPanel jPanelOptionsScale;
    private JPanel jPanelOptionsSort;
    private JPanel jPanelStyle;
    private JPanel jPanelStyleCalculation;
    private JPanel jPanelStyleCurve;
    private JPanel jPanelStylePlot;
    private JRadioButton jRadioButtonAbnMix;
    private JRadioButton jRadioButtonAbnPA;
    private JRadioButton jRadioButtonAbnQ;
    private JRadioButton jRadioButtonAbnSemiQ;
    private JRadioButton jRadioButtonCalcAbs;
    private JRadioButton jRadioButtonCalcDiversity;
    private JRadioButton jRadioButtonCalcRelative;
    private JRadioButton jRadioButtonCalcRelativeOuter;
    private JRadioButton jRadioButtonCalcShannon;
    private JRadioButton jRadioButtonEditInner;
    private JRadioButton jRadioButtonEditOuter;
    private JRadioButton jRadioButtonFilterAll;
    private JRadioButton jRadioButtonFilterCategory;
    private JRadioButton jRadioButtonFilterGroup;
    private JRadioButton jRadioButtonFilterSet;
    private JRadioButton jRadioButtonFilterSpecies;
    private JRadioButton jRadioButtonGroupCat;
    private JRadioButton jRadioButtonGroupCaving;
    private JRadioButton jRadioButtonGroupConf;
    private JRadioButton jRadioButtonGroupGenus;
    private JRadioButton jRadioButtonGroupGroup;
    private JRadioButton jRadioButtonGroupNone;
    private JRadioButton jRadioButtonGroupSitu;
    private JRadioButton jRadioButtonGroupSpec;
    private JRadioButton jRadioButtonGroupSubTypes;
    private JRadioButton jRadioButtonJustifyCentre;
    private JRadioButton jRadioButtonJustifyLeft;
    private JRadioButton jRadioButtonJustifyRight;
    private JRadioButton jRadioButtonPlotCurve;
    private JRadioButton jRadioButtonPlotHist;
    private JRadioButton jRadioButtonPlotNumbers;
    private JRadioButton jRadioButtonPlotSaw;
    private JRadioButton jRadioButtonSortAlpha;
    private JRadioButton jRadioButtonSortFDO;
    private JRadioButton jRadioButtonSortFUO;
    private JRadioButton jRadioButtonSubGroupConf;
    private JRadioButton jRadioButtonSubGroupNone;
    private JRadioButton jRadioButtonSubGroupSitu;
    private JRadioButton jRadioButtonSubGroupSizeFraction;
    private JRadioButton jRadioButtonSubGroupSpecType;
    private JRadioButton jRadioButtonSubTypesAll;
    private JRadioButton jRadioButtonSubTypesRestricted;
    private JRadioButton jRadioButtonTrackMulti;
    private JRadioButton jRadioButtonTrackSingle;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSlider jSliderIGDDensity;
    private JSpinner jSpinnerPlotSawtoothEnhanced;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldCmpStd;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldCutoff;
    private JTextField jTextFieldFilterCat;
    private JTextField jTextFieldFilterGroup;
    private JTextField jTextFieldFilterSet;
    private JTextField jTextFieldFilterSpecies;
    private JTextField jTextFieldHighlightColour;
    private JTextField jTextFieldHighlightGroup;
    private JTextField jTextFieldImageWidth;
    private JTextField jTextFieldInterpSch;
    private JTextField jTextFieldMinWidth;
    private JTextField jTextFieldNormalWeight;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldTaxaColWidth;

    public DialogPanelTaxon(Frame parent, boolean modal, SBdb sbdb, PanelTaxonGroup panelGroup, PanelTaxon panel, ChartProperties cp, WellInterp wellInterp) {
        super(parent, modal, sbdb, (PanelTaxonBase)panel);
        this.initComponents();
        this.panelGroup = panelGroup;
        this.panel = panel;
        this.wellInterp = wellInterp;
        this.init();
    }

    public DialogPanelTaxon(Dialog parent, boolean modal, SBdb sbdb, PanelTaxonGroup panelGroup, PanelTaxon panel, WellInterp wellInterp) {
        super(parent, modal, sbdb, (PanelTaxonBase)panel);
        this.initComponents();
        this.panelGroup = panelGroup;
        this.panel = panel;
        this.wellInterp = wellInterp;
        if (parent instanceof DialogPanelTaxonGroup) {
            this.jButtonOuterPanel.setEnabled(false);
        }
        this.init();
    }

    private void init() {
        super.init(this.panel);
        this.prop = new PanelTaxonProperties(this.panel.getProperties());
        this.setTitle("Biostratigraphy Panel Properties : " + this.panelGroup.getDiscID().getNoun());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jLabelOuterPanel.setText(this.panelGroup.getSubCaption(false, true));
        if (this.panelGroup.size() > 1) {
            if (this.panel.getProperties() == this.panelGroup.defaultProperties) {
                this.jRadioButtonEditOuter.setSelected(true);
            } else {
                this.jRadioButtonEditInner.setSelected(true);
                this.jRadioButtonEditOuter.setText("Reset to outer");
            }
        } else {
            this.jLabelScope.setVisible(false);
            this.jRadioButtonEditInner.setVisible(false);
            this.jRadioButtonEditOuter.setVisible(false);
        }
        try {
            IGDScheme scheme;
            this.setFilterAllLabel();
            if (this.buttonGroupDataFilter.getSelection() == null) {
                if (this.panel.filter_spec != null) {
                    this.filter_spec = this.panel.filter_spec;
                    this.jRadioButtonFilterSpecies.setSelected(true);
                    this.jTextFieldFilterSpecies.setText(this.filter_spec.toString(false, true));
                } else {
                    this.jRadioButtonFilterAll.setSelected(true);
                }
            }
            this.jCheckBoxIncludeSubCats.setSelected(this.panel.includeSubCats);
            this.setFilterFields();
            this.jCheckBoxIncludeUnqualified.setSelected(this.prop.includeUnqualified);
            this.jCheckBoxIncludeRw.setSelected(this.prop.includeRw);
            this.jCheckBoxIncludeCv.setSelected(this.prop.includeCv);
            this.jCheckBoxIncludeQ.setSelected(this.prop.includeQ);
            this.jRadioButtonSubTypesRestricted.setSelected(this.prop.subTypes != null);
            switch (this.prop.abn_style) {
                case Q: {
                    this.jRadioButtonAbnQ.setSelected(true);
                    break;
                }
                case SEMIQ: {
                    this.jRadioButtonAbnSemiQ.setSelected(true);
                    break;
                }
                case MIX: {
                    this.jRadioButtonAbnMix.setSelected(true);
                    break;
                }
                case PA: {
                    this.jRadioButtonAbnPA.setSelected(true);
                }
            }
            this.jCheckBoxSplits.setSelected(this.prop.useSplits);
            this.jCheckBoxNormaliseWeight.setSelected(this.prop.normaliseWeight);
            this.jTextFieldNormalWeight.setText("" + this.prop.normalWeight);
            switch (this.prop.group) {
                case CAT: {
                    this.jRadioButtonGroupCat.setSelected(true);
                    break;
                }
                case GENUS: {
                    this.jRadioButtonGroupGenus.setSelected(true);
                    break;
                }
                case GROUP: {
                    this.jRadioButtonGroupGroup.setSelected(true);
                    break;
                }
                case SITU: {
                    this.jRadioButtonGroupSitu.setSelected(true);
                    break;
                }
                case SPEC: {
                    this.jRadioButtonGroupSpec.setSelected(true);
                    break;
                }
                case SUBTYPE: {
                    this.jRadioButtonGroupSubTypes.setSelected(true);
                    break;
                }
                case CONF: {
                    this.jRadioButtonGroupConf.setSelected(true);
                    break;
                }
                case CV: {
                    this.jRadioButtonGroupCaving.setSelected(true);
                    break;
                }
                case TOTAL: {
                    this.jRadioButtonGroupNone.setSelected(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.prop.track_style == PanelTaxonProperties.Track.MULTI) {
                this.jRadioButtonSubGroupNone.setSelected(true);
                this.enableSubGrouping(false);
            } else {
                switch (this.prop.subgroup) {
                    case CONF: {
                        this.jRadioButtonSubGroupConf.setSelected(true);
                        break;
                    }
                    case SITU: {
                        this.jRadioButtonSubGroupSitu.setSelected(true);
                        break;
                    }
                    case SUBTYPE: {
                        this.jRadioButtonSubGroupSpecType.setSelected(true);
                        break;
                    }
                    case CMF: {
                        this.jRadioButtonSubGroupSizeFraction.setSelected(true);
                        break;
                    }
                    case NONE: {
                        this.jRadioButtonSubGroupNone.setSelected(true);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (this.prop.track_style == PanelTaxonProperties.Track.SINGLE) {
                this.jRadioButtonTrackSingle.setSelected(true);
            } else {
                this.jRadioButtonTrackMulti.setSelected(true);
            }
            switch (this.prop.calc_style) {
                default: {
                    this.jRadioButtonCalcAbs.setSelected(true);
                    break;
                }
                case RELATIVE: {
                    this.jRadioButtonCalcRelative.setSelected(true);
                    break;
                }
                case RELATIVE_OUTER: {
                    this.jRadioButtonCalcRelativeOuter.setSelected(true);
                    break;
                }
                case RICHNESS: {
                    this.jRadioButtonCalcDiversity.setSelected(true);
                    break;
                }
                case SHANNON: {
                    this.jRadioButtonCalcShannon.setSelected(true);
                }
            }
            switch (this.prop.plot_style) {
                case HIST: {
                    this.jRadioButtonPlotHist.setSelected(true);
                    break;
                }
                case SAWTOOTH: {
                    this.jRadioButtonPlotSaw.setSelected(true);
                    if (!this.prop.sawtoothEnhanced) break;
                    this.jCheckBoxPlotSawtoothEnhanced.setSelected(true);
                    this.jSpinnerPlotSawtoothEnhanced.setValue(this.prop.sawtoothEnhancement);
                    break;
                }
                case NUMBERS: {
                    this.jRadioButtonPlotNumbers.setSelected(true);
                    break;
                }
                case CURVE: {
                    this.jRadioButtonPlotCurve.setSelected(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            switch (this.prop.justify) {
                case LEFT: {
                    this.jRadioButtonJustifyLeft.setSelected(true);
                    break;
                }
                case RIGHT: {
                    this.jRadioButtonJustifyRight.setSelected(true);
                    break;
                }
                case CENTRE: {
                    this.jRadioButtonJustifyCentre.setSelected(true);
                }
            }
            this.jCheckBoxStratigraphicRange.setSelected(this.prop.stratRange);
            this.enableSawtoothEnhanced();
            switch (this.prop.sortType) {
                case 3: {
                    this.jRadioButtonSortAlpha.setSelected(true);
                    break;
                }
                case 0: {
                    this.jRadioButtonSortFDO.setSelected(true);
                    break;
                }
                case 1: {
                    this.jRadioButtonSortFUO.setSelected(true);
                }
            }
            this.jTextFieldCutoff.setText("" + Float.valueOf(this.prop.cutoff).intValue());
            this.jTextFieldTaxaColWidth.setText("" + Float.valueOf(this.prop.maxWidth).intValue());
            this.jTextFieldMinWidth.setText("" + Float.valueOf(this.prop.minWidth).intValue());
            this.jTextFieldColour.setBackground(this.prop.colour);
            this.jCheckBoxColoursLabels.setSelected(this.prop.colourLabels);
            this.jCheckBoxColoursSuites.setSelected(this.prop.colourSuites);
            this.jCheckBoxColoursInherit.setSelected(this.prop.inheritFilterColour);
            this.jCheckBoxShowFlags.setSelected(this.prop.showFlags);
            this.jCheckBoxGrid.setSelected(this.prop.grid);
            this.jCheckBoxShowImages.setSelected(this.prop.showImages);
            this.jCheckBoxShowImagesMarkers.setSelected(this.prop.filterMkrImages);
            this.jTextFieldImageWidth.setText("" + Float.valueOf(this.prop.imageWidth).intValue());
            this.jCheckBoxClearEmptyTracks.setSelected(!this.prop.clearEmptyTracks);
            this.jCheckBoxShowAbundance.setSelected(this.prop.showAbundance);
            this.jCheckBoxHdrCat.setSelected(this.prop.hdr_cat);
            this.jCheckBoxHdrAuth.setSelected(this.prop.hdr_author);
            if (this.prop.cmpStdID > 0) {
                CompositeStandard std = this.sbdb.getCompositeStandard(this.prop.cmpStdID);
                if (std != null) {
                    this.jTextFieldCmpStd.setText(std.getName());
                } else {
                    this.prop.cmpStdID = -1;
                }
            }
            if (this.prop.schID > 0) {
                scheme = this.sbdb.getIGDScheme(this.prop.schID);
                if (scheme != null) {
                    this.jTextFieldScheme.setText(scheme.toString());
                } else {
                    this.prop.schID = -1;
                }
            }
            this.jCheckBoxSchAbrs.setSelected(this.prop.schAbrs);
            if (this.prop.highlightGroup != null) {
                this.jTextFieldHighlightGroup.setText(this.prop.highlightGroup.toString());
            }
            this.jTextFieldHighlightColour.setBackground(this.prop.highlightColour);
            if (this.prop.interpSchID > 0) {
                scheme = this.sbdb.getIGDScheme(this.prop.interpSchID);
                if (scheme != null) {
                    this.jTextFieldInterpSch.setText(scheme.toString());
                } else {
                    this.prop.interpSchID = -1;
                }
            }
            this.jSliderIGDDensity.setValue((int)(this.prop.interpShadingDensity * 10.0f));
            this.jCheckBoxInterpEvents.setSelected(this.prop.drawEvents);
            this.jTabbedPane1.setSelectedIndex(tab);
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error initiating dialog", (SQLException)sqle);
        }
    }

    private void setFilterAllLabel() {
        this.jRadioButtonFilterAll.setText(this.panelGroup.getSubCaption(false, true));
    }

    private void initComponents() {
        this.buttonGroupDataFilter = new ButtonGroup();
        this.buttonGroupPlotType = new ButtonGroup();
        this.buttonGroupCalc = new ButtonGroup();
        this.buttonGroupCurve = new ButtonGroup();
        this.buttonGroupGroup = new ButtonGroup();
        this.buttonGroupSubGroup = new ButtonGroup();
        this.buttonGroupAbn = new ButtonGroup();
        this.buttonGroupSort = new ButtonGroup();
        this.buttonGroupSubTypes = new ButtonGroup();
        this.buttonGroupStyleJustify = new ButtonGroup();
        this.buttonGroupEdit = new ButtonGroup();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelData = new JPanel();
        this.jPanelDataFilters = new JPanel();
        this.jTextFieldFilterSet = new JTextField();
        this.jRadioButtonFilterAll = new JRadioButton();
        this.jRadioButtonFilterSet = new JRadioButton();
        this.jRadioButtonFilterGroup = new JRadioButton();
        this.jRadioButtonFilterSpecies = new JRadioButton();
        this.jTextFieldFilterSpecies = new JTextField();
        this.jTextFieldFilterGroup = new JTextField();
        this.jButtonFilterSet = new JButton();
        this.jButtonFilterGroup = new JButton();
        this.jButtonFilterSpecies = new JButton();
        this.jRadioButtonFilterCategory = new JRadioButton();
        this.jButtonFilterCat = new JButton();
        this.jTextFieldFilterCat = new JTextField();
        this.jCheckBoxIncludeSubCats = new JCheckBox();
        this.jPanelDataQualifiers = new JPanel();
        this.jCheckBoxIncludeCv = new JCheckBox();
        this.jCheckBoxIncludeQ = new JCheckBox();
        this.jCheckBoxIncludeRw = new JCheckBox();
        this.jCheckBoxIncludeUnqualified = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanelDataSubTypes = new JPanel();
        this.jRadioButtonSubTypesAll = new JRadioButton();
        this.jRadioButtonSubTypesRestricted = new JRadioButton();
        this.jButtonSubTypes = new JButton();
        this.jPanelAbn = new JPanel();
        this.jPanelAbnDisplay = new JPanel();
        this.jRadioButtonAbnQ = new JRadioButton();
        this.jRadioButtonAbnSemiQ = new JRadioButton();
        this.jRadioButtonAbnMix = new JRadioButton();
        this.jRadioButtonAbnPA = new JRadioButton();
        this.jCheckBoxSplits = new JCheckBox();
        this.jTextFieldNormalWeight = new JTextField();
        this.jLabel11 = new JLabel();
        this.jCheckBoxNormaliseWeight = new JCheckBox();
        this.jPanelGrouping = new JPanel();
        this.jPanelGroupingSubGroup = new JPanel();
        this.jRadioButtonSubGroupSitu = new JRadioButton();
        this.jRadioButtonSubGroupConf = new JRadioButton();
        this.jRadioButtonSubGroupSpecType = new JRadioButton();
        this.jRadioButtonSubGroupNone = new JRadioButton();
        this.jSeparator2 = new JSeparator();
        this.jRadioButtonSubGroupSizeFraction = new JRadioButton();
        this.jPanelGroupingGroup = new JPanel();
        this.jRadioButtonGroupSpec = new JRadioButton();
        this.jRadioButtonGroupCat = new JRadioButton();
        this.jRadioButtonGroupGroup = new JRadioButton();
        this.jRadioButtonGroupGenus = new JRadioButton();
        this.jRadioButtonGroupSitu = new JRadioButton();
        this.jRadioButtonGroupConf = new JRadioButton();
        this.jRadioButtonGroupSubTypes = new JRadioButton();
        this.jRadioButtonGroupCaving = new JRadioButton();
        this.jRadioButtonGroupNone = new JRadioButton();
        this.jPanelStyle = new JPanel();
        this.jPanelStyleCurve = new JPanel();
        this.jRadioButtonPlotHist = new JRadioButton();
        this.jRadioButtonPlotSaw = new JRadioButton();
        this.jRadioButtonPlotNumbers = new JRadioButton();
        this.jCheckBoxStratigraphicRange = new JCheckBox();
        this.jRadioButtonPlotCurve = new JRadioButton();
        this.jCheckBoxPlotSawtoothEnhanced = new JCheckBox();
        this.jSpinnerPlotSawtoothEnhanced = new JSpinner();
        this.jPanel1 = new JPanel();
        this.jRadioButtonJustifyLeft = new JRadioButton();
        this.jRadioButtonJustifyRight = new JRadioButton();
        this.jRadioButtonJustifyCentre = new JRadioButton();
        this.jPanelStyleCalculation = new JPanel();
        this.jRadioButtonCalcAbs = new JRadioButton();
        this.jRadioButtonCalcRelative = new JRadioButton();
        this.jRadioButtonCalcDiversity = new JRadioButton();
        this.jRadioButtonCalcRelativeOuter = new JRadioButton();
        this.jRadioButtonCalcShannon = new JRadioButton();
        this.jPanelStylePlot = new JPanel();
        this.jRadioButtonTrackMulti = new JRadioButton();
        this.jRadioButtonTrackSingle = new JRadioButton();
        this.jPanelOptions = new JPanel();
        this.jPanelOptionsSort = new JPanel();
        this.jRadioButtonSortAlpha = new JRadioButton();
        this.jRadioButtonSortFDO = new JRadioButton();
        this.jRadioButtonSortFUO = new JRadioButton();
        this.jPanelOptionsScale = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldCutoff = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldTaxaColWidth = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldMinWidth = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jCheckBoxShowFlags = new JCheckBox();
        this.jCheckBoxGrid = new JCheckBox();
        this.jPanelOptionsImages = new JPanel();
        this.jCheckBoxShowImages = new JCheckBox();
        this.jCheckBoxShowImagesMarkers = new JCheckBox();
        this.jTextFieldImageWidth = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jCheckBoxClearEmptyTracks = new JCheckBox();
        this.jCheckBoxShowAbundance = new JCheckBox();
        this.jPanelOptionsColours = new JPanel();
        this.jLabel7 = new JLabel();
        this.jButtonColour = new JButton();
        this.jTextFieldColour = new JTextField();
        this.jCheckBoxColoursSuites = new JCheckBox();
        this.jCheckBoxColoursLabels = new JCheckBox();
        this.jCheckBoxColoursInherit = new JCheckBox();
        this.jPanelHeader = new JPanel();
        this.jPanelHeaderNames = new JPanel();
        this.jCheckBoxHdrCat = new JCheckBox();
        this.jCheckBoxHdrAuth = new JCheckBox();
        this.jPanelHeaderAges = new JPanel();
        this.jButtonClearScheme = new JButton();
        this.jButtonClearCmpStd = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonScheme = new JButton();
        this.jTextFieldCmpStd = new JTextField();
        this.jCheckBoxSchAbrs = new JCheckBox();
        this.jButtonCmpStd = new JButton();
        this.jPanelHeaderHighlight = new JPanel();
        this.jTextFieldHighlightGroup = new JTextField();
        this.jButtonHighlightGroup = new JButton();
        this.jButtonHighlightColour = new JButton();
        this.jTextFieldHighlightColour = new JTextField();
        this.jButtonHighlightGroupClear = new JButton();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jPanelInterp = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel14 = new JLabel();
        this.jTextFieldInterpSch = new JTextField();
        this.jButtonInterpSchClear = new JButton();
        this.jButtonInterpSchSelect = new JButton();
        this.jSliderIGDDensity = new JSlider();
        this.jLabel15 = new JLabel();
        this.jCheckBoxInterpEvents = new JCheckBox();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonOuterPanel = new JButton();
        this.jLabelOuterPanel = new JLabel();
        this.jRadioButtonEditInner = new JRadioButton();
        this.jRadioButtonEditOuter = new JRadioButton();
        this.jLabelScope = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanelDataFilters.setBorder(BorderFactory.createTitledBorder(null, "Restrict inner panel data to:", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jTextFieldFilterSet.setEditable(false);
        this.jTextFieldFilterSet.setBackground(new Color(255, 255, 204));
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterAll);
        this.jRadioButtonFilterAll.setText("All <discipline>");
        this.jRadioButtonFilterAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonFilterAllActionPerformed(evt);
            }
        });
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterSet);
        this.jRadioButtonFilterSet.setText("Group set:");
        this.jRadioButtonFilterSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonFilterSetActionPerformed(evt);
            }
        });
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterGroup);
        this.jRadioButtonFilterGroup.setText("Group:");
        this.jRadioButtonFilterGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonFilterGroupActionPerformed(evt);
            }
        });
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterSpecies);
        this.jRadioButtonFilterSpecies.setText("Species:");
        this.jRadioButtonFilterSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonFilterSpeciesActionPerformed(evt);
            }
        });
        this.jTextFieldFilterSpecies.setEditable(false);
        this.jTextFieldFilterSpecies.setBackground(new Color(255, 255, 204));
        this.jTextFieldFilterGroup.setEditable(false);
        this.jTextFieldFilterGroup.setBackground(new Color(255, 255, 204));
        this.jButtonFilterSet.setText("...");
        this.jButtonFilterSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonFilterSetActionPerformed(evt);
            }
        });
        this.jButtonFilterGroup.setText("...");
        this.jButtonFilterGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonFilterGroupActionPerformed(evt);
            }
        });
        this.jButtonFilterSpecies.setText("...");
        this.jButtonFilterSpecies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonFilterSpeciesActionPerformed(evt);
            }
        });
        this.buttonGroupDataFilter.add(this.jRadioButtonFilterCategory);
        this.jRadioButtonFilterCategory.setText("Category:");
        this.jRadioButtonFilterCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonFilterCategoryActionPerformed(evt);
            }
        });
        this.jButtonFilterCat.setText("...");
        this.jButtonFilterCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonFilterCatActionPerformed(evt);
            }
        });
        this.jTextFieldFilterCat.setEditable(false);
        this.jTextFieldFilterCat.setBackground(new Color(255, 255, 204));
        this.jCheckBoxIncludeSubCats.setText("Include sub-categories");
        GroupLayout jPanelDataFiltersLayout = new GroupLayout(this.jPanelDataFilters);
        this.jPanelDataFilters.setLayout(jPanelDataFiltersLayout);
        jPanelDataFiltersLayout.setHorizontalGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterAll).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanelDataFiltersLayout.createSequentialGroup().addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFilterGroup, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonFilterSet).addComponent(this.jRadioButtonFilterSpecies, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFilterSet).addComponent(this.jTextFieldFilterSpecies).addComponent(this.jTextFieldFilterGroup)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonFilterGroup, -2, 35, -2).addComponent(this.jButtonFilterSet, -2, 35, -2)).addComponent(this.jButtonFilterSpecies, GroupLayout.Alignment.TRAILING, -2, 35, -2))).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterCategory, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldFilterCat, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterCat, -2, 29, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeSubCats))).addGap(57, 57, 57)))));
        jPanelDataFiltersLayout.linkSize(0, this.jRadioButtonFilterCategory, this.jRadioButtonFilterGroup, this.jRadioButtonFilterSet, this.jRadioButtonFilterSpecies);
        jPanelDataFiltersLayout.setVerticalGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonFilterSet).addComponent(this.jTextFieldFilterSet, -2, -1, -2).addComponent(this.jButtonFilterSet)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonFilterGroup).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFilterGroup, -2, -1, -2).addComponent(this.jButtonFilterGroup))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonFilterSpecies).addComponent(this.jTextFieldFilterSpecies, -2, -1, -2).addComponent(this.jButtonFilterSpecies)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFilterCat).addComponent(this.jTextFieldFilterCat, -2, -1, -2).addComponent(this.jCheckBoxIncludeSubCats)).addComponent(this.jRadioButtonFilterCategory)).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanelDataQualifiers.setBorder(BorderFactory.createTitledBorder(null, "Qualified occurrences", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxIncludeCv.setText("Caved");
        this.jCheckBoxIncludeCv.setToolTipText("Include caved occurrences");
        this.jCheckBoxIncludeQ.setText("Questionable");
        this.jCheckBoxIncludeQ.setToolTipText("Include questionable occurrences");
        this.jCheckBoxIncludeRw.setText("Reworked");
        this.jCheckBoxIncludeRw.setToolTipText("Include reworked occurrences");
        this.jCheckBoxIncludeUnqualified.setText("Unqualified");
        this.jCheckBoxIncludeUnqualified.setToolTipText("Exclude all occurrences which do not have any of the qualifiers checked above");
        GroupLayout jPanelDataQualifiersLayout = new GroupLayout(this.jPanelDataQualifiers);
        this.jPanelDataQualifiers.setLayout(jPanelDataQualifiersLayout);
        jPanelDataQualifiersLayout.setHorizontalGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataQualifiersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanelDataQualifiersLayout.createSequentialGroup().addGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxIncludeCv).addComponent(this.jCheckBoxIncludeRw).addComponent(this.jCheckBoxIncludeQ).addComponent(this.jCheckBoxIncludeUnqualified)).addGap(0, 34, Short.MAX_VALUE))).addContainerGap()));
        jPanelDataQualifiersLayout.setVerticalGroup(jPanelDataQualifiersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataQualifiersLayout.createSequentialGroup().addComponent(this.jCheckBoxIncludeRw).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeCv).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeQ).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIncludeUnqualified).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelDataSubTypes.setBorder(BorderFactory.createTitledBorder(null, "Sub-types", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSubTypes.add(this.jRadioButtonSubTypesAll);
        this.jRadioButtonSubTypesAll.setSelected(true);
        this.jRadioButtonSubTypesAll.setText("All");
        this.buttonGroupSubTypes.add(this.jRadioButtonSubTypesRestricted);
        this.jRadioButtonSubTypesRestricted.setText("Restrict to..");
        this.jButtonSubTypes.setText("...");
        this.jButtonSubTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonSubTypesActionPerformed(evt);
            }
        });
        GroupLayout jPanelDataSubTypesLayout = new GroupLayout(this.jPanelDataSubTypes);
        this.jPanelDataSubTypes.setLayout(jPanelDataSubTypesLayout);
        jPanelDataSubTypesLayout.setHorizontalGroup(jPanelDataSubTypesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSubTypesLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSubTypesAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSubTypesRestricted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSubTypes, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDataSubTypesLayout.setVerticalGroup(jPanelDataSubTypesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSubTypesLayout.createSequentialGroup().addGroup(jPanelDataSubTypesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonSubTypesAll).addComponent(this.jRadioButtonSubTypesRestricted).addComponent(this.jButtonSubTypes)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout jPanelDataLayout = new GroupLayout(this.jPanelData);
        this.jPanelData.setLayout(jPanelDataLayout);
        jPanelDataLayout.setHorizontalGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelDataFilters, -2, 356, -2).addGroup(jPanelDataLayout.createSequentialGroup().addComponent(this.jPanelDataQualifiers, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelDataSubTypes, -1, -1, Short.MAX_VALUE))).addGap(945, 945, 945)));
        jPanelDataLayout.setVerticalGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelDataFilters, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDataQualifiers, -2, -1, -2).addComponent(this.jPanelDataSubTypes, -2, -1, -2)).addContainerGap(61, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Data", this.jPanelData);
        this.jPanelAbnDisplay.setBorder(BorderFactory.createTitledBorder(null, "Abundance display", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupAbn.add(this.jRadioButtonAbnQ);
        this.jRadioButtonAbnQ.setText("Quantitative (derive counts)");
        this.buttonGroupAbn.add(this.jRadioButtonAbnSemiQ);
        this.jRadioButtonAbnSemiQ.setText("Semi-quantitative");
        this.buttonGroupAbn.add(this.jRadioButtonAbnMix);
        this.jRadioButtonAbnMix.setText("Quant/Semi-quant (mixed)");
        this.buttonGroupAbn.add(this.jRadioButtonAbnPA);
        this.jRadioButtonAbnPA.setText("Presence/Absence");
        GroupLayout jPanelAbnDisplayLayout = new GroupLayout(this.jPanelAbnDisplay);
        this.jPanelAbnDisplay.setLayout(jPanelAbnDisplayLayout);
        jPanelAbnDisplayLayout.setHorizontalGroup(jPanelAbnDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAbnDisplayLayout.createSequentialGroup().addContainerGap().addGroup(jPanelAbnDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAbnQ).addComponent(this.jRadioButtonAbnMix).addComponent(this.jRadioButtonAbnSemiQ).addComponent(this.jRadioButtonAbnPA)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelAbnDisplayLayout.setVerticalGroup(jPanelAbnDisplayLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAbnDisplayLayout.createSequentialGroup().addComponent(this.jRadioButtonAbnQ).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAbnMix).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAbnSemiQ).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAbnPA)));
        this.jCheckBoxSplits.setText("Use split factors for abundance calculation");
        this.jCheckBoxSplits.setToolTipText("Calculate the total count using coarse, medium and fine split factors (if set)");
        this.jTextFieldNormalWeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelTaxon.this.jTextFieldNormalWeightKeyTyped(evt);
            }
        });
        this.jLabel11.setText("g");
        this.jCheckBoxNormaliseWeight.setText("Normalise counts to standard sample weight:");
        GroupLayout jPanelAbnLayout = new GroupLayout(this.jPanelAbn);
        this.jPanelAbn.setLayout(jPanelAbnLayout);
        jPanelAbnLayout.setHorizontalGroup(jPanelAbnLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAbnLayout.createSequentialGroup().addContainerGap().addGroup(jPanelAbnLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAbnLayout.createSequentialGroup().addComponent(this.jCheckBoxNormaliseWeight, -2, 241, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldNormalWeight, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11)).addComponent(this.jCheckBoxSplits, -1, 362, Short.MAX_VALUE).addComponent(this.jPanelAbnDisplay, -2, -1, -2)).addContainerGap()));
        jPanelAbnLayout.setVerticalGroup(jPanelAbnLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAbnLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelAbnDisplay, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSplits).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelAbnLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAbnLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldNormalWeight, -2, -1, -2).addComponent(this.jLabel11)).addComponent(this.jCheckBoxNormaliseWeight)).addContainerGap(209, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Abundance", this.jPanelAbn);
        this.jPanelGroupingSubGroup.setBorder(BorderFactory.createTitledBorder(null, "Sub-Group by:", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSubGroup.add(this.jRadioButtonSubGroupSitu);
        this.jRadioButtonSubGroupSitu.setText("Situation");
        this.buttonGroupSubGroup.add(this.jRadioButtonSubGroupConf);
        this.jRadioButtonSubGroupConf.setText("Confidence");
        this.buttonGroupSubGroup.add(this.jRadioButtonSubGroupSpecType);
        this.jRadioButtonSubGroupSpecType.setText("Sub-types");
        this.buttonGroupSubGroup.add(this.jRadioButtonSubGroupNone);
        this.jRadioButtonSubGroupNone.setText("No sub-grouping");
        this.buttonGroupSubGroup.add(this.jRadioButtonSubGroupSizeFraction);
        this.jRadioButtonSubGroupSizeFraction.setText("Size fraction");
        GroupLayout jPanelGroupingSubGroupLayout = new GroupLayout(this.jPanelGroupingSubGroup);
        this.jPanelGroupingSubGroup.setLayout(jPanelGroupingSubGroupLayout);
        jPanelGroupingSubGroupLayout.setHorizontalGroup(jPanelGroupingSubGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupingSubGroupLayout.createSequentialGroup().addContainerGap().addGroup(jPanelGroupingSubGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addGroup(jPanelGroupingSubGroupLayout.createSequentialGroup().addGroup(jPanelGroupingSubGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSubGroupSizeFraction).addComponent(this.jRadioButtonSubGroupNone).addComponent(this.jRadioButtonSubGroupSitu).addComponent(this.jRadioButtonSubGroupConf).addComponent(this.jRadioButtonSubGroupSpecType)).addGap(0, 34, Short.MAX_VALUE))).addContainerGap()));
        jPanelGroupingSubGroupLayout.setVerticalGroup(jPanelGroupingSubGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupingSubGroupLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonSubGroupNone).addGap(5, 5, 5).addComponent(this.jSeparator2, -2, 6, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSubGroupSitu).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSubGroupConf).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSubGroupSpecType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSubGroupSizeFraction).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelGroupingGroup.setBorder(BorderFactory.createTitledBorder(null, "Group data by:", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupGroup.add(this.jRadioButtonGroupSpec);
        this.jRadioButtonGroupSpec.setText("Species");
        this.buttonGroupGroup.add(this.jRadioButtonGroupCat);
        this.jRadioButtonGroupCat.setText("Category");
        this.buttonGroupGroup.add(this.jRadioButtonGroupGroup);
        this.jRadioButtonGroupGroup.setText("Group");
        this.buttonGroupGroup.add(this.jRadioButtonGroupGenus);
        this.jRadioButtonGroupGenus.setText("Genus");
        this.buttonGroupGroup.add(this.jRadioButtonGroupSitu);
        this.jRadioButtonGroupSitu.setText("Situation (In situ/ Rw)");
        this.buttonGroupGroup.add(this.jRadioButtonGroupConf);
        this.jRadioButtonGroupConf.setText("Confidence");
        this.buttonGroupGroup.add(this.jRadioButtonGroupSubTypes);
        this.jRadioButtonGroupSubTypes.setText("Sub-types");
        this.buttonGroupGroup.add(this.jRadioButtonGroupCaving);
        this.jRadioButtonGroupCaving.setText("Caving");
        this.buttonGroupGroup.add(this.jRadioButtonGroupNone);
        this.jRadioButtonGroupNone.setText("None (panel total)");
        this.jRadioButtonGroupNone.setToolTipText("");
        GroupLayout jPanelGroupingGroupLayout = new GroupLayout(this.jPanelGroupingGroup);
        this.jPanelGroupingGroup.setLayout(jPanelGroupingGroupLayout);
        jPanelGroupingGroupLayout.setHorizontalGroup(jPanelGroupingGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupingGroupLayout.createSequentialGroup().addContainerGap().addGroup(jPanelGroupingGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonGroupGenus).addComponent(this.jRadioButtonGroupGroup).addComponent(this.jRadioButtonGroupSpec).addComponent(this.jRadioButtonGroupCat).addComponent(this.jRadioButtonGroupSitu).addComponent(this.jRadioButtonGroupConf).addComponent(this.jRadioButtonGroupCaving).addComponent(this.jRadioButtonGroupSubTypes).addComponent(this.jRadioButtonGroupNone)).addContainerGap(22, Short.MAX_VALUE)));
        jPanelGroupingGroupLayout.setVerticalGroup(jPanelGroupingGroupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupingGroupLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonGroupSpec).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupCat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupGroup).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupGenus).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupSitu).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupConf).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupCaving).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupSubTypes).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonGroupNone).addContainerGap(9, Short.MAX_VALUE)));
        GroupLayout jPanelGroupingLayout = new GroupLayout(this.jPanelGrouping);
        this.jPanelGrouping.setLayout(jPanelGroupingLayout);
        jPanelGroupingLayout.setHorizontalGroup(jPanelGroupingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupingLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelGroupingGroup, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelGroupingSubGroup, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)));
        jPanelGroupingLayout.linkSize(0, this.jPanelGroupingGroup, this.jPanelGroupingSubGroup);
        jPanelGroupingLayout.setVerticalGroup(jPanelGroupingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGroupingLayout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanelGroupingLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelGroupingSubGroup, -2, -1, -2).addComponent(this.jPanelGroupingGroup, -2, -1, -2)).addContainerGap(97, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Grouping", this.jPanelGrouping);
        this.jPanelStyleCurve.setBorder(BorderFactory.createTitledBorder(null, "Curve style", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupCurve.add(this.jRadioButtonPlotHist);
        this.jRadioButtonPlotHist.setText("Histogram");
        this.jRadioButtonPlotHist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonPlotHistActionPerformed(evt);
            }
        });
        this.buttonGroupCurve.add(this.jRadioButtonPlotSaw);
        this.jRadioButtonPlotSaw.setText("Sawtooth");
        this.jRadioButtonPlotSaw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonPlotSawActionPerformed(evt);
            }
        });
        this.buttonGroupCurve.add(this.jRadioButtonPlotNumbers);
        this.jRadioButtonPlotNumbers.setText("Numbers only");
        this.jRadioButtonPlotNumbers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonPlotNumbersActionPerformed(evt);
            }
        });
        this.jCheckBoxStratigraphicRange.setText("Stratigraphic range");
        this.buttonGroupCurve.add(this.jRadioButtonPlotCurve);
        this.jRadioButtonPlotCurve.setText("Curve");
        this.jRadioButtonPlotCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonPlotCurveActionPerformed(evt);
            }
        });
        this.jCheckBoxPlotSawtoothEnhanced.setText("Enhanced:");
        this.jSpinnerPlotSawtoothEnhanced.setModel(new SpinnerNumberModel(5, 2, 10, 1));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Justify"));
        this.buttonGroupStyleJustify.add(this.jRadioButtonJustifyLeft);
        this.jRadioButtonJustifyLeft.setText("Left");
        this.buttonGroupStyleJustify.add(this.jRadioButtonJustifyRight);
        this.jRadioButtonJustifyRight.setText("Right");
        this.buttonGroupStyleJustify.add(this.jRadioButtonJustifyCentre);
        this.jRadioButtonJustifyCentre.setText("Centre");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonJustifyLeft).addComponent(this.jRadioButtonJustifyRight)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jRadioButtonJustifyCentre).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonJustifyLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonJustifyRight).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonJustifyCentre)));
        GroupLayout jPanelStyleCurveLayout = new GroupLayout(this.jPanelStyleCurve);
        this.jPanelStyleCurve.setLayout(jPanelStyleCurveLayout);
        jPanelStyleCurveLayout.setHorizontalGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStyleCurveLayout.createSequentialGroup().addContainerGap().addGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxStratigraphicRange).addGroup(jPanelStyleCurveLayout.createSequentialGroup().addGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonPlotHist).addComponent(this.jRadioButtonPlotSaw)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStyleCurveLayout.createSequentialGroup().addComponent(this.jCheckBoxPlotSawtoothEnhanced).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerPlotSawtoothEnhanced, -2, -1, -2)).addGroup(jPanelStyleCurveLayout.createSequentialGroup().addComponent(this.jRadioButtonPlotNumbers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonPlotCurve))))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        jPanelStyleCurveLayout.setVerticalGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelStyleCurveLayout.createSequentialGroup().addGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanelStyleCurveLayout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(16, 16, 16)).addGroup(jPanelStyleCurveLayout.createSequentialGroup().addGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonPlotHist).addComponent(this.jRadioButtonPlotNumbers).addComponent(this.jRadioButtonPlotCurve)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelStyleCurveLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonPlotSaw).addComponent(this.jCheckBoxPlotSawtoothEnhanced).addComponent(this.jSpinnerPlotSawtoothEnhanced, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jCheckBoxStratigraphicRange).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.jPanelStyleCalculation.setBorder(BorderFactory.createTitledBorder(null, "Calculation", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupCalc.add(this.jRadioButtonCalcAbs);
        this.jRadioButtonCalcAbs.setText("Absolute abundance");
        this.buttonGroupCalc.add(this.jRadioButtonCalcRelative);
        this.jRadioButtonCalcRelative.setText("Relative abundance (% inner panel)");
        this.buttonGroupCalc.add(this.jRadioButtonCalcDiversity);
        this.jRadioButtonCalcDiversity.setText("Richness");
        this.buttonGroupCalc.add(this.jRadioButtonCalcRelativeOuter);
        this.jRadioButtonCalcRelativeOuter.setText("Relative abundance (% outer panel)");
        this.buttonGroupCalc.add(this.jRadioButtonCalcShannon);
        this.jRadioButtonCalcShannon.setText("Diversity (Shannon)");
        GroupLayout jPanelStyleCalculationLayout = new GroupLayout(this.jPanelStyleCalculation);
        this.jPanelStyleCalculation.setLayout(jPanelStyleCalculationLayout);
        jPanelStyleCalculationLayout.setHorizontalGroup(jPanelStyleCalculationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStyleCalculationLayout.createSequentialGroup().addContainerGap().addGroup(jPanelStyleCalculationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonCalcRelative).addComponent(this.jRadioButtonCalcRelativeOuter).addGroup(jPanelStyleCalculationLayout.createSequentialGroup().addComponent(this.jRadioButtonCalcDiversity).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonCalcShannon)).addComponent(this.jRadioButtonCalcAbs)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelStyleCalculationLayout.setVerticalGroup(jPanelStyleCalculationLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStyleCalculationLayout.createSequentialGroup().addComponent(this.jRadioButtonCalcAbs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCalcRelative).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonCalcRelativeOuter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelStyleCalculationLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonCalcDiversity).addComponent(this.jRadioButtonCalcShannon)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelStylePlot.setBorder(BorderFactory.createTitledBorder(null, "Plot type", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupPlotType.add(this.jRadioButtonTrackMulti);
        this.jRadioButtonTrackMulti.setText("Stacked curves (one column, many curves per column)");
        this.jRadioButtonTrackMulti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonTrackMultiActionPerformed(evt);
            }
        });
        this.buttonGroupPlotType.add(this.jRadioButtonTrackSingle);
        this.jRadioButtonTrackSingle.setText("Individual columns (many columns, one curve per column)");
        this.jRadioButtonTrackSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jRadioButtonTrackSingleActionPerformed(evt);
            }
        });
        GroupLayout jPanelStylePlotLayout = new GroupLayout(this.jPanelStylePlot);
        this.jPanelStylePlot.setLayout(jPanelStylePlotLayout);
        jPanelStylePlotLayout.setHorizontalGroup(jPanelStylePlotLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStylePlotLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanelStylePlotLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioButtonTrackSingle, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonTrackMulti))));
        jPanelStylePlotLayout.linkSize(0, this.jRadioButtonTrackMulti, this.jRadioButtonTrackSingle);
        jPanelStylePlotLayout.setVerticalGroup(jPanelStylePlotLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStylePlotLayout.createSequentialGroup().addComponent(this.jRadioButtonTrackSingle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonTrackMulti).addContainerGap(8, Short.MAX_VALUE)));
        GroupLayout jPanelStyleLayout = new GroupLayout(this.jPanelStyle);
        this.jPanelStyle.setLayout(jPanelStyleLayout);
        jPanelStyleLayout.setHorizontalGroup(jPanelStyleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStyleLayout.createSequentialGroup().addContainerGap().addGroup(jPanelStyleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStyleLayout.createSequentialGroup().addComponent(this.jPanelStyleCalculation, -1, -1, Short.MAX_VALUE).addGap(115, 115, 115)).addGroup(jPanelStyleLayout.createSequentialGroup().addComponent(this.jPanelStylePlot, -2, -1, -2).addContainerGap(49, Short.MAX_VALUE)).addGroup(jPanelStyleLayout.createSequentialGroup().addComponent(this.jPanelStyleCurve, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))));
        jPanelStyleLayout.setVerticalGroup(jPanelStyleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelStyleLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelStylePlot, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelStyleCalculation, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelStyleCurve, -2, 127, -2).addContainerGap(35, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Style", this.jPanelStyle);
        this.jPanelOptionsSort.setBorder(BorderFactory.createTitledBorder(null, "Sorting", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSort.add(this.jRadioButtonSortAlpha);
        this.jRadioButtonSortAlpha.setText("Alphabetical");
        this.buttonGroupSort.add(this.jRadioButtonSortFDO);
        this.jRadioButtonSortFDO.setText("First downhole occurrence");
        this.buttonGroupSort.add(this.jRadioButtonSortFUO);
        this.jRadioButtonSortFUO.setText("First uphole occurrence");
        GroupLayout jPanelOptionsSortLayout = new GroupLayout(this.jPanelOptionsSort);
        this.jPanelOptionsSort.setLayout(jPanelOptionsSortLayout);
        jPanelOptionsSortLayout.setHorizontalGroup(jPanelOptionsSortLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsSortLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsSortLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSortAlpha).addComponent(this.jRadioButtonSortFDO).addComponent(this.jRadioButtonSortFUO)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsSortLayout.setVerticalGroup(jPanelOptionsSortLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsSortLayout.createSequentialGroup().addComponent(this.jRadioButtonSortAlpha).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSortFDO).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSortFUO).addGap(0, 0, Short.MAX_VALUE)));
        this.jPanelOptionsScale.setBorder(BorderFactory.createTitledBorder(null, "Horizontal scale", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel1.setText("Scale limit (count or %):");
        this.jTextFieldCutoff.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelTaxon.this.jTextFieldCutoffKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Default column width:");
        this.jTextFieldTaxaColWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelTaxon.this.jTextFieldTaxaColWidthKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Minimum column width:");
        this.jTextFieldMinWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelTaxon.this.jTextFieldMinWidthKeyTyped(evt);
            }
        });
        this.jLabel5.setText("mm");
        this.jLabel6.setText("mm");
        GroupLayout jPanelOptionsScaleLayout = new GroupLayout(this.jPanelOptionsScale);
        this.jPanelOptionsScale.setLayout(jPanelOptionsScaleLayout);
        jPanelOptionsScaleLayout.setHorizontalGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsScaleLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelOptionsScaleLayout.createSequentialGroup().addGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldMinWidth, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldTaxaColWidth, GroupLayout.Alignment.LEADING, -1, 35, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel5))).addComponent(this.jTextFieldCutoff)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsScaleLayout.setVerticalGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsScaleLayout.createSequentialGroup().addGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldCutoff, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldTaxaColWidth, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelOptionsScaleLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldMinWidth, -2, -1, -2).addComponent(this.jLabel6)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxShowFlags.setText("Show flags for Rw, C, ? etc");
        this.jCheckBoxGrid.setText("Show grid");
        this.jPanelOptionsImages.setBorder(BorderFactory.createTitledBorder(null, "Images column", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxShowImages.setText("Show images column");
        this.jCheckBoxShowImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jCheckBoxShowImagesActionPerformed(evt);
            }
        });
        this.jCheckBoxShowImagesMarkers.setText("Use only markers");
        this.jTextFieldImageWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelTaxon.this.jTextFieldImageWidthKeyTyped(evt);
            }
        });
        this.jLabel9.setText("Column width:");
        this.jLabel10.setText("mm");
        GroupLayout jPanelOptionsImagesLayout = new GroupLayout(this.jPanelOptionsImages);
        this.jPanelOptionsImages.setLayout(jPanelOptionsImagesLayout);
        jPanelOptionsImagesLayout.setHorizontalGroup(jPanelOptionsImagesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsImagesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsImagesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsImagesLayout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldImageWidth, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10)).addGroup(jPanelOptionsImagesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jCheckBoxShowImagesMarkers, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxShowImages, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsImagesLayout.setVerticalGroup(jPanelOptionsImagesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsImagesLayout.createSequentialGroup().addComponent(this.jCheckBoxShowImages).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxShowImagesMarkers).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelOptionsImagesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldImageWidth, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel10)).addGap(0, 0, Short.MAX_VALUE)));
        this.jCheckBoxClearEmptyTracks.setText("Show tracks which are outside panel range");
        this.jCheckBoxShowAbundance.setText("Show abundance labels");
        this.jPanelOptionsColours.setBorder(BorderFactory.createTitledBorder(null, "Colours", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel7.setText("Default:");
        this.jButtonColour.setText("...");
        this.jButtonColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonColourActionPerformed(evt);
            }
        });
        this.jTextFieldColour.setEditable(false);
        this.jCheckBoxColoursSuites.setText("Use suite colours");
        this.jCheckBoxColoursLabels.setText("Colour labels");
        this.jCheckBoxColoursInherit.setText("Inherit filter colour");
        GroupLayout jPanelOptionsColoursLayout = new GroupLayout(this.jPanelOptionsColours);
        this.jPanelOptionsColours.setLayout(jPanelOptionsColoursLayout);
        jPanelOptionsColoursLayout.setHorizontalGroup(jPanelOptionsColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsColoursLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxColoursInherit).addGroup(jPanelOptionsColoursLayout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldColour, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonColour, -2, 30, -2)).addComponent(this.jCheckBoxColoursLabels).addComponent(this.jCheckBoxColoursSuites)).addContainerGap(11, Short.MAX_VALUE)));
        jPanelOptionsColoursLayout.setVerticalGroup(jPanelOptionsColoursLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsColoursLayout.createSequentialGroup().addGroup(jPanelOptionsColoursLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldColour, -2, -1, -2).addComponent(this.jButtonColour)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxColoursInherit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxColoursSuites).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxColoursLabels)));
        GroupLayout jPanelOptionsLayout = new GroupLayout(this.jPanelOptions);
        this.jPanelOptions.setLayout(jPanelOptionsLayout);
        jPanelOptionsLayout.setHorizontalGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsLayout.createSequentialGroup().addComponent(this.jPanelOptionsSort, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelOptionsImages, -1, -1, Short.MAX_VALUE)).addGroup(jPanelOptionsLayout.createSequentialGroup().addComponent(this.jPanelOptionsScale, -2, 204, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelOptionsColours, -1, -1, Short.MAX_VALUE))).addContainerGap()).addGroup(jPanelOptionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxGrid).addComponent(this.jCheckBoxClearEmptyTracks).addComponent(this.jCheckBoxShowFlags).addComponent(this.jCheckBoxShowAbundance)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelOptionsLayout.setVerticalGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelOptionsLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelOptionsSort, -1, 0, Short.MAX_VALUE).addComponent(this.jPanelOptionsImages, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanelOptionsColours, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelOptionsScale, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxShowFlags, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxShowAbundance).addGap(2, 2, 2).addComponent(this.jCheckBoxClearEmptyTracks).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxGrid).addContainerGap(45, Short.MAX_VALUE)));
        jPanelOptionsLayout.linkSize(1, this.jCheckBoxClearEmptyTracks, this.jCheckBoxGrid, this.jCheckBoxShowFlags);
        this.jTabbedPane1.addTab("Options", this.jPanelOptions);
        this.jPanelHeaderNames.setBorder(BorderFactory.createTitledBorder(null, "Taxon names", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxHdrCat.setText("Category");
        this.jCheckBoxHdrAuth.setText("Author");
        GroupLayout jPanelHeaderNamesLayout = new GroupLayout(this.jPanelHeaderNames);
        this.jPanelHeaderNames.setLayout(jPanelHeaderNamesLayout);
        jPanelHeaderNamesLayout.setHorizontalGroup(jPanelHeaderNamesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderNamesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHeaderNamesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxHdrCat).addComponent(this.jCheckBoxHdrAuth)).addContainerGap(23, Short.MAX_VALUE)));
        jPanelHeaderNamesLayout.setVerticalGroup(jPanelHeaderNamesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderNamesLayout.createSequentialGroup().addComponent(this.jCheckBoxHdrCat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxHdrAuth)));
        this.jPanelHeaderAges.setBorder(BorderFactory.createTitledBorder(null, "Display age and unit", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jButtonClearScheme.setText("Clear");
        this.jButtonClearScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonClearScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonClearSchemeActionPerformed(evt);
            }
        });
        this.jButtonClearCmpStd.setText("Clear");
        this.jButtonClearCmpStd.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonClearCmpStd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonClearCmpStdActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Composite:");
        this.jLabel8.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jButtonScheme.setText("...");
        this.jButtonScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonSchemeActionPerformed(evt);
            }
        });
        this.jTextFieldCmpStd.setEditable(false);
        this.jTextFieldCmpStd.setBackground(new Color(255, 255, 204));
        this.jCheckBoxSchAbrs.setText("Use abbreviations");
        this.jButtonCmpStd.setText("...");
        this.jButtonCmpStd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonCmpStdActionPerformed(evt);
            }
        });
        GroupLayout jPanelHeaderAgesLayout = new GroupLayout(this.jPanelHeaderAges);
        this.jPanelHeaderAges.setLayout(jPanelHeaderAgesLayout);
        jPanelHeaderAgesLayout.setHorizontalGroup(jPanelHeaderAgesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderAgesLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHeaderAgesLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderAgesLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldScheme).addComponent(this.jCheckBoxSchAbrs).addComponent(this.jTextFieldCmpStd, -2, 176, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderAgesLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelHeaderAgesLayout.createSequentialGroup().addComponent(this.jButtonCmpStd, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearCmpStd, -1, -1, Short.MAX_VALUE)).addGroup(jPanelHeaderAgesLayout.createSequentialGroup().addComponent(this.jButtonScheme, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearScheme))).addContainerGap(15, Short.MAX_VALUE)));
        jPanelHeaderAgesLayout.setVerticalGroup(jPanelHeaderAgesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelHeaderAgesLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanelHeaderAgesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCmpStd, -2, -1, -2).addComponent(this.jButtonCmpStd).addComponent(this.jButtonClearCmpStd).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderAgesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jButtonScheme).addComponent(this.jButtonClearScheme).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSchAbrs).addContainerGap()));
        this.jPanelHeaderHighlight.setBorder(BorderFactory.createTitledBorder(null, "Highlight taxon group", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jTextFieldHighlightGroup.setEditable(false);
        this.jTextFieldHighlightGroup.setToolTipText("Colour heading text for species in this group");
        this.jButtonHighlightGroup.setText("...");
        this.jButtonHighlightGroup.setToolTipText("Select a taxon group to highlight");
        this.jButtonHighlightGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonHighlightGroupActionPerformed(evt);
            }
        });
        this.jButtonHighlightColour.setText("...");
        this.jButtonHighlightColour.setToolTipText("Select highlight colour");
        this.jButtonHighlightColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonHighlightColourActionPerformed(evt);
            }
        });
        this.jTextFieldHighlightColour.setEditable(false);
        this.jTextFieldHighlightColour.setToolTipText("Colour of the highlighted group");
        this.jButtonHighlightGroupClear.setText("Clear");
        this.jButtonHighlightGroupClear.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonHighlightGroupClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonHighlightGroupClearActionPerformed(evt);
            }
        });
        this.jLabel12.setText("Group:");
        this.jLabel13.setText("Colour:");
        GroupLayout jPanelHeaderHighlightLayout = new GroupLayout(this.jPanelHeaderHighlight);
        this.jPanelHeaderHighlight.setLayout(jPanelHeaderHighlightLayout);
        jPanelHeaderHighlightLayout.setHorizontalGroup(jPanelHeaderHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderHighlightLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHeaderHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderHighlightLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldHighlightGroup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHighlightGroup, -2, 30, -2)).addGroup(jPanelHeaderHighlightLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldHighlightColour, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHighlightColour, -2, 30, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHighlightGroupClear).addContainerGap()));
        jPanelHeaderHighlightLayout.setVerticalGroup(jPanelHeaderHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderHighlightLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHeaderHighlightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jTextFieldHighlightGroup, -2, -1, -2).addComponent(this.jButtonHighlightGroup).addComponent(this.jButtonHighlightGroupClear)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelHeaderHighlightLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelHeaderHighlightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHighlightColour, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel13)).addComponent(this.jTextFieldHighlightColour, -2, 23, -2)).addContainerGap(17, Short.MAX_VALUE)));
        GroupLayout jPanelHeaderLayout = new GroupLayout(this.jPanelHeader);
        this.jPanelHeader.setLayout(jPanelHeaderLayout);
        jPanelHeaderLayout.setHorizontalGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderLayout.createSequentialGroup().addContainerGap().addGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelHeaderAges, -1, -1, Short.MAX_VALUE).addGroup(jPanelHeaderLayout.createSequentialGroup().addComponent(this.jPanelHeaderNames, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanelHeaderHighlight, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelHeaderLayout.setVerticalGroup(jPanelHeaderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelHeaderLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelHeaderNames, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelHeaderAges, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelHeaderHighlight, -2, -1, -2).addContainerGap(68, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Header", this.jPanelHeader);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Intervals", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jLabel14.setText("Background shading of intervals from scheme:");
        this.jTextFieldInterpSch.setEditable(false);
        this.jTextFieldInterpSch.setBackground(new Color(255, 255, 204));
        this.jButtonInterpSchClear.setText("Clear");
        this.jButtonInterpSchClear.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonInterpSchClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonInterpSchClearActionPerformed(evt);
            }
        });
        this.jButtonInterpSchSelect.setText("...");
        this.jButtonInterpSchSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonInterpSchSelectActionPerformed(evt);
            }
        });
        this.jSliderIGDDensity.setMaximum(10);
        this.jSliderIGDDensity.setMinimum(1);
        this.jSliderIGDDensity.setValue(4);
        this.jLabel15.setText("Density:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel14).addGap(0, 105, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderIGDDensity, -2, 0, Short.MAX_VALUE)).addComponent(this.jTextFieldInterpSch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInterpSchSelect, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInterpSchClear))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldInterpSch, -2, -1, -2).addComponent(this.jButtonInterpSchClear).addComponent(this.jButtonInterpSchSelect)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderIGDDensity, -2, -1, -2).addComponent(this.jLabel15)).addContainerGap(13, Short.MAX_VALUE)));
        this.jCheckBoxInterpEvents.setText("Show events");
        GroupLayout jPanelInterpLayout = new GroupLayout(this.jPanelInterp);
        this.jPanelInterp.setLayout(jPanelInterpLayout);
        jPanelInterpLayout.setHorizontalGroup(jPanelInterpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInterpLayout.createSequentialGroup().addContainerGap().addGroup(jPanelInterpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInterpLayout.createSequentialGroup().addComponent(this.jCheckBoxInterpEvents).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelInterpLayout.setVerticalGroup(jPanelInterpLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInterpLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxInterpEvents).addContainerGap(222, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Interpretations", this.jPanelInterp);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Outer Panel", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 205)));
        this.jButtonOuterPanel.setText("...");
        this.jButtonOuterPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxon.this.jButtonOuterPanelActionPerformed(evt);
            }
        });
        this.jLabelOuterPanel.setFont(new Font("Tahoma", 1, 11));
        this.jLabelOuterPanel.setText("jLabel16");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabelOuterPanel, -2, 317, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOuterPanel, -2, 30, -2).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOuterPanel).addComponent(this.jLabelOuterPanel)));
        this.buttonGroupEdit.add(this.jRadioButtonEditInner);
        this.jRadioButtonEditInner.setText("Inner");
        this.buttonGroupEdit.add(this.jRadioButtonEditOuter);
        this.jRadioButtonEditOuter.setText("Outer");
        this.jLabelScope.setText("Scope:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelScope).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonEditInner).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonEditOuter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING, -2, 383, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1, -2, 422, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonEditOuter).addComponent(this.jRadioButtonEditInner).addComponent(this.jLabelScope)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK))).addContainerGap(12, Short.MAX_VALUE)));
        this.pack();
    }

    private void enableSubGrouping(boolean enable) {
        this.jRadioButtonSubGroupConf.setEnabled(enable);
        this.jRadioButtonSubGroupSitu.setEnabled(enable);
        this.jRadioButtonSubGroupSpecType.setEnabled(enable);
        this.jRadioButtonSubGroupSizeFraction.setEnabled(enable);
    }

    private void jButtonFilterSetActionPerformed(ActionEvent evt) {
        this.selectFilterSet();
        this.setFilterFields();
    }

    private void jButtonFilterGroupActionPerformed(ActionEvent evt) {
        this.selectFilterGroup();
        this.setFilterFields();
    }

    private void jButtonFilterCatActionPerformed(ActionEvent evt) {
        this.selectFilterCat();
        this.setFilterFields();
    }

    private void jButtonFilterSpeciesActionPerformed(ActionEvent evt) {
        this.selectFilterSpec();
        this.setFilterFields();
    }

    private void jRadioButtonFilterSetActionPerformed(ActionEvent evt) {
        if (this.filter_set == null) {
            this.selectFilterSet();
        }
        this.setFilterFields();
    }

    private void jRadioButtonFilterGroupActionPerformed(ActionEvent evt) {
        if (this.filter_group == null) {
            this.selectFilterGroup();
        }
        this.setFilterFields();
    }

    private void jRadioButtonFilterCategoryActionPerformed(ActionEvent evt) {
        if (this.filter_cat == null) {
            this.selectFilterCat();
        }
        this.setFilterFields();
    }

    private void jRadioButtonFilterSpeciesActionPerformed(ActionEvent evt) {
        if (this.filter_spec == null) {
            this.selectFilterSpec();
        }
        this.setFilterFields();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int opt;
        String msg;
        int opt2;
        if (this.buttonGroupEdit.getSelection() == this.jRadioButtonEditOuter.getModel() && this.panel.getProperties() != this.panelGroup.defaultProperties) {
            int opt3 = JOptionPane.showConfirmDialog(this, "Discard changes and revert to default outer panel properties?", this.getTitle(), 0);
            if (opt3 != 0) {
                return;
            }
            this.panel.setProperties(this.panelGroup.defaultProperties);
            this.setOK();
            return;
        }
        if (this.jRadioButtonFilterCategory.isSelected() && this.filter_cat == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter category", this.getTitle(), 2);
            this.jTabbedPane1.setSelectedComponent(this.jPanelData);
            return;
        }
        if (this.jRadioButtonFilterGroup.isSelected() && this.filter_group == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter group", this.getTitle(), 2);
            this.jTabbedPane1.setSelectedComponent(this.jPanelData);
            return;
        }
        if (this.jRadioButtonFilterSet.isSelected() && this.filter_set == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter group set", this.getTitle(), 2);
            this.jTabbedPane1.setSelectedComponent(this.jPanelData);
            return;
        }
        if (this.jRadioButtonFilterSpecies.isSelected() && this.filter_spec == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter species", this.getTitle(), 2);
            this.jTabbedPane1.setSelectedComponent(this.jPanelData);
            return;
        }
        if (this.jRadioButtonGroupGroup.isSelected() && !this.jRadioButtonFilterSet.isSelected() && !this.jRadioButtonFilterGroup.isSelected() && this.panelGroup.filter_set == null) {
            JOptionPane.showMessageDialog(this, "You must select a filter set or group if you want to group data by group.", this.getTitle(), 2);
            this.jTabbedPane1.setSelectedComponent(this.jPanelData);
            return;
        }
        if (this.jButtonFilterSpecies.isSelected() && this.filter_spec != null) {
            try {
                if (!this.panel.checkSpecFilter()) {
                    JOptionPane.showMessageDialog(this, "The filter species must occur in the well data.", this.getTitle(), 2);
                    this.jTabbedPane1.setSelectedComponent(this.jPanelData);
                    return;
                }
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                SB.showStackError((String)"SQL Error", (SQLException)sql);
            }
        }
        if (!(!this.jRadioButtonAbnSemiQ.isSelected() || this.jRadioButtonPlotHist.isSelected() && this.jRadioButtonJustifyCentre.isSelected() && this.jRadioButtonTrackSingle.isSelected() && this.jRadioButtonCalcAbs.isSelected() || (opt2 = JOptionPane.showConfirmDialog(this, msg = "Set options for semi-quant display?", this.getTitle(), 0)) != 0)) {
            this.jRadioButtonPlotHist.setSelected(true);
            this.jRadioButtonJustifyCentre.setSelected(true);
            this.jRadioButtonCalcAbs.setSelected(true);
            this.jRadioButtonTrackSingle.setSelected(true);
            this.jRadioButtonSubGroupNone.setSelected(true);
            this.jCheckBoxShowAbundance.setSelected(false);
        }
        if ((this.jRadioButtonJustifyCentre.isSelected() || this.jRadioButtonPlotNumbers.isSelected()) && this.jRadioButtonTrackMulti.isSelected()) {
            boolean numbers = this.jRadioButtonPlotNumbers.isSelected();
            String msg2 = "You cannot plot stacked " + (numbers ? "numbers" : "and centre-justified") + ".\n";
            int option = JOptionPane.showConfirmDialog(this, msg2 = msg2 + "Change style to " + (numbers ? "historgram?" : "left-justified?") + "\n(Press 'No' to change plot type to individual.)\n ", this.getTitle(), 1);
            if (option == 2 || option == -1) {
                return;
            }
            if (option == 0) {
                if (numbers) {
                    this.jRadioButtonPlotHist.setSelected(true);
                } else {
                    this.jRadioButtonJustifyLeft.setSelected(true);
                }
            } else {
                this.jRadioButtonTrackSingle.setSelected(true);
            }
        }
        if (this.jRadioButtonPlotCurve.isSelected() && this.jRadioButtonJustifyCentre.isSelected()) {
            JOptionPane.showMessageDialog(this, "You cannot plot centre-justified curve.\nChanged justification to Left.", this.getTitle(), 2);
            this.jRadioButtonJustifyLeft.setSelected(true);
        }
        boolean dataChange = false;
        if (this.panel.filter_set != null && this.filter_set != this.panel.filter_set) {
            this.panel.filter_set.deleteObserver((Observer)this.panel);
        }
        if (this.panel.setFilterSet(this.jRadioButtonFilterSet.isSelected() ? this.filter_set : null)) {
            dataChange = true;
        }
        if (this.panel.filter_set != null) {
            this.filter_set.addObserver((Observer)this.panel);
        }
        if (this.panel.filter_group != null && this.filter_group != this.panel.filter_group) {
            this.panel.filter_group.deleteObserver((Observer)this.panel);
        }
        if (this.panel.setFilterGroup(this.jRadioButtonFilterGroup.isSelected() ? this.filter_group : null)) {
            dataChange = true;
        }
        if (this.panel.filter_group != null) {
            this.filter_group.addObserver((Observer)this.panel);
        }
        if (this.panel.setFilterSpec(this.jRadioButtonFilterSpecies.isSelected() ? this.filter_spec : null)) {
            dataChange = true;
        }
        if (this.panel.setFilterCat(this.jRadioButtonFilterCategory.isSelected() ? this.filter_cat : null, this.jCheckBoxIncludeSubCats.isSelected())) {
            dataChange = true;
        }
        this.prop.includeRw = this.jCheckBoxIncludeRw.isSelected();
        this.prop.includeCv = this.jCheckBoxIncludeCv.isSelected();
        this.prop.includeQ = this.jCheckBoxIncludeQ.isSelected();
        this.prop.includeUnqualified = this.jCheckBoxIncludeUnqualified.isSelected();
        if (this.jRadioButtonSubTypesAll.isSelected()) {
            this.prop.subTypes = null;
        }
        this.prop.abn_style = this.jRadioButtonAbnQ.isSelected() ? PanelTaxonProperties.Abundance.Q : (this.jRadioButtonAbnSemiQ.isSelected() ? PanelTaxonProperties.Abundance.SEMIQ : (this.jRadioButtonAbnPA.isSelected() ? PanelTaxonProperties.Abundance.PA : PanelTaxonProperties.Abundance.MIX));
        this.prop.useSplits = this.jCheckBoxSplits.isSelected();
        this.prop.normaliseWeight = this.jCheckBoxNormaliseWeight.isSelected();
        if (!this.jTextFieldNormalWeight.getText().trim().isEmpty()) {
            this.prop.normalWeight = Float.parseFloat(this.jTextFieldNormalWeight.getText());
        }
        this.prop.group = this.jRadioButtonGroupCat.isSelected() ? PanelTaxonProperties.Group.CAT : (this.jRadioButtonGroupGenus.isSelected() ? PanelTaxonProperties.Group.GENUS : (this.jRadioButtonGroupGroup.isSelected() ? PanelTaxonProperties.Group.GROUP : (this.jRadioButtonGroupSitu.isSelected() ? PanelTaxonProperties.Group.SITU : (this.jRadioButtonGroupSpec.isSelected() ? PanelTaxonProperties.Group.SPEC : (this.jRadioButtonGroupConf.isSelected() ? PanelTaxonProperties.Group.CONF : (this.jRadioButtonGroupCaving.isSelected() ? PanelTaxonProperties.Group.CV : (this.jRadioButtonGroupNone.isSelected() ? PanelTaxonProperties.Group.TOTAL : PanelTaxonProperties.Group.SUBTYPE)))))));
        this.prop.subgroup = this.jRadioButtonSubGroupSitu.isSelected() ? PanelTaxonProperties.SubGroup.SITU : (this.jRadioButtonSubGroupConf.isSelected() ? PanelTaxonProperties.SubGroup.CONF : (this.jRadioButtonSubGroupSpecType.isSelected() ? PanelTaxonProperties.SubGroup.SUBTYPE : (this.jRadioButtonSubGroupSizeFraction.isSelected() ? PanelTaxonProperties.SubGroup.CMF : PanelTaxonProperties.SubGroup.NONE)));
        this.prop.track_style = this.jRadioButtonTrackSingle.isSelected() ? PanelTaxonProperties.Track.SINGLE : PanelTaxonProperties.Track.MULTI;
        this.prop.plot_style = this.getPlotStyle();
        this.prop.stratRange = this.jCheckBoxStratigraphicRange.isSelected() && this.prop.track_style == PanelTaxonProperties.Track.SINGLE;
        this.prop.sawtoothEnhanced = this.jCheckBoxPlotSawtoothEnhanced.isSelected();
        this.prop.sawtoothEnhancement = (Integer)this.jSpinnerPlotSawtoothEnhanced.getModel().getValue();
        this.prop.calc_style = this.jRadioButtonCalcAbs.isSelected() ? PanelTaxonProperties.Calc.ABS : (this.jRadioButtonCalcRelative.isSelected() ? PanelTaxonProperties.Calc.RELATIVE : (this.jRadioButtonCalcRelativeOuter.isSelected() ? PanelTaxonProperties.Calc.RELATIVE_OUTER : (this.jRadioButtonCalcShannon.isSelected() ? PanelTaxonProperties.Calc.SHANNON : PanelTaxonProperties.Calc.RICHNESS)));
        this.prop.justify = this.jRadioButtonJustifyCentre.isSelected() || this.prop.plot_style == PanelTaxonProperties.Plot.NUMBERS ? PanelTaxonProperties.Justify.CENTRE : (this.jRadioButtonJustifyRight.isSelected() ? PanelTaxonProperties.Justify.RIGHT : PanelTaxonProperties.Justify.LEFT);
        this.prop.sortType = this.jRadioButtonSortAlpha.isSelected() ? 3 : (this.jRadioButtonSortFDO.isSelected() ? 0 : 1);
        String cutoffString = this.jTextFieldCutoff.getText().isEmpty() ? "0" : this.jTextFieldCutoff.getText().trim();
        float cutoff = Float.parseFloat(cutoffString);
        if (cutoff < 5.0f) {
            cutoff = 5.0f;
        }
        if (this.jRadioButtonCalcRelative.isSelected() && cutoff > 100.0f) {
            cutoff = 100.0f;
        }
        this.prop.cutoff = cutoff;
        String colWidthString = this.jTextFieldTaxaColWidth.getText().isEmpty() ? "0" : this.jTextFieldTaxaColWidth.getText().trim();
        float colWidth = Float.parseFloat(colWidthString);
        if (colWidth < 5.0f) {
            colWidth = 5.0f;
        }
        this.prop.maxWidth = colWidth;
        String minWidthString = this.jTextFieldMinWidth.getText().isEmpty() ? "0" : this.jTextFieldMinWidth.getText().trim();
        float minWidth = Float.parseFloat(minWidthString);
        if (minWidth < 3.0f) {
            minWidth = 3.0f;
        }
        this.prop.minWidth = minWidth;
        this.prop.setScale();
        this.prop.colour = this.jTextFieldColour.getBackground();
        this.prop.colourLabels = this.jCheckBoxColoursLabels.isSelected();
        this.prop.colourSuites = this.jCheckBoxColoursSuites.isSelected();
        this.prop.inheritFilterColour = this.jCheckBoxColoursInherit.isSelected();
        this.prop.showFlags = this.jCheckBoxShowFlags.isSelected();
        this.prop.showAbundance = this.jCheckBoxShowAbundance.isSelected();
        this.prop.grid = this.jCheckBoxGrid.isSelected();
        this.prop.clearEmptyTracks = !this.jCheckBoxClearEmptyTracks.isSelected();
        this.prop.showImages = this.jCheckBoxShowImages.isSelected();
        this.prop.filterMkrImages = this.jCheckBoxShowImagesMarkers.isSelected();
        float imgWidth = Float.parseFloat(this.jTextFieldImageWidth.getText());
        if (imgWidth < 20.0f) {
            imgWidth = 20.0f;
        } else if (imgWidth > 150.0f) {
            imgWidth = 150.0f;
        }
        this.prop.imageWidth = imgWidth;
        this.prop.hdr_cat = this.jCheckBoxHdrCat.isSelected();
        this.prop.hdr_author = this.jCheckBoxHdrAuth.isSelected();
        this.prop.schAbrs = this.jCheckBoxSchAbrs.isSelected();
        this.prop.highlightColour = this.jTextFieldHighlightColour.getBackground();
        float sliderval = this.jSliderIGDDensity.getValue();
        this.prop.interpShadingDensity = sliderval / 10.0f;
        this.prop.drawEvents = this.jCheckBoxInterpEvents.isSelected();
        try {
            this.prop.verify(this.panel.getBlock().well, false, this.panelGroup);
        }
        catch (InvalidTaxonFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            this.jTabbedPane1.setSelectedIndex(e.tab);
            return;
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
            return;
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
            return;
        }
        if (!(this.prop.includeUnqualified || this.prop.includeCv || this.prop.includeQ || this.prop.includeRw || (opt = JOptionPane.showConfirmDialog(this, "Warning: current panel settings exclude all data.\nDo you want to include unqualified occurrences?", this.getTitle(), 0)) != 0)) {
            this.prop.includeUnqualified = true;
        }
        tab = this.jTabbedPane1.getSelectedIndex();
        if (!this.prop.equals(this.panel.getProperties())) {
            if (this.buttonGroupEdit.getSelection() == null) {
                this.panelGroup.setDefaultProperties(this.prop);
            } else if (this.buttonGroupEdit.getSelection() == this.jRadioButtonEditOuter.getModel()) {
                if (this.panel.getProperties() != this.panelGroup.defaultProperties) {
                    this.panel.setProperties(this.panelGroup.defaultProperties);
                } else {
                    this.panelGroup.setDefaultProperties(this.prop);
                }
            } else if (this.buttonGroupEdit.getSelection() == this.jRadioButtonEditInner.getModel()) {
                this.panel.setProperties(this.prop);
            } else assert (false);
            this.prop.encode(this.sbdb);
            this.setOK();
        } else if (dataChange) {
            System.out.println("Changes to panel data only");
            this.setOK();
        } else {
            System.out.println("No changes to Properties object");
            this.dispose();
        }
    }

    private void jTextFieldCutoffKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldCutoff, (int)5, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTaxaColWidthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTaxaColWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldMinWidthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldMinWidth, (int)2, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        this.chooseColour(this.jTextFieldColour);
    }

    private void chooseColour(JTextField field) {
        Color colour = field.getBackground();
        if ((colour = JColorChooser.showDialog(this, "Select Colour", colour)) != null) {
            field.setBackground(colour);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogpaneltaxon.html");
    }

    private void jRadioButtonTrackSingleActionPerformed(ActionEvent evt) {
        this.enableSubGrouping(true);
    }

    private void jRadioButtonTrackMultiActionPerformed(ActionEvent evt) {
        this.jRadioButtonSubGroupNone.setSelected(true);
        this.enableSubGrouping(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonCmpStdActionPerformed(ActionEvent evt) {
        try {
            DialogSelectCmpStd dialog = new DialogSelectCmpStd(this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && dialog.selection.getStdID() != this.prop.cmpStdID) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.prop.cmpStdID = dialog.selection.getStdID();
                dialog.selection.loadEvents();
                this.jTextFieldCmpStd.setText(dialog.selection.getName());
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonClearCmpStdActionPerformed(ActionEvent evt) {
        this.prop.cmpStdID = -1;
        this.jTextFieldCmpStd.setText("");
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        this.selectScheme(true);
    }

    private void jButtonClearSchemeActionPerformed(ActionEvent evt) {
        this.prop.schID = -1;
        this.jTextFieldScheme.setText("");
    }

    private void jRadioButtonFilterAllActionPerformed(ActionEvent evt) {
        this.setFilterFields();
    }

    private void jTextFieldImageWidthKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldImageWidth, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxShowImagesActionPerformed(ActionEvent evt) {
        boolean b = this.jCheckBoxShowImages.isSelected();
        this.jCheckBoxShowImagesMarkers.setEnabled(b);
        this.jTextFieldImageWidth.setEnabled(b);
        this.jLabel9.setEnabled(b);
        this.jLabel10.setEnabled(b);
    }

    private void jTextFieldNormalWeightKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldNormalWeight, (int)6, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHighlightColourActionPerformed(ActionEvent evt) {
        this.chooseColour(this.jTextFieldHighlightColour);
    }

    private void jButtonHighlightGroupActionPerformed(ActionEvent evt) {
        try {
            ArrayList groups = new ArrayList(this.sbdb.getTxGroups());
            Collections.sort(groups);
            DialogList dialog = new DialogList(this, true, "Select Group", this.sbdb, groups, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                TxGroup highGroup;
                this.prop.highlightGroup = highGroup = (TxGroup)dialog.selection;
                this.jTextFieldHighlightGroup.setText(highGroup.toString());
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"Error", (SQLException)sql);
        }
    }

    private void jButtonHighlightGroupClearActionPerformed(ActionEvent evt) {
        this.prop.highlightGroup = null;
        this.jTextFieldHighlightGroup.setText("");
    }

    private void jButtonSubTypesActionPerformed(ActionEvent evt) {
        try {
            LinkedList<String> specTypes = new LinkedList<String>();
            Iterator it = this.sbdb.getSpecTypeIterator();
            while (it.hasNext()) {
                specTypes.add((String)it.next());
            }
            DialogList dialog = new DialogList(this, true, "Select Sub-Types", this.sbdb, specTypes, true, true);
            dialog.setLocationRelativeTo(this);
            if (this.prop.subTypes != null) {
                LinkedList<String> selected = new LinkedList<String>();
                Iterator i$ = this.prop.subTypes.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    selected.add(this.sbdb.getSpecType(i));
                }
                dialog.setSelectedItems(selected);
            }
            dialog.setVisible(true);
            if (dialog.selected != null && !dialog.selected.isEmpty()) {
                if (this.prop.subTypes == null) {
                    this.prop.subTypes = new LinkedList();
                }
                this.prop.subTypes.clear();
                for (Object o : dialog.selected) {
                    this.prop.subTypes.add(this.sbdb.getSpecType((String)o));
                }
            }
            this.jRadioButtonSubTypesRestricted.setSelected(this.prop.subTypes != null && !this.prop.subTypes.isEmpty());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jRadioButtonPlotSawActionPerformed(ActionEvent evt) {
        this.enableSawtoothEnhanced();
    }

    private void jRadioButtonPlotCurveActionPerformed(ActionEvent evt) {
        this.enableSawtoothEnhanced();
    }

    private void jRadioButtonPlotHistActionPerformed(ActionEvent evt) {
        this.enableSawtoothEnhanced();
    }

    private void jRadioButtonPlotNumbersActionPerformed(ActionEvent evt) {
        this.enableSawtoothEnhanced();
    }

    private void jButtonInterpSchSelectActionPerformed(ActionEvent evt) {
        this.selectScheme(false);
    }

    private void jButtonInterpSchClearActionPerformed(ActionEvent evt) {
        this.prop.interpSchID = -1;
        this.jTextFieldInterpSch.setText("");
    }

    private void jButtonOuterPanelActionPerformed(ActionEvent evt) {
        DialogPanelTaxonGroup dialog = new DialogPanelTaxonGroup((Dialog)this, true, this.panelGroup);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.jLabelOuterPanel.setText(this.panelGroup.getSubCaption(false, true));
            this.setFilterAllLabel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectScheme(boolean forHeader) {
        try {
            DialogSelectIGDType dialog = new DialogSelectIGDType(this, true, false, false, false, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                DialogSelectScheme dialogScheme = new DialogSelectScheme(this, true, this.sbdb, dialog.igdType, forHeader ? null : this.wellInterp);
                dialogScheme.setLocationRelativeTo(this);
                dialogScheme.setVisible(true);
                if (dialogScheme.selection != null && dialogScheme.selection.getID() != this.prop.schID) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (forHeader) {
                        this.prop.schID = dialogScheme.selection.getID();
                        this.jTextFieldScheme.setText(dialogScheme.selection.toString());
                    } else {
                        this.prop.interpSchID = dialogScheme.selection.getID();
                        this.jTextFieldInterpSch.setText(dialogScheme.selection.toString());
                    }
                    dialogScheme.selection.loadUnits();
                }
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void selectFilterSpec() {
        try {
            DialogSelectTaxa dialog = new DialogSelectTaxa((JDialog)this, true, this.sbdb, true, this.filter_spec);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.jRadioButtonFilterSpecies.setSelected(true);
                this.filter_spec = dialog.selection.get(0);
            }
        }
        catch (Exception e) {
            SB.showStackError((String)"Error", (Exception)e);
        }
    }

    @Override
    void setFilterFields() {
        super.setFilterFields();
        this.jTextFieldFilterSpecies.setText(this.filter_spec != null && this.jRadioButtonFilterSpecies.isSelected() ? this.filter_spec.toString(false, true) : "");
    }

    private PanelTaxonProperties.Plot getPlotStyle() {
        PanelTaxonProperties.Plot plot = this.jRadioButtonPlotSaw.isSelected() ? PanelTaxonProperties.Plot.SAWTOOTH : (this.jRadioButtonPlotNumbers.isSelected() ? PanelTaxonProperties.Plot.NUMBERS : (this.jRadioButtonPlotCurve.isSelected() ? PanelTaxonProperties.Plot.CURVE : PanelTaxonProperties.Plot.HIST));
        return plot;
    }

    private void enableSawtoothEnhanced() {
        this.jCheckBoxPlotSawtoothEnhanced.setEnabled(this.jRadioButtonPlotSaw.isSelected());
        this.jSpinnerPlotSawtoothEnhanced.setEnabled(this.jRadioButtonPlotSaw.isSelected());
    }

    @Override
    JRadioButton getFilterCatButton() {
        return this.jRadioButtonFilterCategory;
    }

    @Override
    JRadioButton getFilterSetButton() {
        return this.jRadioButtonFilterSet;
    }

    @Override
    JRadioButton getFilterGroupButton() {
        return this.jRadioButtonFilterGroup;
    }

    @Override
    JTextField getFilterCatField() {
        return this.jTextFieldFilterCat;
    }

    @Override
    JTextField getFilterSetField() {
        return this.jTextFieldFilterSet;
    }

    @Override
    JTextField getFilterGroupField() {
        return this.jTextFieldFilterGroup;
    }

    @Override
    JCheckBox getSubCatBox() {
        return this.jCheckBoxIncludeSubCats;
    }
}

