/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Frame;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jsbugs.DialogList;
import jsbugs.FrameJsbugs;
import jsbugs.PanelTaxonBase;
import jsbugs.SBDialog;
import model2.Category;
import model2.SBdb;
import model2.TxGroup;
import model2.TxGroupSet;
import util.SB;

abstract class DialogPanelTaxonBase
extends SBDialog {
    final SBdb sbdb;
    TxGroupSet filter_set = null;
    TxGroup filter_group = null;
    Category filter_cat = null;

    DialogPanelTaxonBase(Dialog parent, boolean modal, SBdb sbdb, PanelTaxonBase panel) {
        super(parent, modal);
        this.sbdb = sbdb;
    }

    DialogPanelTaxonBase(Frame parent, boolean modal, SBdb sbdb, PanelTaxonBase panel) {
        super(parent, modal);
        this.sbdb = sbdb;
    }

    void init(PanelTaxonBase panel) {
        if (panel.getFilterSet() != null) {
            this.filter_set = panel.getFilterSet();
            this.getFilterSetButton().setSelected(true);
            this.getFilterSetField().setText(this.filter_set.toString());
        } else if (panel.getFilterGroup() != null) {
            this.filter_group = panel.getFilterGroup();
            this.getFilterGroupButton().setSelected(true);
            this.getFilterGroupField().setText(this.filter_group.toString());
        } else if (panel.getFilterCat() != null) {
            this.filter_cat = panel.getFilterCat();
            this.getFilterCatButton().setSelected(true);
            this.getFilterCatField().setText(this.filter_cat.toString());
        }
    }

    void selectFilterCat() {
        try {
            DialogList dialog = new DialogList(this, true, "Select Category", this.sbdb, this.sbdb.getCategoryList(), true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.getFilterCatButton().setSelected(true);
                this.filter_cat = (Category)dialog.selection;
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    void selectFilterGroup() {
        try {
            ArrayList groups = new ArrayList(this.sbdb.getTxGroups());
            Collections.sort(groups);
            DialogList dialog = new DialogList(this, true, "Select Group", this.sbdb, groups, true, false);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.getFilterGroupButton().setSelected(true);
                this.filter_group = (TxGroup)dialog.selection;
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"Error", (SQLException)sqle);
        }
    }

    void selectFilterSet() {
        try {
            DialogList dialog = new DialogList(this, true, "Select Group Set", this.sbdb, this.sbdb.getTxGroupSetsSorted(), true, false);
            dialog.setLocation(this.getX() + this.getWidth() / 2, this.getY());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.getFilterSetButton().setSelected(true);
                this.filter_set = (TxGroupSet)dialog.selection;
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"Error", (SQLException)sqle);
        }
    }

    abstract JRadioButton getFilterCatButton();

    abstract JRadioButton getFilterSetButton();

    abstract JRadioButton getFilterGroupButton();

    abstract JTextField getFilterCatField();

    abstract JTextField getFilterSetField();

    abstract JTextField getFilterGroupField();

    abstract JCheckBox getSubCatBox();

    void setFilterFields() {
        this.getFilterCatField().setText(this.filter_cat != null && this.getFilterCatButton().isSelected() ? this.filter_cat.toString() : "");
        this.getFilterGroupField().setText(this.filter_group != null && this.getFilterGroupButton().isSelected() ? this.filter_group.toString() : "");
        this.getFilterSetField().setText(this.filter_set != null && this.getFilterSetButton().isSelected() ? this.filter_set.toString() : "");
        this.getSubCatBox().setEnabled(this.getFilterCatButton().isSelected());
    }
}

