/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogList;
import jsbugs.DialogPanelDendrogram;
import jsbugs.DialogPanelSamples;
import jsbugs.DialogPanelTaxon;
import jsbugs.DialogPanelTaxonBase;
import jsbugs.FrameJsbugs;
import jsbugs.PanelDendrogram;
import jsbugs.PanelDendrogramProperties;
import jsbugs.PanelSamplesProperties;
import jsbugs.PanelTaxon;
import jsbugs.PanelTaxonBase;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelTaxonProperties;
import jsbugs.SBDialog;
import model2.AnalystHeader;
import model2.Discipline;
import model2.Sample;
import model2.SynonymScheme;
import model2.TxGroupSet;
import util.SB;
import util.SBException;

public class DialogPanelTaxonGroup
extends SBDialog {
    private static final String NO_SYN = "<none>";
    private final PanelTaxonGroup p;
    private TxGroupSet filter_set = null;
    private List<Sample.SampleType> sampleTypes = null;
    private List<AnalystHeader> suites = null;
    private final PanelSamplesProperties panelSamplesProperties;
    private final DefaultListModel panelModel = new DefaultListModel();
    private ButtonGroup buttonGroupData;
    private ButtonGroup buttonGroupInnerPanels;
    private ButtonGroup buttonGroupSampleTypes;
    private ButtonGroup buttonGroupStyle;
    private ButtonGroup buttonGroupSuites;
    private JButton jButtonAnalyses;
    private JButton jButtonCancel;
    private JButton jButtonDataSampleTypes;
    private JButton jButtonFilterSet;
    private JButton jButtonHelp;
    private JButton jButtonInnerPanelProperties;
    private JButton jButtonInnerPanelsAdd;
    private JButton jButtonInnerPanelsRemove;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOK;
    private JButton jButtonPanelSamplesProperties;
    private JCheckBox jCheckBoxAlphabeticKey;
    private JCheckBox jCheckBoxMoveSamplePositions;
    private JCheckBox jCheckBoxShowAnalyst;
    private JCheckBox jCheckBoxShowSamples;
    private JComboBox jComboBoxSyn;
    private JLabel jLabel1;
    private JLabel jLabelStyle;
    private JList jListPanels;
    private JPanel jPanel1;
    private JPanel jPanelData;
    private JPanel jPanelDataFilters;
    private JPanel jPanelDataSampleTypes;
    private JPanel jPanelDataSuites;
    private JPanel jPanelInnerPanels;
    private JRadioButton jRadioButtonAnalysesAll;
    private JRadioButton jRadioButtonAnalysesRestricted;
    private JRadioButton jRadioButtonDataSamplesAll;
    private JRadioButton jRadioButtonDataSamplesRestricted;
    private JRadioButton jRadioButtonFilterAll;
    private JRadioButton jRadioButtonFilterSet;
    private JRadioButton jRadioButtonInnerCat;
    private JRadioButton jRadioButtonInnerGroup;
    private JRadioButton jRadioButtonInnerSingle;
    private JRadioButton jRadioButtonStyleDendr;
    private JRadioButton jRadioButtonStyleStd;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldFilterSet;

    public DialogPanelTaxonGroup(Dialog parent, boolean modal, PanelTaxonGroup group) {
        super(parent, modal);
        if (group == null) {
            throw new IllegalArgumentException("Attempt to edit null panelTaxonGroup");
        }
        this.p = group;
        this.panelSamplesProperties = new PanelSamplesProperties(this.p.panelSamplesProperties);
        this.initComponents();
        boolean innerTab = !(parent instanceof DialogPanelTaxon);
        this.init(innerTab);
    }

    public DialogPanelTaxonGroup(Frame parent, boolean modal, PanelTaxonGroup group) {
        super(parent, modal);
        if (group == null) {
            throw new IllegalArgumentException("Attempt to edit null panelTaxonGroup");
        }
        this.p = group;
        this.panelSamplesProperties = new PanelSamplesProperties(this.p.panelSamplesProperties);
        this.initComponents();
        this.init(true);
    }

    private void init(boolean innerTab) {
        this.setTitle("Biostratigraphy Outer Panel : " + this.p.getDiscID().getNoun());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jRadioButtonFilterAll.setText("all " + this.p.getDiscID().getNoun());
        if (this.p.filter_set != null) {
            this.filter_set = this.p.filter_set;
            this.jRadioButtonFilterSet.setSelected(true);
            this.jTextFieldFilterSet.setText(this.filter_set.getName());
        } else {
            this.jRadioButtonFilterAllActionPerformed(null);
        }
        if (this.p.sampleTypes != null) {
            this.sampleTypes = new LinkedList<Sample.SampleType>(this.p.sampleTypes);
            this.jRadioButtonDataSamplesRestricted.setSelected(true);
        }
        if (this.p.suites != null) {
            this.suites = new LinkedList<AnalystHeader>(this.p.suites);
            this.jRadioButtonAnalysesRestricted.setSelected(true);
        }
        this.setFilterFields();
        if (this.p.size() > 0) {
            this.jRadioButtonInnerCat.setEnabled(false);
            this.jRadioButtonInnerGroup.setEnabled(false);
            this.jRadioButtonInnerSingle.setEnabled(false);
            this.jPanelInnerPanels.setEnabled(false);
            if (this.p.getPanels().get(0) instanceof PanelDendrogram) {
                this.jRadioButtonStyleDendr.setSelected(true);
            } else {
                this.jRadioButtonStyleStd.setSelected(true);
            }
            this.jLabelStyle.setEnabled(false);
            this.jRadioButtonStyleDendr.setEnabled(false);
            this.jRadioButtonStyleStd.setEnabled(false);
        } else {
            this.jRadioButtonInnerSingle.setSelected(true);
            innerTab = false;
            this.jRadioButtonStyleStd.setSelected(true);
        }
        this.jCheckBoxShowAnalyst.setSelected(this.p.showAnalyst);
        this.jCheckBoxShowSamples.setSelected(this.p.showSamples);
        if (innerTab) {
            this.initPanelModel();
        } else {
            this.jTabbedPane1.removeTabAt(this.jTabbedPane1.indexOfComponent(this.jPanelInnerPanels));
        }
        this.jCheckBoxMoveSamplePositions.setSelected(this.p.moveSamplePositions);
        this.jCheckBoxAlphabeticKey.setSelected(this.p.alphabeticKey);
        this.jComboBoxSyn.removeAllItems();
        this.jComboBoxSyn.addItem(NO_SYN);
        try {
            for (SynonymScheme s : this.p.getDb().getSynSchemes()) {
                this.jComboBoxSyn.addItem(s);
            }
            this.jComboBoxSyn.setSelectedItem(this.p.synschID > 0 ? this.p.getDb().getSynSch(this.p.synschID) : NO_SYN);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.p.getDb());
            this.jComboBoxSyn.setEnabled(false);
        }
    }

    private void initPanelModel() {
        for (PanelTaxonBase panel : this.p.getPanels()) {
            this.panelModel.addElement(panel);
        }
    }

    private void initComponents() {
        this.buttonGroupInnerPanels = new ButtonGroup();
        this.buttonGroupData = new ButtonGroup();
        this.buttonGroupSuites = new ButtonGroup();
        this.buttonGroupSampleTypes = new ButtonGroup();
        this.buttonGroupStyle = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelData = new JPanel();
        this.jPanelDataFilters = new JPanel();
        this.jTextFieldFilterSet = new JTextField();
        this.jRadioButtonFilterAll = new JRadioButton();
        this.jRadioButtonFilterSet = new JRadioButton();
        this.jButtonFilterSet = new JButton();
        this.jPanelDataSuites = new JPanel();
        this.jRadioButtonAnalysesAll = new JRadioButton();
        this.jRadioButtonAnalysesRestricted = new JRadioButton();
        this.jButtonAnalyses = new JButton();
        this.jPanelDataSampleTypes = new JPanel();
        this.jRadioButtonDataSamplesAll = new JRadioButton();
        this.jRadioButtonDataSamplesRestricted = new JRadioButton();
        this.jButtonDataSampleTypes = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonInnerCat = new JRadioButton();
        this.jRadioButtonInnerSingle = new JRadioButton();
        this.jRadioButtonInnerGroup = new JRadioButton();
        this.jCheckBoxShowSamples = new JCheckBox();
        this.jButtonPanelSamplesProperties = new JButton();
        this.jCheckBoxShowAnalyst = new JCheckBox();
        this.jCheckBoxMoveSamplePositions = new JCheckBox();
        this.jCheckBoxAlphabeticKey = new JCheckBox();
        this.jComboBoxSyn = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jPanelInnerPanels = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListPanels = new JList();
        this.jButtonInnerPanelsAdd = new JButton();
        this.jButtonInnerPanelsRemove = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jButtonInnerPanelProperties = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabelStyle = new JLabel();
        this.jRadioButtonStyleStd = new JRadioButton();
        this.jRadioButtonStyleDendr = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanelData.setRequestFocusEnabled(false);
        this.jPanelDataFilters.setBorder(BorderFactory.createTitledBorder(null, "Outer panel data:", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jTextFieldFilterSet.setEditable(false);
        this.jTextFieldFilterSet.setBackground(new Color(255, 255, 204));
        this.buttonGroupData.add(this.jRadioButtonFilterAll);
        this.jRadioButtonFilterAll.setSelected(true);
        this.jRadioButtonFilterAll.setText("All <discipline>");
        this.jRadioButtonFilterAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jRadioButtonFilterAllActionPerformed(evt);
            }
        });
        this.buttonGroupData.add(this.jRadioButtonFilterSet);
        this.jRadioButtonFilterSet.setText("Group set:");
        this.jRadioButtonFilterSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jRadioButtonFilterSetActionPerformed(evt);
            }
        });
        this.jButtonFilterSet.setText("...");
        this.jButtonFilterSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonFilterSetActionPerformed(evt);
            }
        });
        GroupLayout jPanelDataFiltersLayout = new GroupLayout(this.jPanelDataFilters);
        this.jPanelDataFilters.setLayout(jPanelDataFiltersLayout);
        jPanelDataFiltersLayout.setHorizontalGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterAll).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanelDataFiltersLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterSet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jTextFieldFilterSet, -2, 194, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterSet, -2, 30, -2).addGap(73, 73, 73)))));
        jPanelDataFiltersLayout.setVerticalGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelDataFiltersLayout.createSequentialGroup().addComponent(this.jRadioButtonFilterAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(jPanelDataFiltersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonFilterSet).addComponent(this.jTextFieldFilterSet, -2, -1, -2).addComponent(this.jButtonFilterSet)).addContainerGap()));
        this.jPanelDataSuites.setBorder(BorderFactory.createTitledBorder(null, "Analysis suites", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSuites.add(this.jRadioButtonAnalysesAll);
        this.jRadioButtonAnalysesAll.setSelected(true);
        this.jRadioButtonAnalysesAll.setText("All");
        this.buttonGroupSuites.add(this.jRadioButtonAnalysesRestricted);
        this.jRadioButtonAnalysesRestricted.setText("Restrict to..");
        this.jButtonAnalyses.setText("...");
        this.jButtonAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonAnalysesActionPerformed(evt);
            }
        });
        GroupLayout jPanelDataSuitesLayout = new GroupLayout(this.jPanelDataSuites);
        this.jPanelDataSuites.setLayout(jPanelDataSuitesLayout);
        jPanelDataSuitesLayout.setHorizontalGroup(jPanelDataSuitesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSuitesLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonAnalysesAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAnalysesRestricted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnalyses, -2, 30, -2).addGap(0, 12, Short.MAX_VALUE)));
        jPanelDataSuitesLayout.setVerticalGroup(jPanelDataSuitesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSuitesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAnalysesRestricted, -2, 23, -2).addComponent(this.jButtonAnalyses)).addComponent(this.jRadioButtonAnalysesAll));
        this.jPanelDataSampleTypes.setBorder(BorderFactory.createTitledBorder(null, "Sample types", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSampleTypes.add(this.jRadioButtonDataSamplesAll);
        this.jRadioButtonDataSamplesAll.setSelected(true);
        this.jRadioButtonDataSamplesAll.setText("All");
        this.buttonGroupSampleTypes.add(this.jRadioButtonDataSamplesRestricted);
        this.jRadioButtonDataSamplesRestricted.setText("Restrict to..");
        this.jButtonDataSampleTypes.setText("...");
        this.jButtonDataSampleTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonDataSampleTypesActionPerformed(evt);
            }
        });
        GroupLayout jPanelDataSampleTypesLayout = new GroupLayout(this.jPanelDataSampleTypes);
        this.jPanelDataSampleTypes.setLayout(jPanelDataSampleTypesLayout);
        jPanelDataSampleTypesLayout.setHorizontalGroup(jPanelDataSampleTypesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSampleTypesLayout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonDataSamplesAll).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonDataSamplesRestricted).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDataSampleTypes, -2, 30, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDataSampleTypesLayout.setVerticalGroup(jPanelDataSampleTypesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataSampleTypesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonDataSamplesAll).addComponent(this.jRadioButtonDataSamplesRestricted).addComponent(this.jButtonDataSampleTypes)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Generate inner panels", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupInnerPanels.add(this.jRadioButtonInnerCat);
        this.jRadioButtonInnerCat.setText("One per category");
        this.buttonGroupInnerPanels.add(this.jRadioButtonInnerSingle);
        this.jRadioButtonInnerSingle.setText("Single panel");
        this.buttonGroupInnerPanels.add(this.jRadioButtonInnerGroup);
        this.jRadioButtonInnerGroup.setText("One per group");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonInnerGroup).addComponent(this.jRadioButtonInnerCat).addComponent(this.jRadioButtonInnerSingle)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonInnerSingle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonInnerCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonInnerGroup).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxShowSamples.setText("Show samples column");
        this.jButtonPanelSamplesProperties.setText("...");
        this.jButtonPanelSamplesProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonPanelSamplesPropertiesActionPerformed(evt);
            }
        });
        this.jCheckBoxShowAnalyst.setText("Show analyst column");
        this.jCheckBoxMoveSamplePositions.setText("Distribute analysis positions");
        this.jCheckBoxAlphabeticKey.setText("Alphabetic key");
        this.jComboBoxSyn.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel1.setText("Synonym scheme:");
        GroupLayout jPanelDataLayout = new GroupLayout(this.jPanelData);
        this.jPanelData.setLayout(jPanelDataLayout);
        jPanelDataLayout.setHorizontalGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataLayout.createSequentialGroup().addContainerGap().addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAlphabeticKey).addComponent(this.jCheckBoxMoveSamplePositions).addComponent(this.jPanelDataFilters, -2, 337, -2).addGroup(jPanelDataLayout.createSequentialGroup().addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDataSuites, -2, -1, -2).addComponent(this.jPanelDataSampleTypes, -2, -1, -2).addComponent(this.jCheckBoxShowAnalyst).addGroup(jPanelDataLayout.createSequentialGroup().addComponent(this.jCheckBoxShowSamples).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPanelSamplesProperties, -2, 30, -2))).addGap(18, 18, 18).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jComboBoxSyn, GroupLayout.Alignment.TRAILING, -2, 135, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelDataLayout.setVerticalGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelDataLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelDataFilters, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanelDataLayout.createSequentialGroup().addComponent(this.jPanelDataSuites, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelDataSampleTypes, -2, -1, -2)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxShowSamples).addComponent(this.jButtonPanelSamplesProperties).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelDataLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxShowAnalyst).addComponent(this.jComboBoxSyn, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxMoveSamplePositions).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAlphabeticKey).addContainerGap(31, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab("Data", this.jPanelData);
        this.jListPanels.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPanels.setModel(this.panelModel);
        this.jListPanels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogPanelTaxonGroup.this.jListPanelsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListPanels);
        this.jButtonInnerPanelsAdd.setText("Add...");
        this.jButtonInnerPanelsAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonInnerPanelsAddActionPerformed(evt);
            }
        });
        this.jButtonInnerPanelsRemove.setText("Remove");
        this.jButtonInnerPanelsRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonInnerPanelsRemoveActionPerformed(evt);
            }
        });
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jButtonInnerPanelProperties.setText("Properties...");
        this.jButtonInnerPanelProperties.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonInnerPanelProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonInnerPanelPropertiesActionPerformed(evt);
            }
        });
        GroupLayout jPanelInnerPanelsLayout = new GroupLayout(this.jPanelInnerPanels);
        this.jPanelInnerPanels.setLayout(jPanelInnerPanelsLayout);
        jPanelInnerPanelsLayout.setHorizontalGroup(jPanelInnerPanelsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInnerPanelsLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 242, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanelInnerPanelsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonInnerPanelProperties, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMoveDown, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonMoveUp, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonInnerPanelsRemove, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonInnerPanelsAdd, GroupLayout.Alignment.TRAILING, -2, 85, -2)).addContainerGap()));
        jPanelInnerPanelsLayout.setVerticalGroup(jPanelInnerPanelsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelInnerPanelsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelInnerPanelsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanelInnerPanelsLayout.createSequentialGroup().addComponent(this.jButtonInnerPanelsAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInnerPanelsRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveUp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonMoveDown).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInnerPanelProperties).addGap(0, 195, Short.MAX_VALUE))).addContainerGap()));
        this.jTabbedPane1.addTab("Inner Panels", this.jPanelInnerPanels);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelTaxonGroup.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelStyle.setText("Style:");
        this.buttonGroupStyle.add(this.jRadioButtonStyleStd);
        this.jRadioButtonStyleStd.setFont(new Font("Tahoma", 1, 11));
        this.jRadioButtonStyleStd.setText("Standard");
        this.buttonGroupStyle.add(this.jRadioButtonStyleDendr);
        this.jRadioButtonStyleDendr.setText("Cluster analysis");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp, -2, 53, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel, -2, 65, -2)).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING, -2, 362, -2)).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelStyle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonStyleStd).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonStyleDendr).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelStyle).addComponent(this.jRadioButtonStyleStd).addComponent(this.jRadioButtonStyleDendr)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jRadioButtonFilterAllActionPerformed(ActionEvent evt) {
        this.setFilterFields();
        if (this.jRadioButtonInnerGroup.isSelected()) {
            this.jRadioButtonInnerSingle.setSelected(true);
        }
        this.jRadioButtonInnerGroup.setEnabled(false);
    }

    private void jRadioButtonFilterSetActionPerformed(ActionEvent evt) {
        if (this.filter_set == null) {
            this.selectFilterSet();
        }
        this.setFilterFields();
        if (this.p.size() == 0) {
            this.jRadioButtonInnerGroup.setEnabled(true);
        }
    }

    private void jButtonFilterSetActionPerformed(ActionEvent evt) {
        this.selectFilterSet();
        this.setFilterFields();
        this.jRadioButtonFilterSetActionPerformed(null);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonFilterAll.isSelected()) {
            this.filter_set = null;
        }
        if (this.p.filter_set != null && this.filter_set != this.p.filter_set) {
            this.p.filter_set.deleteObserver((Observer)this.p);
        }
        TxGroupSet txGroupSet = this.p.filter_set = this.jRadioButtonFilterSet.isSelected() ? this.filter_set : null;
        if (this.p.filter_set != null) {
            this.p.filter_set.addObserver((Observer)this.p);
        }
        if (this.jRadioButtonAnalysesAll.isSelected() || this.suites.isEmpty()) {
            this.suites = null;
        }
        this.p.suites = this.suites;
        if (this.jRadioButtonDataSamplesAll.isSelected() || this.sampleTypes.isEmpty()) {
            this.sampleTypes = null;
        }
        this.p.sampleTypes = this.sampleTypes;
        this.p.panelSamplesProperties = this.panelSamplesProperties;
        this.p.showAnalyst = this.jCheckBoxShowAnalyst.isSelected();
        this.p.showSamples = this.jCheckBoxShowSamples.isSelected();
        this.p.moveSamplePositions = this.jCheckBoxMoveSamplePositions.isSelected();
        this.p.alphabeticKey = this.jCheckBoxAlphabeticKey.isSelected();
        int n = this.p.synschID = this.jComboBoxSyn.getSelectedItem() == NO_SYN ? 0 : ((SynonymScheme)this.jComboBoxSyn.getSelectedItem()).getSchID();
        if (this.p.size() == 0) {
            try {
                if (this.jRadioButtonInnerSingle.isSelected()) {
                    this.p.addDefaultPanel(this.jRadioButtonStyleDendr.isSelected());
                } else if (this.jRadioButtonInnerGroup.isSelected()) {
                    this.p.addGroupPanels(this.jRadioButtonStyleDendr.isSelected());
                } else if (this.jRadioButtonInnerCat.isSelected()) {
                    this.p.addCatPanels(this.jRadioButtonStyleDendr.isSelected());
                }
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.p.getDb());
            }
        } else if (!this.panelModel.isEmpty()) {
            this.p.clearPanels();
            for (Object o : this.panelModel.toArray()) {
                this.p.addPanel((PanelTaxonBase)o);
            }
        }
        this.setOK();
    }

    private void jButtonAnalysesActionPerformed(ActionEvent evt) {
        try {
            LinkedList<AnalystHeader> hdrs = new LinkedList<AnalystHeader>();
            for (AnalystHeader hdr : this.p.getBlock().well.getAnalystHeaders()) {
                if (Discipline.getDisc((char)hdr.getDiscID()) != this.p.getDiscID()) continue;
                hdrs.add(hdr);
            }
            DialogList dialog = new DialogList(this, true, "Select Analyses", this.p.getDb(), hdrs, true, true);
            dialog.setLocationRelativeTo(this);
            if (this.suites != null) {
                dialog.setSelectedItems(this.suites);
            }
            dialog.setVisible(true);
            if (dialog.selected != null && !dialog.selected.isEmpty()) {
                if (this.suites == null) {
                    this.suites = new LinkedList<AnalystHeader>();
                }
                this.suites.clear();
                for (Object o : dialog.selected) {
                    this.suites.add((AnalystHeader)o);
                }
            }
            this.jRadioButtonAnalysesRestricted.setSelected(this.suites != null && this.suites.size() != this.p.getBlock().well.getAnalystHeaders().size());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.p.getDb());
        }
    }

    private void jButtonDataSampleTypesActionPerformed(ActionEvent evt) {
        Sample.SampleType[] values = Sample.SampleType.values();
        LinkedList<Sample.SampleType> sTypes = new LinkedList<Sample.SampleType>();
        sTypes.addAll(Arrays.asList(values));
        DialogList dialog = new DialogList(this, true, "Select Sample Types", this.p.getDb(), sTypes, true, true);
        dialog.setLocationRelativeTo(this);
        if (this.sampleTypes != null) {
            dialog.setSelectedItems(this.sampleTypes);
        }
        dialog.setVisible(true);
        if (dialog.selected != null && !dialog.selected.isEmpty()) {
            this.sampleTypes = new LinkedList<Sample.SampleType>();
            for (Object o : dialog.selected) {
                this.sampleTypes.add((Sample.SampleType)o);
            }
        }
        this.jRadioButtonDataSamplesRestricted.setSelected(this.sampleTypes != null && !this.sampleTypes.isEmpty());
    }

    private void jButtonInnerPanelsRemoveActionPerformed(ActionEvent evt) {
        if (this.panelModel.size() == 1) {
            JOptionPane.showMessageDialog(this, "You can't remove the last panel", this.getTitle(), 2);
            return;
        }
        PanelTaxonBase panel = (PanelTaxonBase)this.panelModel.getElementAt(this.jListPanels.getSelectedIndex());
        if (panel != null) {
            this.panelModel.removeElement(panel);
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        this.movePanel(true, this.jListPanels.getSelectedIndex());
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        this.movePanel(false, this.jListPanels.getSelectedIndex());
    }

    private void jButtonInnerPanelsAddActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonStyleStd.isSelected()) {
            this.panelModel.addElement(new PanelTaxon(this.p, (PanelTaxonProperties)this.p.defaultProperties));
        } else {
            this.panelModel.addElement(new PanelDendrogram(this.p, (PanelDendrogramProperties)this.p.defaultProperties));
        }
    }

    private void jButtonInnerPanelPropertiesActionPerformed(ActionEvent evt) {
        if (this.jListPanels.getSelectedIndex() < 0) {
            this.getToolkit().beep();
        }
        PanelTaxonBase panel = (PanelTaxonBase)this.panelModel.getElementAt(this.jListPanels.getSelectedIndex());
        boolean tempAdd = false;
        if (!this.p.contains(panel)) {
            this.p.addPanel(panel);
            tempAdd = true;
        }
        DialogPanelTaxonBase dialog = panel instanceof PanelTaxon ? new DialogPanelTaxon(this, true, this.p.getDb(), this.p, (PanelTaxon)panel, this.p.getBlock().getInterp()) : new DialogPanelDendrogram(this, true, this.p.getDb(), this.p, (PanelDendrogram)panel);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        this.jListPanels.repaint();
        if (tempAdd) {
            this.p.removePanel(panel);
        }
    }

    private void jButtonPanelSamplesPropertiesActionPerformed(ActionEvent evt) {
        DialogPanelSamples dialog = new DialogPanelSamples((Dialog)this, true, this.panelSamplesProperties, this.p.getDb());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jListPanelsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonInnerPanelPropertiesActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogpaneltaxon.html");
    }

    private void movePanel(boolean up, int index) {
        if (index < 0) {
            JOptionPane.showMessageDialog(this, "No panel selected", "Move panel", 2);
            return;
        }
        if (index == this.panelModel.size() - 1 && !up) {
            JOptionPane.showMessageDialog(this, "Can't move down", "MovePanel", 2);
            return;
        }
        if (index == 0 && up) {
            JOptionPane.showMessageDialog(this, "Can't move up", "MovePanel", 2);
            return;
        }
        Object panel = this.panelModel.get(index);
        this.panelModel.remove(index);
        this.panelModel.add(up ? index - 1 : index + 1, panel);
        this.jListPanels.repaint();
        this.jListPanels.setSelectedIndex(up ? index - 1 : index + 1);
    }

    private void setFilterFields() {
        this.jTextFieldFilterSet.setText(this.filter_set != null && this.jRadioButtonFilterSet.isSelected() ? this.filter_set.toString() : "");
    }

    private void selectFilterSet() {
        try {
            DialogList dialog = new DialogList(this, true, "Select Group Set", this.p.getDb(), this.p.getDb().getTxGroupSetsSorted(), true, false);
            dialog.setLocation(this.getX() + this.getWidth() / 2, this.getY());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.jRadioButtonFilterSet.setSelected(true);
                this.filter_set = (TxGroupSet)dialog.selection;
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"Error", (SQLException)sqle);
        }
    }
}

