/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.PanelWellHeader;
import jsbugs.PanelWellHeaderProperties;
import jsbugs.SBDialog;
import util.SB;

public class DialogPanelWellHeader
extends SBDialog {
    private final PanelWellHeader panel;
    private final PanelWellHeaderProperties p;
    private ButtonGroup buttonGroupLocation;
    private ButtonGroup buttonGroupWellName;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxBorder;
    private JCheckBox jCheckBoxComments;
    private JCheckBox jCheckBoxLocation;
    private JCheckBox jCheckBoxLogo;
    private JCheckBox jCheckBoxOperator;
    private JCheckBox jCheckBoxScale;
    private JCheckBox jCheckBoxSpud;
    private JCheckBox jCheckBoxWellCode;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonLocDMS;
    private JRadioButton jRadioButtonLocDec;
    private JRadioButton jRadioButtonWellNameCentre;
    private JRadioButton jRadioButtonWellNameLeft;
    private JSeparator jSeparator1;
    private JTextField jTextFieldPanelHeight;

    public DialogPanelWellHeader(Frame parent, boolean modal, PanelWellHeader panel) {
        super(parent, modal);
        this.initComponents();
        this.panel = panel;
        this.p = new PanelWellHeaderProperties(panel.getProperties());
        this.init();
    }

    private void init() {
        this.setTitle("Well Header Panel Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldPanelHeight.setText("" + Float.valueOf(this.p.height).intValue());
        if (this.p.centreName) {
            this.jRadioButtonWellNameCentre.setSelected(true);
        } else {
            this.jRadioButtonWellNameLeft.setSelected(true);
        }
        this.jCheckBoxWellCode.setSelected(this.p.wellCode);
        this.jCheckBoxLocation.setSelected(this.p.location);
        if (this.p.decimalLocation) {
            this.jRadioButtonLocDec.setSelected(true);
        } else {
            this.jRadioButtonLocDMS.setSelected(true);
        }
        this.jCheckBoxLocationActionPerformed(null);
        this.jCheckBoxOperator.setSelected(this.p.operator);
        this.jCheckBoxSpud.setSelected(this.p.spud);
        this.jCheckBoxLogo.setSelected(this.p.logo);
        this.jCheckBoxBorder.setSelected(this.p.border);
        this.jCheckBoxScale.setSelected(this.p.scale);
        this.jCheckBoxComments.setSelected(this.p.comments);
    }

    private void initComponents() {
        this.buttonGroupLocation = new ButtonGroup();
        this.buttonGroupWellName = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldPanelHeight = new JTextField();
        this.jCheckBoxLogo = new JCheckBox();
        this.jCheckBoxBorder = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jCheckBoxSpud = new JCheckBox();
        this.jCheckBoxWellCode = new JCheckBox();
        this.jCheckBoxLocation = new JCheckBox();
        this.jCheckBoxOperator = new JCheckBox();
        this.jRadioButtonLocDec = new JRadioButton();
        this.jRadioButtonLocDMS = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jRadioButtonWellNameLeft = new JRadioButton();
        this.jRadioButtonWellNameCentre = new JRadioButton();
        this.jCheckBoxComments = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jCheckBoxScale = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Panel height:");
        this.jTextFieldPanelHeight.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogPanelWellHeader.this.jTextFieldPanelHeightKeyTyped(evt);
            }
        });
        this.jCheckBoxLogo.setText("Logo");
        this.jCheckBoxLogo.setToolTipText("Display \"logo.jpg\" from StrataBugs folder");
        this.jCheckBoxBorder.setText("Border");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Well Header", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxSpud.setText("Spud/Completion");
        this.jCheckBoxWellCode.setText("Well code");
        this.jCheckBoxLocation.setText("Location:");
        this.jCheckBoxLocation.setToolTipText("Latitude and Longitude");
        this.jCheckBoxLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelWellHeader.this.jCheckBoxLocationActionPerformed(evt);
            }
        });
        this.jCheckBoxOperator.setText("Operator");
        this.buttonGroupLocation.add(this.jRadioButtonLocDec);
        this.jRadioButtonLocDec.setText("Decimal");
        this.buttonGroupLocation.add(this.jRadioButtonLocDMS);
        this.jRadioButtonLocDMS.setText("DMS");
        this.jLabel2.setText("Well name:");
        this.buttonGroupWellName.add(this.jRadioButtonWellNameLeft);
        this.jRadioButtonWellNameLeft.setText("Left");
        this.buttonGroupWellName.add(this.jRadioButtonWellNameCentre);
        this.jRadioButtonWellNameCentre.setText("Centre");
        this.jCheckBoxComments.setText("Comments");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonLocDec).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jRadioButtonLocDMS)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxComments).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonWellNameLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonWellNameCentre)).addComponent(this.jCheckBoxSpud).addComponent(this.jCheckBoxOperator).addComponent(this.jCheckBoxWellCode)).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jRadioButtonWellNameLeft).addComponent(this.jRadioButtonWellNameCentre)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxWellCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxOperator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxLocation).addComponent(this.jRadioButtonLocDec).addComponent(this.jRadioButtonLocDMS)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSpud).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxComments).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelWellHeader.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPanelWellHeader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jCheckBoxScale.setText("Scale");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldPanelHeight, -2, 40, -2)).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxLogo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBorder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxScale).addGap(44, 44, 44))).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -2, 201, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldPanelHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxLogo).addComponent(this.jCheckBoxBorder).addComponent(this.jCheckBoxScale)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float height = Float.parseFloat(this.jTextFieldPanelHeight.getText());
        if (height < 20.0f) {
            height = 20.0f;
        }
        this.p.height = height;
        this.p.centreName = this.jRadioButtonWellNameCentre.isSelected();
        this.p.wellCode = this.jCheckBoxWellCode.isSelected();
        this.p.location = this.jCheckBoxLocation.isSelected();
        this.p.decimalLocation = this.jRadioButtonLocDec.isSelected();
        this.p.operator = this.jCheckBoxOperator.isSelected();
        this.p.spud = this.jCheckBoxSpud.isSelected();
        this.p.logo = this.jCheckBoxLogo.isSelected();
        this.p.border = this.jCheckBoxBorder.isSelected();
        this.p.scale = this.jCheckBoxScale.isSelected();
        this.p.comments = this.jCheckBoxComments.isSelected();
        this.panel.setProperties(this.p);
        this.setOK();
    }

    private void jTextFieldPanelHeightKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldPanelHeight, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxLocationActionPerformed(ActionEvent evt) {
        this.jRadioButtonLocDMS.setEnabled(this.jCheckBoxLocation.isSelected());
        this.jRadioButtonLocDec.setEnabled(this.jCheckBoxLocation.isSelected());
    }
}

