/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import jsbugs.ImageGallery;
import model2.Lastval;
import model2.SBdb;

public class DialogPrintImageGallery
extends JDialog {
    ImageGallery gallery;
    SBdb db;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxCat;
    private JCheckBox jCheckBoxOccComments;
    private JCheckBox jCheckBoxSuite;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonSetAll;
    private JRadioButton jRadioButtonSetFirst;
    private JRadioButton jRadioButtonSizeL;
    private JRadioButton jRadioButtonSizeM;
    private JRadioButton jRadioButtonSizeS;
    private JSeparator jSeparator1;

    public DialogPrintImageGallery(Dialog parent, boolean modal, ImageGallery gallery, SBdb db) {
        super(parent, modal);
        this.gallery = gallery;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Image Gallery Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        switch (this.gallery.getSize()) {
            case 'S': {
                this.jRadioButtonSizeS.setSelected(true);
                break;
            }
            case 'M': {
                this.jRadioButtonSizeM.setSelected(true);
                break;
            }
            case 'L': {
                this.jRadioButtonSizeL.setSelected(true);
            }
        }
        if (this.gallery.getWholeSet()) {
            this.jRadioButtonSetAll.setSelected(true);
        } else {
            this.jRadioButtonSetFirst.setSelected(true);
        }
        this.jCheckBoxOccComments.setSelected(this.gallery.getOccComments());
        this.jCheckBoxCat.setSelected(this.gallery.getCats());
        this.jCheckBoxSuite.setSelected(this.gallery.getSuite());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonSizeL = new JRadioButton();
        this.jRadioButtonSizeM = new JRadioButton();
        this.jRadioButtonSizeS = new JRadioButton();
        this.jRadioButtonSetAll = new JRadioButton();
        this.jRadioButtonSetFirst = new JRadioButton();
        this.jCheckBoxOccComments = new JCheckBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jCheckBoxSuite = new JCheckBox();
        this.jCheckBoxCat = new JCheckBox();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Image size", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroup1.add(this.jRadioButtonSizeL);
        this.jRadioButtonSizeL.setText("Large");
        this.buttonGroup1.add(this.jRadioButtonSizeM);
        this.jRadioButtonSizeM.setText("Medium");
        this.buttonGroup1.add(this.jRadioButtonSizeS);
        this.jRadioButtonSizeS.setText("Small");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSizeL).addComponent(this.jRadioButtonSizeM).addComponent(this.jRadioButtonSizeS)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonSizeS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSizeM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSizeL).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonGroup2.add(this.jRadioButtonSetAll);
        this.jRadioButtonSetAll.setText("All images in set");
        this.buttonGroup2.add(this.jRadioButtonSetFirst);
        this.jRadioButtonSetFirst.setText("First image in set");
        this.jCheckBoxOccComments.setText("Occurrence comments");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintImageGallery.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintImageGallery.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jCheckBoxSuite.setText("Analysis suite");
        this.jCheckBoxCat.setText("Exclude taxon categories");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintImageGallery.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxCat).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxSuite).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxOccComments).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSetAll).addComponent(this.jRadioButtonSetFirst)))).addGap(17, 17, 17)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 217, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()))))));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jRadioButtonSetFirst).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSetAll))).addGap(18, 18, 18).addComponent(this.jCheckBoxOccComments).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSuite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        char size = this.jRadioButtonSizeL.isSelected() ? (char)'L' : (this.jRadioButtonSizeM.isSelected() ? (char)'M' : 'S');
        this.gallery.setProperties(size, this.jRadioButtonSetAll.isSelected(), this.jCheckBoxOccComments.isSelected(), this.jCheckBoxSuite.isSelected(), this.jCheckBoxCat.isSelected());
        this.encodeProperties(size);
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtoprintimagegalleries.html");
    }

    private void encodeProperties(char size) {
        System.out.println("Encoding ImageGallery properties...");
        String string = new String();
        String[] props = new String[]{"" + size, "" + (this.jRadioButtonSetAll.isSelected() ? 1 : 0), "" + (this.jCheckBoxOccComments.isSelected() ? 1 : 0), "" + (this.jCheckBoxSuite.isSelected() ? 1 : 0), "" + (this.jCheckBoxCat.isSelected() ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        System.out.println("log sheet prefs: " + string);
        try {
            Lastval.putString((SBdb)this.db, (String)"IMGGALPREF", (String)string);
            this.db.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

