/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsbugs.DialogLoggingSheetCodesProperties;
import jsbugs.DialogPrintImageGallery;
import jsbugs.DialogPrintLoggingSheetProperties;
import jsbugs.ImageGallery;
import jsbugs.LoggingSheet;
import jsbugs.LoggingSheetCodes;
import jsbugs.PrintJPanel;
import jsbugs.SBPrint;
import model2.SBdb;

public class DialogPrintPreview
extends JDialog {
    List<? extends SBPrint> prints;
    PrintJPanel printJPanel;
    boolean isPrint = false;
    int viewPage = 0;
    int nPages;
    SpinnerModel model;
    PrinterJob job;
    PageFormat pf;
    SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonPageSetup;
    private JButton jButtonPrint;
    private JButton jButtonProperties;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinner1;

    public DialogPrintPreview(Frame parent, boolean modal, List<? extends SBPrint> prints, PrintJPanel printJPanel, PrinterJob job, PageFormat pf, SBdb db) {
        super(parent, modal);
        this.prints = prints;
        this.printJPanel = printJPanel;
        this.job = job;
        this.pf = pf;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Print Preview");
        this.jScrollPane1.getViewport().add(this.printJPanel);
        this.refreshSpinner();
        this.getRootPane().setDefaultButton(this.jButtonPrint);
    }

    private void initComponents() {
        this.jButtonPrint = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jButtonProperties = new JButton();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jButtonPageSetup = new JButton();
        this.setDefaultCloseOperation(2);
        this.jButtonPrint.setText("Print");
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreview.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreview.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonProperties.setText("Properties...");
        this.jButtonProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreview.this.jButtonPropertiesActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Page:");
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogPrintPreview.this.jSpinner1StateChanged(evt);
            }
        });
        this.jLabel2.setText("of:");
        this.jButtonPageSetup.setText("Page setup...");
        this.jButtonPageSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreview.this.jButtonPageSetupActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 650, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinner1, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 416, Short.MAX_VALUE).addComponent(this.jButtonPrint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jButtonProperties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPageSetup))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonPrint);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonProperties).addComponent(this.jButtonPageSetup)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 640, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonPrint).addComponent(this.jLabel2).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel1)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        this.isPrint = true;
        this.dispose();
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        this.printJPanel.setViewPage((Integer)this.model.getValue() - 1);
        this.jScrollPane1.repaint();
    }

    private void jButtonPageSetupActionPerformed(ActionEvent evt) {
        PageFormat newPf = null;
        newPf = this.job.pageDialog(this.pf);
        if (newPf == this.pf) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.pf = newPf;
        this.refreshJPanel();
        this.refreshSpinner();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        JDialog dialog = null;
        if (this.prints.get(0) instanceof LoggingSheet) {
            dialog = new DialogPrintLoggingSheetProperties(this, true, this.prints, this.db);
        } else if (this.prints.get(0) instanceof ImageGallery) {
            dialog = new DialogPrintImageGallery((Dialog)this, true, (ImageGallery)this.prints.get(0), this.db);
        } else if (this.prints.get(0) instanceof LoggingSheetCodes) {
            dialog = new DialogLoggingSheetCodesProperties(this, true, (LoggingSheetCodes)this.prints.get(0), this.db, this.pf);
        }
        if (dialog == null) {
            JOptionPane.showMessageDialog(this, "No properties available", this.getTitle(), 1);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (!dialog.isVisible()) {
            this.refreshSpinner();
            this.refreshJPanel();
        }
    }

    private void refreshSpinner() {
        int page = this.model != null ? (Integer)this.model.getValue() - 1 : 0;
        this.printJPanel.calcnPages(this.pf);
        this.nPages = this.printJPanel.getPages();
        this.jLabel2.setText("of: " + this.nPages);
        this.model = new SpinnerNumberModel(1, 1, this.nPages, 1);
        this.jSpinner1.setModel(this.model);
        this.model.setValue(page + 1);
        this.printJPanel.setViewPage(page);
    }

    private void refreshJPanel() {
        this.printJPanel.calcnPages(this.pf);
        this.printJPanel.setDimensions(this.pf);
        this.jScrollPane1.repaint();
    }
}

