/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.ChartJPanel;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.Lastval;
import model2.SBdb;

public class DialogPrintPreviewChart
extends SBDialog {
    private final ChartJPanel chartJPanel;
    private final SBdb sbdb;
    private final PrinterJob job;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonPageSetup;
    private JButton jButtonPrint;
    private JLabel jLabelChartSize;
    private JRadioButton jRadioButtonShrink;
    private JRadioButton jRadioButtonTile;
    private JScrollPane jScrollPane1;

    public DialogPrintPreviewChart(Frame parent, boolean modal, ChartJPanel chartJPanel, PrinterJob job, SBdb sbdb) {
        super(parent, modal);
        this.chartJPanel = chartJPanel;
        this.job = job;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Print Preview : Chart");
        this.jScrollPane1.getViewport().add(this.chartJPanel);
        this.getRootPane().setDefaultButton(this.jButtonPrint);
        if (this.chartJPanel.isFitToPage()) {
            this.jRadioButtonShrink.setSelected(true);
        } else {
            this.jRadioButtonTile.setSelected(true);
        }
        this.jLabelChartSize.setText("Chart size: " + Math.floor(this.chartJPanel.chart.getMMwidth()) + " x " + Math.floor(this.chartJPanel.chart.getMMheight()) + " mm");
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonPageSetup = new JButton();
        this.jRadioButtonTile = new JRadioButton();
        this.jRadioButtonShrink = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jButtonCancel = new JButton();
        this.jButtonPrint = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabelChartSize = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 400));
        this.jButtonPageSetup.setText("Page Setup...");
        this.jButtonPageSetup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreviewChart.this.jButtonPageSetupActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonTile);
        this.jRadioButtonTile.setText("Print at natural scale (tile across multiple pages)");
        this.jRadioButtonTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreviewChart.this.jRadioButtonTileActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonShrink);
        this.jRadioButtonShrink.setText("Shrink to fit page (incorrect scale)");
        this.jRadioButtonShrink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreviewChart.this.jRadioButtonShrinkActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreviewChart.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonPrint.setText("Print");
        this.jButtonPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreviewChart.this.jButtonPrintActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogPrintPreviewChart.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabelChartSize.setHorizontalAlignment(11);
        this.jLabelChartSize.setText("Chart size:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 544, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonPrint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonTile).addComponent(this.jRadioButtonShrink)).addGap(56, 56, 56).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonPageSetup, GroupLayout.Alignment.TRAILING).addComponent(this.jLabelChartSize, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonPrint);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButtonTile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonShrink)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelChartSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonPageSetup))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 496, Short.MAX_VALUE).addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonPrint)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonPrintActionPerformed(ActionEvent evt) {
        this.encodeProperties();
        this.setOK();
    }

    private void jButtonPageSetupActionPerformed(ActionEvent evt) {
        PageFormat newPf = this.job.pageDialog(this.chartJPanel.getPf());
        if (newPf == this.chartJPanel.getPf()) {
            return;
        }
        this.chartJPanel.setPf(newPf);
        this.refreshJPanel();
    }

    private void jRadioButtonTileActionPerformed(ActionEvent evt) {
        this.setFit(false);
    }

    private void jRadioButtonShrinkActionPerformed(ActionEvent evt) {
        this.setFit(true);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("samples_printcharts.html");
    }

    private void setFit(boolean fit) {
        this.chartJPanel.setFitToPage(fit);
        this.refreshJPanel();
    }

    private void refreshJPanel() {
        this.jScrollPane1.repaint();
    }

    private void encodeProperties() {
        System.out.println("Encoding chart print properties...");
        String string = new String();
        String[] props = new String[]{"" + (this.chartJPanel.isFitToPage() ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        System.out.println("chart print prefs: " + string);
        try {
            Lastval.putString((SBdb)this.sbdb, (String)"CHPRNTPREF", (String)string);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

