/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmHandle;
import com.reprisesoftware.rlm.RlmLicense;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import util.SB;
import util.SBException;

public class DialogRLMRoam
extends JDialog {
    RlmLicense license;
    RlmHandle handle;
    int maxRoamDays = 0;
    boolean isOK = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonCheckin;
    private JRadioButton jRadioButtonCheckout;
    private JTextField jTextFieldDays;

    public DialogRLMRoam(Frame parent, boolean modal, RlmHandle handle, RlmLicense license, String product, String version) throws SBException {
        super(parent, modal);
        this.initComponents();
        this.license = license;
        this.handle = handle;
        this.init(product, version);
    }

    private void init(String product, String version) throws SBException {
        this.setTitle("StrataBugs - Licence checkout/in");
        Vector vec = this.handle.getAvailableProducts(product, version);
        if (vec == null || vec.isEmpty()) {
            throw new SBException("Cannot find roaming license in DialogRLMRoam");
        }
        RlmAvailableProduct rlmProduct = (RlmAvailableProduct)vec.get(0);
        if (rlmProduct.getMaxRoam() > 0) {
            this.maxRoamDays = rlmProduct.getMaxRoam();
            this.jTextFieldDays.setText("" + this.maxRoamDays);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonCheckout = new JRadioButton();
        this.jTextFieldDays = new JTextField();
        this.jLabel1 = new JLabel();
        this.jRadioButtonCheckin = new JRadioButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRLMRoam.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRLMRoam.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Warning: control panel and al modules will close!");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Options", 0, 0, new Font("Tahoma", 0, 11), new Color(0, 51, 204)));
        this.buttonGroup1.add(this.jRadioButtonCheckout);
        this.jRadioButtonCheckout.setText("Checkout - number of days required:");
        this.jRadioButtonCheckout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRLMRoam.this.jRadioButtonCheckoutActionPerformed(evt);
            }
        });
        this.jTextFieldDays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRLMRoam.this.jTextFieldDaysActionPerformed(evt);
            }
        });
        this.jLabel1.setText("(max)");
        this.buttonGroup1.add(this.jRadioButtonCheckin);
        this.jRadioButtonCheckin.setText("Checkin");
        this.jRadioButtonCheckin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRLMRoam.this.jRadioButtonCheckinActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonCheckin).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonCheckout).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDays, -2, 56, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonCheckout).addComponent(this.jTextFieldDays, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonCheckin).addContainerGap()));
        this.jLabel3.setText("<html>This option allows you to run a licensed copy of StrataBugs<br> away from the network for a specified number of days.<br> When you press OK, the system will close and confirm when the<br>\n licence has been checked out. <br>\n<br>\nSelect the checkin option when you have reconnected to the network.</html>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(5, 5, 5).addComponent(this.jLabel3, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldDaysActionPerformed(ActionEvent evt) {
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroup1.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "No option selected.", this.getTitle(), 1);
            return;
        }
        if (this.jTextFieldDays.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "No number of days specified", this.getTitle(), 1);
            return;
        }
        int days = Integer.parseInt(this.jTextFieldDays.getText());
        if (days < -1 || days > this.maxRoamDays) {
            JOptionPane.showMessageDialog(this, "Invalid number of days specified", this.getTitle(), 1);
            return;
        }
        this.license.checkin();
        String[] commands = new String[]{"java", "-cp", "jsbugs2_0.jar", "jsbugs.DialogRLMRoamExec"};
        ProcessBuilder pb = new ProcessBuilder(commands);
        Map<String, String> env = pb.environment();
        env.put("RLM_ROAM", this.jTextFieldDays.getText());
        try {
            pb.start();
            this.isOK = true;
            this.dispose();
        }
        catch (IOException e) {
            SB.showStackError((String)e.toString(), (Exception)e);
            e.printStackTrace();
        }
    }

    private void jRadioButtonCheckoutActionPerformed(ActionEvent evt) {
        this.setField(true);
    }

    private void jRadioButtonCheckinActionPerformed(ActionEvent evt) {
        this.setField(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void setField(boolean selected) {
        if (selected) {
            this.jTextFieldDays.setEnabled(true);
        } else {
            this.jTextFieldDays.setEnabled(false);
            this.jTextFieldDays.setText("-1");
        }
    }
}

