/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartProperties;
import jsbugs.DialogChartFont;
import jsbugs.DialogSelectCmpStd;
import jsbugs.DialogSelectIGDType;
import jsbugs.DialogSelectScheme;
import jsbugs.DialogSelectVersion;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelSchemeBlock;
import jsbugs.PanelIGDScheme;
import jsbugs.PanelRange;
import jsbugs.PanelRangeProperties;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import model2.InterpHdr;
import model2.Project;
import model2.SBdb;
import model2.TxGroupSet;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class DialogRangeChart
extends SBDialog {
    private final SBdb sbdb;
    ChartProperties cp = null;
    private final Chart chart;
    private final PanelRange panelRange;
    private final SchemeBlock block;
    private PanelRangeProperties prop = null;
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel setModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final JPanelSchemeBlock schemeBlockPanel;
    static final String CHART_PROPERTIES_CODE = "RANGCHTPRP";
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonClearScheme;
    private JButton jButtonCmpStd;
    private JButton jButtonFonts;
    private JButton jButtonHelp;
    private JButton jButtonInterp;
    private JButton jButtonOK;
    private JButton jButtonScheme;
    private JCheckBox jCheckBoxGroup;
    private JCheckBox jCheckBoxPlotFull;
    private JCheckBox jCheckBoxSetExclude;
    private JCheckBox jCheckBoxShowImages;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxScale;
    private JComboBox jComboBoxSet;
    private JComboBox jComboBoxVersion;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JRadioButton jRadioButtonAlpha;
    private JRadioButton jRadioButtonSortBase;
    private JRadioButton jRadioButtonSortTop;
    private JSlider jSliderColour;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldAgeMax;
    private JTextField jTextFieldAgeMin;
    private JTextField jTextFieldCmpStd;
    private JTextField jTextFieldEventColumnWidth;
    private JTextField jTextFieldScheme;

    public DialogRangeChart(Frame parent, boolean modal, SBdb sbdb, Chart chart) {
        super(parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.chart = chart;
        SchemeBlock sb = null;
        PanelRange pr = null;
        block0: for (ChartBlock b : chart.blocks) {
            if (!(b instanceof SchemeBlock)) continue;
            sb = (SchemeBlock)b;
            for (SBPanel sbp : b.panels) {
                if (!(sbp instanceof PanelRange)) continue;
                pr = (PanelRange)sbp;
                break block0;
            }
        }
        if (sb == null) {
            assert (false);
            sb = new SchemeBlock();
            chart.blocks.add(sb);
        }
        if (pr == null) {
            pr = new PanelRange(sbdb, sb);
            sb.addPanel(pr);
        }
        this.block = sb;
        this.schemeBlockPanel = new JPanelSchemeBlock(this.block, sbdb, this);
        this.panelRange = pr;
        this.init();
    }

    private void init() {
        this.setTitle("Stratigraphic Range Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        SchemeBlock.fillScaleCombo(this.scaleModel);
        this.fillSetComobo();
        this.fillProjectCombo();
        this.refreshInterpCombo();
        this.jComboBoxScale.getEditor().getEditorComponent().addKeyListener(new CbKeyListener(this.jComboBoxScale));
        this.prop = new PanelRangeProperties(this.panelRange.getProperties());
        if (this.prop.interpID >= 0) {
            try {
                this.jComboBoxVersion.setSelectedItem(this.sbdb.getInterp(this.prop.interpID));
            }
            catch (SQLException sqle) {
                SB.showStackError((String)"Error", (SQLException)sqle);
            }
        }
        if (this.prop.std != null) {
            this.jTextFieldCmpStd.setText(this.prop.std.toString());
        }
        if (this.prop.scheme != null) {
            this.jTextFieldScheme.setText(this.prop.scheme.toString());
        }
        if (this.prop.sortTops == null) {
            this.jRadioButtonAlpha.setSelected(true);
        } else if (this.prop.sortTops.booleanValue()) {
            this.jRadioButtonSortTop.setSelected(true);
        } else {
            this.jRadioButtonSortBase.setSelected(true);
        }
        if (this.prop.set != null) {
            this.setModel.setSelectedItem(this.prop.set);
            this.jCheckBoxGroup.setEnabled(true);
            this.jCheckBoxGroup.setSelected(this.prop.groupGroups);
            this.jCheckBoxSetExclude.setEnabled(true);
            this.jCheckBoxSetExclude.setSelected(this.prop.setExclusive);
        }
        if (this.prop.project != null) {
            this.projectModel.setSelectedItem(this.prop.project);
        }
        this.jCheckBoxPlotFull.setSelected(this.prop.showAll);
        this.jTextFieldAgeMin.setText("" + this.block.prop.min);
        this.jTextFieldAgeMax.setText("" + this.block.prop.max);
        if (this.scaleModel.getIndexOf(Float.valueOf(this.block.prop.scale)) >= 0) {
            this.scaleModel.setSelectedItem(Float.valueOf(this.block.prop.scale));
        } else {
            this.scaleModel.addElement(Float.valueOf(this.block.prop.scale));
            this.scaleModel.setSelectedItem(Float.valueOf(this.block.prop.scale));
        }
        this.jSliderColour.setValue(this.prop.colourDensity);
        this.jCheckBoxShowImages.setSelected(this.prop.showImages);
        this.jTextFieldEventColumnWidth.setText("" + this.prop.evWidth);
        this.jTabbedPane1.insertTab("Scheme Block", null, this.schemeBlockPanel, null, 1);
    }

    private void setCmpStdAges() {
        if (this.prop.std != null) {
            this.jTextFieldAgeMin.setText("" + this.prop.std.getMinAge());
            this.jTextFieldAgeMax.setText("" + this.prop.std.getMaxAge());
        } else {
            this.jTextFieldAgeMin.setText("" + this.block.prop.min);
            this.jTextFieldAgeMax.setText("" + this.block.prop.max);
        }
    }

    private void fillSetComobo() {
        this.setModel.addElement("");
        try {
            for (TxGroupSet set : this.sbdb.getTxGroupSetsSorted()) {
                this.setModel.addElement(set);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void fillProjectCombo() {
        this.projectModel.removeAllElements();
        try {
            this.sbdb.getProjects().loadCombo(this.projectModel, true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void refreshInterpCombo() {
        try {
            this.jComboBoxVersion.removeAllItems();
            for (InterpHdr interp : this.sbdb.getInterps()) {
                this.jComboBoxVersion.addItem(interp);
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error loading versions", (SQLException)sqle);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonFonts = new JButton();
        this.jButtonInterp = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jTextFieldCmpStd = new JTextField();
        this.jButtonCmpStd = new JButton();
        this.jButtonScheme = new JButton();
        this.jButtonClearScheme = new JButton();
        this.jLabel7 = new JLabel();
        this.jComboBoxSet = new JComboBox();
        this.jLabel12 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel11 = new JLabel();
        this.jComboBoxVersion = new JComboBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonSortTop = new JRadioButton();
        this.jRadioButtonSortBase = new JRadioButton();
        this.jCheckBoxGroup = new JCheckBox();
        this.jRadioButtonAlpha = new JRadioButton();
        this.jCheckBoxPlotFull = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jSliderColour = new JSlider();
        this.jCheckBoxSetExclude = new JCheckBox();
        this.jCheckBoxShowImages = new JCheckBox();
        this.jLabel13 = new JLabel();
        this.jTextFieldEventColumnWidth = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextFieldAgeMax = new JTextField();
        this.jTextFieldAgeMin = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jComboBoxScale = new JComboBox();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonFonts.setText("Options...");
        this.jButtonFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonFontsActionPerformed(evt);
            }
        });
        this.jButtonInterp.setText("...");
        this.jButtonInterp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonInterpActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Composite standard:");
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setEditable(false);
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldCmpStd.setEditable(false);
        this.jTextFieldCmpStd.setBackground(new Color(255, 255, 204));
        this.jButtonCmpStd.setText("...");
        this.jButtonCmpStd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonCmpStdActionPerformed(evt);
            }
        });
        this.jButtonScheme.setText("...");
        this.jButtonScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonSchemeActionPerformed(evt);
            }
        });
        this.jButtonClearScheme.setText("Clear");
        this.jButtonClearScheme.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonClearScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jButtonClearSchemeActionPerformed(evt);
            }
        });
        this.jLabel7.setText("Group set:");
        this.jComboBoxSet.setModel(this.setModel);
        this.jComboBoxSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRangeChart.this.jComboBoxSetActionPerformed(evt);
            }
        });
        this.jLabel12.setText("Version:");
        this.jComboBoxProject.setModel(this.projectModel);
        this.jLabel11.setText("Project:");
        this.jComboBoxVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Sorting", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroup1.add(this.jRadioButtonSortTop);
        this.jRadioButtonSortTop.setText("Top of range");
        this.buttonGroup1.add(this.jRadioButtonSortBase);
        this.jRadioButtonSortBase.setText("Base of range");
        this.jCheckBoxGroup.setText("Cluster by Group");
        this.jCheckBoxGroup.setEnabled(false);
        this.buttonGroup1.add(this.jRadioButtonAlpha);
        this.jRadioButtonAlpha.setText("Alphabetical (by event name)");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonAlpha).addComponent(this.jRadioButtonSortTop).addComponent(this.jRadioButtonSortBase).addComponent(this.jCheckBoxGroup)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonSortTop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSortBase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAlpha).addGap(5, 5, 5).addComponent(this.jCheckBoxGroup).addContainerGap(-1, Short.MAX_VALUE)));
        this.jCheckBoxPlotFull.setText("Plot full composite");
        this.jCheckBoxPlotFull.setToolTipText("Show all events in header even if their age range is outside the chart's age range");
        this.jLabel10.setText("Background colour density:");
        this.jSliderColour.setMaximum(255);
        this.jSliderColour.setValue(85);
        this.jCheckBoxSetExclude.setEnabled(false);
        this.jCheckBoxSetExclude.setLabel("Exclude events from taxa not in set");
        this.jCheckBoxShowImages.setText("Plot taxon images");
        this.jCheckBoxShowImages.setToolTipText("Show a thumbnail image if the event linked taxon has a \"Type\" image defined");
        this.jLabel13.setText("Event column width:");
        this.jTextFieldEventColumnWidth.setText("7.5");
        this.jTextFieldEventColumnWidth.setToolTipText("width of individual event columns. Make wider to accommodate images in header");
        this.jTextFieldEventColumnWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogRangeChart.this.jTextFieldEventColumnWidthKeyTyped(evt);
            }
        });
        this.jLabel14.setText("mm");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldCmpStd).addComponent(this.jTextFieldScheme)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonScheme, GroupLayout.Alignment.TRAILING, -2, 28, -2).addComponent(this.jButtonCmpStd, GroupLayout.Alignment.TRAILING, -2, 28, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGap(49, 49, 49).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel11).addComponent(this.jLabel7).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxSet, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxProject, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxVersion, 0, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxSetExclude, -1, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearScheme)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderColour, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxShowImages, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxPlotFull).addComponent(this.jLabel10).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldEventColumnWidth, -2, 47, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel14))).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldCmpStd, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jButtonCmpStd)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jButtonScheme).addComponent(this.jButtonClearScheme)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jComboBoxSet, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSetExclude).addGap(1, 1, 1).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jComboBoxProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxVersion, -2, -1, -2).addComponent(this.jLabel12)).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel3Layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jCheckBoxPlotFull).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderColour, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxShowImages).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jTextFieldEventColumnWidth, -2, -1, -2).addComponent(this.jLabel14))).addGroup(jPanel3Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap(23, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(1, this.jComboBoxProject, this.jComboBoxSet, this.jTextFieldCmpStd, this.jTextFieldScheme);
        this.jTabbedPane1.addTab("Stratigraphic range panel", this.jPanel3);
        this.jLabel3.setText("Min age:");
        this.jLabel4.setText("Max age:");
        this.jLabel5.setText("Scale:");
        this.jLabel8.setText("Ma");
        this.jLabel9.setText("Ma");
        this.jComboBoxScale.setEditable(true);
        this.jComboBoxScale.setModel(this.scaleModel);
        this.jLabel6.setText("mm/Ma");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonInterp, -2, 0, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldAgeMin, -2, 78, -2).addComponent(this.jTextFieldAgeMax, -2, 78, -2).addComponent(this.jComboBoxScale, -2, 78, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonFonts))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldAgeMin, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextFieldAgeMax, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jComboBoxScale, -2, -1, -2).addComponent(this.jButtonFonts)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(355, 355, 355).addComponent(this.jButtonInterp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        float maxAge;
        if (this.prop.std == null) {
            JOptionPane.showMessageDialog(this, "You must select a composite standard", this.getTitle(), 2);
            return;
        }
        float minAge = Float.parseFloat(this.jTextFieldAgeMin.getText());
        if (minAge > (maxAge = Float.parseFloat(this.jTextFieldAgeMax.getText()))) {
            JOptionPane.showMessageDialog(this, "Minimum age is greater than maxiumum age", this.getTitle(), 2);
            return;
        }
        float scale = ((Float)this.jComboBoxScale.getSelectedItem()).floatValue();
        this.block.prop.min = minAge;
        this.block.prop.max = maxAge;
        this.block.prop.scale = scale;
        this.prop.sortTops = null;
        if (this.jRadioButtonSortTop.isSelected()) {
            this.prop.sortTops = true;
        } else if (this.jRadioButtonSortBase.isSelected()) {
            this.prop.sortTops = false;
        }
        this.prop.groupGroups = false;
        this.prop.set = null;
        if (this.jComboBoxSet.getSelectedItem() instanceof TxGroupSet) {
            this.prop.set = (TxGroupSet)this.jComboBoxSet.getSelectedItem();
            if (this.jCheckBoxGroup.isSelected()) {
                this.prop.groupGroups = true;
            }
            this.prop.setExclusive = this.jCheckBoxSetExclude.isSelected();
        }
        this.prop.showAll = this.jCheckBoxPlotFull.isSelected();
        this.prop.showImages = this.jCheckBoxShowImages.isSelected();
        this.prop.evWidth = Float.parseFloat(this.jTextFieldEventColumnWidth.getText());
        this.prop.colourDensity = this.jSliderColour.getValue();
        this.prop.interpID = ((InterpHdr)this.jComboBoxVersion.getSelectedItem()).getInterpID();
        this.prop.project = null;
        if (this.jComboBoxProject.getSelectedIndex() > 0) {
            this.prop.project = (Project)this.jComboBoxProject.getSelectedItem();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.prop.project.loadWells(this.sbdb, this.sbdb.getDatabase().createStatement());
                Iterator it = this.prop.project.getWellIterator();
                while (it.hasNext()) {
                    Well well = (Well)it.next();
                    well.loadInterps();
                    WellInterp interp = null;
                    try {
                        interp = well.getInterp(this.prop.interpID);
                    }
                    catch (SBException sbe) {
                        // empty catch block
                    }
                    if (interp == null) continue;
                    well.loadInterp(interp);
                }
            }
            catch (SQLException sqle) {
                FrameJsbugs.showStackError("SQL Error loading project", sqle, this.sbdb);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error loading project", (Exception)((Object)sbe));
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        if (this.cp != null) {
            this.chart.chartProperties = this.cp;
            this.cp.encode(this.sbdb, CHART_PROPERTIES_CODE);
        }
        this.panelRange.setProperties(this.prop);
        this.schemeBlockPanel.confirm();
        this.prop.encode(this.sbdb, minAge, maxAge, scale);
        try {
            this.chart.savePreference(this.sbdb, SchemeBlock.getPrefKey(6));
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        this.setOK();
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonCmpStdActionPerformed(ActionEvent evt) {
        try {
            DialogSelectCmpStd dialog = new DialogSelectCmpStd(this, true, this.sbdb);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null && dialog.selection != this.prop.std) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                dialog.selection.loadEvents();
                this.prop.std = dialog.selection;
                this.jTextFieldCmpStd.setText(this.prop.std.getName());
                this.setCmpStdAges();
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDType typeDialog = new DialogSelectIGDType(this, true, false, false, false, false);
            typeDialog.setLocationRelativeTo(this);
            typeDialog.setVisible(true);
            if (!typeDialog.isOK()) {
                return;
            }
            DialogSelectScheme dialog = new DialogSelectScheme(this, true, this.sbdb, typeDialog.igdType, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                if (this.prop.scheme != dialog.selection) {
                    ListIterator it = this.block.panels.listIterator();
                    while (it.hasNext()) {
                        SBPanel panel = (SBPanel)it.next();
                        if (!(panel instanceof PanelIGDScheme) || ((PanelIGDScheme)panel).getScheme() != this.prop.scheme) continue;
                        it.remove();
                    }
                }
                dialog.selection.getUnits();
                PanelIGDScheme panel = new PanelIGDScheme(dialog.selection, this.block);
                this.block.addPanel(panel);
                this.schemeBlockPanel.createPanelList(this.block);
                this.schemeBlockPanel.movePanelToTop(panel);
                this.prop.scheme = dialog.selection;
                this.jTextFieldScheme.setText(this.prop.scheme.toString());
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonClearSchemeActionPerformed(ActionEvent evt) {
        this.prop.scheme = null;
        this.jTextFieldScheme.setText("");
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("rangechart.html");
    }

    private void jButtonFontsActionPerformed(ActionEvent evt) {
        if (this.cp == null) {
            this.cp = new ChartProperties(this.chart.chartProperties);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartFont dialog = new DialogChartFont(this, true, this.cp);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
    }

    private void jComboBoxSetActionPerformed(ActionEvent evt) {
        this.jCheckBoxGroup.setEnabled(this.jComboBoxSet.getSelectedIndex() > 0);
        this.jCheckBoxSetExclude.setEnabled(this.jComboBoxSet.getSelectedIndex() > 0);
    }

    private void jButtonInterpActionPerformed(ActionEvent evt) {
        try {
            DialogSelectVersion dialog = new DialogSelectVersion((Dialog)this, true, this.sbdb, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.prop.interpID = dialog.selection.get(0).getInterpID();
                this.jComboBoxVersion.setSelectedItem(this.sbdb.getInterp(this.prop.interpID));
            }
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"Error", (SQLException)sqle);
        }
    }

    private void jTextFieldEventColumnWidthKeyTyped(KeyEvent evt) {
        SB.floatFieldVal((JTextField)this.jTextFieldEventColumnWidth, (int)4, (KeyEvent)evt, (boolean)false);
    }

    private class CbKeyListener
    implements KeyListener {
        JComboBox comboBox;

        public CbKeyListener(JComboBox box) {
            this.comboBox = box;
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            char c = evt.getKeyChar();
            if ((c < '0' || c > '9') && c != '.' && c != '-' && c != '+' && c != '\b' && c != '\u007f') {
                DialogRangeChart.this.getToolkit().beep();
                evt.consume();
            }
        }
    }
}

