/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model2.CompositeStandard;
import model2.IGDScheme;
import model2.SBdb;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogRecalibrate
extends JDialog {
    SBdb db;
    IGDScheme scheme;
    CompositeStandard cmpStd;
    DefaultComboBoxModel comboModelChronoOld = new DefaultComboBoxModel();
    DefaultComboBoxModel comboModelChronoNew = new DefaultComboBoxModel();
    private JButton jButton2;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxChronoNew;
    private JComboBox jComboBoxChronoOld;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldSchemeNew;

    public DialogRecalibrate(Frame parent, boolean modal, SBdb db, Object obj) throws SQLException {
        super(parent, modal);
        this.db = db;
        if (obj instanceof IGDScheme) {
            this.scheme = (IGDScheme)obj;
        } else {
            this.cmpStd = (CompositeStandard)obj;
        }
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        for (IGDScheme chronoScheme : this.db.getIGDSchemes(3)) {
            this.comboModelChronoOld.addElement(chronoScheme);
            this.comboModelChronoNew.addElement(chronoScheme);
        }
        this.jComboBoxChronoOld.repaint();
        this.jComboBoxChronoNew.repaint();
        this.jTextFieldScheme.setText(this.scheme != null ? this.scheme.toString() : this.cmpStd.toString());
        this.setTitle("Recalibrate Scheme");
    }

    private void initComponents() {
        this.jButton2 = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxChronoOld = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxChronoNew = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jTextFieldSchemeNew = new JTextField();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton2.setText("jButton2");
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Recalibrating scheme/composite:");
        this.jTextFieldScheme.setEditable(false);
        this.jLabel2.setText("Current chronostratigraphy:");
        this.jComboBoxChronoOld.setModel(this.comboModelChronoOld);
        this.jLabel3.setText("New chronostratigraphy:");
        this.jComboBoxChronoNew.setModel(this.comboModelChronoNew);
        this.jComboBoxChronoNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRecalibrate.this.jComboBoxChronoNewActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Save as scheme/composite:");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRecalibrate.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRecalibrate.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRecalibrate.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(0, 153, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel4))).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldScheme).addComponent(this.jComboBoxChronoNew, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxChronoOld, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSchemeNew)))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldScheme, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxChronoOld, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBoxChronoNew, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSchemeNew, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogrecalibrate.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            IGDScheme chronoOld = (IGDScheme)this.jComboBoxChronoOld.getSelectedItem();
            IGDScheme chronoNew = (IGDScheme)this.jComboBoxChronoNew.getSelectedItem();
            if (chronoOld == chronoNew) {
                JOptionPane.showMessageDialog(this, "You must select different chronostratigraphy schemes", this.getTitle(), 2);
                return;
            }
            String newSchemeName = this.jTextFieldSchemeNew.getText().trim();
            if (newSchemeName.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No new scheme name entered", this.getTitle(), 2);
                return;
            }
            if (this.scheme != null) {
                if (this.db.getIGDScheme(newSchemeName, this.scheme.getIGDType()) != null) {
                    JOptionPane.showMessageDialog(this, "A scheme already exists with name entered.", this.getTitle(), 2);
                    return;
                }
                IGDScheme newScheme = this.scheme.recalibrate(this.db, chronoOld, chronoNew, newSchemeName);
                JOptionPane.showMessageDialog(this, "Scheme recalibrated and new scheme saved: " + newScheme.toString() + "\nPlot old and new schemes together to see changes.", this.getTitle(), 1);
            } else {
                if (this.db.getCompositeStandard(newSchemeName) != null) {
                    JOptionPane.showMessageDialog(this, "A composite standard already exists with name entered.", this.getTitle(), 2);
                    return;
                }
                CompositeStandard newCmpStd = this.db.recalibrateComposite(this.cmpStd, chronoOld, chronoNew, newSchemeName);
                JOptionPane.showMessageDialog(this, "Standard recalibrated and saved: " + newCmpStd.toString() + "\nPlot old and new schemes & standards together to see changes.", this.getTitle(), 1);
            }
            this.dispose();
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void jComboBoxChronoNewActionPerformed(ActionEvent evt) {
        IGDScheme chronoNew = (IGDScheme)this.jComboBoxChronoNew.getSelectedItem();
        this.jTextFieldSchemeNew.setText((this.scheme != null ? this.scheme.toString() : this.cmpStd.toString()) + " (" + chronoNew.toString() + ")");
    }
}

