/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model2.Lastval;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogRefresh
extends JDialog {
    SBdb db;
    boolean isOK = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JRadioButton jRadioButtonMinutes;
    private JRadioButton jRadioButtonNorefresh;
    private JRadioButton jRadioButtonSeconds;
    private JSeparator jSeparator1;
    private JTextField jTextFieldRefresh;

    public DialogRefresh(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Data Refresh Rate");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        int seconds = (int)this.db.monitorInterval / 1000;
        if (seconds == 0) {
            this.jRadioButtonNorefresh.setSelected(true);
            this.jTextFieldRefresh.setText("0");
            this.jTextFieldRefresh.setEnabled(false);
        } else if (seconds > 59) {
            this.jRadioButtonMinutes.setSelected(true);
            this.jTextFieldRefresh.setText("" + seconds / 60);
        } else {
            this.jRadioButtonSeconds.setSelected(true);
            this.jTextFieldRefresh.setText("" + seconds);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldRefresh = new JTextField();
        this.jRadioButtonSeconds = new JRadioButton();
        this.jRadioButtonMinutes = new JRadioButton();
        this.jRadioButtonNorefresh = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Refresh displayed data every:");
        this.jTextFieldRefresh.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogRefresh.this.jTextFieldRefreshKeyTyped(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonSeconds);
        this.jRadioButtonSeconds.setText("Seconds");
        this.jRadioButtonSeconds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRefresh.this.jRadioButtonSecondsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonMinutes);
        this.jRadioButtonMinutes.setText("Minutes");
        this.jRadioButtonMinutes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRefresh.this.jRadioButtonMinutesActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonNorefresh);
        this.jRadioButtonNorefresh.setText("Don't refresh data");
        this.jRadioButtonNorefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRefresh.this.jRadioButtonNorefreshActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRefresh.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRefresh.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogRefresh.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonNorefresh).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldRefresh, -2, 52, -2).addPreferredGap(0).add((Component)this.jRadioButtonSeconds).addPreferredGap(1).add((Component)this.jRadioButtonMinutes)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).add((Component)this.jSeparator1, -1, 334, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldRefresh, -2, -1, -2).add((Component)this.jRadioButtonSeconds).add((Component)this.jRadioButtonMinutes)).addPreferredGap(1).add((Component)this.jRadioButtonNorefresh).add(7, 7, 7).add((Component)this.jSeparator1, -2, 10, -2).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            int seconds = Integer.parseInt(this.jTextFieldRefresh.getText().trim());
            if (this.jRadioButtonNorefresh.isSelected()) {
                seconds = 0;
            } else {
                if (this.jTextFieldRefresh.getText().length() == 0) {
                    JOptionPane.showMessageDialog(this, "No interval selected", this.getTitle(), 2);
                    return;
                }
                if (this.jRadioButtonMinutes.isSelected()) {
                    seconds *= 60;
                }
            }
            Lastval.putInt((SBdb)this.db, (String)"DMONITOR", (int)seconds);
            this.db.commit();
            this.db.monitorInterval = seconds * 1000;
            this.dispose();
            this.isOK = true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "No interval selected", this.getTitle(), 2);
            return;
        }
    }

    private void jRadioButtonSecondsActionPerformed(ActionEvent evt) {
        this.jTextFieldRefresh.setEnabled(true);
        if (this.jTextFieldRefresh.getText().equals("0")) {
            this.jTextFieldRefresh.setText("30");
        }
    }

    private void jRadioButtonMinutesActionPerformed(ActionEvent evt) {
        this.jTextFieldRefresh.setEnabled(true);
        if (this.jTextFieldRefresh.getText().equals("0")) {
            this.jTextFieldRefresh.setText("10");
        }
    }

    private void jRadioButtonNorefreshActionPerformed(ActionEvent evt) {
        this.jTextFieldRefresh.setEnabled(false);
    }

    private void jTextFieldRefreshKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldRefresh, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("control_panel.html#refresh");
    }
}

