/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import jsbugs.ConnectionParameters;
import jsbugs.DialogSelectAnalyst;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.Userdef;

public class DialogSBLogin
extends JDialog {
    SBdb sbdb;
    boolean isOK = false;
    ConnectionParameters parms;
    boolean inInitCombo = false;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonUsers;
    private JCheckBox jCheckBoxRemember;
    private JCheckBox jCheckBoxSilentSBLogin;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPasswordField jPasswordField;
    private JSeparator jSeparator1;

    public DialogSBLogin(Frame parent, boolean modal, ConnectionParameters parms, SBdb sbdb) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.sbdb = sbdb;
        this.parms = parms;
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("StrataBugs Login");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initCombo();
    }

    private void initCombo() throws SQLException {
        this.inInitCombo = true;
        this.jComboBox1.removeAllItems();
        for (Userdef user : this.sbdb.getUsers()) {
            if (user.getPriv() <= 0) continue;
            user.setShowName(true);
            this.jComboBox1.addItem(user);
            if (this.parms.sbUID == null || this.parms.sbUID.length() <= 0 || !user.getAbr().equals(this.parms.sbUID)) continue;
            this.jComboBox1.setSelectedItem(user);
            this.jPasswordField.setText(this.parms.sbPwd);
        }
        if (this.parms.sbUID != null && this.parms.sbUID.length() > 0 && this.parms.sbPwd != null && this.parms.sbPwd.length() > 0) {
            this.jCheckBoxRemember.setSelected(true);
        }
        this.inInitCombo = false;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jButtonUsers = new JButton();
        this.jPasswordField = new JPasswordField();
        this.jCheckBoxRemember = new JCheckBox();
        this.jCheckBoxSilentSBLogin = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Login Name:");
        this.jLabel2.setText("Password:");
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSBLogin.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jButtonUsers.setText("...");
        this.jButtonUsers.setToolTipText("Select analyst (you must enter the correct password to do this)");
        this.jButtonUsers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSBLogin.this.jButtonUsersActionPerformed(evt);
            }
        });
        this.jCheckBoxRemember.setText("Remember StrataBugs login name and password");
        this.jCheckBoxRemember.setToolTipText("Not recommended for shared computers");
        this.jCheckBoxSilentSBLogin.setText("Don't show this dialog again");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSBLogin.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSBLogin.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSBLogin.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 329, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSilentSBLogin).addComponent(this.jCheckBoxRemember).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPasswordField).addComponent(this.jComboBox1, 0, 226, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUsers, -2, 34, -2)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jButtonUsers)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jCheckBoxRemember).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSilentSBLogin).addGap(15, 15, 15).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonUsersActionPerformed(ActionEvent evt) {
        if (this.login()) {
            if ((this.sbdb.getUser().getPriv() & 0x40) <= 0) {
                JOptionPane.showMessageDialog(this, "You need to be a super user to do this.");
                return;
            }
            try {
                DialogSelectAnalyst dialog = new DialogSelectAnalyst(this, true, this.sbdb);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                this.initCombo();
                this.jComboBox1ActionPerformed(null);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Passsword incorrect", this.getTitle(), 2);
            }
        }
    }

    boolean login() {
        if (this.jComboBox1.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, "No login name selected", this.getTitle(), 2);
            return false;
        }
        Userdef user = (Userdef)this.jComboBox1.getSelectedItem();
        this.parms.sbUID = user.getAbr();
        char[] passwordChars = this.jPasswordField.getPassword();
        if (passwordChars.length == 0) {
            JOptionPane.showMessageDialog(this, "You must enter a password", this.getTitle(), 1);
            return false;
        }
        String password = "";
        for (int i = 0; i < passwordChars.length && i < 9; ++i) {
            password = password + passwordChars[i];
        }
        this.parms.sbPwd = password;
        try {
            this.sbdb.login(user.getAbr(), password);
            ConnectionParameters.putSilentSBLogin(this.jCheckBoxSilentSBLogin.isSelected());
            if (!this.jCheckBoxRemember.isSelected()) {
                this.parms.sbPwd = null;
            }
            this.parms.putSBLogin();
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 2);
            ex.printStackTrace();
            return false;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.login()) {
            this.isOK = true;
            this.dispose();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtologin.html");
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        if (this.inInitCombo) {
            return;
        }
        Userdef user = (Userdef)this.jComboBox1.getSelectedItem();
        if (this.parms.sbUID != null && this.parms.sbUID.length() > 0) {
            if (user.getAbr().equals(this.parms.sbUID)) {
                this.jPasswordField.setText(this.parms.sbPwd);
            } else {
                this.jPasswordField.setText("");
            }
        }
    }
}

