/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import jsbugs.DialogSQLResults;
import jsbugs.DialogSQQueryLstrat;
import model2.SBdb;
import util.SB;
import util.SBException;

public class DialogSQLQuery
extends JDialog {
    private final SBdb db;
    private final String[] queries = new String[]{"Chronostrat/age at formation", "Age/formation/zone within 30m of TD", "Bioevents within 30m of TD (base depth, metres)", "Bioevents within 100ft of TD (top depth, feet)", "Deepest bioevent(s) (by well selection). Default version only"};
    static final int ITEM_CHRONO = 0;
    static final int ITEM_TD = 1;
    static final int ITEM_EVENT_TD_M = 2;
    static final int ITEM_EVENT_TD_F = 3;
    static final int ITEM_DEEP_EVENT = 4;
    DefaultComboBoxModel model = new DefaultComboBoxModel();
    boolean inInit = true;
    boolean typesSet = false;
    private JButton jButtonClose;
    private JButton jButtonRun;
    private JComboBox jComboBoxQuery;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanelDBTypes;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaSql;
    private JTextField jTextFieldTablePrefix;

    public DialogSQLQuery(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("StrataBugs Query");
        this.getRootPane().setDefaultButton(this.jButtonRun);
        for (String string : this.queries) {
            this.model.addElement(string);
        }
        this.jComboBoxQuery.repaint();
        for (String string : SBdb.DBType.values()) {
            JLabel jLabelDBType = new JLabel(string.getName());
            jLabelDBType.setForeground(Color.gray);
            Font font = jLabelDBType.getFont();
            jLabelDBType.setFont(font.deriveFont(1));
            this.jPanelDBTypes.add(jLabelDBType);
        }
        ((TitledBorder)this.jPanelDBTypes.getBorder()).setTitle("Current database: " + this.db.getDBType().getName());
        if (this.db.getTablePrefix() != null && this.db.getTablePrefix().length() > 0) {
            this.jTextFieldTablePrefix.setText(this.db.getTablePrefix() + ".");
        }
        this.inInit = false;
    }

    private void setDBType(SBdb.DBType dbType, boolean isActive, boolean isCompatible) {
        this.typesSet = true;
        for (Component comp : this.jPanelDBTypes.getComponents()) {
            JLabel label;
            if (!(comp instanceof JLabel) || !(label = (JLabel)comp).getText().equals(dbType.getName())) continue;
            Color colour = isActive ? (isCompatible ? new Color(0, 150, 0) : Color.red) : Color.lightGray;
            label.setForeground(colour);
            return;
        }
    }

    private void resetDBType() {
        if (!this.typesSet) {
            return;
        }
        for (Component comp : this.jPanelDBTypes.getComponents()) {
            if (!(comp instanceof JLabel)) continue;
            JLabel label = (JLabel)comp;
            label.setForeground(Color.lightGray);
        }
        this.typesSet = false;
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jButtonRun = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaSql = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBoxQuery = new JComboBox();
        this.jPanelDBTypes = new JPanel();
        this.jLabel3 = new JLabel();
        this.jTextFieldTablePrefix = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQLQuery.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRun.setText("Run...");
        this.jButtonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQLQuery.this.jButtonRunActionPerformed(evt);
            }
        });
        this.jTextAreaSql.setColumns(20);
        this.jTextAreaSql.setRows(5);
        this.jTextAreaSql.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSQLQuery.this.jTextAreaSqlKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaSql);
        this.jLabel1.setText("Enter query to run...");
        this.jLabel2.setText("...or select prepared query:");
        this.jComboBoxQuery.setModel(this.model);
        this.jComboBoxQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQLQuery.this.jComboBoxQueryActionPerformed(evt);
            }
        });
        this.jPanelDBTypes.setBorder(BorderFactory.createTitledBorder(null, "Database support", 2, 0));
        this.jLabel3.setText("Table name prefix (if required):");
        this.jTextFieldTablePrefix.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelDBTypes, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonRun).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(91, 91, 91).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxQuery, 0, 434, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldTablePrefix))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jComboBoxQuery, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelDBTypes, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldTablePrefix, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonRun)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonRunActionPerformed(ActionEvent evt) {
        String query = this.jTextAreaSql.getText();
        if (query.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No query entered", this.getTitle(), 2);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogSQLResults dialog = new DialogSQLResults((Frame)this.getParent(), false, this.db, query);
            if (dialog.wasUpdate) {
                return;
            }
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 2);
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jComboBoxQueryActionPerformed(ActionEvent evt) {
        if (this.inInit) {
            return;
        }
        int index = this.jComboBoxQuery.getSelectedIndex();
        try {
            switch (index) {
                case 0: {
                    DialogSQQueryLstrat dialog = new DialogSQQueryLstrat(this, true, this.db);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (dialog.isOK()) {
                        this.jTextAreaSql.setText(dialog.sql);
                    }
                    this.setDBType(SBdb.DBType.ORACLE, true, true);
                    this.setDBType(SBdb.DBType.ACCESS, true, false);
                    this.setDBType(SBdb.DBType.MYSQL, false, false);
                    this.setDBType(SBdb.DBType.SQLITE, false, false);
                    this.setDBType(SBdb.DBType.MSSQLSERVER, false, false);
                    break;
                }
                case 1: {
                    this.jTextAreaSql.setText("select w.well_name as Well_Name, w.td as TD, i.upp_inf AS Interval_Upper, i.low_inf AS Interval_Lower, s1.base_depth as Top_Depth, s2.base_depth as Base_Depth \nFROM " + this.db.DBTableName("wells") + " w, igd i, " + this.db.DBTableName("well_ident") + " v, " + this.db.DBTableName("samples") + " s1, " + this.db.DBTableName("samples") + " s2 " + "\nWHERE v.well_id=i.well_id and v.well_code=w.well_code and s1.well_id=v.well_id and " + "\ns2.well_id=v.well_id and i.top_id=s1.samp_id and i.base_id=s2.samp_id and (s1.base_depth >= w.td-30 or s2.base_depth >= w.td-30)");
                    this.setDBType(SBdb.DBType.ORACLE, true, true);
                    this.setDBType(SBdb.DBType.ACCESS, true, true);
                    this.setDBType(SBdb.DBType.MYSQL, false, false);
                    this.setDBType(SBdb.DBType.SQLITE, false, false);
                    this.setDBType(SBdb.DBType.MSSQLSERVER, false, false);
                    break;
                }
                case 2: {
                    this.jTextAreaSql.setText("select w.well_name as Well_Name, w.td AS TD, e.ev_type AS EventType, ed.name AS Event, s.base_depth AS Depth FROM " + this.db.DBTableName("wells") + " w, " + this.db.DBTableName("events") + " e, " + this.db.DBTableName("eventdic") + " ed, " + this.db.DBTableName("well_ident") + " v, " + this.db.DBTableName("samples") + " s " + "WHERE v.well_id=e.well_id AND v.well_code=w.well_code AND s.well_id=v.well_id AND " + "e.samp_id=s.samp_id AND e.ev_id=ed.ev_id AND s.base_depth >= w.td-30 ");
                    this.setDBType(SBdb.DBType.ORACLE, true, true);
                    this.setDBType(SBdb.DBType.ACCESS, true, true);
                    this.setDBType(SBdb.DBType.MYSQL, false, false);
                    this.setDBType(SBdb.DBType.SQLITE, false, false);
                    this.setDBType(SBdb.DBType.MSSQLSERVER, false, false);
                    break;
                }
                case 3: {
                    this.jTextAreaSql.setText("select w.well_name as Well_Name, w.td/.3048 AS TD, e.ev_type AS EventType, ed.name AS Event, s.top_depth/.3048 AS Depth FROM " + this.db.DBTableName("wells") + " w, " + this.db.DBTableName("events") + " e, " + this.db.DBTableName("eventdic") + " ed, " + this.db.DBTableName("well_ident") + " v, " + this.db.DBTableName("samples") + " s " + "WHERE v.well_id=e.well_id AND v.well_code=w.well_code AND s.well_id=v.well_id AND " + "e.samp_id=s.samp_id AND e.ev_id=ed.ev_id AND s.top_depth >= w.td-33 ");
                    this.setDBType(SBdb.DBType.ORACLE, true, true);
                    this.setDBType(SBdb.DBType.ACCESS, true, true);
                    this.setDBType(SBdb.DBType.MYSQL, false, false);
                    this.setDBType(SBdb.DBType.SQLITE, false, false);
                    this.setDBType(SBdb.DBType.MSSQLSERVER, false, false);
                    break;
                }
                case 4: {
                    String wellName = JOptionPane.showInputDialog(this, (Object)"Well name search prefix");
                    String sampleDepthField = "" + (this.db.useSampleTops() ? "top" : "base") + "_depth";
                    this.jTextAreaSql.setText("SELECT w.well_name as Well_Name, w.td as TD, e.ev_type as EventType, ed.name AS Event, s." + sampleDepthField + "/0.3048 as DepthF," + sampleDepthField + " as DepthM" + "\nFROM " + this.db.DBTableName("wells") + " w, " + this.db.DBTableName("events") + " e, " + this.db.DBTableName("eventdic") + " ed, " + this.db.DBTableName("well_ident") + " v, " + this.db.DBTableName("samples") + " s \nINNER JOIN (SELECT e.well_id as well_id, max(s." + sampleDepthField + ") as maxd \n    FROM " + this.db.DBTableName("samples") + " s, " + this.db.DBTableName("events") + " e \n    WHERE e.well_id=s.well_id and e.samp_id=s.samp_id and e.interp_id=0 " + "\n    GROUP BY e.well_id ) ss ON s.well_id=ss.well_id AND s." + sampleDepthField + "=ss.maxd" + "\nWHERE v.well_id=e.well_id AND v.well_code=w.well_code AND s.well_id=v.well_id AND e.samp_id=s.samp_id AND e.ev_id=ed.ev_id AND e.interp_id=0 \nAND w.well_name like '" + wellName + "%'");
                    this.setDBType(SBdb.DBType.ORACLE, true, true);
                    this.setDBType(SBdb.DBType.ACCESS, true, true);
                    this.setDBType(SBdb.DBType.MYSQL, false, false);
                    this.setDBType(SBdb.DBType.SQLITE, false, false);
                    this.setDBType(SBdb.DBType.MSSQLSERVER, false, false);
                }
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jTextAreaSqlKeyTyped(KeyEvent evt) {
        if (this.typesSet) {
            this.resetDBType();
        }
    }
}

