/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelSQLResults;
import model2.Lastval;
import model2.SBdb;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSQLResults
extends JDialog {
    TableModelSQLResults model;
    TableSorter sorter;
    SBdb db;
    boolean wasUpdate = false;
    private JButton jButtonClose;
    private JButton jButtonSaveAs;
    private JScrollPane jScrollPane1;
    private JTable jTableSQLResults;

    public DialogSQLResults(Frame parent, boolean modal, SBdb db, String sql) throws SQLException, SBException {
        super(parent, modal);
        this.db = db;
        this.init(sql);
        if (this.wasUpdate) {
            return;
        }
        this.initComponents();
        this.postInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String sql) throws SQLException, SBException {
        try {
            String[] disAllowed;
            this.setCursor(Cursor.getPredefinedCursor(3));
            Statement stmt = this.db.getDatabase().createStatement();
            String sqlLower = sql.toLowerCase();
            for (String dis : disAllowed = new String[]{"insert ", "update ", "delete ", "drop ", "truncate "}) {
                if (!sqlLower.contains(dis)) continue;
                if ((this.db.getUser().getPriv() & 0x40) == 0) {
                    throw new SBException("Your sql cannot include the expression: " + dis);
                }
                int nUpdated = stmt.executeUpdate(this.db.modQuery(sql));
                int opt = JOptionPane.showConfirmDialog(this.getParent(), "Number of rows updated: " + nUpdated + "\nCommit?", "StrataBugs update", 0, 1);
                if (opt == 0) {
                    this.db.commit();
                } else {
                    this.db.doRollback();
                }
                stmt.close();
                this.wasUpdate = true;
                return;
            }
            this.model = new TableModelSQLResults();
            this.sorter = new TableSorter((TableModel)this.model);
            ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
            int columns = rs.getMetaData().getColumnCount();
            if (columns == 0) {
                stmt.close();
                throw new SBException("The query produced no results.");
            }
            this.model.columntitles = new String[columns];
            for (int i = 0; i < columns; ++i) {
                this.model.columntitles[i] = rs.getMetaData().getColumnLabel(i + 1);
            }
            LinkedList rows = new LinkedList();
            while (rs.next()) {
                LinkedList<String> row = new LinkedList<String>();
                for (int i = 1; i <= columns; ++i) {
                    row.add(rs.getString(i));
                }
                rows.add(row);
            }
            rs.close();
            stmt.close();
            if (rows.isEmpty()) {
                throw new SBException("The query produced no results.");
            }
            this.model.data = new String[rows.size()][columns];
            for (int row = 0; row < rows.size(); ++row) {
                List rowData = (List)rows.get(row);
                for (int col = 0; col < columns; ++col) {
                    this.model.data[row][col] = (String)rowData.get(col);
                }
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void postInit() {
        this.setTitle("StrataBugs Query Results");
        Font font = this.jTableSQLResults.getTableHeader().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        this.jTableSQLResults.getTableHeader().setFont(font);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableSQLResults);
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            this.jTableSQLResults.getColumnModel().getColumn(i).setHeaderValue(this.model.columntitles[i]);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableSQLResults = new JTable();
        this.jButtonSaveAs = new JButton();
        this.setDefaultCloseOperation(2);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQLResults.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableSQLResults.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableSQLResults);
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save the current list as a text file");
        this.jButtonSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQLResults.this.jButtonSaveAsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonSaveAs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 756, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 515, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonSaveAs)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        String[] extensions = new String[]{"txt", "csv"};
        String[] descriptions = new String[]{"TAB delimited text files", "Commas Separated Values text files"};
        File file = FrameJsbugs.chooseFile(this.db, this, "JLISTFILE", "JLISTFILE", extensions, descriptions, null);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (file != null) {
            try {
                char delim = '\t';
                String fileName = file.getPath();
                if (!fileName.toLowerCase().endsWith(".txt")) {
                    if (fileName.endsWith(".csv")) {
                        delim = ',';
                    } else {
                        fileName = fileName + ".txt";
                    }
                }
                FileWriter out = new FileWriter(fileName);
                out.write("StrataBugs output: " + df.format(date) + "\r\n\r\n");
                Enumeration<TableColumn> en = this.jTableSQLResults.getColumnModel().getColumns();
                while (en.hasMoreElements()) {
                    TableColumn column = en.nextElement();
                    out.write("" + column.getHeaderValue() + delim);
                }
                out.write("\r\n");
                for (int row = 0; row < this.model.data.length; ++row) {
                    out.write("\r\n");
                    for (int col = 0; col < this.model.data[row].length; ++col) {
                        out.write((col > 0 ? Character.valueOf(delim) : "") + (this.model.data[row][col] != null ? this.model.data[row][col] : ""));
                    }
                }
                out.write("\r\n");
                out.close();
                if (JOptionPane.showConfirmDialog(this, "File '" + fileName + "' written", "File Saved", 2) == 0) {
                    Lastval.putString((SBdb)this.db, (String)"JLISTFILE", (String)fileName);
                    this.db.commit();
                }
            }
            catch (SQLException se) {
                JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }
}

