/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogSelectSample;
import jsbugs.DialogSelectSurface;
import jsbugs.FrameJsbugs;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Surface;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogSQPick
extends JDialog {
    private final SBdb db;
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private Sample sample;
    private Surface surface;
    private SQPick pick;
    private final DefaultComboBoxModel comboModelScheme = new DefaultComboBoxModel();
    private static final int INF_LEN = 80;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonSample;
    private JButton jButtonSurface;
    private JCheckBox jCheckBoxQuestionable;
    private JComboBox jComboBoxBoundary;
    private JComboBox jComboBoxScheme;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDepth;
    private JTextField jTextFieldInformal;
    private JTextField jTextFieldSurface;
    private JTextField jTextFieldSurfaceType;

    public DialogSQPick(Frame parent, boolean modal, SBdb db, IGDScheme scheme, Well well, WellInterp wellInterp, char units, SQPick pick, Sample sample, Surface surface) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.wellInterp = wellInterp;
        this.sample = sample;
        this.surface = surface;
        this.pick = pick;
        this.initComponents();
        this.init(scheme);
    }

    public DialogSQPick(Dialog parent, boolean modal, SBdb db, IGDScheme scheme, Well well, WellInterp wellInterp, char units, SQPick pick, Sample sample, Surface surface) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.wellInterp = wellInterp;
        this.sample = sample;
        this.surface = surface;
        this.pick = pick;
        this.initComponents();
        this.init(scheme);
    }

    private void init(IGDScheme scheme) throws SQLException {
        if (this.pick == null) {
            this.setTitle("Sequence Pick : Add to Well");
        } else {
            this.sample = this.pick.getSample();
            this.surface = this.pick.getSurface();
            this.jCheckBoxQuestionable.setSelected(this.pick.isQuestionable());
            this.setTitle("Sequence Pick : Edit in well");
            if (this.pick.getInfName() != null) {
                this.jTextFieldInformal.setText(this.pick.getInfName());
            } else {
                this.jTextFieldInformal.setText("");
            }
        }
        if (this.sample != null) {
            this.jTextFieldDepth.setText(this.sample.toString(this.units));
        }
        if (this.surface != null) {
            this.jTextFieldSurface.setText(this.surface.toString());
            this.jTextFieldSurfaceType.setText(this.surface.getTypeString());
            if (this.pick != null) {
                this.jComboBoxBoundary.setSelectedItem(this.pick.getBnd());
            } else {
                this.setBndDefault();
            }
        }
        Iterator it = this.db.getIGDSchemes(10).iterator();
        while (it.hasNext()) {
            this.jComboBoxScheme.addItem(it.next());
        }
        this.jComboBoxScheme.repaint();
        if (this.pick != null) {
            this.jComboBoxScheme.setSelectedItem(this.db.getIGDScheme(this.pick.getSurface().getSchID()));
        } else if (scheme != null) {
            this.jComboBoxScheme.setSelectedItem(scheme);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void setBndDefault() {
        switch (this.surface.getType()) {
            case CC: 
            case SB: {
                this.jComboBoxBoundary.setSelectedItem(IGDIntervalZone.getBoundary((int)4));
                break;
            }
            case MFS: {
                this.jComboBoxBoundary.setSelectedItem(IGDIntervalZone.getBoundary((int)3));
                break;
            }
            case TS: {
                this.jComboBoxBoundary.setSelectedItem(IGDIntervalZone.getBoundary((int)2));
            }
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jTextFieldDepth = new JTextField();
        this.jButtonSample = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldSurface = new JTextField();
        this.jButtonSurface = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jComboBoxScheme = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jCheckBoxQuestionable = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldSurfaceType = new JTextField();
        this.jComboBoxBoundary = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jTextFieldInformal = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Sample depth:");
        this.jTextFieldDepth.setEditable(false);
        this.jTextFieldDepth.setBackground(new Color(255, 255, 204));
        this.jButtonSample.setText("...");
        this.jButtonSample.setToolTipText("Select sample");
        this.jButtonSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQPick.this.jButtonSampleActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Surface:");
        this.jTextFieldSurface.setEditable(false);
        this.jTextFieldSurface.setBackground(new Color(255, 255, 204));
        this.jButtonSurface.setText("...");
        this.jButtonSurface.setToolTipText("Select surface / type");
        this.jButtonSurface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQPick.this.jButtonSurfaceActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQPick.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQPick.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQPick.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jComboBoxScheme.setModel(this.comboModelScheme);
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText("Scheme:");
        this.jCheckBoxQuestionable.setText("Questionable");
        this.jLabel1.setText("Type:");
        this.jTextFieldSurfaceType.setEditable(false);
        this.jTextFieldSurfaceType.setBackground(new Color(255, 255, 204));
        this.jComboBoxBoundary.setModel(new DefaultComboBoxModel<String>(IGDIntervalZone.bnds));
        this.jComboBoxBoundary.setToolTipText("Select boundary type");
        this.jLabel5.setText("Boundary:");
        this.jLabel6.setText("Informal:");
        this.jTextFieldInformal.setToolTipText("Enter informal name (optional)");
        this.jTextFieldInformal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSQPick.this.jTextFieldInformalKeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.jLabel2, -2, 79, -2).add((Component)this.jLabel4).add((Component)this.jLabel3)).add((Component)this.jLabel6)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jCheckBoxQuestionable, -2, 89, -2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jTextFieldDepth).add(1, (Component)this.jComboBoxScheme, 0, 345, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonSample, -2, 27, -2).add((Component)this.jButtonSurface, -2, 28, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jTextFieldInformal, -1, 213, Short.MAX_VALUE).add((Component)this.jTextFieldSurface)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel5).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldSurfaceType, -2, 68, -2).add((Component)this.jComboBoxBoundary, 0, 102, Short.MAX_VALUE)))))).add(0, 0, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jLabel2, this.jLabel3, this.jLabel4}, 1);
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonSample).add((Component)this.jTextFieldDepth, -2, -1, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxScheme, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldSurface, -2, -1, -2).add((Component)this.jButtonSurface).add((Component)this.jTextFieldSurfaceType, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxBoundary, -2, -1, -2).add((Component)this.jLabel5).add((Component)this.jTextFieldInformal, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(1).add((Component)this.jCheckBoxQuestionable).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonSampleActionPerformed(ActionEvent evt) {
        DialogSelectSample dialog;
        try {
            dialog = new DialogSelectSample(this, true, this.db, this.well, this.sample, this.units, true);
            dialog.getTableModel().setInterp(this.well, this.wellInterp, this.db);
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)ex));
            return;
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("Error opening dialog", ex, this.db);
            return;
        }
        dialog.setLocation(this.jButtonSample.getLocationOnScreen());
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.sample = dialog.selection;
            this.jTextFieldDepth.setText(this.sample.toString(this.units));
        }
    }

    private void jButtonSurfaceActionPerformed(ActionEvent evt) {
        DialogSelectSurface dialog;
        try {
            dialog = new DialogSelectSurface(this, true, this.db, (IGDScheme)this.jComboBoxScheme.getSelectedItem(), this.surface);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)sbe));
            return;
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error opening dialog", e, this.db);
            return;
        }
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.selection != null && dialog.selection != this.surface) {
            this.surface = dialog.selection;
            this.jTextFieldSurface.setText(this.surface.toString());
            this.jTextFieldSurfaceType.setText(this.surface.getTypeString());
            this.jTextFieldInformal.setText("");
            this.setBndDefault();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.surface == null) {
            JOptionPane.showMessageDialog(this, "Select a surface", this.getTitle(), 0);
            return;
        }
        if (this.sample == null) {
            JOptionPane.showMessageDialog(this, "Select a sample", this.getTitle(), 0);
            return;
        }
        try {
            this.pick = this.pick != null ? this.wellInterp.updateSQPick(this.pick, this.well, this.sample, this.surface, this.jTextFieldInformal.getText(), this.jCheckBoxQuestionable.isSelected(), (String)this.jComboBoxBoundary.getSelectedItem()) : this.wellInterp.addSQPick(this.well, this.sample, this.surface, this.jTextFieldInformal.getText(), this.jCheckBoxQuestionable.isSelected(), (String)this.jComboBoxBoundary.getSelectedItem());
            this.db.commit();
            this.wellInterp.notifyObservers((Object)this.pick);
            this.dispose();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot save pick", 2);
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error saving pick", e, this.db);
            this.db.doRollback();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogsqpick.html");
    }

    private void jTextFieldInformalKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldInformal, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    SQPick getPick() {
        return this.pick;
    }
}

