/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import jsbugs.SBDialog;
import model2.IGDUnit;
import model2.Project;
import model2.SBdb;
import util.SBException;

public class DialogSQQueryLstrat
extends SBDialog {
    DefaultComboBoxModel comboBoxModelProjects = new DefaultComboBoxModel();
    DefaultComboBoxModel comboBoxModelUnits = new DefaultComboBoxModel();
    SBdb sbdb;
    String sql;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxProject;
    private JComboBox jComboBoxUnit;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;

    public DialogSQQueryLstrat(JDialog parent, boolean modal, SBdb db) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.sbdb = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Query Lithstratigraphy");
        this.loadProjects();
        this.jComboBoxProject.setModel(this.comboBoxModelProjects);
        this.jComboBoxProject.repaint();
        this.comboBoxModelUnits.removeAllElements();
        IGDUnit.getAllLstrat((SBdb)this.sbdb, (DefaultComboBoxModel)this.comboBoxModelUnits);
        this.jComboBoxUnit.setModel(this.comboBoxModelUnits);
        this.jComboBoxUnit.repaint();
    }

    void loadProjects() throws SQLException, SBException {
        this.comboBoxModelProjects.removeAllElements();
        this.sbdb.getProjects().loadCombo(this.comboBoxModelProjects, true);
        Project def = this.sbdb.getProject(0);
        this.comboBoxModelProjects.setSelectedItem(def);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxUnit = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQQueryLstrat.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSQQueryLstrat.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("<html><strong>Note: This query is only available for Oracle databases</strong><br>\n<br>This query will search for the chronostratigtraphic interval(s) that are recorded in wells at the same\n<br>depths as the given lithostratigraphic interval; i.e. it will provide the age at which the formation is found.\n<br>You can choose to restrict the query to a project, otherwise the entire well database will be searched.\n<br>\n<br>The query does NOT use the well depth/age curve.<br>\n<br>\nThe lithostratigtraphic unit can be a member of any lithostrat scheme.</html>\n");
        this.jComboBoxProject.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Project:");
        this.jComboBoxUnit.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("Lithostratigraphic unit:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxUnit, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(70, 70, 70).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxProject, -2, 389, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProject, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxUnit, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String unitName = this.jComboBoxUnit.getSelectedItem().toString();
        Object p = this.jComboBoxProject.getSelectedItem();
        Project project = p instanceof Project ? (Project)p : null;
        System.out.println("Project is: " + project + " object is: " + p);
        this.sql = "SELECT ip.DESCRIP as Version,w.well_name,nvl(s1.base_depth,s1.top_depth) as top,nvl(s2.base_depth,s2.top_depth) as base,ic.upp_inf as InformalUpper, ic.low_inf as InformalLower,dc.u_age, dc.L_AGE, dc.NAME \nFROM " + this.sbdb.DBTableName("samples") + " s1, " + this.sbdb.DBTableName("samples") + " s2, " + this.sbdb.DBTableName("igd") + " ic, " + this.sbdb.DBTableName("wells") + " w, " + this.sbdb.DBTableName("well_ident") + " v, " + this.sbdb.DBTableName("igd_dict") + " dc, " + this.sbdb.DBTableName("interp") + " ip ";
        if (project != null) {
            this.sql = this.sql + ", " + this.sbdb.DBTableName("sbwllst") + " wl, " + this.sbdb.DBTableName("sbwlmb") + " wb ";
        }
        this.sql = this.sql + "\nWHERE ic.igd_type=3 and ip.INTERP_ID=ic.INTERP_ID \nAND ic.TOP_ID=s1.SAMP_ID and ic.BASE_ID=s2.SAMP_ID ";
        if (project != null) {
            this.sql = this.sql + "\nAND wl.ID=wb.ID and wl.NAME='" + project.getName() + "' AND v.WELL_ID=wb.WELL_ID ";
        }
        this.sql = this.sql + "\nAND  s1.well_id=ic.well_id and s2.well_id=ic.well_id and ic.well_id=v.well_id  \nAND v.well_code=w.well_code and ic.UPP_ZONE(+)=dc.IGD_ID \nAND nvl(s1.base_depth,s1.top_depth)<= (SELECT nvl(s3.base_depth,s3.top_depth) FROM " + this.sbdb.DBTableName("samples") + " s3, " + this.sbdb.DBTableName("igd") + " il, " + this.sbdb.DBTableName("igd_dict") + " d WHERE il.upp_zone=d.IGD_ID " + "\nAND d.name='" + unitName + "' AND il.well_id=v.WELL_ID AND s3.WELL_ID=il.WELL_ID AND s3.SAMP_ID=il.TOP_ID) AND nvl(s2.base_depth,s2.top_depth)>=(SELECT nvl(s3.base_depth,s3.top_depth) FROM " + this.sbdb.DBTableName("samples") + " s3, " + this.sbdb.DBTableName("igd") + " il, " + this.sbdb.DBTableName("igd_dict") + " d WHERE il.upp_zone=d.IGD_ID " + "\nAND d.name='" + unitName + "' and il.well_id=v.WELL_ID AND s3.WELL_ID=il.WELL_ID AND s3.SAMP_ID=il.TOP_ID ) " + "\nORDER BY well_name, top, base";
        this.setOK();
    }
}

