/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import jsbugs.SbugsFocusTraversalPolicy;
import model2.Lastval;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSample
extends JDialog {
    static final int DEPTHLEN = 10;
    int depthPrec = 3;
    static final int LABELEN = 15;
    Well well;
    SBdb db;
    Sample original;
    Sample sample;
    char units;
    boolean isOK = false;
    static String lastType = null;
    boolean addAnalysis = false;
    SbugsFocusTraversalPolicy focusPolicy = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAnalysis;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelBaseDepth;
    private JLabel jLabelTopDepth;
    private JLabel jLabelUnitsBase;
    private JLabel jLabelUnitsTop;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldCreated;
    private JTextField jTextFieldCreator;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldModified;
    private JTextField jTextFieldModifier;
    private JTextField jTextFieldTopDepth;

    public DialogSample(Frame parent, boolean modal, SBdb db, Well well, char units, Sample sample, boolean allowAddAnalysis) {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.units = units;
        this.original = sample;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.initFocus();
        this.init(allowAddAnalysis);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public DialogSample(Dialog parent, boolean modal, SBdb db, Well well, char units, Sample sample) {
        super(parent, modal);
        this.well = well;
        this.db = db;
        this.units = units;
        this.original = sample;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.initFocus();
        this.init(false);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public DialogSample(JDialog parent, boolean modal, SBdb db, Well well, char units) {
        super((Dialog)parent, modal);
        this.well = well;
        this.db = db;
        this.units = units;
        this.setLocation(parent.getLocation().x + 25, parent.getLocation().y + 25);
        this.initComponents();
        this.initFocus();
        this.init(false);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initFocus() {
    }

    private void init(boolean analysis) {
        int n = this.depthPrec = this.units == 'F' ? 2 : 3;
        if (this.db.useSampleTops()) {
            this.jTextFieldTopDepth.requestFocusInWindow();
        } else {
            this.jTextFieldBaseDepth.requestFocusInWindow();
        }
        if (this.original == null) {
            this.setTitle("Sample : Add");
            if (lastType != null) {
                this.jComboBoxType.setSelectedItem(lastType);
            } else if (this.well.getType() == 'O') {
                this.jComboBoxType.setSelectedItem("OC");
            }
            if (analysis) {
                try {
                    int add = Lastval.getInt((SBdb)this.db, (String)"ADDANALY");
                    this.jCheckBoxAnalysis.setSelected(add > 0);
                }
                catch (SQLException sql) {}
            } else {
                this.jCheckBoxAnalysis.setEnabled(false);
            }
        } else {
            this.setTitle("Sample : Edit");
            this.jCheckBoxAnalysis.setEnabled(false);
            try {
                if (this.original.getType().equals("SC") || this.original.getType().equals("LOG")) {
                    this.setSingleField();
                }
                if (this.original.hasTopDepth()) {
                    this.jTextFieldTopDepth.setText(SB.floatString((double)this.original.getTopDepth(this.units), (int)this.depthPrec).trim());
                }
                if (this.original.hasBaseDepth()) {
                    this.jTextFieldBaseDepth.setText(SB.floatString((double)this.original.getBaseDepth(this.units), (int)this.depthPrec).trim());
                }
            }
            catch (SBException ex) {
                ex.printStackTrace();
            }
            this.jTextFieldLabel.setText(this.original.getLabel());
            this.jComboBoxType.setSelectedItem(this.original.getType());
            this.jTextFieldModified.setText(SB.df.format(this.original.getModified()));
            if (this.original.getModifier() > 0) {
                try {
                    this.jTextFieldModifier.setText(this.db.getUser(this.original.getModifier()).getAbr());
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            this.jTextFieldCreated.setText(SB.df.format(this.original.getCreated()));
            if (this.original.getCreator() > 0) {
                try {
                    this.jTextFieldCreator.setText(this.db.getUser(this.original.getCreator()).getAbr());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        if (this.units != 'M') {
            this.jLabelUnitsTop.setText("ft");
            this.jLabelUnitsBase.setText("ft");
        }
    }

    public void setDepth(double depth) {
        if (this.db.useSampleTops()) {
            this.jTextFieldTopDepth.setText(SB.floatString((double)SB.convFromM((double)depth, (char)this.units, (char)this.well.getType()), (int)(this.units == 'F' ? 2 : 3)));
        } else {
            this.jTextFieldBaseDepth.setText(SB.floatString((double)SB.convFromM((double)depth, (char)this.units, (char)this.well.getType()), (int)(this.units == 'F' ? 2 : 3)));
        }
    }

    public void setType(String type) {
        this.jComboBoxType.setSelectedItem(type);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabelTopDepth = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jLabelUnitsTop = new JLabel();
        this.jLabelUnitsBase = new JLabel();
        this.jTextFieldBaseDepth = new JTextField();
        this.jLabelBaseDepth = new JLabel();
        this.jLabel4 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jTextFieldLabel = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel10 = new JLabel();
        this.jTextFieldCreated = new JTextField();
        this.jLabel12 = new JLabel();
        this.jTextFieldCreator = new JTextField();
        this.jLabel11 = new JLabel();
        this.jTextFieldModified = new JTextField();
        this.jLabel13 = new JLabel();
        this.jTextFieldModifier = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jCheckBoxAnalysis = new JCheckBox();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSample.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSample.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabelTopDepth.setHorizontalAlignment(11);
        this.jLabelTopDepth.setText("Top depth:");
        this.jTextFieldTopDepth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSample.this.jTextFieldTopDepthFocusGained(evt);
            }
        });
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSample.this.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jLabelUnitsTop.setText("m");
        this.jLabelUnitsBase.setText("m");
        this.jTextFieldBaseDepth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogSample.this.jTextFieldBaseDepthFocusGained(evt);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSample.this.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jLabelBaseDepth.setHorizontalAlignment(11);
        this.jLabelBaseDepth.setText("Base depth:");
        this.jLabel4.setText("Type:");
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"CU", "CO", "SC", "LOG", "OC"}));
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSample.this.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jTextFieldLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSample.this.jTextFieldLabelKeyTyped(evt);
            }
        });
        this.jLabel5.setText("Label:");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Dates"));
        this.jLabel10.setText("Created:");
        this.jTextFieldCreated.setEditable(false);
        this.jLabel12.setText("By user:");
        this.jTextFieldCreator.setEditable(false);
        this.jLabel11.setText("Modified:");
        this.jTextFieldModified.setEditable(false);
        this.jLabel13.setText("By user:");
        this.jTextFieldModifier.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel10).add((Component)this.jLabel11)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jTextFieldCreated, -2, 83, -2).add((Component)this.jTextFieldModified, -1, 83, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((Component)this.jLabel12).add((Component)this.jLabel13)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.jTextFieldModifier).add((Component)this.jTextFieldCreator, -1, 48, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.jTextFieldCreated, -2, -1, -2).add((Component)this.jTextFieldCreator, -2, -1, -2).add((Component)this.jLabel12)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.jTextFieldModifier, -2, -1, -2).add((Component)this.jLabel13).add((Component)this.jTextFieldModified, -2, -1, -2)).addContainerGap(22, Short.MAX_VALUE)));
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSample.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jCheckBoxAnalysis.setText("Add analysis");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jCheckBoxAnalysis).addPreferredGap(0, 169, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jSeparator1, -1, 461, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel4).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(5, 5, 5).add((Component)this.jLabelTopDepth)).add((Component)this.jLabelBaseDepth))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jTextFieldBaseDepth).add((Component)this.jTextFieldTopDepth, -2, 87, -2).add((Component)this.jComboBoxType, 0, 87, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelUnitsBase, -2, 11, -2).add((Component)this.jLabelUnitsTop, -2, 11, -2))).add((GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextFieldLabel, -2, 122, -2))).add(18, 18, 18).add((Component)this.jPanel2, -2, -1, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxType, -2, -1, -2).add((Component)this.jLabel4)).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelTopDepth).add((Component)this.jTextFieldTopDepth, -2, -1, -2).add((Component)this.jLabelUnitsTop)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelBaseDepth).add((Component)this.jTextFieldBaseDepth, -2, -1, -2).add((Component)this.jLabelUnitsBase)).add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldLabel, -2, -1, -2).add((Component)this.jLabel5))).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(0, 16, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonOK).add((Component)this.jButtonHelp).add((Component)this.jButtonCancel)).add((Component)this.jCheckBoxAnalysis)).addContainerGap()));
        this.pack();
    }

    private void jTextFieldLabelKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLabel, (int)15, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)10, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldTopDepthFocusGained(FocusEvent evt) {
        this.jTextFieldTopDepth.setSelectionStart(0);
        this.jTextFieldTopDepth.setSelectionEnd(this.jTextFieldTopDepth.getText().length());
    }

    private void jTextFieldBaseDepthFocusGained(FocusEvent evt) {
        this.jTextFieldBaseDepth.setSelectionStart(0);
        this.jTextFieldBaseDepth.setSelectionEnd(this.jTextFieldBaseDepth.getText().length());
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)10, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            Double topDepth = null;
            Double baseDepth = null;
            if (this.jTextFieldTopDepth.getText().length() > 0) {
                topDepth = Double.parseDouble(this.jTextFieldTopDepth.getText());
            }
            if (this.jTextFieldBaseDepth.getText().length() > 0) {
                baseDepth = Double.parseDouble(this.jTextFieldBaseDepth.getText());
            }
            if (topDepth == null && baseDepth == null) {
                JOptionPane.showMessageDialog(this, "No depth entered", this.getTitle(), 2);
                return;
            }
            String type = (String)this.jComboBoxType.getSelectedItem();
            Sample existingSample = this.well.getSample(topDepth != null ? Double.valueOf(SB.convToM((double)topDepth, (char)this.units)) : null, baseDepth != null ? Double.valueOf(SB.convToM((double)baseDepth, (char)this.units)) : null, type);
            if (this.original == null) {
                if (existingSample != null) {
                    JOptionPane.showMessageDialog(this, "A sample already exists at this depth/type", this.getTitle(), 1);
                    return;
                }
                this.sample = this.well.addSample(topDepth == null ? null : Double.valueOf(SB.convToM((double)topDepth, (char)this.units, (char)this.well.getType())), baseDepth == null ? null : Double.valueOf(SB.convToM((double)baseDepth, (char)this.units, (char)this.well.getType())), type, this.jTextFieldLabel.getText());
                this.sample.displayUnits = this.units;
                if (baseDepth != null) {
                    // empty if block
                }
                System.out.println("sample added. " + this.sample.getSectionType() + "  " + this.sample.getBaseDepth());
            } else {
                if (this.original != null && existingSample != null && existingSample != this.original) {
                    JOptionPane.showMessageDialog(this, "Another sample already exists at this depth/type", this.getTitle(), 1);
                    return;
                }
                this.well.updateSample(this.original, topDepth == null ? null : Double.valueOf(SB.convToM((double)topDepth, (char)this.units, (char)this.well.getType())), baseDepth == null ? null : Double.valueOf(SB.convToM((double)baseDepth, (char)this.units, (char)this.well.getType())), type, this.jTextFieldLabel.getText());
                this.sample = this.original;
                this.sample.displayUnits = this.units;
            }
            this.addAnalysis = this.jCheckBoxAnalysis.isSelected();
            if (this.jCheckBoxAnalysis.isEnabled()) {
                Lastval.putInt((SBdb)this.db, (String)"ADDANALY", (int)(this.addAnalysis ? 1 : 0));
            }
            lastType = type;
            this.well.notifyObservers((Object)this.sample);
            this.db.commit();
            this.isOK = true;
            this.dispose();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, "Error adding sample: " + e.getMessage() + "\n" + SB.sql, this.getTitle(), 0);
            System.out.println(SB.sql);
            e.printStackTrace();
            this.db.doRollback();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error adding sample: " + e.getMessage(), this.getTitle(), 0);
            e.printStackTrace();
            this.db.doRollback();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        String type = (String)this.jComboBoxType.getSelectedItem();
        if (type.equals("SC") || type.equals("LOG")) {
            this.setSingleField();
        } else {
            this.setDualField();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogsample.html");
    }

    private void setSingleField() {
        if (this.db.useSampleTops()) {
            this.jTextFieldBaseDepth.setText("");
            this.jTextFieldBaseDepth.setEnabled(false);
            this.jLabelBaseDepth.setEnabled(false);
            this.jLabelUnitsBase.setEnabled(false);
        } else {
            this.jTextFieldTopDepth.setText("");
            this.jTextFieldTopDepth.setEnabled(false);
            this.jLabelTopDepth.setEnabled(false);
            this.jLabelUnitsTop.setEnabled(false);
        }
    }

    private void setDualField() {
        if (this.db.useSampleTops()) {
            if (!this.jTextFieldBaseDepth.isEnabled()) {
                this.jTextFieldBaseDepth.setEnabled(true);
                this.jLabelBaseDepth.setEnabled(true);
                this.jLabelUnitsBase.setEnabled(true);
            }
        } else if (!this.jTextFieldTopDepth.isEnabled()) {
            this.jTextFieldTopDepth.setEnabled(true);
            this.jLabelTopDepth.setEnabled(true);
            this.jLabelUnitsTop.setEnabled(true);
        }
    }
}

