/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelAnalyses;
import model2.SBdb;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSampleCopy
extends JDialog {
    static int lastAbundance = 0;
    static boolean keepComments = false;
    static boolean ignoreQuals = false;
    SBdb db;
    Well well;
    Smpdtl smpdtlFrom = null;
    DefaultListModel model = new DefaultListModel();
    char discID;
    boolean isOK = false;
    TableModelAnalyses tableModelAnalyses = new TableModelAnalyses();
    TableSorter sorter = new TableSorter((TableModel)this.tableModelAnalyses);
    private ButtonGroup buttonGroupAbn;
    private JButton jButtonCancel;
    private JButton jButtonExclude;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxIgnoreQualifiers;
    private JCheckBox jCheckBoxKeepComments;
    private JLabel jLabel1;
    private JList jListTaxa;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonKeepAbn;
    private JRadioButton jRadioButtonResetTo1;
    private JRadioButton jRadioButtonUnsaved;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTable jTableAnalyses;

    public DialogSampleCopy(Frame parent, boolean modal, SBdb db, Well well, char discID, String smpdtlString, boolean smpdtlIsEmpty) {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.well = well;
        this.discID = discID;
        this.init(smpdtlString, smpdtlIsEmpty);
    }

    private void init(String smpdtlString, boolean smpdtlIsEmpty) {
        this.setTitle("Copy Sample Analysis data to: '" + smpdtlString + "'");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (smpdtlIsEmpty) {
            switch (lastAbundance) {
                case 1: {
                    this.jRadioButtonKeepAbn.setSelected(true);
                    break;
                }
                case 2: {
                    this.jRadioButtonResetTo1.setSelected(true);
                    break;
                }
                case 3: {
                    this.jRadioButtonUnsaved.setSelected(true);
                }
            }
        } else {
            this.jRadioButtonUnsaved.setSelected(true);
            this.jRadioButtonKeepAbn.setEnabled(false);
            this.jRadioButtonResetTo1.setEnabled(false);
            this.jRadioButtonKeepAbn.setToolTipText("Target analysis must be empty to use this option");
            this.jRadioButtonResetTo1.setToolTipText("Target analysis must be empty to use this option");
        }
        this.jCheckBoxKeepComments.setSelected(keepComments);
        this.jCheckBoxIgnoreQualifiers.setSelected(ignoreQuals);
        SB.setTableHeaderBold((JTable)this.jTableAnalyses);
        this.tableModelAnalyses.setupTable(this.jTableAnalyses, null);
        this.tableModelAnalyses.units = this.well.getWellUnits();
        this.sorter.addMouseListenerToHeaderInTable(this.jTableAnalyses);
        ListSelectionListener rowSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    int selectedRow = lsm.getAnchorSelectionIndex();
                    DialogSampleCopy.this.tableSelectionChanged(selectedRow);
                }
            }
        };
        this.jTableAnalyses.getSelectionModel().addListSelectionListener(rowSelectionListener);
        this.refreshAnalyses();
    }

    private void refreshAnalyses() {
        try {
            List dtls = this.well.getAnalyses(this.discID, null, 0);
            LinkedList<Smpdtl> filtered = new LinkedList<Smpdtl>();
            for (Smpdtl s : dtls) {
                if (s.getAnalysisType() == Smpdtl.AnalysisType.PREPARED) continue;
                filtered.add(s);
            }
            this.tableModelAnalyses.setSmpdtls(filtered, null);
            this.sorter.reallocateIndexes();
            this.sorter.sort((Object)this);
            this.jTableAnalyses.updateUI();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (SBException ex) {
            ex.printStackTrace();
        }
    }

    List<Taxon> getTaxa() {
        LinkedList<Taxon> taxa = new LinkedList<Taxon>();
        Enumeration e = this.model.elements();
        while (e.hasMoreElements()) {
            taxa.add((Taxon)e.nextElement());
        }
        return taxa;
    }

    boolean getKeepComments() {
        return keepComments;
    }

    int getKeepAbundance() {
        return lastAbundance;
    }

    boolean getIgnoreQs() {
        return ignoreQuals;
    }

    private void initComponents() {
        this.buttonGroupAbn = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jListTaxa = new JList();
        this.jButtonExclude = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTableAnalyses = new JTable();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonKeepAbn = new JRadioButton();
        this.jRadioButtonResetTo1 = new JRadioButton();
        this.jRadioButtonUnsaved = new JRadioButton();
        this.jCheckBoxIgnoreQualifiers = new JCheckBox();
        this.jCheckBoxKeepComments = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(650, 500));
        this.jListTaxa.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        this.jListTaxa.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListTaxa);
        this.jButtonExclude.setText("Exclude selected");
        this.jButtonExclude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleCopy.this.jButtonExcludeActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleCopy.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleCopy.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTableAnalyses.setModel((TableModel)this.sorter);
        this.jTableAnalyses.setSelectionMode(0);
        this.jTableAnalyses.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogSampleCopy.this.jTableAnalysesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTableAnalyses);
        this.jLabel1.setText("Select an analysis to copy from:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleCopy.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.buttonGroupAbn.add(this.jRadioButtonKeepAbn);
        this.jRadioButtonKeepAbn.setText("Record and copy abundance");
        this.buttonGroupAbn.add(this.jRadioButtonResetTo1);
        this.jRadioButtonResetTo1.setText("Record as 'outside the count'");
        this.buttonGroupAbn.add(this.jRadioButtonUnsaved);
        this.jRadioButtonUnsaved.setText("Insert as unsaved occurrences with no abundance");
        this.jCheckBoxIgnoreQualifiers.setText("Ignore qualifiers");
        this.jCheckBoxKeepComments.setText("Copy comments");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonUnsaved).add((Component)this.jRadioButtonResetTo1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonKeepAbn).add(104, 104, 104))).add(22, 22, 22).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxIgnoreQualifiers).add((Component)this.jCheckBoxKeepComments)).add(46, 46, 46)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonKeepAbn).add((Component)this.jCheckBoxIgnoreQualifiers)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonResetTo1).add((Component)this.jCheckBoxKeepComments)).addPreferredGap(0).add((Component)this.jRadioButtonUnsaved).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(73, 73, 73).add((Component)this.jButtonExclude)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 695, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jScrollPane1))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 309, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 309, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.jButtonExclude)).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        keepComments = this.jCheckBoxKeepComments.isSelected();
        ignoreQuals = this.jCheckBoxIgnoreQualifiers.isSelected();
        if (this.buttonGroupAbn.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "No abundance option selected", this.getTitle(), 2);
            return;
        }
        if (this.smpdtlFrom == null) {
            JOptionPane.showMessageDialog(this, "No analysis selected", this.getTitle(), 2);
            return;
        }
        lastAbundance = this.jRadioButtonKeepAbn.isSelected() ? 1 : (this.jRadioButtonResetTo1.isSelected() ? 2 : 3);
        this.isOK = true;
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonExcludeActionPerformed(ActionEvent evt) {
        int[] indices = this.jListTaxa.getSelectedIndices();
        if (indices.length == 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 2);
            return;
        }
        LinkedList<Taxon> toDelete = new LinkedList<Taxon>();
        for (int i : indices) {
            toDelete.add((Taxon)this.model.elementAt(i));
        }
        for (Taxon taxon : toDelete) {
            this.model.removeElement(taxon);
        }
        this.jListTaxa.updateUI();
    }

    private void jTableAnalysesMouseClicked(MouseEvent evt) {
        int row = this.jTableAnalyses.getSelectedRow();
        this.tableSelectionChanged(row);
    }

    private void tableSelectionChanged(int row) {
        if (row >= 0) {
            this.model.clear();
            this.smpdtlFrom = this.tableModelAnalyses.getSmpdtls().get(this.sorter.getIndexOf(row));
            try {
                this.smpdtlFrom.load(this.well.getWellID());
                if (this.smpdtlFrom != null) {
                    for (TaxonOcc fss : this.smpdtlFrom.getOccur()) {
                        if (this.model.contains(fss.getTaxon())) continue;
                        this.model.addElement(fss.getTaxon());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.jListTaxa.repaint();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogsamplecopy.html");
    }
}

