/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model2.Lastval;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogSampleGenerate
extends JDialog {
    Well well;
    char units;
    SBdb db;
    final int DEPTH_WID = 8;
    boolean addAnalyses = false;
    List<Sample> generated = new LinkedList<Sample>();
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAddAnalyses;
    private JCheckBox jCheckBoxRange;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JSeparator jSeparator1;
    private JTextField jTextFieldBase;
    private JTextField jTextFieldInterval;
    private JTextField jTextFieldLabel;
    private JTextField jTextFieldRange;
    private JTextField jTextFieldTop;

    public DialogSampleGenerate(Frame parent, boolean modal, SBdb db, Well well, char units) {
        super(parent, modal);
        this.initComponents();
        this.well = well;
        this.units = units;
        this.db = db;
        this.init();
    }

    private void init() {
        this.setTitle("Samples : Generate");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jComboBoxType.removeAllItems();
        this.jComboBoxType.addItem("CU - cuttings");
        this.jComboBoxType.addItem("CO - core samples");
        this.jComboBoxType.addItem("SC - sidewall cores");
        this.jComboBoxType.addItem("OC - outcrop");
        if (this.units == 'M') {
            this.jRadioButtonMetres.setSelected(true);
        } else {
            this.jRadioButtonFeet.setSelected(true);
        }
        this.setDepths();
        try {
            this.addAnalyses = Lastval.getInt((SBdb)this.db, (String)"ADDANALY") > 0;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.jCheckBoxAddAnalyses.setSelected(this.addAnalyses);
    }

    private void setDepths() {
        this.jTextFieldTop.setText("" + SB.convFromM((double)this.well.getHeader().getKicko(), (char)this.units, (char)this.well.getType()));
        this.jTextFieldBase.setText("" + SB.convFromM((double)this.well.getTD(), (char)this.units, (char)this.well.getType()));
        this.setInterval();
    }

    private void setInterval() {
        switch (this.jComboBoxType.getSelectedIndex()) {
            case 0: {
                this.jTextFieldInterval.setText(this.units == 'F' ? "30.0" : "10.0");
                this.jTextFieldRange.setText(this.units == 'F' ? "30.0" : "10.0");
                this.jCheckBoxRange.setSelected(true);
                break;
            }
            default: {
                this.jTextFieldInterval.setText("");
                this.jTextFieldRange.setText("");
                this.jCheckBoxRange.setSelected(false);
            }
        }
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jTextFieldTop = new JTextField();
        this.jTextFieldBase = new JTextField();
        this.jTextFieldInterval = new JTextField();
        this.jCheckBoxRange = new JCheckBox();
        this.jTextFieldRange = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jButtonHelp = new JButton();
        this.jCheckBoxAddAnalyses = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleGenerate.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleGenerate.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jRadioButtonMetres)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonFeet).addContainerGap(12, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonFeet)));
        this.jLabel1.setText("From:");
        this.jLabel2.setText("To:");
        this.jLabel3.setText("Interval:");
        this.jComboBoxType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleGenerate.this.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Type:");
        this.jTextFieldTop.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSampleGenerate.this.jTextFieldTopKeyTyped(evt);
            }
        });
        this.jTextFieldBase.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSampleGenerate.this.jTextFieldBaseKeyTyped(evt);
            }
        });
        this.jTextFieldInterval.setToolTipText("the depth interval between the top of one sample to the top of the next");
        this.jTextFieldInterval.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSampleGenerate.this.jTextFieldIntervalKeyTyped(evt);
            }
        });
        this.jCheckBoxRange.setSelected(true);
        this.jCheckBoxRange.setText("Top-base range:");
        this.jCheckBoxRange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleGenerate.this.jCheckBoxRangeActionPerformed(evt);
            }
        });
        this.jTextFieldRange.setToolTipText("The depth range of each sample. Can be the same as the interval.");
        this.jTextFieldRange.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSampleGenerate.this.jTextFieldRangeKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleGenerate.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleGenerate.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Label (added to all samples) :");
        this.jTextFieldLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSampleGenerate.this.jTextFieldLabelKeyTyped(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleGenerate.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jCheckBoxAddAnalyses.setText("Add analyses");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldInterval, -2, 133, -2).add(2, (Component)this.jTextFieldBase, -2, 133, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabel4).add(2, (Component)this.jLabel1).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jTextFieldTop, -1, 133, Short.MAX_VALUE).add(2, (Component)this.jComboBoxType, -2, 133, -2)))).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jCheckBoxRange).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jCheckBoxAddAnalyses).add((Component)this.jLabel6))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jTextFieldRange, -1, 122, Short.MAX_VALUE).add((Component)this.jTextFieldLabel, -1, 122, Short.MAX_VALUE))).add(2, (Component)this.jSeparator1, -1, 266, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jComboBoxType, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTop, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldBase, -2, -1, -2)).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldInterval, -2, -1, -2))).add((Component)this.jPanel1, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldRange, -2, -1, -2).add((Component)this.jCheckBoxRange)).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldLabel, -2, -1, -2)).addPreferredGap(1).add((Component)this.jCheckBoxAddAnalyses).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 2, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        if (this.units != 'M') {
            this.units = (char)77;
            this.setDepths();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonOKActionPerformed(ActionEvent evt) {
        String type;
        double top = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldTop.getText().trim()), (char)this.units, (char)this.well.getType());
        double base = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldBase.getText().trim()), (char)this.units, (char)this.well.getType());
        double interval = 0.0;
        double range = 0.0;
        try {
            interval = SB.convToM((float)Float.parseFloat(this.jTextFieldInterval.getText().trim()), (char)this.units);
            range = this.jTextFieldRange.isEnabled() ? (double)SB.convToM((float)Float.parseFloat(this.jTextFieldRange.getText().trim()), (char)this.units) : 0.0;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (top > base || Math.abs(top - base) < interval || range > interval || interval <= (double)0.0029f) {
            JOptionPane.showMessageDialog(this, "Depth range or interval invalid", this.getTitle(), 2);
            return;
        }
        if (base > this.well.getTD() + (double)0.0029f) {
            JOptionPane.showMessageDialog(this, "Base depth below TD of well: " + SB.convFromM((double)this.well.getTD(), (char)this.units), this.getTitle(), 2);
            return;
        }
        if (this.jComboBoxType.getSelectedIndex() == 0 && Math.IEEEremainder(top, interval) > 0.0 && JOptionPane.showConfirmDialog(this, "Warning: generated samples will not be exactly divisible by: " + SB.convFromM((double)interval, (char)this.units) + ". OK to proceed?", this.getTitle(), 0, 3) != 0) {
            return;
        }
        double currentDepth = top;
        switch (this.jComboBoxType.getSelectedIndex()) {
            case 0: {
                type = "CU";
                break;
            }
            case 1: {
                type = "CO";
                break;
            }
            case 2: {
                type = "SC";
                break;
            }
            case 3: {
                type = "OC";
                break;
            }
            default: {
                System.out.println("Invalid type selected!!");
                return;
            }
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int existingCount = 0;
            String label = this.jTextFieldLabel.getText().trim();
            while (currentDepth <= base) {
                Double baseSample = null;
                Double topSample = null;
                if (this.jCheckBoxRange.isSelected()) {
                    if (this.db.useSampleTops()) {
                        topSample = currentDepth;
                        baseSample = currentDepth + range;
                    } else {
                        baseSample = currentDepth;
                        topSample = currentDepth - range;
                    }
                } else if (this.db.useSampleTops()) {
                    topSample = currentDepth;
                } else {
                    baseSample = currentDepth;
                }
                System.out.println("Generating sample: " + (topSample != null ? Double.valueOf(SB.convFromM((double)topSample, (char)this.units, (char)this.well.getType())) : "<null>") + " - " + (baseSample != null ? Double.valueOf(SB.convFromM((double)baseSample, (char)this.units, (char)this.well.getType())) : "<null>") + " (" + type + ")");
                try {
                    Sample sample = this.well.addSample(topSample, baseSample, type, label);
                    sample.displayUnits = this.units;
                    this.db.commit();
                    this.generated.add(sample);
                }
                catch (SBException se) {
                    ++existingCount;
                }
                currentDepth += interval;
            }
            String msg = "" + this.generated.size() + " samples added.";
            if (existingCount > 0) {
                msg = msg + "\n" + existingCount + " samples not added becuase of overlap with existing samples.";
            }
            JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
            this.addAnalyses = this.jCheckBoxAddAnalyses.isSelected();
            Lastval.putInt((SBdb)this.db, (String)"ADDANALY", (int)(this.addAnalyses ? 1 : 0));
            this.db.commit();
            this.well.notifyObservers();
            this.dispose();
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(this, "SQL Error adding sample: " + sqle.getMessage() + "\n" + SB.sql, this.getTitle(), 0);
            this.db.doRollback();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error adding sample: " + e.getMessage() + "\n", this.getTitle(), 0);
            e.printStackTrace();
            this.db.doRollback();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        if (this.units != 'F') {
            this.units = (char)70;
            this.setDepths();
        }
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        this.setInterval();
    }

    private void jTextFieldTopKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTop, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBase, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldIntervalKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldInterval, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldRangeKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldRange, (int)8, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jCheckBoxRangeActionPerformed(ActionEvent evt) {
        this.jTextFieldRange.setEnabled(this.jCheckBoxRange.isSelected());
    }

    private void jTextFieldLabelKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldLabel, (int)15, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogsamplegenerate.html");
    }
}

