/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.ComboCellRenderer;
import jsbugs.FrameJsbugs;
import jsbugs.LithologyPattern;
import jsbugs.SBDialog;
import jsbugs.SBGraphics;
import jsbugs.TableModelSampleLithology;
import model2.SBdb;
import model2.Sample;
import model2.SampleLithology;
import model2.SampleLithologyUnit;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogSampleLithology
extends SBDialog {
    private final SBdb db;
    private final Sample sample;
    private final Well well;
    private final TableModelSampleLithology model = new TableModelSampleLithology();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private JComboBox comboBox = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonClear;
    private JButton jButtonDelete;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTableLith;

    public DialogSampleLithology(Frame parent, boolean modal, SBdb db, Well well, Sample sample) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.sample = sample;
        this.well = well;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Sample Lithology: " + this.sample.toString());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.lithdesc = this.db.getLithdesc();
        if (this.sample != null && this.sample.getLithology() != null && !this.sample.getLithology().getLithology().isEmpty()) {
            this.model.liths = new LinkedList<SampleLithologyUnit>();
            for (SampleLithologyUnit s : this.sample.getLithology().getLithology()) {
                this.model.liths.add(new SampleLithologyUnit(s.getDescription(), s.getPercent()));
            }
            Collections.sort(this.model.liths);
            this.model.lithPanel = new SampleLithologyPanel(this.model.liths);
            this.jScrollPane2.getViewport().add(this.model.lithPanel);
        }
        SB.setTableHeaderBold((JTable)this.jTableLith);
        for (int i = 0; i < TableModelSampleLithology.colTitles.length; ++i) {
            this.jTableLith.getColumnModel().getColumn(i).setHeaderValue(TableModelSampleLithology.colTitles[i]);
            this.jTableLith.getColumnModel().getColumn(i).setPreferredWidth(TableModelSampleLithology.colWidths[i]);
        }
        this.sorter.addMouseListenerToHeaderInTable(this.jTableLith);
        this.sorter.reallocateIndexes();
        this.comboBox = this.db.getLithologyCombo(false);
        this.jTableLith.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.comboBox));
        this.jTableLith.getColumnModel().getColumn(0).setCellRenderer(new ComboCellRenderer());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableLith = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonClear = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 300));
        this.jTableLith.setModel((TableModel)this.sorter);
        this.jTableLith.setToolTipText("Click on table cells to change values");
        this.jScrollPane1.setViewportView(this.jTableLith);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithology.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add row");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithology.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete row");
        this.jButtonDelete.setMargin(new Insets(2, 10, 2, 10));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithology.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithology.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonClear.setText("Clear all");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithology.this.jButtonClearActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Lithology:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithology.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 327, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 327, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonOK, -2, 77, -2).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonClear, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE)).add((Component)this.jButtonHelp, -2, 77, -2)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonClear, this.jButtonDelete, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 46, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jButtonClear).addPreferredGap(0, 64, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 226, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.model.liths == null) {
            this.model.liths = new LinkedList<SampleLithologyUnit>();
            this.model.lithPanel = new SampleLithologyPanel(this.model.liths);
            this.jScrollPane2.getViewport().add(this.model.lithPanel);
        }
        int percent = 0;
        int newPercent = 0;
        for (SampleLithologyUnit s : this.model.liths) {
            percent += s.getPercent();
        }
        if (percent < 100) {
            newPercent = 100 - percent;
        }
        try {
            this.model.liths.add(new SampleLithologyUnit(this.db.getLithdesc().getLithology(TableModelSampleLithology.lastCode), newPercent));
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
            this.jScrollPane2.repaint();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableLith.isEditing()) {
            this.jTableLith.getCellEditor().stopCellEditing();
        }
        if (this.model.liths == null) {
            JOptionPane.showMessageDialog(this, "No lithlogies specified", this.getTitle(), 2);
            return;
        }
        int totalPercent = 0;
        boolean hasZero = false;
        for (SampleLithologyUnit s : this.model.liths) {
            if (s.getPercent() == 0) {
                hasZero = true;
            }
            for (SampleLithologyUnit sDup : this.model.liths) {
                if (sDup == s || sDup.getDescription().getLithID() != s.getDescription().getLithID()) continue;
                JOptionPane.showMessageDialog(this, "Duplicate entries.", this.getTitle(), 2);
                return;
            }
            totalPercent += s.getPercent();
        }
        if (hasZero) {
            JOptionPane.showMessageDialog(this, "Cannot have zero percent", this.getTitle(), 2);
            return;
        }
        if (totalPercent > 100) {
            JOptionPane.showMessageDialog(this, "Total percentage is > 100", this.getTitle(), 2);
            return;
        }
        if (this.sample == null) {
            JOptionPane.showMessageDialog(this, "No sample", this.getTitle(), 2);
            return;
        }
        try {
            this.sample.updateLithology(this.model.liths, this.well.getWellID());
            this.well.setDataChanged();
            this.well.notifyObservers(SampleLithology.class);
            this.db.commit();
            this.setOK();
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this, sbe.getMessage(), this.getTitle(), 2);
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableLith.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row to delete", this.getTitle(), 1);
            return;
        }
        this.model.liths.remove(this.sorter.getIndexOf(this.jTableLith.getSelectedRow()));
        this.jScrollPane2.repaint();
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.model.liths.clear();
        this.jScrollPane2.getViewport().removeAll();
        this.jScrollPane2.repaint();
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogsamplelithology.html");
    }

    static class SampleLithologyPanel
    extends JPanel {
        List liths = null;

        public SampleLithologyPanel(List liths) {
            this.liths = liths;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            AffineTransform tnf = new AffineTransform();
            tnf.scale(0.028346456587314606, 0.028346456587314606);
            ((Graphics2D)g).transform(tnf);
            boolean drawOutline = false;
            boolean noPattern = false;
            LithologyPattern.drawList(this.liths, new SBGraphics((Graphics2D)g, null, false, true), 0.0f, 0.0f, (float)this.getWidth() / 2.8346457f, (float)this.getHeight() / 2.8346457f, false, drawOutline, noPattern);
        }
    }
}

