/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import model2.WsWell;
import util.SB;

public class DialogSampleLithologyImport
extends JDialog {
    char units;
    float interval;
    boolean singleDepth;
    boolean isOK = false;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonDual;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonSingle;
    private JSeparator jSeparator1;
    private JTextField jTextFieldInterval;

    public DialogSampleLithologyImport(Dialog parent, boolean modal, WsWell well) {
        super(parent, modal);
        this.initComponents();
        this.init(well);
    }

    private void init(WsWell well) {
        this.setTitle("Lithology Import");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (well.getWellUnits() == 'M') {
            this.units = (char)77;
            this.jRadioButtonMetres.setSelected(true);
        } else {
            this.units = (char)70;
            this.jRadioButtonFeet.setSelected(true);
        }
        this.setUnits();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldInterval = new JTextField();
        this.jPanel2 = new JPanel();
        this.jRadioButtonSingle = new JRadioButton();
        this.jRadioButtonDual = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithologyImport.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithologyImport.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "File units", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroup1.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithologyImport.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithologyImport.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMetres).addComponent(this.jRadioButtonFeet))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonMetres).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel1.setText("Sample interval:");
        this.jTextFieldInterval.setToolTipText("Samples will be created at this interval unless the lithology changes");
        this.jTextFieldInterval.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogSampleLithologyImport.this.jTextFieldIntervalKeyTyped(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "File Type", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroup2.add(this.jRadioButtonSingle);
        this.jRadioButtonSingle.setText("Single depth");
        this.jRadioButtonSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithologyImport.this.jRadioButtonSingleActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButtonDual);
        this.jRadioButtonDual.setText("Dual depth");
        this.jRadioButtonDual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleLithologyImport.this.jRadioButtonDualActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonSingle).addComponent(this.jRadioButtonDual)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonSingle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonDual).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setText("m");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldInterval, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 14, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldInterval, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (!this.jRadioButtonDual.isSelected() && !this.jRadioButtonSingle.isSelected()) {
            JOptionPane.showMessageDialog(this, "Select a depth option", this.getTitle(), 2);
            return;
        }
        this.interval = this.jTextFieldInterval.getText().isEmpty() ? 0.0f : Float.parseFloat(this.jTextFieldInterval.getText().trim());
        this.singleDepth = this.jRadioButtonSingle.isSelected();
        this.isOK = true;
        this.dispose();
    }

    private void jTextFieldIntervalKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldInterval, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonSingleActionPerformed(ActionEvent evt) {
        this.enableInterval(true);
    }

    private void jRadioButtonDualActionPerformed(ActionEvent evt) {
        this.enableInterval(false);
    }

    private void enableInterval(boolean enable) {
        if (enable) {
            this.jTextFieldInterval.setEnabled(true);
        } else {
            this.jTextFieldInterval.setEnabled(false);
        }
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldInterval.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldInterval.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldInterval.setText("30.0");
            }
            this.jLabel2.setText("ft");
        } else {
            this.units = (char)77;
            try {
                this.jTextFieldInterval.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldInterval.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldInterval.setText("10.0");
            }
            this.jLabel2.setText("m");
        }
    }
}

