/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Well;
import util.SB;
import util.SBException;

public class DialogSampleReport
extends JDialog {
    SBdb sbdb;
    Well well;
    private JButton jButtonClose;
    private JButton jButtonFile;
    private JButton jButtonSave;
    private JCheckBox jCheckBoxAnalyses;
    private JCheckBox jCheckBoxAnalysesAnylists;
    private JCheckBox jCheckBoxAnalysesBarren;
    private JCheckBox jCheckBoxSampleDepthRange;
    private JCheckBox jCheckBoxSampleLabel;
    private JCheckBox jCheckBoxSampleType;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JTextField jTextFieldFile;

    public DialogSampleReport(Frame parent, boolean modal, Well well, String filename, SBdb sbdb, List<Sample> samples) {
        super(parent, modal);
        this.initComponents();
        this.well = well;
        this.sbdb = sbdb;
        this.init(filename);
    }

    private void init(String filename) {
        this.jTextFieldFile.setText(filename);
        this.enableAnalyses(this.jCheckBoxAnalyses.isSelected());
        this.setTitle("Save Sample Report");
        this.getRootPane().setDefaultButton(this.jButtonSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        String fileName = this.jTextFieldFile.getText();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            FileWriter out = new FileWriter(fileName);
            char delim = ',';
            out.write("StrataBugs sample report for well: " + this.well.getWellName() + "\n\n");
            if (this.jCheckBoxSampleDepthRange.isSelected()) {
                out.write("top" + delim + "base" + delim);
            } else {
                out.write("sample" + delim);
            }
            if (this.jCheckBoxSampleType.isSelected()) {
                out.write("type" + delim);
            }
            if (this.jCheckBoxSampleLabel.isSelected()) {
                out.write("label" + delim);
            }
            if (this.jCheckBoxAnalyses.isSelected() && this.jCheckBoxAnalysesAnylists.isSelected()) {
                for (char discID : SBdb.discArr) {
                    out.write(SBdb.getDiscAbr((char)discID) + delim);
                }
            }
            out.write("\n");
            for (Sample sample : this.well.getSamples()) {
                if (this.jCheckBoxSampleDepthRange.isSelected()) {
                    if (sample.hasTopDepth()) {
                        out.write("" + sample.getTopDepth(this.well.getWellUnits()));
                    }
                    out.write(delim);
                    if (sample.hasBaseDepth()) {
                        out.write("" + sample.getBaseDepth(this.well.getWellUnits()));
                    }
                    out.write(delim);
                } else {
                    out.write(sample.toString(this.well.getWellUnits(), true, false, false, false, null, null) + delim);
                }
                if (this.jCheckBoxSampleType.isSelected()) {
                    out.write(sample.getType() + delim);
                }
                if (this.jCheckBoxSampleLabel.isSelected()) {
                    out.write(sample.getLabel() + delim);
                }
                if (this.jCheckBoxAnalyses.isSelected()) {
                    for (char discID : SBdb.discArr) {
                        if (sample.hasDisciplineData(discID)) {
                            String analystString = "";
                            for (Smpdtl dtl : sample.getAnalyses()) {
                                if (dtl.getDiscID() != discID) continue;
                                if (this.jCheckBoxAnalysesAnylists.isSelected()) {
                                    if (!analystString.isEmpty()) {
                                        analystString = analystString + " ";
                                    }
                                    analystString = analystString + dtl.getHeader().toString();
                                } else if (analystString.isEmpty()) {
                                    analystString = analystString + SBdb.getDiscAbr((char)discID);
                                }
                                if (!dtl.getBarren() || this.jCheckBoxAnalysesAnylists.isSelected() && analystString.contains("barren")) continue;
                                analystString = analystString + "(barren)";
                            }
                            out.write(analystString);
                        }
                        out.write(delim);
                    }
                }
                out.write("\n");
            }
            out.close();
            JOptionPane.showMessageDialog(this, "File written.", this.getTitle(), 1);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error writing file: \n" + ioe.getMessage(), "Error", 0);
            System.out.println("IOE ERROR: " + ioe.getMessage());
        }
        catch (SQLException sqle) {
            SB.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jButtonFile = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSave = new JButton();
        this.jPanel1 = new JPanel();
        this.jCheckBoxSampleDepthRange = new JCheckBox();
        this.jCheckBoxSampleType = new JCheckBox();
        this.jCheckBoxSampleLabel = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jCheckBoxAnalyses = new JCheckBox();
        this.jCheckBoxAnalysesAnylists = new JCheckBox();
        this.jCheckBoxAnalysesBarren = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("File:");
        this.jTextFieldFile.setBackground(new Color(255, 255, 204));
        this.jTextFieldFile.setEditable(false);
        this.jButtonFile.setText("...");
        this.jButtonFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleReport.this.jButtonFileActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleReport.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleReport.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Samples", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxSampleDepthRange.setSelected(true);
        this.jCheckBoxSampleDepthRange.setText("Depth range");
        this.jCheckBoxSampleType.setSelected(true);
        this.jCheckBoxSampleType.setText("Sample type");
        this.jCheckBoxSampleLabel.setText("Label");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSampleDepthRange).addComponent(this.jCheckBoxSampleType).addComponent(this.jCheckBoxSampleLabel)).addContainerGap(19, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxSampleDepthRange).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSampleType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSampleLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Analyses summary", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxAnalyses.setSelected(true);
        this.jCheckBoxAnalyses.setText("Analysis summary");
        this.jCheckBoxAnalyses.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogSampleReport.this.jCheckBoxAnalysesActionPerformed(evt);
            }
        });
        this.jCheckBoxAnalysesAnylists.setText("Analysts");
        this.jCheckBoxAnalysesBarren.setText("Flag barren analyses");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAnalyses).addComponent(this.jCheckBoxAnalysesAnylists).addComponent(this.jCheckBoxAnalysesBarren)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAnalyses).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAnalysesAnylists).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxAnalysesBarren).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFile, -2, 30, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonSave);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldFile, -2, -1, -2).addComponent(this.jButtonFile)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonSave)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void jButtonFileActionPerformed(ActionEvent evt) {
        File file = FrameJsbugs.chooseFile(this.sbdb, this, "SMPRPRTWIN", "SMPRPRTUNX", new String[]{"csv"}, new String[]{"CSV files"}, null);
        this.jTextFieldFile.setText(file.getPath());
    }

    private void jCheckBoxAnalysesActionPerformed(ActionEvent evt) {
        this.enableAnalyses(this.jCheckBoxAnalyses.isSelected());
    }

    private void enableAnalyses(boolean enabled) {
        this.jCheckBoxAnalysesAnylists.setEnabled(enabled);
        this.jCheckBoxAnalysesBarren.setEnabled(enabled);
    }
}

